/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryresultcheck;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsas.business.salaryresultcheck.helper.SalaryResultCheckHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.ResultCheckIndexEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryResultBasicPointOutPlugin
extends SWCDataBaseEdit {
    private static String[] yearIndexCodeArray = new String[]{"yearincreaseless", "yearincreasebigger", "yeargrowthless", "yeargrowthbigger"};
    private static String[] chainIndexCodeArray = new String[]{"chainincreaseless", "chainincreasebigger", "chaingrowthless", "chaingrowthbigger"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.labelClickRegister();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadPointOutDatas();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("currentnum") || key.startsWith("yearnum") || key.startsWith("chainnum")) {
            this.numLabelClick(key);
        }
    }

    private void numLabelClick(String labelName) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String calPersonIdStr = (String)pageCache.get(labelName, String.class);
        if (SWCStringUtils.equals((String)"[]", (String)calPersonIdStr)) {
            return;
        }
        this.getView().returnDataToParent((Object)calPersonIdStr);
        this.getView().close();
    }

    private void labelClickRegister() {
        this.labelDynamicRegister("currentnum", 3);
        this.labelDynamicRegister("yearnum", 4);
        this.labelDynamicRegister("chainnum", 4);
    }

    private void labelDynamicRegister(String preName, int size) {
        for (int i = 0; i < size; ++i) {
            Label textEdit = (Label)this.getView().getControl(preName + i);
            textEdit.addClickListener((ClickListener)this);
        }
    }

    private void loadPointOutDatas() {
        SalaryDetailResultMarkListHelper detailHelper = new SalaryDetailResultMarkListHelper();
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Set calPersonIds = detailHelper.getCalPersonIds(Long.valueOf(calTaskId));
        if (calPersonIds == null || calPersonIds.size() == 0) {
            return;
        }
        SalaryResultCheckHelper helper = new SalaryResultCheckHelper();
        DynamicObjectCollection checkStatsIdColl = helper.getCheckStatsIdByCalTaskId(calTaskId);
        if (checkStatsIdColl == null || checkStatsIdColl.size() == 0) {
            return;
        }
        HashSet<Long> checkStatsIdSet = new HashSet<Long>(checkStatsIdColl.size());
        for (DynamicObject checkStatsIdObj : checkStatsIdColl) {
            checkStatsIdSet.add(checkStatsIdObj.getLong("id"));
        }
        Object basicItemIdObj = this.getView().getFormShowParameter().getCustomParam("basicItemId");
        long basicItemId = 0L;
        basicItemId = basicItemIdObj instanceof Integer ? Long.parseLong(String.valueOf(basicItemIdObj)) : (Long)basicItemIdObj;
        DynamicObjectCollection checkIndexStatsInfoColl = helper.getCheckIndexStatsByItemIdAndCheckStatsId(checkStatsIdSet, basicItemId);
        if (checkIndexStatsInfoColl == null || checkIndexStatsInfoColl.size() == 0) {
            return;
        }
        HashSet<Object> indexCodeSet = new HashSet<Object>(checkIndexStatsInfoColl.size());
        HashMap<String, String> checkIndexTransInfoMap = new HashMap<String, String>(checkIndexStatsInfoColl.size());
        for (DynamicObject checkIndexStatsInfoObj : checkIndexStatsInfoColl) {
            String indexCode = checkIndexStatsInfoObj.getString("indexcode");
            String indexValue = checkIndexStatsInfoObj.getString("indexvalue");
            checkIndexTransInfoMap.put(indexCode, this.getIndexValStr(indexCode) + indexValue);
            indexCodeSet.add(indexCode);
        }
        DynamicObjectCollection checkIndexPersonInfoColl = helper.getCheckIndexPersonByItemIdAndCheckStatsId(checkStatsIdSet, basicItemId, indexCodeSet);
        HashMap<String, Set<Long>> checkIndexPersonInfoMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject checkIndexPersonInfoObj : checkIndexPersonInfoColl) {
            String indexCode = checkIndexPersonInfoObj.getString("indexcode");
            long calPersonId = checkIndexPersonInfoObj.getLong("personid");
            HashSet<Long> calPersonIdSet = (HashSet<Long>)checkIndexPersonInfoMap.get(indexCode);
            if (calPersonIdSet != null && calPersonIdSet.size() > 0) {
                if (calPersonIds.contains(calPersonId)) {
                    calPersonIdSet.add(calPersonId);
                }
                checkIndexPersonInfoMap.put(indexCode, calPersonIdSet);
                continue;
            }
            calPersonIdSet = new HashSet<Long>(16);
            if (calPersonIds.contains(calPersonId)) {
                calPersonIdSet.add(calPersonId);
            }
            checkIndexPersonInfoMap.put(indexCode, calPersonIdSet);
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String indexCode = "valueequals";
        String indexCodeDesc = (String)checkIndexTransInfoMap.get(indexCode);
        if (SWCStringUtils.isNotEmpty((String)indexCodeDesc)) {
            this.modifyLabelValue("currentequalname", (String)checkIndexTransInfoMap.get(indexCode));
            Set calPersonIdSet = (Set)checkIndexPersonInfoMap.get(indexCode);
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                this.modifyLabelValue("currentnum0", "0");
                pageCache.put("currentnum0", (Object)"[]");
            } else {
                this.modifyLabelValue("currentnum0", String.valueOf(calPersonIdSet.size()));
                pageCache.put("currentnum0", (Object)calPersonIdSet.toString());
            }
        }
        if (SWCStringUtils.isNotEmpty((String)(indexCodeDesc = (String)checkIndexTransInfoMap.get(indexCode = "valueless")))) {
            this.modifyLabelValue("currentlessname", (String)checkIndexTransInfoMap.get(indexCode));
            Set calPersonIdSet = (Set)checkIndexPersonInfoMap.get(indexCode);
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                this.modifyLabelValue("currentnum1", "0");
                pageCache.put("currentnum1", (Object)"[]");
            } else {
                this.modifyLabelValue("currentnum1", String.valueOf(calPersonIdSet.size()));
                pageCache.put("currentnum1", (Object)calPersonIdSet.toString());
            }
        }
        if (SWCStringUtils.isNotEmpty((String)(indexCodeDesc = (String)checkIndexTransInfoMap.get(indexCode = "valuebigger")))) {
            this.modifyLabelValue("currentlargername", (String)checkIndexTransInfoMap.get(indexCode));
            Set calPersonIdSet = (Set)checkIndexPersonInfoMap.get(indexCode);
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                this.modifyLabelValue("currentnum2", "0");
                pageCache.put("currentnum2", (Object)"[]");
            } else {
                this.modifyLabelValue("currentnum2", String.valueOf(calPersonIdSet.size()));
                pageCache.put("currentnum2", (Object)calPersonIdSet.toString());
            }
        }
        int yearHideIndex = 0;
        for (String indexCodeStr : yearIndexCodeArray) {
            if (!checkIndexTransInfoMap.containsKey(indexCodeStr)) continue;
            this.dynamicShowPannel("year", yearHideIndex, indexCodeStr, checkIndexTransInfoMap, checkIndexPersonInfoMap, pageCache);
            ++yearHideIndex;
        }
        if (yearHideIndex == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"yearflexpanelap"});
        } else {
            for (int i = yearHideIndex; i <= 3; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"yearname" + i, "yearnum" + i, "yearlast" + i});
            }
        }
        int chainHideIndex = 0;
        for (String indexCodeStr : chainIndexCodeArray) {
            if (!checkIndexTransInfoMap.containsKey(indexCodeStr)) continue;
            this.dynamicShowPannel("chain", chainHideIndex, indexCodeStr, checkIndexTransInfoMap, checkIndexPersonInfoMap, pageCache);
            ++chainHideIndex;
        }
        if (chainHideIndex == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chainflexpanelap"});
        } else {
            for (int i = chainHideIndex; i <= 3; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"chainname" + i, "chainnum" + i, "chainlast" + i});
            }
        }
    }

    private void dynamicShowPannel(String type, int index, String indexCode, Map<String, String> ransInfoMap, Map<String, Set<Long>> personInfoMap, SWCPageCache pageCache) {
        this.modifyLabelValue(type + "name" + index, ransInfoMap.get(indexCode));
        Set<Long> calPersonIdSet = personInfoMap.get(indexCode);
        if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
            this.modifyLabelValue(type + "num" + index, "0");
            pageCache.put(type + "num" + index, (Object)"[]");
        } else {
            this.modifyLabelValue(type + "num" + index, String.valueOf(calPersonIdSet.size()));
            pageCache.put(type + "num" + index, (Object)calPersonIdSet.toString());
        }
    }

    private String getIndexValStr(String indexCode) {
        String desc = "";
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_EQUALS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_EQUALS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAININCREASE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAININCREASE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAININCREASE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAININCREASE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAINGROWTH_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAINGROWTH_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAINGROWTH_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAINGROWTH_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARINCREASE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARINCREASE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARINCREASE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARINCREASE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARGROWTH_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARGROWTH_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARGROWTH_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARGROWTH_LESS.getDesc();
        }
        return desc;
    }

    private void modifyLabelValue(String labelName, String modifyStr) {
        Label lable = (Label)this.getControl(labelName);
        lable.setText(modifyStr);
    }
}

