/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryresultcheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsas.business.salaryresultcheck.helper.SalaryResultCheckHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.ResultCheckIndexEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryResultCheckViewPlugin
extends SWCDataBaseEdit
implements HyperLinkClickListener {
    public final Log log = LogFactory.getLog(SalaryResultCheckViewPlugin.class);
    private static final String BASIC_ENTRY = "basicentryentity";
    private static final String BASIC_ITEM_NAME = "basicitemname";
    private static final String BASIC_ITEM_ID = "basicitemid";
    private static final String BASIC_ITEM_CATEGORY = "basiccategory";
    private static final String BASIC_CAL_PERSON_NUM = "basiccalpersonnum";
    private static final String BASIC_VIEW_POINT_OUT = "viewbasicpointout";
    private static final String BASIC_SALARY_IDX = "hsas_saldtlbasicindex";
    private static final String BASIC_ALL_MARK = "basicallmark";
    private static final String BASIC_CANCEL_MARK = "basiccancelmark";
    private static final String BASIC_DONT_PROMPT = "basicprompt";
    private static final String BASIC_MARK_ENUM = "1";
    private static final String BASIC_OPERATIONCOLUMN = "basicoperationcolumnap";
    private static final String SALARY_DETAIL_MARK_TABLE = "hsas_salarydtmark";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BASIC_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        SalaryResultCheckHelper helper = new SalaryResultCheckHelper();
        DynamicObject[] checkDatas = helper.getSalaryResultCheckInfoByCalTaskId(calTaskId);
        if (checkDatas == null || checkDatas.length == 0) {
            return;
        }
        HashSet<Long> retCheckSchemeIdSet = new HashSet<Long>(16);
        ArrayList<Long> checkRetstatsIdList = new ArrayList<Long>(checkDatas.length);
        for (DynamicObject checkRetStatsObj : checkDatas) {
            checkRetstatsIdList.add(checkRetStatsObj.getLong("id"));
            DynamicObject checkSchemeObj = checkRetStatsObj.getDynamicObject("checkscheme");
            retCheckSchemeIdSet.add(checkSchemeObj.getLong("id"));
        }
        DynamicObject[] checkSchemeItemSeq = helper.getItemSeqByCheckSchemeId(retCheckSchemeIdSet);
        if (checkSchemeItemSeq == null || checkSchemeItemSeq.length == 0) {
            return;
        }
        LinkedHashSet<Long> itemSeqLinkSet = new LinkedHashSet<Long>(16);
        for (DynamicObject checkSchemeItemSeqObj : checkSchemeItemSeq) {
            DynamicObjectCollection valueEntryColl = checkSchemeItemSeqObj.getDynamicObjectCollection("valueentry");
            for (DynamicObject valueEntryObj : valueEntryColl) {
                long itemId = valueEntryObj.getLong("itemid");
                itemSeqLinkSet.add(itemId);
            }
        }
        DynamicObjectCollection checkIndexStatsColl = helper.getCheckIndexStatsByCheckRetStatsIds(checkRetstatsIdList);
        if (checkIndexStatsColl == null || checkIndexStatsColl.size() == 0) {
            return;
        }
        HashSet<Long> itemIdSet = new HashSet<Long>(16);
        for (DynamicObject checkIndexStatsCollObj : checkIndexStatsColl) {
            long itemId = checkIndexStatsCollObj.getLong("itemid");
            itemIdSet.add(itemId);
        }
        DynamicObjectCollection checkIndexPersonColl = helper.getCheckIndexPersonByCheckRetStatsIds(checkRetstatsIdList);
        DynamicObjectCollection checkNotPromptColl = helper.getCheckNotPromptInfo(calTaskId, RequestContext.get().getCurrUserId());
        HashSet<Long> notPromptSet = new HashSet<Long>(16);
        for (DynamicObject checkNotPromptObj : checkNotPromptColl) {
            notPromptSet.add(checkNotPromptObj.getLong("itemid"));
        }
        this.loadBasicEntryDatas(checkIndexPersonColl, retCheckSchemeIdSet, notPromptSet, itemIdSet, itemSeqLinkSet);
        DynamicObject[] markInfos = helper.getSalaryCheckMarkInfoByCalTaskId(calTaskId, null);
        this.loadBasicMarkOprion(markInfos);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)BASIC_VIEW_POINT_OUT)) {
            this.viewBasicPointOut();
        } else if (SWCStringUtils.equals((String)optKey, (String)BASIC_ALL_MARK)) {
            this.basicMarkAll();
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)optKey, (String)BASIC_CANCEL_MARK)) {
            this.basicCancelMark();
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)optKey, (String)BASIC_DONT_PROMPT)) {
            this.basicPrompt();
            this.getView().invokeOperation("refresh");
        }
    }

    private void basicPrompt() {
        int index = this.getModel().getEntryCurrentRowIndex(BASIC_ENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(BASIC_ENTRY, index);
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        long itemId = viewObj.getLong(BASIC_ITEM_ID);
        long userId = RequestContext.get().getCurrUserId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarychecknotprompt");
        String field = "id";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("itemid", "=", (Object)itemId);
        filter.and("userid", "=", (Object)userId);
        DynamicObjectCollection notPromptColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        if (notPromptColl != null && notPromptColl.size() > 0) {
            return;
        }
        DynamicObject notPromptObj = helper.generateEmptyDynamicObject();
        notPromptObj.set("caltaskid", (Object)calTaskId);
        notPromptObj.set("itemid", (Object)itemId);
        notPromptObj.set("userid", (Object)userId);
        helper.saveOne(notPromptObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicCancelMark() {
        int index = this.getModel().getEntryCurrentRowIndex(BASIC_ENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(BASIC_ENTRY, index);
        long itemId = viewObj.getLong(BASIC_ITEM_ID);
        SalaryResultCheckHelper helper = new SalaryResultCheckHelper();
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Object[] markInfos = helper.getSalaryCheckMarkInfoByCalTaskId(calTaskId, Long.valueOf(itemId));
        if (markInfos == null || markInfos.length == 0) {
            return;
        }
        String checkType = BASIC_MARK_ENUM;
        DynamicObject markObj = helper.getSalaryRetMarkIdsByCalTaskId(calTaskId, checkType);
        Long[] markIds = this.getSalaryRetMarkIds(markObj);
        Object[] salaryRetMarkInfos = helper.getSalaryRetMarkInfoByIds(markIds);
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper("hsas_salarycheckmark");
        try (TXHandle txHandle = TX.requiresNew();){
            dataHelper.delete(markInfos);
            if (salaryRetMarkInfos != null && salaryRetMarkInfos.length > 0) {
                SWCDataServiceHelper salaryRetMarkHelper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
                salaryRetMarkHelper.delete(salaryRetMarkInfos);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"SalaryResultCheckViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private Long[] getSalaryRetMarkIds(DynamicObject markObj) {
        if (markObj == null) {
            return null;
        }
        String markIdsStr = markObj.getString("salaryretmarkids");
        if (SWCStringUtils.isEmpty((String)markIdsStr)) {
            return null;
        }
        String[] markIdsArray = markIdsStr.split(",");
        int len = markIdsArray.length;
        Long[] markIds = new Long[len];
        for (int i = 0; i < len; ++i) {
            markIds[i] = Long.valueOf(markIdsArray[i]);
        }
        return markIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicMarkAll() {
        int index = this.getModel().getEntryCurrentRowIndex(BASIC_ENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(BASIC_ENTRY, index);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycheckmark");
        DynamicObject markObj = helper.generateEmptyDynamicObject();
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        markObj.set("caltaskid", (Object)calTaskId);
        long itemId = viewObj.getLong(BASIC_ITEM_ID);
        String itemName = viewObj.getString(BASIC_ITEM_NAME);
        markObj.set("markid", (Object)itemId);
        markObj.set("checktype", (Object)BASIC_MARK_ENUM);
        SalaryDetailResultMarkListHelper detailHelper = new SalaryDetailResultMarkListHelper();
        Set calPersonIds = detailHelper.getCalPersonIds(Long.valueOf(calTaskId));
        if (calPersonIds == null || calPersonIds.size() == 0) {
            return;
        }
        SalaryResultCheckHelper checkHelper = new SalaryResultCheckHelper();
        DynamicObjectCollection checkStatsIdColl = checkHelper.getCheckStatsIdByCalTaskId(calTaskId);
        if (checkStatsIdColl == null || checkStatsIdColl.size() == 0) {
            return;
        }
        HashSet<Long> checkStatsIdSet = new HashSet<Long>(checkStatsIdColl.size());
        for (DynamicObject checkStatsIdObj : checkStatsIdColl) {
            checkStatsIdSet.add(checkStatsIdObj.getLong("id"));
        }
        DynamicObjectCollection checkIndexStatsInfoColl = checkHelper.getCheckIndexStatsByItemIdAndCheckStatsId(checkStatsIdSet, itemId);
        if (checkIndexStatsInfoColl == null || checkIndexStatsInfoColl.size() == 0) {
            return;
        }
        HashSet<Object> indexCodeSet = new HashSet<Object>(checkIndexStatsInfoColl.size());
        HashMap<String, String> checkIndexTransInfoMap = new HashMap<String, String>(checkIndexStatsInfoColl.size());
        for (DynamicObject checkIndexStatsInfoObj : checkIndexStatsInfoColl) {
            String indexCode = checkIndexStatsInfoObj.getString("indexcode");
            String indexValue = checkIndexStatsInfoObj.getString("indexvalue");
            checkIndexTransInfoMap.put(indexCode, this.getIndexValStr(indexCode) + indexValue);
            indexCodeSet.add(indexCode);
        }
        DynamicObjectCollection checkIndexPersonInfoColl = checkHelper.getCheckIndexPersonByItemIdAndCheckStatsId(checkStatsIdSet, itemId, indexCodeSet);
        HashMap checkIndexPersonInfoMap = new HashMap(16);
        for (DynamicObject checkIndexPersonInfoObj : checkIndexPersonInfoColl) {
            String indexCode = checkIndexPersonInfoObj.getString("indexcode");
            long calPersonId = checkIndexPersonInfoObj.getLong("personid");
            HashSet<Long> calPersonIdSet = (HashSet<Long>)checkIndexPersonInfoMap.get(indexCode);
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                calPersonIdSet = new HashSet<Long>(16);
                if (calPersonIds.contains(calPersonId)) {
                    calPersonIdSet.add(calPersonId);
                }
                checkIndexPersonInfoMap.put(indexCode, calPersonIdSet);
                continue;
            }
            if (calPersonIds.contains(calPersonId)) {
                calPersonIdSet.add(calPersonId);
            }
            checkIndexPersonInfoMap.put(indexCode, calPersonIdSet);
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper dataServicehelper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        Date currentDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        for (Map.Entry entry : checkIndexPersonInfoMap.entrySet()) {
            String indexCode = (String)entry.getKey();
            DynamicObject[] calPersonIdSet = (DynamicObject[])entry.getValue();
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) continue;
            DynamicObject salaryDtMarkObj = dataServicehelper.generateEmptyDynamicObject();
            salaryDtMarkObj.set("caltaskid", (Object)calTaskId);
            salaryDtMarkObj.set("marknum", (Object)calPersonIdSet.size());
            salaryDtMarkObj.set("markreason", (Object)(itemName + (String)checkIndexTransInfoMap.get(indexCode)));
            salaryDtMarkObj.set("createtime", (Object)currentDate);
            salaryDtMarkObj.set("modifytime", (Object)currentDate);
            salaryDtMarkObj.set("creator", (Object)userId);
            salaryDtMarkObj.set("modifier", (Object)userId);
            DynamicObjectCollection calPersonColl = salaryDtMarkObj.getDynamicObjectCollection("calpersonentry");
            for (Long l : calPersonIdSet) {
                DynamicObject calPersonObj = new DynamicObject(calPersonColl.getDynamicObjectType());
                calPersonObj.set("calpersonid", (Object)l);
                calPersonColl.add((Object)calPersonObj);
            }
            salaryDtMarkObj.set("calpersonentry", (Object)calPersonColl);
            saveList.add(salaryDtMarkObj);
        }
        if (saveList.size() == 0) {
            return;
        }
        DynamicObject[] salaryDtMarkArray = new DynamicObject[saveList.size()];
        for (int i = 0; i < saveList.size(); ++i) {
            salaryDtMarkArray[i] = (DynamicObject)saveList.get(i);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            dataServicehelper.save(salaryDtMarkArray);
            ArrayList<Long> salaryRetMarkIds = new ArrayList<Long>(10);
            for (DynamicObject dataObj : salaryDtMarkArray) {
                long l = dataObj.getLong("id");
                if (l == 0L) continue;
                salaryRetMarkIds.add(l);
            }
            if (salaryRetMarkIds != null && salaryRetMarkIds.size() > 0) {
                int size = salaryRetMarkIds.size();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    long salaryRetMarkId = (Long)salaryRetMarkIds.get(i);
                    sb.append(String.valueOf(salaryRetMarkId));
                    if (i == size - 1) continue;
                    sb.append(',');
                }
                markObj.set("salaryretmarkids", (Object)sb.toString());
            }
            helper.saveOne(markObj);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6807\u8bb0\u6210\u529f\u3002", (String)"SalaryResultCheckViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private String getIndexValStr(String indexCode) {
        String desc = "";
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_EQUALS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_EQUALS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.VALUE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.VALUE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAININCREASE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAININCREASE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAININCREASE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAININCREASE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAINGROWTH_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAINGROWTH_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.CHAINGROWTH_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.CHAINGROWTH_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARINCREASE_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARINCREASE_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARINCREASE_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARINCREASE_LESS.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARGROWTH_BIGGER.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARGROWTH_BIGGER.getDesc();
        }
        if (SWCStringUtils.equals((String)ResultCheckIndexEnum.YEARGROWTH_LESS.getCode(), (String)indexCode)) {
            return ResultCheckIndexEnum.YEARGROWTH_LESS.getDesc();
        }
        return desc;
    }

    private void loadBasicMarkOprion(DynamicObject[] markInfos) {
        if (markInfos == null || markInfos.length == 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BASIC_ENTRY);
            entryGrid.addPackageDataListener(pkEvent -> {
                if (pkEvent.getSource() instanceof OperationColumn && BASIC_OPERATIONCOLUMN.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                    List operationColItems = (List)pkEvent.getFormatValue();
                    for (OperationColItem operationColItem : operationColItems) {
                        String operationKey = operationColItem.getOperationKey();
                        if (SWCStringUtils.equals((String)operationKey, (String)BASIC_ALL_MARK)) {
                            operationColItem.setVisible(true);
                            continue;
                        }
                        if (!SWCStringUtils.equals((String)operationKey, (String)BASIC_CANCEL_MARK)) continue;
                        operationColItem.setVisible(false);
                    }
                }
            });
            return;
        }
        HashSet<Long> markedSet = new HashSet<Long>(markInfos.length);
        for (DynamicObject markObj : markInfos) {
            String checkType = markObj.getString("checktype");
            if (!SWCStringUtils.equals((String)checkType, (String)BASIC_MARK_ENUM)) continue;
            long markId = markObj.getLong("markid");
            markedSet.add(markId);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(BASIC_ENTRY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && BASIC_OPERATIONCOLUMN.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                long markId = pkEvent.getRowData().getLong(BASIC_ITEM_ID);
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    if (SWCStringUtils.equals((String)operationKey, (String)BASIC_ALL_MARK)) {
                        if (markedSet.contains(markId)) {
                            operationColItem.setVisible(false);
                            continue;
                        }
                        operationColItem.setVisible(true);
                        continue;
                    }
                    if (!SWCStringUtils.equals((String)operationKey, (String)BASIC_CANCEL_MARK)) continue;
                    if (markedSet.contains(markId)) {
                        operationColItem.setVisible(true);
                        continue;
                    }
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)actId, (String)"basicPointOutCloseBack")) {
            String calPersonIds = (String)closedCallBackEvent.getReturnData();
            if (SWCStringUtils.isEmpty((String)calPersonIds)) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            SWCPageCache pageCache = new SWCPageCache(parentView);
            pageCache.put(parentView.getPageId() + "_cacheCalPersonIds", (Object)calPersonIds);
            this.getView().close();
        }
    }

    private void viewBasicPointOut() {
        int index = this.getModel().getEntryCurrentRowIndex(BASIC_ENTRY);
        DynamicObject viewObj = this.getModel().getEntryRowEntity(BASIC_ENTRY, index);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BASIC_SALARY_IDX);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        long basicItemId = viewObj.getLong(BASIC_ITEM_ID);
        String title = ResManager.loadKDString((String)"\u6307\u6807\u5206\u5e03", (String)"SalaryResultCheckViewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        showParameter.setCaption(viewObj.getString(BASIC_ITEM_NAME) + title);
        showParameter.setCustomParam("basicItemId", (Object)basicItemId);
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "basicPointOutCloseBack"));
        this.getView().showForm(showParameter);
    }

    private Map<Long, Set<Long>> getItemIdAndCalPersonIdRelationByItemIdSet(DynamicObjectCollection checkIndexPersonColl, Set<Long> calPersonIds, Set<Long> itemIdSet) {
        HashMap<Long, Set<Long>> cacheItemIdAndCalPersonIdMap = new HashMap<Long, Set<Long>>(16);
        for (Long itemId : itemIdSet) {
            if (checkIndexPersonColl == null || checkIndexPersonColl.size() == 0) {
                cacheItemIdAndCalPersonIdMap.put(itemId, new HashSet(16));
                continue;
            }
            for (DynamicObject checkIndexPersonObj : checkIndexPersonColl) {
                Long calPersonId;
                Object itemIdObj = checkIndexPersonObj.get("itemid");
                Long checkIndexItemId = this.getLongVal(itemIdObj);
                if (checkIndexItemId.longValue() != itemId.longValue() || !calPersonIds.contains(calPersonId = Long.valueOf(checkIndexPersonObj.getLong("personid")))) continue;
                HashSet<Long> calPersonIdSet = (HashSet<Long>)cacheItemIdAndCalPersonIdMap.get(itemId);
                if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                    calPersonIdSet = new HashSet<Long>(16);
                    calPersonIdSet.add(calPersonId);
                    cacheItemIdAndCalPersonIdMap.put(itemId, calPersonIdSet);
                    continue;
                }
                calPersonIdSet.add(calPersonId);
                cacheItemIdAndCalPersonIdMap.put(itemId, calPersonIdSet);
            }
        }
        return cacheItemIdAndCalPersonIdMap;
    }

    private Map<Long, Set<Long>> getItemIdAndCalPersonIdRelation(DynamicObjectCollection checkIndexPersonColl, Set<Long> calPersonIds) {
        HashMap<Long, Set<Long>> cacheItemIdAndCalPersonIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject checkIndexPersonObj : checkIndexPersonColl) {
            Object itemIdObj = checkIndexPersonObj.get("itemid");
            Long itemId = this.getLongVal(itemIdObj);
            Long calPersonId = checkIndexPersonObj.getLong("personid");
            if (!calPersonIds.contains(calPersonId)) continue;
            HashSet<Long> calPersonIdSet = (HashSet<Long>)cacheItemIdAndCalPersonIdMap.get(itemId);
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                calPersonIdSet = new HashSet<Long>(16);
                calPersonIdSet.add(calPersonId);
                cacheItemIdAndCalPersonIdMap.put(itemId, calPersonIdSet);
                continue;
            }
            calPersonIdSet.add(calPersonId);
            cacheItemIdAndCalPersonIdMap.put(itemId, calPersonIdSet);
        }
        return cacheItemIdAndCalPersonIdMap;
    }

    private void loadBasicEntryDatas(DynamicObjectCollection checkIndexPersonColl, Set<Long> retCheckSchemeIdSet, Set<Long> notPromptSet, Set<Long> itemIdSet, Set<Long> itemSeqLinkSet) {
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Set calPersonIds = helper.getCalPersonIds(Long.valueOf(calTaskId));
        if (calPersonIds == null || calPersonIds.size() == 0) {
            return;
        }
        Map<Long, Set<Long>> cacheItemIdAndCalPersonIdMap = this.getItemIdAndCalPersonIdRelationByItemIdSet(checkIndexPersonColl, calPersonIds, itemIdSet);
        SalaryResultCheckHelper checkHelper = new SalaryResultCheckHelper();
        DynamicObject[] itemInfoArray = checkHelper.getItemInfoByItemIdAndSchemeId(retCheckSchemeIdSet, itemIdSet);
        HashMap cacheItemInfoMap = new HashMap(16);
        for (DynamicObject itemInfoObj : itemInfoArray) {
            DynamicObjectCollection itemEntryColl = itemInfoObj.getDynamicObjectCollection("valueentry");
            for (DynamicObject itemEntryObj : itemEntryColl) {
                Object itemIdObj = itemEntryObj.get("itemid");
                Long itemId = this.getLongVal(itemIdObj);
                String itemType = itemEntryObj.getString("itemtype");
                String itemName = itemEntryObj.getString("itemname");
                if (cacheItemInfoMap.containsKey(itemId)) continue;
                HashMap<String, String> itemMap = new HashMap<String, String>(2);
                itemMap.put("itemType", itemType);
                itemMap.put("itemName", itemName);
                cacheItemInfoMap.put(itemId, itemMap);
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(BASIC_ITEM_NAME, new Object[0]);
        setter.addField(BASIC_ITEM_ID, new Object[0]);
        setter.addField(BASIC_ITEM_CATEGORY, new Object[0]);
        setter.addField(BASIC_CAL_PERSON_NUM, new Object[0]);
        for (Long itemId : itemSeqLinkSet) {
            if (!itemIdSet.contains(itemId) || notPromptSet.contains(itemId)) continue;
            Set<Long> calPersonIdSet = cacheItemIdAndCalPersonIdMap.get(itemId);
            Map itemInfoMap = (Map)cacheItemInfoMap.get(itemId);
            if (itemInfoMap == null || itemInfoMap.size() == 0) continue;
            String itemType = (String)itemInfoMap.get("itemType");
            String itemName = (String)itemInfoMap.get("itemName");
            if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
                setter.addRow(new Object[]{itemName, itemId, itemType, 0});
                continue;
            }
            setter.addRow(new Object[]{itemName, itemId, itemType, calPersonIdSet.size()});
        }
        model.batchCreateNewEntryRow(BASIC_ENTRY, setter);
        this.getView().updateView(BASIC_ENTRY);
        model.endInit();
    }

    private Long getLongVal(Object longObj) {
        Long val = 0L;
        val = longObj instanceof Integer ? Long.valueOf(String.valueOf(longObj)) : (Long)longObj;
        return val;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int index = arg0.getRowIndex();
        String fieldName = arg0.getFieldName();
        if (SWCStringUtils.equals((String)fieldName, (String)BASIC_CAL_PERSON_NUM)) {
            this.basicCalPersonNumClick(index);
        }
    }

    private void basicCalPersonNumClick(int index) {
        SalaryResultCheckHelper helper = new SalaryResultCheckHelper();
        long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        DynamicObject[] checkDatas = helper.getSalaryResultCheckInfoByCalTaskId(calTaskId);
        if (checkDatas == null || checkDatas.length == 0) {
            return;
        }
        ArrayList<Long> checkRetstatsIdList = new ArrayList<Long>(checkDatas.length);
        for (DynamicObject checkRetStatsObj : checkDatas) {
            checkRetstatsIdList.add(checkRetStatsObj.getLong("id"));
        }
        DynamicObjectCollection checkIndexPersonColl = helper.getCheckIndexPersonByCheckRetStatsIds(checkRetstatsIdList);
        if (checkIndexPersonColl == null || checkIndexPersonColl.size() == 0) {
            return;
        }
        SalaryDetailResultMarkListHelper markListhelper = new SalaryDetailResultMarkListHelper();
        Set calPersonIds = markListhelper.getCalPersonIds(Long.valueOf(calTaskId));
        long basicItemId = ((DynamicObject)this.getModel().getEntryEntity(BASIC_ENTRY).get(index)).getLong(BASIC_ITEM_ID);
        Map<Long, Set<Long>> cacheItemIdAndCalPersonIdMap = this.getItemIdAndCalPersonIdRelation(checkIndexPersonColl, calPersonIds);
        Set<Long> calPersonIdSet = cacheItemIdAndCalPersonIdMap.get(basicItemId);
        if (calPersonIdSet == null || calPersonIdSet.size() == 0) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        SWCPageCache pageCache = new SWCPageCache(parentView);
        pageCache.put(parentView.getPageId() + "_cacheCalPersonIds", (Object)calPersonIdSet.toString());
        this.getView().close();
    }
}

