/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class CalRuleHelper {
    public static boolean resortEntryByItemTypeId(List<Long> itemTypeIdList, DynamicObjectCollection entryEntity, List<DynamicObject> resultList) {
        LinkedList<DynamicObject> sortedEntryList = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> unSortedEntryList = new LinkedList<DynamicObject>();
        CalRuleHelper.classifyEntry(entryEntity, itemTypeIdList, sortedEntryList, unSortedEntryList);
        if (CollectionUtils.isEmpty(sortedEntryList)) {
            resultList.addAll(unSortedEntryList);
            return false;
        }
        List salaryItemTypeIdList = entryEntity.stream().map(entry -> entry.getLong("salaryitem.salaryitemtype.id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitemtype");
        DynamicObjectCollection salaryItemTypes = helper.queryOriginalCollection("id,index", new QFilter[]{new QFilter("id", "in", salaryItemTypeIdList)});
        Map<Long, Integer> salaryItemTypeIndexMap = salaryItemTypes.stream().collect(Collectors.toMap(salaryItemType -> salaryItemType.getLong("id"), salaryItemType -> salaryItemType.getInt("index")));
        sortedEntryList = CalRuleHelper.resortSortedEntryList(sortedEntryList, salaryItemTypeIndexMap);
        if (CollectionUtils.isEmpty(unSortedEntryList)) {
            resultList.addAll(sortedEntryList);
            return true;
        }
        int minIndex = salaryItemTypeIndexMap.getOrDefault(sortedEntryList.get(0).getLong("salaryitem.salaryitemtype.id"), 0);
        List unSortedIndexList = unSortedEntryList.stream().map(unSortedEntry -> salaryItemTypeIndexMap.getOrDefault(unSortedEntry.getLong("salaryitem.salaryitemtype.id"), 0)).sorted().collect(Collectors.toList());
        int targetIndex = -1;
        for (int index = unSortedIndexList.size() - 1; index >= 0; --index) {
            Integer sortedIndex = (Integer)unSortedIndexList.get(index);
            if (sortedIndex > minIndex) continue;
            targetIndex = sortedIndex;
            break;
        }
        int targetSeq = 0;
        if (targetIndex >= 0) {
            int seq = unSortedEntryList.size() - 1;
            while (seq >= 0) {
                DynamicObject unSortedEntry2 = unSortedEntryList.get(seq);
                DynamicObject unSortedItem = unSortedEntry2.getDynamicObject("salaryitem");
                if (unSortedItem != null && salaryItemTypeIndexMap.getOrDefault(unSortedItem.getLong("salaryitemtype.id"), 0) == targetIndex) {
                    targetSeq = seq + 1;
                    break;
                }
                targetSeq = seq--;
            }
        }
        unSortedEntryList.addAll(targetSeq, sortedEntryList);
        resultList.addAll(unSortedEntryList);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static LinkedList<DynamicObject> resortSortedEntryList(LinkedList<DynamicObject> sortedEntryList, Map<Long, Integer> salaryItemTypeIndexMap) {
        sortedEntryList.sort((o1, o2) -> {
            int itemTypeIndex1 = salaryItemTypeIndexMap.getOrDefault(o1.getLong("salaryitem.salaryitemtype.id"), 0);
            int itemTypeIndex2 = salaryItemTypeIndexMap.getOrDefault(o2.getLong("salaryitem.salaryitemtype.id"), 0);
            return itemTypeIndex1 - itemTypeIndex2;
        });
        LinkedHashMap entryListMap = new LinkedHashMap(sortedEntryList.size());
        for (DynamicObject entry : sortedEntryList) {
            void var6_8;
            Long salaryItemTypeId = entry.getLong("salaryitem.salaryitemtype.id");
            List list = (List)entryListMap.get(salaryItemTypeId);
            if (list == null) {
                ArrayList arrayList = new ArrayList(10);
                entryListMap.put(salaryItemTypeId, arrayList);
            }
            var6_8.add(entry);
        }
        HashMap<String, Set<DynamicObject>> dependonsSetMap = new HashMap<String, Set<DynamicObject>>(sortedEntryList.size());
        for (int index = 0; index < sortedEntryList.size(); ++index) {
            DynamicObject entry = sortedEntryList.get(index);
            String string = entry.getString("salaryitem.number");
            DynamicObject formula = entry.getDynamicObject("formula");
            Set<String> dependons = formula == null ? new HashSet<String>(0) : CalRuleHelper.getDependonItems(formula);
            dependonsSetMap.put(string, CalRuleHelper.getDependonsSet(sortedEntryList, dependons));
        }
        LinkedList<DynamicObject> resultList = new LinkedList<DynamicObject>();
        for (Map.Entry entry : entryListMap.entrySet()) {
            CalRuleHelper.resortPartEntryList((List)entry.getValue(), dependonsSetMap);
            resultList.addAll((Collection)entry.getValue());
        }
        return resultList;
    }

    private static void resortPartEntryList(List<DynamicObject> entryList, Map<String, Set<DynamicObject>> dependonsSetMap) {
        int index;
        LinkedHashSet<DynamicObject> linkedHashSet = new LinkedHashSet<DynamicObject>(entryList.size());
        for (index = 0; index < entryList.size(); ++index) {
            DynamicObject entry = entryList.get(index);
            CalRuleHelper.insertEntryForResort(linkedHashSet, new HashSet<DynamicObject>(entryList.size()), entry, dependonsSetMap, entryList);
        }
        index = 0;
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            entryList.set(index++, (DynamicObject)iterator.next());
        }
    }

    private static void insertEntryForResort(LinkedHashSet<DynamicObject> linkedHashSet, Set<DynamicObject> waitSet, DynamicObject entry, Map<String, Set<DynamicObject>> dependonsSetMap, List<DynamicObject> entryList) {
        if (linkedHashSet.contains(entry)) {
            return;
        }
        Set<DynamicObject> dependonsSet = dependonsSetMap.get(entry.getString("salaryitem.number"));
        if (CollectionUtils.isEmpty(dependonsSet)) {
            linkedHashSet.add(entry);
            return;
        }
        if (waitSet.contains(entry)) {
            return;
        }
        waitSet.add(entry);
        for (DynamicObject dependon : dependonsSet) {
            if (!entryList.contains(dependon)) continue;
            CalRuleHelper.insertEntryForResort(linkedHashSet, waitSet, dependon, dependonsSetMap, entryList);
        }
        linkedHashSet.add(entry);
        waitSet.remove(entry);
    }

    private static Set<DynamicObject> getDependonsSet(List<DynamicObject> dynamicObjects, Set<String> itemNumberSet) {
        if (CollectionUtils.isEmpty(itemNumberSet)) {
            return new HashSet<DynamicObject>(0);
        }
        HashSet<DynamicObject> dependonsSet = new HashSet<DynamicObject>(itemNumberSet.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String uniqueCode = dynamicObject.getString("salaryitem.uniquecode");
            if (!itemNumberSet.contains(uniqueCode)) continue;
            dependonsSet.add(dynamicObject);
        }
        return dependonsSet;
    }

    private static Set<String> getDependonItems(DynamicObject formula) {
        if (formula == null) {
            return new HashSet<String>(0);
        }
        String[] itemArray = formula.getString("dependonsitem").split(",");
        if (itemArray.length == 0) {
            return new HashSet<String>(0);
        }
        return Arrays.stream(itemArray).collect(Collectors.toSet());
    }

    private static void classifyEntry(DynamicObjectCollection entryEntity, List<Long> itemTypeIdList, LinkedList<DynamicObject> sortedEntryList, LinkedList<DynamicObject> unSortedEntryList) {
        for (DynamicObject entry : entryEntity) {
            DynamicObject salaryItem = entry.getDynamicObject("salaryitem");
            if (salaryItem == null) {
                unSortedEntryList.add(entry);
                continue;
            }
            Long itemTypeId = entry.getLong("salaryitem.salaryitemtype.id");
            if (!itemTypeIdList.contains(itemTypeId)) {
                unSortedEntryList.add(entry);
                continue;
            }
            sortedEntryList.add(entry);
        }
    }
}

