/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.accumulator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import org.jetbrains.annotations.NotNull;

public class AccResultCheckService {
    private static final Log LOGGER = LogFactory.getLog(AccResultCheckService.class);

    public Map<Long, List<DynamicObject>> getAccDetailMapByAccResultId(Set<Long> accResultIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter filter = new QFilter("accresult.id", "in", accResultIdSet);
        DynamicObjectCollection accDetailList = helper.queryOriginalCollection("id,accresult.id", new QFilter[]{filter});
        return accDetailList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("accresult.id")));
    }

    public DynamicObject getAccResultById(Long id, String fields) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        return helper.queryOne(fields, (Object)id);
    }

    public void checkDataAndSave(long accResultId, BigDecimal value, Long personIndexId, Map<String, Long> personMap) {
        LOGGER.info("checkDataAndSave start,accResultId = {},value = {}", (Object)accResultId, (Object)value);
        HashSet<Long> accResultIdSet = new HashSet<Long>(16);
        accResultIdSet.add(accResultId);
        Map<Long, List<DynamicObject>> accDetailMap = this.getAccDetailMapByAccResultId(accResultIdSet);
        if (accDetailMap.size() > 0) {
            LOGGER.info("exist acc details data");
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7d2f\u52a0\u7ed3\u679c\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u901a\u8fc7\u85aa\u8d44\u6838\u7b97\u751f\u6210\u7684\u7d2f\u52a0\u660e\u7ec6\u7ed3\u679c\uff0c\u65e0\u6cd5\u8c03\u6574\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"AccResultCheckService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        HashMap<Long, Map<String, Long>> personIndexMap = new HashMap<Long, Map<String, Long>>(1);
        personIndexMap.put(personIndexId, personMap);
        HashMap<Long, String> errorDataMap = new HashMap<Long, String>(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, "3");
        if (errorDataMap.size() > 0) {
            LOGGER.info("checkPersonHrIsCalingAndAddMutexData is fail");
            throw new KDBizException((String)errorDataMap.get(personIndexId));
        }
        TXHandle txHandle = TX.requiresNew();
        try {
            DynamicObject accResult = this.dealAccResultData(accResultId, value);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
            helper.saveOne(accResult);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            txHandle.markRollback();
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        finally {
            txHandle.close();
            AccCalMutexUtils.releaseSalaryCalMutexData(personIndexMap.keySet(), "3");
        }
        LOGGER.info("checkDataAndSave end,accResultId = {}", (Object)accResultId);
    }

    @NotNull
    private DynamicObject dealAccResultData(long accResultId, BigDecimal value) {
        String fields = "id,resultvalue,modifytime,modifier,acc.datatype.id,acc.dataprecision.id,acc.dataround.id,currency.amtprecision,adjustentry.adjustamount,adjustentry.adjustdescript,adjustentry.adjusttime,adjustentry.adjustperson,adjustentry.seq";
        DynamicObject accResult = this.getAccResultById(accResultId, fields);
        long dataTypeId = accResult.getLong("acc.datatype.id");
        int scale = 0;
        scale = DataTypeEnum.NUMBERIC.getDbId() == dataTypeId ? ItemDataUtils.getScal((long)accResult.getLong("acc.dataprecision.id")) : accResult.getInt("currency.amtprecision");
        long dataRoundId = accResult.getLong("acc.dataround.id");
        value = value.setScale(scale, ItemDataUtils.getRoundingMode((long)dataRoundId));
        accResult.set("resultvalue", (Object)value);
        accResult.set("modifytime", (Object)new Date());
        accResult.set("modifier", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection entryList = accResult.getDynamicObjectCollection("adjustentry");
        if (entryList.size() > 0) {
            entryList.clear();
        }
        String adjustDescript = ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"AccResultCheckService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        DynamicObject entry = entryList.addNew();
        entry.set("seq", (Object)1);
        entry.set("adjustamount", (Object)value);
        entry.set("adjustdescript", (Object)adjustDescript);
        entry.set("adjusttime", (Object)new Date());
        entry.set("adjustperson", (Object)RequestContext.get().getCurrUserId());
        return accResult;
    }
}

