/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.accumulator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class AccResultPermService {
    public Map<String, DynamicObject> getAccDataMap(Set<String> accNumberSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        String fields = "id,number,datatype.id,dataprecision.scale,dataround.id,periodtype,startdatetype,startdate,startmonth,startday,accdimension,accdimitementry.dimitemtype";
        QFilter filter = new QFilter("number", "in", accNumberSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] result = helper.query(fields, new QFilter[]{filter});
        return Arrays.asList(result).stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj));
    }

    public Set<Long> getHasPermsAccDataSet(Map<String, DynamicObject> existAccDataMap) {
        QFilter dataFilter;
        QFilter baseDataFilter;
        if (existAccDataMap.size() == 0) {
            return new HashSet<Long>(0);
        }
        Set accIdSet = existAccDataMap.values().stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        QFilter filter = new QFilter("id", "in", accIdSet);
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm() && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) != null) {
            filter.and(baseDataFilter);
        }
        if ((dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"acc")) != null) {
            filter.and(dataFilter);
        }
        DynamicObjectCollection result = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    public Map<String, List<DynamicObject>> getEmployeeDataMap(Set<String> empNumberSet, Set<Long> employeeIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("empnumber", "in", empNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObjectCollection result = helper.queryOriginalCollection("id,empnumber,person.personindexid", new QFilter[]{filter}, "startdate desc");
        HashMap<String, List<DynamicObject>> employeeMap = new HashMap<String, List<DynamicObject>>(16);
        ArrayList<DynamicObject> tempList = null;
        for (DynamicObject obj : result) {
            employeeIdSet.add(obj.getLong("id"));
            tempList = (ArrayList<DynamicObject>)employeeMap.get(obj.getString("empnumber"));
            if (tempList == null) {
                tempList = new ArrayList<DynamicObject>(10);
                employeeMap.put(obj.getString("empnumber"), tempList);
            }
            tempList.add(obj);
        }
        return employeeMap;
    }

    public Set<Long> getHasPermsEmployeeDataSet(Set<Long> employeeIdSet) {
        if (employeeIdSet.size() == 0) {
            return new HashSet<Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("id", "in", employeeIdSet);
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"employee");
        if (dataFilter != null) {
            filter.and(dataFilter);
        }
        DynamicObjectCollection result = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    public Map<String, DynamicObject> getSalaryFileData(Set<String> fileNumberSet) {
        if (fileNumberSet.size() == 0) {
            return new HashMap<String, DynamicObject>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String fields = "id,number,employee.empnumber,employee.id";
        QFilter filter = new QFilter("number", "in", fileNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection list = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return list.stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj));
    }

    public Set<Long> getHasPermsSalaryFileDataSet(Map<String, DynamicObject> fileMap) {
        QFilter dataFilter;
        if (fileMap.size() == 0) {
            return new HashSet<Long>(0);
        }
        Set salaryFileIdSet = fileMap.values().stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", salaryFileIdSet);
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            filter.and(new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        if ((dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"salaryfile")) != null) {
            filter.and(dataFilter);
        }
        DynamicObjectCollection result = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }
}

