/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.accumulator.accresultlist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsas.business.bankoffer.excel.ExcelHelper;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.common.constants.CalTableExportProgressConstants;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.kafka.common.Uuid;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AccResultListExportHelper {
    private static final String SYSTEM_NAME = "swc-hsas-business";
    protected static final Log logger = LogFactory.getLog(AccResultListExportHelper.class);
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";

    public void mutiThreadExport(RequestContext ctx, String fileName, Map<String, String> headers, int totalPages, QFilter[] filters, CountDownLatch countDownLatch, IFormView view, int totalElements, String downLoadTaskId, Map<Long, Integer> scaleMap) {
        CalTableExportProgressInfo progressInfo = new CalTableExportProgressInfo();
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("starting export data: {}", (Object)stopWatch.toString());
            SXSSFWorkbook copyWb = new SXSSFWorkbook(CalTableExportProgressConstants.ROW_ACCESS_WINDOWS_SIZE);
            try (SXSSFWorkbook wb = new SXSSFWorkbook(CalTableExportProgressConstants.ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                SXSSFSheet copySheet = copyWb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                copySheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                copyWb.setSheetName(0, fileName);
                this.writeAbstractRows(sheet);
                this.writeAbstractRows(copySheet);
                this.write2ExportHead(sheet, null, null, headers);
                this.write2ExportHead(copySheet, null, null, headers);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List<Map<String, Object>> accAdjustData = this.getAccAdjustExportData(filters, currentPage, CalTableExportProgressConstants.PAGE_SIZE, scaleMap);
                            int size = accAdjustData.size();
                            Long[] accResultIds = new Long[size];
                            for (int i = 0; i < size; ++i) {
                                accResultIds[i] = (Long)accAdjustData.get(i).get("id");
                            }
                            Map<Long, Object> accDetailMap = this.getAccDetailExportData(accResultIds, currentPage, CalTableExportProgressConstants.PAGE_SIZE);
                            List<Map<String, Object>> exportDataList = this.buildExportData(accAdjustData, accDetailMap);
                            lock.lock();
                            this.createContentColumn(wb, sheet, exportDataList, headers);
                            this.createContentColumn(copyWb, copySheet, exportDataList, headers);
                        }
                        catch (Exception e) {
                            logger.error("CalTableExportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(view);
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            complete = totalElements < 100 ? (long)totalElements : ((long)totalPages - countDownLatch.getCount()) * (long)CalTableExportProgressConstants.PAGE_SIZE.intValue();
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                    String filePath = ExcelHelper.storeFile((Workbook)copyWb, fileName + ".xlsx");
                    this.writeAccExportLog(totalElements, view, filePath);
                    this.flushAll(headers, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements, view);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }

    private void writeAbstractRows(SXSSFSheet sheet) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        SXSSFCell cell = headRow.createCell(0);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListExportHelper_44", (String)SYSTEM_NAME, (Object[])new Object[0]));
        sb.append(" # hsas_calresult");
        cell.setCellValue(sb.toString());
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"AccResultListExportHelper_45", (String)SYSTEM_NAME, (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"AccResultListExportHelper_46", (String)SYSTEM_NAME, (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"AccResultListExportHelper_47", (String)SYSTEM_NAME, (Object[])new Object[0]));
        sb.append(ResManager.loadKDString((String)"3\u3001\u6863\u6848\u7f16\u53f7\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u586b", (String)"AccResultListExportHelper_49", (String)SYSTEM_NAME, (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"4\u3001\u7d2f\u52a0\u5b50\u7ef4\u5ea6\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u586b", (String)"AccResultListExportHelper_50", (String)SYSTEM_NAME, (Object[])new Object[0])).append('\n');
        CellStyle columnStyle = this.getFontRedRowStyle(sheet.getWorkbook());
        cell.setCellStyle(columnStyle);
        cell.setCellValue(sb.toString());
        headRow = sheet.createRow(++row);
        cell = this.newCell(headRow, 0, sheet.getWorkbook());
        cell.setCellValue("employee.person.number");
        cell = this.newCell(headRow, 1, sheet.getWorkbook());
        cell.setCellValue("salaryfile.number");
        cell = this.newCell(headRow, 2, sheet.getWorkbook());
        cell.setCellValue("employee.person.name");
        cell = this.newCell(headRow, 3, sheet.getWorkbook());
        cell.setCellValue("acc.number");
        cell = this.newCell(headRow, 4, sheet.getWorkbook());
        cell.setCellValue("acc.name");
        cell = this.newCell(headRow, 5, sheet.getWorkbook());
        cell.setCellValue("instancenum");
        cell = this.newCell(headRow, 6, sheet.getWorkbook());
        cell.setCellValue("startdate");
        cell = this.newCell(headRow, 7, sheet.getWorkbook());
        cell.setCellValue("enddate");
        cell = this.newCell(headRow, 8, sheet.getWorkbook());
        cell.setCellValue("dimension1");
        cell = this.newCell(headRow, 9, sheet.getWorkbook());
        cell.setCellValue("dimension2");
        cell = this.newCell(headRow, 10, sheet.getWorkbook());
        cell.setCellValue("dimension3");
        cell = this.newCell(headRow, 11, sheet.getWorkbook());
        cell.setCellValue("dimension4");
        cell = this.newCell(headRow, 12, sheet.getWorkbook());
        cell.setCellValue("dimension5");
        cell = this.newCell(headRow, 13, sheet.getWorkbook());
        cell.setCellValue("acc.period.type");
        cell = this.newCell(headRow, 14, sheet.getWorkbook());
        cell.setCellValue("acc.bsedstrategy");
        cell = this.newCell(headRow, 15, sheet.getWorkbook());
        cell.setCellValue("acc.dimension");
        cell = this.newCell(headRow, 16, sheet.getWorkbook());
        cell.setCellValue("currency.name");
        cell = this.newCell(headRow, 17, sheet.getWorkbook());
        cell.setCellValue("resultvalue");
        cell = this.newCell(headRow, 18, sheet.getWorkbook());
        cell.setCellValue("entryfilenumber");
        cell = this.newCell(headRow, 19, sheet.getWorkbook());
        cell.setCellValue("caltask.number");
        cell = this.newCell(headRow, 20, sheet.getWorkbook());
        cell.setCellValue("caltask.name");
        cell = this.newCell(headRow, 21, sheet.getWorkbook());
        cell.setCellValue("period");
        cell = this.newCell(headRow, 22, sheet.getWorkbook());
        cell.setCellValue("period.startdate");
        cell = this.newCell(headRow, 23, sheet.getWorkbook());
        cell.setCellValue("period.enddate");
        cell = this.newCell(headRow, 24, sheet.getWorkbook());
        cell.setCellValue("period.paydate");
        cell = this.newCell(headRow, 25, sheet.getWorkbook());
        cell.setCellValue("entrycurrency");
        cell = this.newCell(headRow, 26, sheet.getWorkbook());
        cell.setCellValue("initvalue");
        cell = this.newCell(headRow, 27, sheet.getWorkbook());
        cell.setCellValue("currentvalue");
        cell = this.newCell(headRow, 28, sheet.getWorkbook());
        cell.setCellValue("entryresultval");
        cell = this.newCell(headRow, 29, sheet.getWorkbook());
        cell.setCellValue("entryindex");
        cell = this.newCell(headRow, 30, sheet.getWorkbook());
        cell.setCellValue("adjustamount");
        cell = this.newCell(headRow, 31, sheet.getWorkbook());
        cell.setCellValue("adjustreason");
        cell = this.newCell(headRow, 32, sheet.getWorkbook());
        cell.setCellValue("adjusttime");
        cell = this.newCell(headRow, 33, sheet.getWorkbook());
        cell.setCellValue("adjustuser");
        cell = this.newCell(headRow, 34, sheet.getWorkbook());
        cell.setCellValue("adjustnumber");
    }

    private SXSSFCell newCell(SXSSFRow headRow, int index, SXSSFWorkbook wb) {
        SXSSFCell cell = headRow.createCell(index);
        cell.setCellStyle(this.getFontCenterStyle(wb));
        return cell;
    }

    private List<Map<String, Object>> buildExportData(List<Map<String, Object>> accAdjustData, Map<Long, Object> accDetailMap) {
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> accResultMap : accAdjustData) {
            long accResultId = (Long)accResultMap.get("id");
            List adjustList = (List)accResultMap.get("adjustInfo");
            int adjustSize = 0;
            if (adjustList != null && adjustList.size() > 0) {
                adjustSize = adjustList.size();
            }
            List accDetailList = (List)accDetailMap.get(accResultId);
            int accDetailSize = 0;
            if (accDetailList != null && accDetailList.size() > 0) {
                accDetailSize = accDetailList.size();
            }
            int rowSize = 1;
            rowSize = Math.max(rowSize, Math.max(adjustSize, accDetailSize));
            for (int i = 0; i < rowSize; ++i) {
                HashMap<String, Object> exportDataMap = new HashMap<String, Object>(35);
                if (i == 0) {
                    exportDataMap.put("employeepersonnumber", accResultMap.get("employeepersonnumber"));
                } else {
                    exportDataMap.put("employeepersonnumber", null);
                }
                if (i == 0) {
                    exportDataMap.put("salaryfilenumber", accResultMap.get("salaryfilenumber"));
                } else {
                    exportDataMap.put("salaryfilenumber", null);
                }
                if (i == 0) {
                    exportDataMap.put("employeepersonname", accResultMap.get("employeepersonname"));
                } else {
                    exportDataMap.put("employeepersonname", null);
                }
                if (i == 0) {
                    exportDataMap.put("accnumber", accResultMap.get("accnumber"));
                } else {
                    exportDataMap.put("accnumber", null);
                }
                if (i == 0) {
                    exportDataMap.put("accname", accResultMap.get("accname"));
                } else {
                    exportDataMap.put("accname", null);
                }
                if (i == 0) {
                    exportDataMap.put("instancenum", accResultMap.get("instancenum"));
                } else {
                    exportDataMap.put("instancenum", null);
                }
                if (i == 0) {
                    exportDataMap.put("startdate", accResultMap.get("startdate"));
                } else {
                    exportDataMap.put("startdate", null);
                }
                if (i == 0) {
                    exportDataMap.put("enddate", accResultMap.get("enddate"));
                } else {
                    exportDataMap.put("enddate", null);
                }
                if (i == 0) {
                    exportDataMap.put("dimension1", accResultMap.get("dimension1"));
                } else {
                    exportDataMap.put("dimension1", null);
                }
                if (i == 0) {
                    exportDataMap.put("dimension2", accResultMap.get("dimension2"));
                } else {
                    exportDataMap.put("dimension2", null);
                }
                if (i == 0) {
                    exportDataMap.put("dimension3", accResultMap.get("dimension3"));
                } else {
                    exportDataMap.put("dimension3", null);
                }
                if (i == 0) {
                    exportDataMap.put("dimension4", accResultMap.get("dimension4"));
                } else {
                    exportDataMap.put("dimension4", null);
                }
                if (i == 0) {
                    exportDataMap.put("dimension5", accResultMap.get("dimension5"));
                } else {
                    exportDataMap.put("dimension5", null);
                }
                if (i == 0) {
                    exportDataMap.put("accperiodtype", this.buildAccPeriod((String)accResultMap.get("accperiodtype")));
                } else {
                    exportDataMap.put("accperiodtype", null);
                }
                if (i == 0) {
                    exportDataMap.put("accbsedstrategy", this.buildAccBsedStrategy((String)accResultMap.get("accbsedstrategy")));
                } else {
                    exportDataMap.put("accbsedstrategy", null);
                }
                if (i == 0) {
                    exportDataMap.put("accdimension", this.buildAccDimension((String)accResultMap.get("accdimension")));
                } else {
                    exportDataMap.put("accdimension", null);
                }
                if (i == 0) {
                    exportDataMap.put("currencyname", accResultMap.get("currencyname"));
                } else {
                    exportDataMap.put("currencyname", null);
                }
                if (i == 0) {
                    exportDataMap.put("resultvalue", accResultMap.get("resultvalue"));
                } else {
                    exportDataMap.put("resultvalue", null);
                }
                exportDataMap.put("scale", accResultMap.get("scale"));
                if (i < accDetailSize) {
                    Map detailMap = (Map)accDetailList.get(i);
                    exportDataMap.put("entryfilenumber", detailMap.get("entryfilenumber"));
                    exportDataMap.put("caltasknumber", detailMap.get("caltasknumber"));
                    exportDataMap.put("caltaskname", detailMap.get("caltaskname"));
                    exportDataMap.put("period", detailMap.get("period"));
                    exportDataMap.put("periodstartdate", detailMap.get("periodstartdate"));
                    exportDataMap.put("periodenddate", detailMap.get("periodenddate"));
                    exportDataMap.put("periodpaydate", detailMap.get("periodpaydate"));
                    exportDataMap.put("entrycurrency", detailMap.get("entrycurrency"));
                    exportDataMap.put("initvalue", detailMap.get("initvalue"));
                    exportDataMap.put("currentvalue", detailMap.get("currentvalue"));
                    exportDataMap.put("entryresultval", detailMap.get("entryresultval"));
                    exportDataMap.put("entryindex", detailMap.get("entryindex"));
                }
                if (i < adjustSize) {
                    Map adjustMap = (Map)adjustList.get(i);
                    exportDataMap.put("adjustamount", adjustMap.get("adjustamount"));
                    exportDataMap.put("adjustreason", adjustMap.get("adjustreason"));
                    exportDataMap.put("adjusttime", adjustMap.get("adjusttime"));
                    exportDataMap.put("adjustuser", adjustMap.get("adjustuser"));
                    exportDataMap.put("adjustnumber", adjustMap.get("adjustnumber"));
                }
                exportDataList.add(exportDataMap);
            }
        }
        return exportDataList;
    }

    private String buildAccDimension(String accDimension) {
        String retStr = "";
        if (SWCStringUtils.isEmpty((String)accDimension)) {
            return retStr;
        }
        if (SWCStringUtils.equals((String)accDimension, (String)"1")) {
            retStr = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458", (String)"AccResultListExportHelper_42", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)accDimension, (String)"2")) {
            retStr = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848", (String)"AccResultListExportHelper_43", (String)SYSTEM_NAME, (Object[])new Object[0]);
        }
        return retStr;
    }

    private String buildAccBsedStrategy(String accBsedStrategy) {
        String retStr = "";
        if (SWCStringUtils.isEmpty((String)accBsedStrategy)) {
            return retStr;
        }
        if (SWCStringUtils.equals((String)accBsedStrategy, (String)"1")) {
            retStr = ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f", (String)"AccResultListExportHelper_39", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)accBsedStrategy, (String)"2")) {
            retStr = ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f", (String)"AccResultListExportHelper_40", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)accBsedStrategy, (String)"3")) {
            retStr = ResManager.loadKDString((String)"\u9884\u8ba1\u652f\u4ed8\u65e5\u671f", (String)"AccResultListExportHelper_41", (String)SYSTEM_NAME, (Object[])new Object[0]);
        }
        return retStr;
    }

    private String buildAccPeriod(String periodType) {
        String retStr = "";
        if (SWCStringUtils.isEmpty((String)periodType)) {
            return retStr;
        }
        if (SWCStringUtils.equals((String)periodType, (String)"1")) {
            retStr = ResManager.loadKDString((String)"\u6309\u5e74\u7d2f\u8ba1", (String)"AccResultListExportHelper_35", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)periodType, (String)"2")) {
            retStr = ResManager.loadKDString((String)"\u6309\u5b63\u7d2f\u8ba1", (String)"AccResultListExportHelper_36", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)periodType, (String)"3")) {
            retStr = ResManager.loadKDString((String)"\u6309\u6708\u7d2f\u8ba1", (String)"AccResultListExportHelper_37", (String)SYSTEM_NAME, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)periodType, (String)"4")) {
            retStr = ResManager.loadKDString((String)"\u81ea\u5b9a\u671f\u95f4", (String)"AccResultListExportHelper_38", (String)SYSTEM_NAME, (Object[])new Object[0]);
        }
        return retStr;
    }

    private void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, Object>> exportDataList, Map<String, String> headMap) {
        if (exportDataList == null || exportDataList.size() == 0) {
            return;
        }
        int rowIndex = 4;
        for (Map<String, Object> exportDataMap : exportDataList) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            int columnIndex = 0;
            for (Map.Entry<String, String> entry : headMap.entrySet()) {
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = entry.getKey();
                int scale = (Integer)exportDataMap.get("scale");
                Object value = exportDataMap.get(key);
                this.parseCellValue(columnCell, value, scale);
                columnCell.setCellType(this.getValueType(value));
                ++columnIndex;
            }
            ++rowIndex;
        }
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private void parseCellValue(SXSSFCell cell, Object value, int scale) {
        if (value instanceof String) {
            cell.setCellValue(value.toString());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof BigDecimal) {
            BigDecimal bdVal = (BigDecimal)value;
            String valStr = bdVal.setScale(scale, 4).toString();
            cell.setCellValue(valStr);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof OrmLocaleValue) {
            cell.setCellValue(value.toString());
        }
    }

    private CellType getValueType(Object value) {
        if (value instanceof Integer) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Long, Object> getAccDetailExportData(Long[] accResultIds, int currentPage, int pageSize) {
        DynamicObject[] accDetails;
        HashMap<Long, Object> dataMap = new HashMap<Long, Object>(16);
        String field = "accresult.id,calpersonid,caltask.number,caltask.name,caltask.period.name,caltask.STARTDATE,caltask.ENDDATE,caltask.paydate,currency.name,initvalue,currentvalue,index";
        String orderBy = "index asc";
        QFilter qFilter = new QFilter("accresult", "in", (Object)accResultIds);
        for (DynamicObject dataObj : accDetails = BusinessDataServiceHelper.load((String)"hsas_accdetails", (String)field, (QFilter[])new QFilter[]{qFilter}, (String)orderBy)) {
            void var14_17;
            Date date;
            Long accResultId = dataObj.getLong("accresult.id");
            List list = (List)dataMap.get(accResultId);
            if (list == null) {
                ArrayList arrayList = new ArrayList(10);
            }
            HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
            detailMap.put("calPersonId", dataObj.get("calpersonid"));
            detailMap.put("caltasknumber", dataObj.get("caltask.number"));
            detailMap.put("caltaskname", dataObj.get("caltask.name"));
            detailMap.put("period", dataObj.get("caltask.period.name"));
            if (dataObj.get("caltask.STARTDATE") != null) {
                date = dataObj.getDate("caltask.STARTDATE");
                detailMap.put("periodstartdate", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            } else {
                detailMap.put("periodstartdate", null);
            }
            if (dataObj.get("caltask.ENDDATE") != null) {
                date = dataObj.getDate("caltask.ENDDATE");
                detailMap.put("periodenddate", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            } else {
                detailMap.put("periodenddate", null);
            }
            if (dataObj.get("caltask.paydate") != null) {
                date = dataObj.getDate("caltask.paydate");
                detailMap.put("periodpaydate", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            } else {
                detailMap.put("periodpaydate", null);
            }
            detailMap.put("entrycurrency", dataObj.get("currency.name"));
            BigDecimal initValue = dataObj.getBigDecimal("initvalue");
            if (initValue == null) {
                initValue = BigDecimal.ZERO;
            }
            detailMap.put("initvalue", initValue);
            BigDecimal currentValue = dataObj.getBigDecimal("currentvalue");
            if (currentValue == null) {
                currentValue = BigDecimal.ZERO;
            }
            detailMap.put("currentvalue", currentValue);
            detailMap.put("entryresultval", initValue.add(currentValue));
            detailMap.put("entryindex", dataObj.get("index"));
            var14_17.add(detailMap);
            dataMap.put(accResultId, var14_17);
        }
        int size = accDetails.length;
        Long[] calPersonIds = new Long[size];
        for (int i = 0; i < size; ++i) {
            calPersonIds[i] = accDetails[i].getLong("calpersonid");
        }
        field = "id,salaryfile.number";
        qFilter = new QFilter("id", "in", (Object)calPersonIds);
        DynamicObject[] calPersons = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)field, (QFilter[])new QFilter[]{qFilter}, null);
        HashMap<Long, String> relationMap = new HashMap<Long, String>(16);
        for (DynamicObject dataObj : calPersons) {
            Long calPersonId = dataObj.getLong("id");
            String salaryFileNumber = dataObj.getString("salaryfile.number");
            relationMap.put(calPersonId, salaryFileNumber);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            List detailList = (List)entry.getValue();
            for (Map detailMap : detailList) {
                Long calPersonId = (Long)detailMap.get("calPersonId");
                detailMap.put("entryfilenumber", relationMap.get(calPersonId));
            }
        }
        return dataMap;
    }

    private List<Map<String, Object>> getAccAdjustExportData(QFilter[] filters, int currentPage, int pageSize, Map<Long, Integer> scaleMap) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        String field = "id,employee.person.number,salaryfile.number,employee.person.name,acc.number,acc.name,instancenum,startdate,enddate,dimension1,dimension2,dimension3,dimension4,dimension5,acc.periodtype,acc.bsedstrategy,acc.accdimension,acc.dataprecision,currency.name,resultvalue,adjustamount,adjustdescript,adjusttime,adjustperson.name,adjustperson.number,currency.amtprecision,";
        String orderBy = "employee.person.number asc,acc.number asc,instancenum asc,startdate desc";
        for (DynamicObject dataObj : BusinessDataServiceHelper.load((String)"hsas_accresult", (String)field, (QFilter[])filters, (String)orderBy)) {
            Date date;
            HashMap<String, Object> accResultMap = new HashMap<String, Object>(20);
            accResultMap.put("id", dataObj.getLong("id"));
            accResultMap.put("employeepersonnumber", dataObj.get("employee.person.number"));
            accResultMap.put("salaryfilenumber", dataObj.get("salaryfile.number"));
            accResultMap.put("employeepersonname", dataObj.get("employee.person.name"));
            accResultMap.put("accnumber", dataObj.get("acc.number"));
            accResultMap.put("accname", dataObj.get("acc.name"));
            accResultMap.put("instancenum", dataObj.get("instancenum"));
            if (dataObj.get("startdate") != null) {
                date = dataObj.getDate("startdate");
                accResultMap.put("startdate", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            } else {
                accResultMap.put("startdate", null);
            }
            if (dataObj.get("enddate") != null) {
                date = dataObj.getDate("enddate");
                accResultMap.put("enddate", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            } else {
                accResultMap.put("enddate", null);
            }
            accResultMap.put("dimension1", dataObj.get("dimension1"));
            accResultMap.put("dimension2", dataObj.get("dimension2"));
            accResultMap.put("dimension3", dataObj.get("dimension3"));
            accResultMap.put("dimension4", dataObj.get("dimension4"));
            accResultMap.put("dimension5", dataObj.get("dimension5"));
            accResultMap.put("accperiodtype", dataObj.get("acc.periodtype"));
            accResultMap.put("accbsedstrategy", dataObj.get("acc.bsedstrategy"));
            accResultMap.put("accdimension", dataObj.get("acc.accdimension"));
            accResultMap.put("currencyname", dataObj.get("currency.name"));
            if (dataObj.get("resultvalue") != null) {
                accResultMap.put("resultvalue", dataObj.get("resultvalue"));
            }
            DynamicObject currencyObj = dataObj.getDynamicObject("currency");
            DynamicObject accObj = dataObj.getDynamicObject("acc");
            int scale = this.getDecimalScale(currencyObj, accObj, scaleMap);
            accResultMap.put("scale", scale);
            DynamicObjectCollection adjustColl = dataObj.getDynamicObjectCollection("adjustentry");
            ArrayList adjustList = new ArrayList(10);
            for (DynamicObject adjustObj : adjustColl) {
                HashMap<String, Object> adjustMap = new HashMap<String, Object>(5);
                adjustMap.put("adjustamount", adjustObj.get("adjustamount"));
                adjustMap.put("adjustreason", adjustObj.get("adjustdescript"));
                if (adjustObj.get("adjusttime") != null) {
                    Date date2 = adjustObj.getDate("adjusttime");
                    adjustMap.put("adjusttime", SWCDateTimeUtils.format((Date)date2, (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    adjustMap.put("adjusttime", null);
                }
                adjustMap.put("adjustuser", adjustObj.get("adjustperson.name"));
                adjustMap.put("adjustnumber", adjustObj.get("adjustperson.number"));
                adjustList.add(adjustMap);
            }
            if (adjustList != null && adjustList.size() > 0) {
                accResultMap.put("adjustInfo", adjustList);
            }
            dataList.add(accResultMap);
        }
        return dataList;
    }

    private int getDecimalScale(DynamicObject currencyObj, DynamicObject accObj, Map<Long, Integer> scaleMap) {
        DynamicObject dataPrecisionObj;
        if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
            int amtprecision = currencyObj.getInt("amtprecision");
            return amtprecision;
        }
        if (!SWCObjectUtils.isEmpty((Object)accObj) && !SWCObjectUtils.isEmpty((Object)(dataPrecisionObj = accObj.getDynamicObject("dataprecision")))) {
            int scale = 2;
            long dataPrecisionId = dataPrecisionObj.getLong("id");
            if (scaleMap.get(dataPrecisionId) != null) {
                scale = scaleMap.get(dataPrecisionId);
            }
            return scale;
        }
        return 2;
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, CalTableExportProgressInfo progressInfo, int totalElements, IFormView view) throws IOException {
        List<Map<String, String>> headList = SWCExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = this.safeWriteFile(sheet.getWorkbook(), fileName);
        SWCPageCache pageCache = new SWCPageCache(view);
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)totalElements, (String)downLoadTaskId);
        stopWatch.stop();
        logger.info("ending export data: {},countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String safeWriteFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + ".xlsx";
            String downloadUrl = this.getDownLoadUrl(inStream, fileName);
            String string = SWCURLHelper.getSafeUrl((String)"hsas", (String)"hsas_accresult", (String)downloadUrl);
            return string;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private String getDownLoadUrl(InputStream inStream, String fileName) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"accResultExport", (String)fileName);
        FileItem item = new FileItem(fileName, pathParam, inStream);
        String path = fileService.upload(item);
        return UrlService.getAttachmentFullUrl((String)path);
    }

    public void writeAccExportLog(int total, IFormView view, String url) {
        String prefixName = ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListExportHelper_48", (String)SYSTEM_NAME, (Object[])new Object[0]);
        String bizObj = prefixName + "-" + Uuid.randomUuid().toString().trim().replace("-", "");
        Object exportLogId = ExportLogHelper.create((Object)"", (String)bizObj, (int)total, (String)"1");
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)exportLogId, (DynamicObjectType)objType);
        dyn.set("total", (Object)total);
        dyn.set(COMPLETE, (Object)total);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        dyn.set("downloadurl", (Object)url);
        dyn.set("expttype", (Object)"3");
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    private Sheet write2ExportHead(SXSSFSheet sheet, String pageKey, String pageName, Map<String, String> headMap) {
        int row = 3;
        SXSSFRow headRow = sheet.createRow(row);
        SXSSFWorkbook wb = sheet.getWorkbook();
        int index = 0;
        for (Map.Entry<String, String> entry : headMap.entrySet()) {
            CellStyle headColumnStyle;
            SXSSFCell cell = headRow.createCell(index);
            String headString = entry.getValue();
            cell.setCellValue(headString);
            if (headString.startsWith("*")) {
                headColumnStyle = this.getHeadColumnStyle(wb, true);
                cell.setCellStyle(headColumnStyle);
            } else {
                headColumnStyle = this.getHeadColumnStyle(wb, false);
                cell.setCellStyle(headColumnStyle);
            }
            ++index;
        }
        return sheet;
    }

    private CellStyle getFontRedRowStyle(SXSSFWorkbook wb) {
        CellStyle columnStyle = wb.createCellStyle();
        Font font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        columnStyle.setFont(font);
        return columnStyle;
    }

    private CellStyle getFontCenterStyle(SXSSFWorkbook wb) {
        CellStyle columnStyle = wb.createCellStyle();
        columnStyle.setBorderBottom(BorderStyle.THIN);
        columnStyle.setBorderBottom(BorderStyle.THIN);
        columnStyle.setBorderTop(BorderStyle.THIN);
        columnStyle.setBorderLeft(BorderStyle.THIN);
        columnStyle.setBorderRight(BorderStyle.THIN);
        columnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        columnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        columnStyle.setAlignment(HorizontalAlignment.CENTER);
        columnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        columnStyle.setHidden(true);
        return columnStyle;
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb, boolean isMust) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        if (isMust) {
            Font font = wb.createFont();
            font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            headColumnStyle.setFont(font);
        }
        return headColumnStyle;
    }

    public Map<String, String> getExportHeaders() {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        String strPre = "*";
        headerMap.put("employeepersonnumber", strPre.concat(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AccResultListExportHelper_0", (String)SYSTEM_NAME, (Object[])new Object[0])));
        headerMap.put("salaryfilenumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"AccResultListExportHelper_1", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("employeepersonname", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AccResultListExportHelper_2", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("accnumber", strPre.concat(ResManager.loadKDString((String)"\u7d2f\u52a0\u5668\u7f16\u7801", (String)"AccResultListExportHelper_3", (String)SYSTEM_NAME, (Object[])new Object[0])));
        headerMap.put("accname", ResManager.loadKDString((String)"\u7d2f\u52a0\u5668\u540d\u79f0", (String)"AccResultListExportHelper_4", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("instancenum", strPre.concat(ResManager.loadKDString((String)"\u7d2f\u52a0\u5b9e\u4f8b\u53f7", (String)"AccResultListExportHelper_5", (String)SYSTEM_NAME, (Object[])new Object[0])));
        headerMap.put("startdate", ResManager.loadKDString((String)"\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f", (String)"AccResultListExportHelper_6", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("enddate", ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u675f\u65e5\u671f", (String)"AccResultListExportHelper_7", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("dimension1", ResManager.loadKDString((String)"\u7d2f\u52a0\u5b50\u7ef4\u5ea61", (String)"AccResultListExportHelper_8", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("dimension2", ResManager.loadKDString((String)"\u7d2f\u52a0\u5b50\u7ef4\u5ea62", (String)"AccResultListExportHelper_9", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("dimension3", ResManager.loadKDString((String)"\u7d2f\u52a0\u5b50\u7ef4\u5ea63", (String)"AccResultListExportHelper_10", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("dimension4", ResManager.loadKDString((String)"\u7d2f\u52a0\u5b50\u7ef4\u5ea64", (String)"AccResultListExportHelper_11", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("dimension5", ResManager.loadKDString((String)"\u7d2f\u52a0\u5b50\u7ef4\u5ea65", (String)"AccResultListExportHelper_12", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("accperiodtype", ResManager.loadKDString((String)"\u7d2f\u52a0\u9891\u5ea6", (String)"AccResultListExportHelper_13", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("accbsedstrategy", ResManager.loadKDString((String)"\u7d2f\u52a0\u751f\u6548\u7b56\u7565", (String)"AccResultListExportHelper_14", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("accdimension", ResManager.loadKDString((String)"\u7d2f\u52a0\u7ef4\u5ea6", (String)"AccResultListExportHelper_15", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AccResultListExportHelper_16", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("resultvalue", ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u503c", (String)"AccResultListExportHelper_17", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("entryfilenumber", ResManager.loadKDString((String)"\u7d2f\u52a0\u660e\u7ec6\u6863\u6848\u7f16\u53f7", (String)"AccResultListExportHelper_18", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("caltasknumber", ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801", (String)"AccResultListExportHelper_19", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("caltaskname", ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u540d\u79f0", (String)"AccResultListExportHelper_20", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"AccResultListExportHelper_21", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("periodstartdate", ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f", (String)"AccResultListExportHelper_22", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("periodenddate", ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f", (String)"AccResultListExportHelper_23", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("periodpaydate", ResManager.loadKDString((String)"\u9884\u8ba1\u652f\u4ed8\u65e5\u671f", (String)"AccResultListExportHelper_24", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("entrycurrency", ResManager.loadKDString((String)"\u7d2f\u52a0\u660e\u7ec6\u5e01\u79cd", (String)"AccResultListExportHelper_25", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("initvalue", ResManager.loadKDString((String)"\u521d\u59cb\u503c", (String)"AccResultListExportHelper_26", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("currentvalue", ResManager.loadKDString((String)"\u5f53\u524d\u503c", (String)"AccResultListExportHelper_27", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("entryresultval", ResManager.loadKDString((String)"\u7d2f\u52a0\u660e\u7ec6\u7ed3\u679c\u503c", (String)"AccResultListExportHelper_28", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("entryindex", ResManager.loadKDString((String)"\u987a\u5e8f\u53f7", (String)"AccResultListExportHelper_29", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("adjustamount", strPre.concat(ResManager.loadKDString((String)"\u8c03\u6574\u503c", (String)"AccResultListExportHelper_30", (String)SYSTEM_NAME, (Object[])new Object[0])));
        headerMap.put("adjustreason", strPre.concat(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"AccResultListExportHelper_31", (String)SYSTEM_NAME, (Object[])new Object[0])));
        headerMap.put("adjusttime", ResManager.loadKDString((String)"\u8c03\u6574\u65f6\u95f4", (String)"AccResultListExportHelper_32", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("adjustuser", ResManager.loadKDString((String)"\u8c03\u6574\u4eba", (String)"AccResultListExportHelper_33", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("adjustnumber", ResManager.loadKDString((String)"\u8c03\u6574\u4eba\u5de5\u53f7", (String)"AccResultListExportHelper_34", (String)SYSTEM_NAME, (Object[])new Object[0]));
        return headerMap;
    }
}

