/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgencyPayHelper {
    protected static final Log logger = LogFactory.getLog(AgencyPayHelper.class);

    private AgencyPayHelper() {
    }

    public static String toJsonString(Object obj) {
        if (SWCObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        return SerializationUtils.toJsonString((Object)obj);
    }

    public static <T> T jsonToObject(String json, Class<?> clazzName) {
        if (SWCStringUtils.isEmpty((String)json)) {
            return null;
        }
        return (T)SerializationUtils.fromJsonString((String)json, clazzName);
    }

    public static DynamicObject[] queryPayDetail(String selectProperties, Set<String> keySet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keySet)};
        return helper.query(selectProperties, filters);
    }

    public static LocaleString createDefaultBillName(String billno, String orgName) {
        if (SWCStringUtils.isEmpty((String)billno) || SWCStringUtils.isEmpty((String)orgName)) {
            return new LocaleString("");
        }
        String[] billnoArray = billno.split("-");
        StringBuilder sb = new StringBuilder(orgName);
        if (billnoArray.length >= 3) {
            String dateStr = billnoArray[1];
            String serialNum = billnoArray[2];
            sb.append(dateStr);
            sb.append(serialNum);
        } else {
            sb.append(billno);
        }
        if (sb.length() > 100) {
            return new LocaleString(sb.substring(0, 100));
        }
        return new LocaleString(sb.toString());
    }

    public static DynamicObject queyOrgById(long userOrgId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_org");
        return helper.queryOne((Object)userOrgId);
    }

    public static DynamicObject[] queyOrgByIds(Set<Long> userOrgIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_org");
        return helper.query(userOrgIds.toArray());
    }

    public static void viewAgencyPayBill(IFormView view, Set<Long> billIdSet) {
        ListShowParameter bill = new ListShowParameter();
        bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bill.setBillFormId("hsas_agencypaybill");
        String caption = ResManager.loadKDString((String)"\u5173\u8054\u85aa\u8d44\u4ee3\u53d1\u5355", (String)"SWCPayDetailAgencyList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        bill.setCaption(caption);
        ListFilterParameter listFilterParameter = bill.getListFilterParameter();
        ArrayList hiddenList = Lists.newArrayListWithExpectedSize((int)10);
        hiddenList.add("tblnew");
        bill.setCustomParam("hiddenList", (Object)SerializationUtils.toJsonString((Object)hiddenList));
        QFilter qFilter = new QFilter("id", "in", billIdSet);
        listFilterParameter.setFilter(qFilter);
        bill.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)bill);
    }

    public static Set<Long> stringToLong(Set<String> billIdSet) {
        HashSet<Long> billIds = new HashSet<Long>(billIdSet.size());
        for (String billId : billIdSet) {
            billIds.add(Long.valueOf(billId));
        }
        return billIds;
    }

    public static BigDecimal setAmountScale(BigDecimal amount, int scale) {
        return amount.setScale(scale, 4);
    }

    public static String formateDecimal(String text) {
        if (SWCObjectUtils.isEmpty((Object)text)) {
            return "0";
        }
        int index = text.indexOf(46);
        if (index > 0) {
            String integerPartial = text.substring(0, index);
            String decimalPartial = text.substring(index);
            return AgencyPayHelper.addThousandSeparatorForInteger(integerPartial) + decimalPartial;
        }
        return AgencyPayHelper.addThousandSeparatorForInteger(text);
    }

    public static String addThousandSeparatorForInteger(String text) {
        int length;
        int index = text.indexOf(46);
        if (index != -1) {
            return text;
        }
        ArrayList<String> stringContainer = new ArrayList<String>();
        for (length = text.length(); length > 3; length -= 3) {
            stringContainer.add(text.substring(length - 3, length));
        }
        stringContainer.add(text.substring(0, length));
        StringBuilder sb = new StringBuilder();
        for (int i = stringContainer.size() - 1; i >= 0; --i) {
            sb.append((String)stringContainer.get(i));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static QFilter getQFilter(long billId, Set<Long> detailIds, long payrollGroupId, long orgId) {
        QFilter filter = new QFilter("paystate", "=", (Object)PayStateEnum.UNPAY.getCode());
        QFilter agencyStateFilter = new QFilter("agencypaystate", "=", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
        filter.and(agencyStateFilter);
        QFilter paySubjectVFilter = new QFilter("paysubjecthis.cashintergration", "=", (Object)"1");
        filter.and(paySubjectVFilter);
        QFilter onHoldFilter = new QFilter("onholdstatus", "not in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), String.valueOf(OnHoldStatusEnum.ABANDON.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())});
        filter.and(onHoldFilter);
        QFilter abandonFilter = new QFilter("abandonedstatus", "!=", (Object)Boolean.TRUE);
        filter.and(abandonFilter);
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        modifyBillFilter.or(new QFilter("acctmodifybill.billstatus", "=", (Object)"E"));
        filter.and(modifyBillFilter);
        QFilter isNeedBankCardQFilter = new QFilter("ismustbankcard", "=", (Object)Boolean.TRUE);
        isNeedBankCardQFilter.and("perbankcard.id", "!=", (Object)0);
        QFilter noNeedBankCardQFilter = new QFilter("ismustbankcard", "=", (Object)Boolean.FALSE);
        isNeedBankCardQFilter.or(noNeedBankCardQFilter);
        filter.and(isNeedBankCardQFilter);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        filter.and(orgFilter);
        QFilter grpFilter = new QFilter("payrollgroup", "=", (Object)payrollGroupId);
        filter.and(grpFilter);
        return filter;
    }

    public static Map<Long, String> queryAgencyIdByDetailId(Long detailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_agencypaybill");
        String selectProperty = "id,paydetail.id, auditstatus";
        QFilter filter = new QFilter("entryentity.paydetail.id", "in", (Object)detailId);
        DynamicObject[] agencyPayBillObjs = helper.query(selectProperty, new QFilter[]{filter});
        if (agencyPayBillObjs == null) {
            return null;
        }
        return Arrays.stream(agencyPayBillObjs).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("auditstatus"), (k1, k2) -> k1));
    }
}

