/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgencyPayWriteBackService {
    private static final String PAY_STATE = "paystate";

    public void updateCaltablePayState(Set<Long> calPersonIdSet) {
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdSet);
        filter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "paystate,agencypaystate,calpersonid,bankofferstatus";
        DynamicObject[] paydetails = detailHelper.query(selectProperties, filters);
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject detail : paydetails) {
            long calPersonId = detail.getLong("calpersonid");
            DynamicObjectCollection detailCol = (DynamicObjectCollection)groupMap.get(calPersonId);
            if (detailCol == null) {
                detailCol = new DynamicObjectCollection();
            }
            detailCol.add((Object)detail);
            groupMap.put(calPersonId, detailCol);
        }
        this.writeBackCalPerson(calPersonIdSet, groupMap);
    }

    private void writeBackCalPerson(Set<Long> calPersonIdSet, Map<Long, DynamicObjectCollection> groupMap) {
        SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calperson");
        HashMap tablePayStateMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, DynamicObjectCollection> tableDetail : groupMap.entrySet()) {
            Long calPersonId = tableDetail.getKey();
            DynamicObjectCollection detailCol = tableDetail.getValue();
            int unPay = 0;
            int paid = 0;
            int paying = 0;
            int unPrepare = 0;
            int payFail = 0;
            int total = detailCol.size();
            for (DynamicObject detail : detailCol) {
                String paystate = detail.getString(PAY_STATE);
                String agencypaystate = detail.getString("agencypaystate");
                String bankofferstatus = detail.getString("bankofferstatus");
                if (SWCStringUtils.equals((String)paystate, (String)PayStateEnum.UNPAY.getCode())) {
                    ++unPay;
                } else if (SWCStringUtils.equals((String)paystate, (String)PayStateEnum.PAID.getCode())) {
                    ++paid;
                } else if (SWCStringUtils.equals((String)paystate, (String)PayStateEnum.PAYFAIL.getCode())) {
                    ++payFail;
                } else if (SWCStringUtils.equals((String)paystate, (String)PayStateEnum.PAYING.getCode())) {
                    ++paying;
                }
                if (SWCStringUtils.equals((String)agencypaystate, (String)AgencyPayStateEnum.GENERATED.getCode()) || !SWCStringUtils.equals((String)bankofferstatus, (String)BankOfferEnum.UNDEXPORT.getCode()) && !SWCStringUtils.equals((String)bankofferstatus, (String)BankOfferEnum.INVALIDED.getCode())) continue;
                ++unPrepare;
            }
            if (total == 0) {
                tablePayStateMap.put(calPersonId, PayStateEnum.UNCREATE);
                continue;
            }
            if (unPay == total) {
                if (total == unPrepare) {
                    tablePayStateMap.put(calPersonId, PayStateEnum.UNPAY);
                    continue;
                }
                tablePayStateMap.put(calPersonId, PayStateEnum.PREPAREPAY);
                continue;
            }
            if (paid == total) {
                tablePayStateMap.put(calPersonId, PayStateEnum.PAID);
                continue;
            }
            if (paying > 0 || paid > 0) {
                tablePayStateMap.put(calPersonId, PayStateEnum.PAYING);
                continue;
            }
            if (payFail > 0) {
                tablePayStateMap.put(calPersonId, PayStateEnum.PAYFAIL);
                continue;
            }
            tablePayStateMap.put(calPersonId, PayStateEnum.UNPAY);
        }
        String selectFields = "id,paystatus,modifier,modifytime";
        QFilter filter = new QFilter("id", "in", calPersonIdSet);
        DynamicObject[] calList = calHelper.query(selectFields, new QFilter[]{filter});
        DynamicObjectCollection updateCol = new DynamicObjectCollection();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject cal : calList) {
            long calPersonId = cal.getLong("id");
            String paystateStr = null;
            String oldPayStateStr = cal.getString("paystatus");
            PayStateEnum payStateEnum = (PayStateEnum)tablePayStateMap.get(calPersonId);
            if (payStateEnum != null) {
                paystateStr = payStateEnum.getCode();
            }
            if (!SWCStringUtils.isNotEmpty(paystateStr) || SWCStringUtils.equals((String)paystateStr, (String)oldPayStateStr)) continue;
            cal.set("paystatus", (Object)paystateStr);
            cal.set("modifier", (Object)currUserId);
            cal.set("modifytime", (Object)date);
            updateCol.add((Object)cal);
        }
        Object[] updateArr = new DynamicObject[updateCol.size()];
        updateArr = (DynamicObject[])updateCol.toArray(updateArr);
        calHelper.update((DynamicObject[])updateArr);
    }

    public void updateDetailWriteBackAgencyPayBillTotalCount(List<DynamicObject> payDetailDys) {
        DynamicObject[] agencyPayDys;
        if (payDetailDys == null || payDetailDys.isEmpty()) {
            return;
        }
        HashSet<Long> payDetailIds = new HashSet<Long>(payDetailDys.size());
        for (DynamicObject payDetailDy : payDetailDys) {
            if (!String.valueOf(OnHoldStatusEnum.ABANDON.getCode()).equals(payDetailDy.getString("onholdstatus"))) continue;
            payDetailIds.add(payDetailDy.getLong("id"));
        }
        if (payDetailIds.isEmpty()) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("id", "in", payDetailIds);
        DynamicObject[] payDetails = helper.query("id,agencypaybill.id", qFilter.toArray());
        HashSet<Long> agencyIds = new HashSet<Long>(16);
        for (DynamicObject payDetail : payDetails) {
            agencyIds.add(payDetail.getLong("agencypaybill.id"));
        }
        helper = new SWCDataServiceHelper("hsas_agencypaybill");
        QFilter qilter = new QFilter("id", "in", agencyIds);
        for (DynamicObject agencyPayDy : agencyPayDys = helper.query("totalcount,entryentity,entryentity.paydetail,entryentity.paydetail.onholdstatus", qilter.toArray())) {
            int total = 0;
            DynamicObjectCollection entryEntity = agencyPayDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                if (OnHoldStatusEnum.ABANDON.getCode() == entry.getInt("paydetail.onholdstatus")) continue;
                ++total;
            }
            agencyPayDy.set("totalcount", (Object)total);
        }
        helper.save(agencyPayDys);
    }

    public void submitCasWriteBackDetail(Set<Long> detailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("id", "in", detailId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] details = helper.query(PAY_STATE, filters);
        this.setDetailPaystate(details, PayStateEnum.PAYING);
        helper.update(details);
    }

    public void unSubmitCasWriteBackDetail(Set<Long> detailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("id", "in", detailId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] details = helper.query(PAY_STATE, filters);
        this.setDetailPaystate(details, PayStateEnum.UNPAY);
        helper.update(details);
    }

    private void setDetailPaystate(DynamicObject[] details, PayStateEnum paystate) {
        for (DynamicObject detail : details) {
            detail.set(PAY_STATE, (Object)paystate.getCode());
        }
    }
}

