/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay.payresult.handler;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackErrorEnum;
import kd.swc.hsas.business.agencypay.payresult.handler.AgentPayResultBaseHandler;
import kd.swc.hsas.business.agencypay.payresult.vo.AgentPayResult;
import org.apache.commons.collections4.MapUtils;

public abstract class AgentPayResultForMapParamHandler
extends AgentPayResultBaseHandler {
    private static Log logger = LogFactory.getLog(AgentPayResultForMapParamHandler.class);

    @Override
    protected List<AgentPayResult> parseParam(Map<String, Object> param) {
        if (param == null) {
            logger.info("[PayResult]AgentPayResultForMapParamHandler parseParam param is null...");
            throw new KDException(new ErrorCode(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getCode(), MessageFormat.format(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getErrorMsg(), "param")), new Object[0]);
        }
        Object refundPayInfos = param.get("refundPayInfos");
        if (refundPayInfos == null) {
            logger.info("[PayResult]AgentPayResultForMapParamHandler parseParam refundPayInfos is null...");
            throw new KDException(new ErrorCode(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getCode(), AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getErrorMsg()), new Object[0]);
        }
        List refundPayInfoList = (List)refundPayInfos;
        ArrayList agentPayResults = Lists.newArrayListWithCapacity((int)refundPayInfoList.size());
        for (Map refundPayInfoMap : refundPayInfoList) {
            Object entryInfos = refundPayInfoMap.get("entryInfos");
            if (entryInfos == null) {
                logger.info("[PayResult]AgentPayResultForMapParamHandler parseParam entryInfos is null...");
                throw new KDException(new ErrorCode(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getCode(), AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getErrorMsg()), new Object[0]);
            }
            List entryInfoList = (List)entryInfos;
            for (Map entryInfoMap : entryInfoList) {
                String failReason = MapUtils.getString((Map)entryInfoMap, (Object)"reason");
                Object sourceInfos = entryInfoMap.get("sourceInfos");
                this.parseSourceInfos(sourceInfos, failReason, agentPayResults);
            }
        }
        return agentPayResults;
    }

    protected void parseSourceInfos(Object sourceInfos, String failReason, List<AgentPayResult> agentPayResults) {
        if (sourceInfos == null) {
            logger.info("[PayResult]AgentPayResultForMapParamHandler parseParam sourceInfos is null...");
            throw new KDException(new ErrorCode(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getCode(), AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getErrorMsg()), new Object[0]);
        }
        List sourceInfoList = (List)sourceInfos;
        for (Map sourceInfoMap : sourceInfoList) {
            Long srcBillId = MapUtils.getLong((Map)sourceInfoMap, (Object)"sourcePk");
            Object sourceEntryPks = sourceInfoMap.get("sourceEntryPks");
            if (sourceEntryPks == null) {
                logger.info("[PayResult]AgentPayResultForMapParamHandler parseParam sourceEntryPks is null...");
                throw new KDException(new ErrorCode(AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getCode(), AgentPayResultWriteBackErrorEnum.COMMON_PARAMISNULL.getErrorMsg()), new Object[0]);
            }
            List srcEntIds = (List)sourceEntryPks;
            for (Long srcEntId : srcEntIds) {
                AgentPayResult agentPayResult = new AgentPayResult(srcBillId, srcEntId, true, failReason);
                this.fillAgentPayResult(agentPayResult);
                agentPayResults.add(agentPayResult);
            }
        }
    }
}

