/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.approve;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.swc.hsas.common.dto.ApproveBillAccountDTO;
import kd.swc.hsas.common.dto.ApproveBillSalaryItemDTO;
import kd.swc.hsas.common.dto.CalPersonDTO;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class ApproveBillService {
    private static final Log log = LogFactory.getLog(ApproveBillService.class);
    private static final int DEFAULT_SIZE = 500;

    public static DynamicObject[] getApproveBillList(List<Long> pkIdList, SWCDataServiceHelper helper) {
        QFilter filter = new QFilter("id", "in", pkIdList);
        return helper.query("id,billno,billstatus,caltableid,caltask,calpersonid,approvebilltpl,approvebilltplv", new QFilter[]{filter});
    }

    public static DynamicObject[] getCalPersonList(List<Long> calPersonIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        return helper.query("id,calresultid,calstatus,paystatus,salarystatus,onholdstatus,caltask", new QFilter[]{filter});
    }

    public static void updatePayDetail(Long approveBillId, List<Long> calPersonIdList) {
        DynamicObject[] payDetailArr;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("abandonedstatus", "=", (Object)Boolean.FALSE);
        for (DynamicObject payDetailDy : payDetailArr = helper.query("id,approvebill", new QFilter[]{filter})) {
            payDetailDy.set("approvebill", (Object)approveBillId);
        }
        helper.update(payDetailArr);
    }

    public static Boolean isPayDetail(DynamicObject approveBillTplDy) {
        DynamicObjectCollection schemeEntry = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
        for (DynamicObject schemeDy : schemeEntry) {
            String referReport = schemeDy.getString("referreport");
            if (!"3".equals(referReport)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Map<Long, Boolean> isPayDetail(Set<Long> approveBillTplIds) {
        DynamicObject[] collection;
        Map<Long, Boolean> map = approveBillTplIds.stream().collect(Collectors.toMap(id -> id, id -> Boolean.FALSE));
        SWCDataServiceHelper apvSchemeHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter filter = new QFilter("schemeentryentity.referreport", "=", (Object)"3");
        filter.and(new QFilter("id", "in", approveBillTplIds));
        for (DynamicObject approveBillTpl : collection = apvSchemeHelper.query("id", new QFilter[]{filter})) {
            map.put(approveBillTpl.getLong("id"), Boolean.TRUE);
        }
        return map;
    }

    public static List<CalPersonDTO> queryApproveBillByCalPersonId(List<Long> calPersonIds) {
        ArrayList<CalPersonDTO> calPersonList = new ArrayList<CalPersonDTO>(10);
        List partition = Lists.partition(calPersonIds, (int)5000);
        for (List partitionCalPersonIds : partition) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            sql.append("T2.FID APPROVE_BILL_ID, T1.FCALPERSONID CAL_PERSON_ID ");
            sql.append("FROM T_HSAS_APPROVEBILLENT T1 ");
            sql.append("LEFT JOIN T_HSAS_APPROVEBILL T2 ON T1.FID = T2.FID ");
            sql.append("WHERE T2.FBILLSTATUS NOT IN ('E', 'F') ");
            sql.append("AND T2.FBILLNO NOT LIKE 'PREVIEW_%' ");
            sql.append("AND T1.FCALPERSONID IN (?");
            int size = partitionCalPersonIds.size();
            for (int i = 1; i < size; ++i) {
                sql.append(", ?");
            }
            sql.append(" ) ");
            DataSet dataSet = SWCDbUtil.queryDataSet((String)"ApproveBillService.", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString(), (Object[])partitionCalPersonIds.toArray());
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long approveBillId = row.getLong(0);
                Long calPersonId = row.getLong(1);
                CalPersonDTO calPersonDTO = new CalPersonDTO();
                calPersonDTO.setId(approveBillId);
                calPersonDTO.setCalPersonId(calPersonId);
                calPersonList.add(calPersonDTO);
            }
        }
        return calPersonList;
    }

    public static ApproveBillAccountDTO getItemInfoInCalTable(Collection<Long> inputCalTableIds) {
        log.info("ApproveBillService.getItemInfoInCalTable: begin to calculate item number.");
        LinkedHashSet<Long> calTableIds = new LinkedHashSet<Long>(inputCalTableIds);
        long startTime = System.nanoTime();
        LinkedHashMap itemInfo = new LinkedHashMap(64);
        int totalSize = calTableIds.size();
        ApproveBillAccountDTO approveBillAccountDTO = new ApproveBillAccountDTO(Integer.valueOf(totalSize), itemInfo);
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hsas_caltable");
        String selectFields = "salaryitem.id,salaryitem.datatype.id,hsas_caltableentry.numvalue,hsas_caltableentry.calamountvalue,hsas_caltableentry.slprorationindex,fetchitem.id,fetchitem.datatype.id,hsas_calbcentry.bcnumvalue,hsas_calbcentry.ftprorationindex,supportitem.id,supportitem.datatype.id,hsas_calspentry.spnumvalue,bizitem.id,bizitem.datatype.id,hsas_calbsentry.bsnumvalue,hsas_calbsentry.bscalamountvalue,hsas_calbsentry.bsprorationindex";
        DynamicObject[] calTableDys = helper.query(selectFields, new QFilter("id", "in", calTableIds).toArray());
        if (calTableDys == null || calTableDys.length == 0) {
            log.error("CalApproveBillCreateOp.calSalaryItemAccount: calTableDys is emtpy, cal rule id is {}, and calTableIds is {}", (Object)JSONObject.toJSONString(calTableIds));
            return approveBillAccountDTO;
        }
        Arrays.stream(calTableDys).forEach(calTableDy -> {
            for (SalaryRptItemTypeEnum salaryRptItemTypeEnum : SalaryRptItemTypeEnum.values()) {
                DynamicObjectCollection entryEntity;
                if (SalaryRptItemTypeEnum.ITEMTAG == salaryRptItemTypeEnum || !calTableDy.containsProperty(salaryRptItemTypeEnum.getEntryCode()) || (entryEntity = calTableDy.getDynamicObjectCollection(salaryRptItemTypeEnum.getEntryCode())) == null || entryEntity.isEmpty()) continue;
                for (DynamicObject entity : entryEntity) {
                    String itemType;
                    String prorationIndexCode = salaryRptItemTypeEnum.getProrationIndexCode();
                    boolean isInvalid = prorationIndexCode != null && (!entity.containsProperty(prorationIndexCode) || entity.getInt(prorationIndexCode) != 0);
                    if (isInvalid || !entity.containsProperty(itemType = salaryRptItemTypeEnum.getItemFieldCode())) continue;
                    String itemIdProp = itemType + ".id";
                    String itemFieldProp = itemType + ".datatype.id";
                    long itemId = entity.getLong(itemIdProp);
                    long dataTypeId = entity.getLong(itemFieldProp);
                    DataTypeEnum dataTypeEnum = DataTypeEnum.getDataTypeById((long)dataTypeId);
                    String itemKey = salaryRptItemTypeEnum.getItemFieldCode() + itemId;
                    ApproveBillSalaryItemDTO approveBillSalaryItemDTO = itemInfo.computeIfAbsent(itemKey, key -> new ApproveBillSalaryItemDTO(Long.valueOf(dataTypeId), Long.valueOf(itemId), salaryRptItemTypeEnum.getItemFieldCode(), totalSize));
                    String valProp = null;
                    switch (dataTypeEnum) {
                        case AMOUNT: {
                            valProp = salaryRptItemTypeEnum.getCalAmountFieldCode();
                            break;
                        }
                        case NUMBERIC: {
                            valProp = salaryRptItemTypeEnum.getNumFieldCode();
                            break;
                        }
                        default: {
                            approveBillSalaryItemDTO.setOtherItemAccount(Integer.valueOf(approveBillSalaryItemDTO.getOtherItemAccount() + 1));
                        }
                    }
                    if (valProp == null || !entity.containsProperty(valProp)) continue;
                    BigDecimal itemValue = entity.getBigDecimal(valProp);
                    if (BigDecimal.ZERO.compareTo(itemValue) == 0) {
                        approveBillSalaryItemDTO.setZeroItemAccount(Integer.valueOf(approveBillSalaryItemDTO.getZeroItemAccount() + 1));
                        continue;
                    }
                    approveBillSalaryItemDTO.setOtherItemAccount(Integer.valueOf(approveBillSalaryItemDTO.getOtherItemAccount() + 1));
                }
            }
        });
        long costTime = (System.nanoTime() - startTime) / 1000000L;
        log.info("ApproveBillService.getItemInfoInCalTable: end to calculate item number, it cost {} millisecond.", (Object)costTime);
        return approveBillAccountDTO;
    }

    public static void updateItemAccountDy(ApproveBillAccountDTO approveBillAccountDTO) {
        if (approveBillAccountDTO == null || approveBillAccountDTO.getTotalItemAccount() == 0) {
            return;
        }
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hsas_itemaccount");
        DynamicObject itemAccountDy = helper.loadDynamicObject(new QFilter("approvebill", "=", (Object)approveBillAccountDTO.getApproveBillId()));
        if (HRObjectUtils.isEmpty((Object)itemAccountDy)) {
            itemAccountDy = helper.generateEmptyDynamicObject();
            itemAccountDy.set("approvebill", (Object)approveBillAccountDTO.getApproveBillId());
            itemAccountDy.set("totalaccount", (Object)approveBillAccountDTO.getTotalItemAccount());
            DynamicObjectCollection entryEntity = itemAccountDy.getDynamicObjectCollection("entryentity");
            approveBillAccountDTO.getApproveBillSalaryItemDTOMap().values().forEach(approveBillSalaryItemDTO -> ApproveBillService.addNewItemId(approveBillAccountDTO.getApproveBillId(), entryEntity, approveBillSalaryItemDTO));
        } else {
            int currBatchSize = approveBillAccountDTO.getTotalItemAccount() + itemAccountDy.getInt("totalaccount");
            itemAccountDy.set("totalaccount", (Object)currBatchSize);
            LinkedHashMap tmpItemInfo = new LinkedHashMap(approveBillAccountDTO.getApproveBillSalaryItemDTOMap());
            DynamicObjectCollection entryEntity = itemAccountDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryEntity) {
                String itemFieldCode;
                if (!entity.containsProperty(itemFieldCode = entity.getString("itemfieldcode"))) continue;
                long itemId = entity.getLong(itemFieldCode + ".id");
                String itemKey = itemFieldCode + itemId;
                ApproveBillSalaryItemDTO approveBillSalaryItemDTO2 = (ApproveBillSalaryItemDTO)tmpItemInfo.get(itemKey);
                if (approveBillSalaryItemDTO2 == null) continue;
                int otherItemNum = entity.getInt("otheritemnum");
                int zeroItemNum = entity.getInt("zeroitemnum");
                entity.set("otheritemnum", (Object)(otherItemNum += approveBillSalaryItemDTO2.getOtherItemAccount().intValue()));
                entity.set("zeroitemnum", (Object)(zeroItemNum += approveBillSalaryItemDTO2.getZeroItemAccount().intValue()));
                tmpItemInfo.remove(itemKey);
            }
            tmpItemInfo.values().forEach(approveBillSalaryItemDTO -> ApproveBillService.addNewItemId(approveBillAccountDTO.getApproveBillId(), entryEntity, approveBillSalaryItemDTO));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemAccountDy});
    }

    private static void addNewItemId(long approveBillId, DynamicObjectCollection entryEntity, ApproveBillSalaryItemDTO approveBillSalaryItemDTO) {
        String itemFieldCode;
        DynamicObject entity = entryEntity.addNew();
        if (entity.containsProperty(itemFieldCode = approveBillSalaryItemDTO.getItemFieldCode())) {
            entity.set("itemfieldcode", (Object)itemFieldCode);
            entity.set(itemFieldCode, (Object)approveBillSalaryItemDTO.getItemId());
            entity.set("zeroitemnum", (Object)approveBillSalaryItemDTO.getZeroItemAccount());
            entity.set("otheritemnum", (Object)approveBillSalaryItemDTO.getOtherItemAccount());
        } else {
            log.error("CalApproveBillCreateOp.updateItemAccountDy: entityCode error, approveBillId is {}, and approveBillSalaryItemDTO value is {}", (Object)approveBillId, (Object)JSONObject.toJSONString((Object)approveBillSalaryItemDTO));
            entryEntity.remove((Object)entity);
        }
    }

    public static void saveAdjustedItemAccountDy(ApproveBillAccountDTO approveBillAccountDTO) {
        if (approveBillAccountDTO == null) {
            return;
        }
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hsas_itemaccount");
        DynamicObject itemAccountDy = helper.loadDynamicObject(new QFilter("approvebill", "=", (Object)approveBillAccountDTO.getApproveBillId()));
        if (HRObjectUtils.isEmpty((Object)itemAccountDy)) {
            return;
        }
        itemAccountDy.set("totalaccount", (Object)approveBillAccountDTO.getTotalItemAccount());
        DynamicObjectCollection entryEntity = itemAccountDy.getDynamicObjectCollection("entryentity");
        LinkedHashMap tmpApproveBillSalaryItemDTOMap = new LinkedHashMap(approveBillAccountDTO.getApproveBillSalaryItemDTOMap());
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            String itemFieldCode;
            DynamicObject entity = (DynamicObject)iterator.next();
            if (entity.containsProperty(itemFieldCode = entity.getString("itemfieldcode"))) {
                long itemId = entity.getLong(itemFieldCode + ".id");
                String itemKey = itemFieldCode + itemId;
                ApproveBillSalaryItemDTO approveBillSalaryItemDTO2 = (ApproveBillSalaryItemDTO)tmpApproveBillSalaryItemDTOMap.remove(itemKey);
                if (approveBillSalaryItemDTO2 != null) {
                    entity.set("otheritemnum", (Object)approveBillSalaryItemDTO2.getOtherItemAccount());
                    entity.set("zeroitemnum", (Object)approveBillSalaryItemDTO2.getZeroItemAccount());
                    continue;
                }
                iterator.remove();
                continue;
            }
            log.error("CalApproveBillCreateOp.saveAdjustedItemAccountDy: itemFieldCode error, approveBillId is {}, and itemFieldCode value is {}", (Object)approveBillAccountDTO.getApproveBillId(), (Object)itemFieldCode);
        }
        tmpApproveBillSalaryItemDTOMap.values().stream().filter(Objects::nonNull).forEach(approveBillSalaryItemDTO -> ApproveBillService.addNewItemId(approveBillAccountDTO.getApproveBillId(), entryEntity, approveBillSalaryItemDTO));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemAccountDy});
    }

    public static void updateHistoryData() {
        QFilter filter;
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hsas_approvebill");
        DynamicObject[] approveBillDys = helper.query("id,calentryentity.caltableid", (filter = new QFilter("billstatus", "not in", (Object)new String[]{"C", "E", "F"})).toArray());
        if (approveBillDys == null || approveBillDys.length == 0) {
            return;
        }
        log.info("ApproveBillService.updateHistoryData: begin to calculate item number.");
        long startTime = System.nanoTime();
        for (DynamicObject approveBillDy : approveBillDys) {
            ApproveBillAccountDTO approveBillAccountDTO = ApproveBillService.getApproveBillAccountDTO(approveBillDy);
            HRBaseServiceHelper.create((String)"hsas_itemaccount").deleteByFilter(new QFilter("approvebill", "=", (Object)approveBillAccountDTO.getApproveBillId()).toArray());
            ApproveBillService.updateItemAccountDy(approveBillAccountDTO);
        }
        long costTime = (System.nanoTime() - startTime) / 1000000L;
        log.info("ApproveBillService.updateHistoryData: end to calculate item number, it cost {} millisecond.", (Object)costTime);
    }

    public static ApproveBillAccountDTO getApproveBillAccountDTO(DynamicObject approveBillDy) {
        if (approveBillDy == null) {
            return new ApproveBillAccountDTO();
        }
        DynamicObjectCollection approveDyEntryDyCollection = approveBillDy.getDynamicObjectCollection("calentryentity");
        List calTableIds = approveDyEntryDyCollection.stream().map(entry -> entry.getLong("caltableid")).filter(id -> id > 0L).collect(Collectors.toList());
        ApproveBillAccountDTO approveBillAccountDTO = new ApproveBillAccountDTO(Integer.valueOf(calTableIds.size()), new LinkedHashMap(64));
        approveBillAccountDTO.setApproveBillId(Long.valueOf(approveBillDy.getLong("id")));
        List partitionIds = Lists.partition(calTableIds, (int)500);
        for (List subPartitionIds : partitionIds) {
            ApproveBillAccountDTO subApproveBillAccountDTO = ApproveBillService.getItemInfoInCalTable(subPartitionIds);
            subApproveBillAccountDTO.getApproveBillSalaryItemDTOMap().forEach((itemKey, itemDTO) -> {
                ApproveBillSalaryItemDTO approveBillSalaryItemDTO = approveBillAccountDTO.getApproveBillSalaryItemDTOMap().computeIfAbsent(itemKey, key -> new ApproveBillSalaryItemDTO(itemDTO.getDataTypeId(), itemDTO.getItemId(), itemDTO.getItemFieldCode(), approveBillAccountDTO.getTotalItemAccount().intValue()));
                int zeroAccount = approveBillSalaryItemDTO.getZeroItemAccount() + itemDTO.getZeroItemAccount();
                approveBillSalaryItemDTO.setZeroItemAccount(Integer.valueOf(zeroAccount));
                int otherAccount = approveBillSalaryItemDTO.getOtherItemAccount() + itemDTO.getOtherItemAccount();
                approveBillSalaryItemDTO.setOtherItemAccount(Integer.valueOf(otherAccount));
            });
        }
        return approveBillAccountDTO;
    }

    public static boolean getApproveBillTplIsOnHold(DynamicObject approveBillTpl) {
        if (approveBillTpl == null) {
            return false;
        }
        return approveBillTpl.getBoolean("isonhold");
    }
}

