/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.approve;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.swc.hsas.common.events.approve.ApproveOverViewDealEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.approve.IApproveOverViewDealExtService;
import kd.swc.hsas.business.approve.ApproveSettingService;
import kd.swc.hsas.business.approve.DefaultApproveOverViewDealExtService;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.cal.helper.CalSchemeViewHelper;
import kd.swc.hsas.common.HSASCompareType;
import kd.swc.hsas.common.dto.ApproveSettingDTO;
import kd.swc.hsas.common.dto.ApproveSettingViewDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ApproveSettingHelper {
    private static final Log logger = LogFactory.getLog(ApproveSettingHelper.class);
    private static final Map<String, List<String>> entryMultiValueMap = new HashMap<String, List<String>>(16);
    private static final List<String> defaultValueList = new ArrayList<String>(10);
    private static final List<String> approveValueList = new ArrayList<String>(10);
    private static final List<String> agentValueList = new ArrayList<String>(10);
    private static final String ZERO = "0";
    private static final double DOUBLE_ZERO = 0.0;
    private static final BigDecimal BIG_DECIMAL_ZERO;
    private static final int ONE_LINE = 4;
    private static final int ROW_ONE = 1;
    private static final int ROW_TWO = 2;
    private static final int ROW_THREE = 3;
    private static final int ROW_FOUR = 4;

    public static Map<String, String> getApproveBillTplSpRuleMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u5de5\u4f5c\u89d2\u8272", (String)"CalApproveBillTpl_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_personrolerel.role.name", name);
        name = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"CalApproveBillTpl_8", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_empjobrel.position.name", name);
        name = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"CalApproveBillTpl_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_empjobrel.job.name", name);
        name = ResManager.loadKDString((String)"\u804c\u7ea7", (String)"CalApproveBillTpl_10", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_empjobrel.joblevel.name", name);
        name = ResManager.loadKDString((String)"\u804c\u7b49", (String)"CalApproveBillTpl_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_empjobrel.jobgrade.name", name);
        name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTpl_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_employee.person.name", name);
        name = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalApproveBillTpl_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("hrpi_employee.person.number", name);
        return filedNameLangMap;
    }

    public static FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    public static void setDataFromObject(AbstractFormDataModel model, ApproveSettingDTO dto) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter = ApproveSettingHelper.createTableSetter(setter);
        model.beginInit();
        for (ApproveSettingViewDTO approveSettingViewDTO : dto.getApproveSettingViewDTOList()) {
            String dataSource = approveSettingViewDTO.getDatasource();
            String displayName = approveSettingViewDTO.getDisplayname();
            String fieldValue = approveSettingViewDTO.getFieldvalue();
            String valueType = approveSettingViewDTO.getValuetype();
            String remark = approveSettingViewDTO.getRemark();
            Boolean isEnable = approveSettingViewDTO.getIsenable();
            String fieldType = approveSettingViewDTO.getFieldtype();
            String selectField = approveSettingViewDTO.getSelectfield();
            setter.addRow(new Object[]{dataSource, displayName, fieldValue, valueType, remark, isEnable, fieldType, selectField});
        }
        model.batchCreateNewEntryRow("overviewentryentity", setter);
        model.endInit();
    }

    public static TableValueSetter createTableSetter(TableValueSetter setter) {
        setter.addField("datasource", new Object[0]);
        setter.addField("displayname", new Object[0]);
        setter.addField("fieldvalue", new Object[0]);
        setter.addField("valuetype", new Object[0]);
        setter.addField("remark", new Object[0]);
        setter.addField("isenable", new Object[0]);
        setter.addField("fieldtype", new Object[0]);
        setter.addField("selectfield", new Object[0]);
        return setter;
    }

    public static TableValueSetter createApproveSchemeTableSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("schemename", new Object[0]);
        setter.addField("referreport", new Object[0]);
        setter.addField("reportscheme", new Object[0]);
        setter.addField("approvepaydetail", new Object[0]);
        setter.addField("isdisplaytotal", new Object[0]);
        setter.addField("sumtype", new Object[0]);
        setter.addField("referreportname", new Object[0]);
        setter.addField("reportschemename", new Object[0]);
        setter.addField("isdisplayzeroitem", new Object[0]);
        setter.addField("isdisplayemptyitem", new Object[0]);
        setter.addField("id", new Object[0]);
        setter.addField("entryboid3", new Object[0]);
        return setter;
    }

    public static TableValueSetter createDefaultEntryTableSetter(TableValueSetter setter) {
        setter.addField("defaultschemename", new Object[0]);
        setter.addField("defaultschemeentry", new Object[0]);
        return setter;
    }

    public static TableValueSetter createSpecialEntryTableSetter(TableValueSetter setter) {
        setter.addField("conditiontxt", new Object[0]);
        setter.addField("condition", new Object[0]);
        setter.addField("approveschemeset", new Object[0]);
        setter.addField("agentschemeset", new Object[0]);
        setter.addField("issame", new Object[0]);
        return setter;
    }

    public static TableValueSetter createApvSpecialEntryTableSetter2(TableValueSetter setter) {
        setter.addField("apvspecialschename", new Object[0]);
        setter.addField("apvspecialschentry", new Object[0]);
        setter.addField("apvspecialschentryboid", new Object[0]);
        return setter;
    }

    public static TableValueSetter createApvSpecialEntryTableSetter(TableValueSetter setter) {
        setter.addField("apvspecialschename", new Object[0]);
        setter.addField("apvspecialschentry", new Object[0]);
        return setter;
    }

    public static TableValueSetter createAgeSpecialEntryTableSetter2(TableValueSetter setter) {
        setter.addField("agespecialschename", new Object[0]);
        setter.addField("agespecialschentry", new Object[0]);
        setter.addField("agespecialschentryboid", new Object[0]);
        return setter;
    }

    public static TableValueSetter createAgeSpecialEntryTableSetter(TableValueSetter setter) {
        setter.addField("agespecialschename", new Object[0]);
        setter.addField("agespecialschentry", new Object[0]);
        return setter;
    }

    public static void setDefaultApproveSettingView(ApproveSettingDTO dto) {
        ArrayList<ApproveSettingViewDTO> approveSettingViewDTOList = new ArrayList<ApproveSettingViewDTO>(10);
        String displayName1 = ResManager.loadKDString((String)"\u603b\u4eba\u6570", (String)"CalApproveBillTpl_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        String fieldValue1 = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ApproveSettingHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        String remark1 = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u5185\u6240\u6709\u8ba1\u85aa\u4eba\u5458\u5408\u8ba1\u6570\u3002", (String)"CalApproveBillTpl_19", (String)"swc-hsas-business", (Object[])new Object[0]);
        String displayName3 = ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u5408\u8ba1", (String)"CalApproveBillTpl_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        String fieldValue3 = ResManager.loadKDString((String)"\u603b\u85aa\u8d44", (String)"CalApproveBillTpl_17", (String)"swc-hsas-business", (Object[])new Object[0]);
        String remark3 = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u5185\u6240\u6709\u6570\u636e\u603b\u85aa\u8d44\u9879\u76ee\u5408\u8ba1\u91d1\u989d\u3002", (String)"CalApproveBillTpl_21", (String)"swc-hsas-business", (Object[])new Object[0]);
        String displayName4 = ResManager.loadKDString((String)"\u51c0\u85aa\u8d44\u5408\u8ba1", (String)"CalApproveBillTpl_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        String fieldValue4 = ResManager.loadKDString((String)"\u51c0\u85aa\u8d44", (String)"CalApproveBillTpl_18", (String)"swc-hsas-business", (Object[])new Object[0]);
        String remark4 = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u5185\u6240\u6709\u6570\u636e\u51c0\u85aa\u8d44\u9879\u76ee\u5408\u8ba1\u91d1\u989d\u3002", (String)"CalApproveBillTpl_22", (String)"swc-hsas-business", (Object[])new Object[0]);
        ApproveSettingViewDTO row1 = new ApproveSettingViewDTO("1", displayName1, fieldValue1, "1", remark1, Boolean.TRUE, "int", "salaryfile.employee.empnumber");
        ApproveSettingViewDTO row3 = new ApproveSettingViewDTO("1", displayName3, fieldValue3, "2", remark3, Boolean.TRUE, "amount", "");
        ApproveSettingViewDTO row4 = new ApproveSettingViewDTO("1", displayName4, fieldValue4, "2", remark4, Boolean.TRUE, "amount", "");
        approveSettingViewDTOList.add(row1);
        approveSettingViewDTOList.add(row3);
        approveSettingViewDTOList.add(row4);
        dto.setApproveSettingViewDTOList(approveSettingViewDTOList);
    }

    public static void searchTreeNode(String searchText, IFormView iFormView, boolean isSelected) {
        List<Object> treeNodes;
        boolean flag;
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        SWCPageCache swcPageCache = new SWCPageCache(iFormView);
        String rootNode = (String)swcPageCache.get("rootnode", String.class);
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
        IPageCache pageCache = (IPageCache)iFormView.getService(IPageCache.class);
        String searchNodesCacheKey = iFormView.getPageId() + "_searchNodes";
        String matchNodesCacheKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = iFormView.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = iFormView.getPageId() + "_searchIndex";
        String searchKeySetColorCacheKey = iFormView.getPageId() + "_searchKeyColor";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !SWCStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeViewNode = pageCache.get(searchNodesCacheKey);
            treeNodes = SWCStringUtils.isEmpty((String)treeViewNode) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeViewNode, TreeNode.class);
        } else {
            treeNodes = ApproveSettingHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, ZERO);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = ApproveSettingHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, ZERO);
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ApproveSettingPlugin_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else {
            if (SWCStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    if (isSelected) {
                        ApproveSettingHelper.keyWordSearchSelected(treeView, iFormView, pageCache, searchIndexCacheKey, indexCache, treeNode);
                    } else {
                        ApproveSettingHelper.keyWordSearchSetColor(treeView, iFormView, treeNode, pageCache, searchIndexCacheKey, indexCache, searchKeySetColorCacheKey);
                    }
                } else {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"ApproveSettingPlugin_2", (String)"swc-hsas-business", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, ZERO);
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, ZERO);
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static List<TreeNode> getNodes(List<TreeNode> rootNodes, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode rootNode : rootNodes) {
            nodes.addAll(rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16));
        }
        return nodes;
    }

    private static void keyWordSearchSelected(TreeView treeView, IFormView iFormView, IPageCache pageCache, String searchIndexCacheKey, int indexCache, TreeNode treeNode) {
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkedNodeIds);
        treeView.checkNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
    }

    private static void keyWordSearchSetColor(TreeView treeView, IFormView iFormView, TreeNode treeNode, IPageCache pageCache, String searchIndexCacheKey, int indexCache, String searchKeySetColorCacheKey) {
        treeNode.setColor("#ff0000");
        treeView.updateNode(treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
        String preTreeNodeStr = pageCache.get(searchKeySetColorCacheKey);
        if (!SWCStringUtils.isEmpty((String)preTreeNodeStr)) {
            TreeNode preTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)preTreeNodeStr, TreeNode.class);
            preTreeNode.setColor("");
            treeView.updateNode(preTreeNode);
        }
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        SWCPageCache swcPageCache = new SWCPageCache(iFormView);
        String allTreeNodeStr = (String)swcPageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)allTreeNodeStr);
        checkedNodeIds.forEach(selectNodeId -> {
            TreeNode selectNode = (TreeNode)nodeMap.get(selectNodeId);
            treeView.checkNode(selectNode);
        });
        pageCache.put(searchKeySetColorCacheKey, SerializationUtils.toJsonString((Object)treeNode));
    }

    public static void buildLeftTree(List<TreeNode> schemeNodes, DynamicObjectCollection schemeEntryEntity, TreeView treeView) {
        if (!schemeEntryEntity.isEmpty()) {
            treeView.deleteAllNodes();
            if (!CollectionUtils.isEmpty(schemeNodes)) {
                schemeNodes.clear();
            }
            for (DynamicObject scheme : schemeEntryEntity) {
                TreeNode node = new TreeNode("", scheme.getString("id"), scheme.getString("schemename"));
                schemeNodes.add(node);
            }
            treeView.addNodes(schemeNodes);
        }
    }

    public static void addShowColumn(IFormView view, TreeView tree, String entryentityname) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryentityname);
        List selectedNodesList = tree.getTreeState().getSelectedNodes();
        ArrayList resultNodesList = new ArrayList(selectedNodesList);
        int selectSize = resultNodesList.size();
        if (selectSize == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"ApproveSettingPlugin_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        int count = model.getEntryRowCount(entryentityname);
        HashMap<Long, String> schemeIdMap = new HashMap<Long, String>(16);
        for (Object dynamicObject : entryEntity) {
            Long schemeId = dynamicObject.getLong(entryMultiValueMap.get(entryentityname).get(0));
            schemeIdMap.put(schemeId, "1");
        }
        int newSize = 0;
        for (Map selectedNodes : resultNodesList) {
            Long schemeId = Long.valueOf((String)selectedNodes.get("id"));
            if (schemeIdMap.containsKey(schemeId)) continue;
            ++newSize;
        }
        if (newSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow(entryentityname, newSize);
        int tag = count;
        for (Map selectedNodes : resultNodesList) {
            Long schemeId = Long.valueOf((String)selectedNodes.get("id"));
            String schemeName = (String)selectedNodes.get("text");
            if (schemeIdMap.containsKey(schemeId)) continue;
            view.getModel().setValue(entryMultiValueMap.get(entryentityname).get(0), (Object)schemeId, tag);
            view.getModel().setValue(entryMultiValueMap.get(entryentityname).get(1), (Object)schemeName, tag);
            ++tag;
        }
        view.sendFormAction(view);
    }

    public static void removeShowColumn(TreeView tree, List<DynamicObject> entryEntityCollection, String entryEntityName) {
        ArrayList<String> schemeIdList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : entryEntityCollection) {
            String schemeId = dynamicObject.getString(entryMultiValueMap.get(entryEntityName).get(0));
            schemeIdList.add(schemeId);
        }
        tree.uncheckNodes(schemeIdList);
    }

    public static void showColumn(TreeView tree, List<DynamicObject> entryEntityCollection, Map<String, TreeNode> treeNodeMap, String entryEntityName) {
        for (DynamicObject dynamicObject : entryEntityCollection) {
            String schemeId = dynamicObject.getString(entryMultiValueMap.get(entryEntityName).get(0));
            if (StringUtils.isBlank((CharSequence)schemeId)) {
                return;
            }
            TreeNode node = treeNodeMap.get(schemeId);
            if (null == node) continue;
            tree.checkNode(node);
        }
    }

    public static int setShareScheme(List<Long> pkIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter filter = new QFilter("id", "in", pkIdList);
        DynamicObject[] needUpdateCalApvTplDy = helper.query("id, issharescheme,status", new QFilter[]{filter});
        int notsharenum = 0;
        for (DynamicObject dynamicObject : needUpdateCalApvTplDy) {
            boolean isShareScheme = dynamicObject.getBoolean("issharescheme");
            if (isShareScheme) {
                dynamicObject.set("issharescheme", (Object)Boolean.FALSE);
                continue;
            }
            ++notsharenum;
        }
        helper.update(needUpdateCalApvTplDy);
        List<DynamicObject> needUpdateCalApvTplNewDy = Arrays.stream(needUpdateCalApvTplDy).filter(item -> "C".equals(item.getString("status"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needUpdateCalApvTplNewDy)) {
            ApproveSettingHelper.shareOrUnshareApproveBillTpl(needUpdateCalApvTplNewDy.toArray(new DynamicObject[0]), helper);
        }
        return notsharenum;
    }

    public static int setHasShareScheme(List<Long> pkIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter filter = new QFilter("id", "in", pkIdList);
        DynamicObject[] needUpdateCalApvTplDy = helper.query("id, issharescheme,modifytime,status", new QFilter[]{filter});
        int sharenum = 0;
        for (DynamicObject dynamicObject : needUpdateCalApvTplDy) {
            boolean isShareScheme = dynamicObject.getBoolean("issharescheme");
            if (isShareScheme) {
                ++sharenum;
                continue;
            }
            dynamicObject.set("issharescheme", (Object)Boolean.TRUE);
            dynamicObject.set("modifytime", (Object)new Date());
        }
        helper.update(needUpdateCalApvTplDy);
        List<DynamicObject> needUpdateCalApvTplNewDy = Arrays.stream(needUpdateCalApvTplDy).filter(item -> "C".equals(item.getString("status"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needUpdateCalApvTplNewDy)) {
            ApproveSettingHelper.shareOrUnshareApproveBillTpl(needUpdateCalApvTplNewDy.toArray(new DynamicObject[0]), helper);
        }
        return sharenum;
    }

    private static void shareOrUnshareApproveBillTpl(DynamicObject[] needUpdateCalApvTplDy, SWCDataServiceHelper helper) {
        ArrayList<Long> approveBillTplIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : needUpdateCalApvTplDy) {
            Long approveBillTplId = dynamicObject.getLong("id");
            approveBillTplIds.add(approveBillTplId);
        }
        QFilter approveBillTplFilter = new QFilter("id", "in", approveBillTplIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)approveBillTplFilter);
        DynamicObject[] approveBillTplDyArr = helper.loadDynamicObjectArray("hsas_approvebilltpl", new QFilter[]{approveBillTplFilter});
        ArrayList newApproveBillTplDys = Lists.newArrayListWithExpectedSize((int)approveBillTplDyArr.length);
        for (DynamicObject approveBillTplDy : approveBillTplDyArr) {
            HashSet ignoreField = Sets.newHashSet();
            ignoreField.add("id");
            ignoreField.add("sourcevid");
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
            DynamicObject approveBillTplDyNew = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)approveBillTplDy, (DynamicObject)approveBillTplDyNew, (Set)ignoreField, (boolean)true);
            ApproveSettingHelper.assembleData(approveBillTplDyNew);
            newApproveBillTplDys.add(approveBillTplDyNew);
        }
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber("hsas_approvebilltpl");
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(newApproveBillTplDys.toArray(new DynamicObject[0]));
        hisModelController.noLineTimeHisVersionChange(hisVersionParamBo);
    }

    public static FormShowParameter getOperationResultParameter(String message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationresult");
        parameters.setShowTitle(false);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;text-align:center;margin-top: 40px;word-wrap:break-word;word-break:break-all;width:100%;font-size:16px'>");
        buf.append(message).append("<br/>");
        parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", null);
        return parameters;
    }

    public static void moveEntryTop(IFormView view, DynamicObjectCollection entryEntity, String entryName) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int[] rowIndexArr = proxy.getEntryState(entryName).getSelectedRows();
        CalSchemeViewHelper helper = new CalSchemeViewHelper();
        Arrays.sort(rowIndexArr);
        int[] sortSelectedRows = (int[])rowIndexArr.clone();
        if (null == sortSelectedRows || 0 == sortSelectedRows.length) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalApproveBillTplTips_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (sortSelectedRows[0] == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u7f6e\u9876\u3002", (String)"CalApproveBillTplTips_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = view.getModel().getEntryRowCount(entryName);
        int[] upIndexArr = helper.moveIndexUp(sortSelectedRows, rowCount);
        ApproveSettingHelper.setColumnInfo(view.getFormShowParameter().getFormId(), entryEntity, entryName, upIndexArr);
    }

    public static void moveEntryDown(IFormView view, DynamicObjectCollection entryEntity, String entryName) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int[] rowIndexArr = proxy.getEntryState(entryName).getSelectedRows();
        CalSchemeViewHelper helper = new CalSchemeViewHelper();
        Arrays.sort(rowIndexArr);
        int[] sortSelectedRows = (int[])rowIndexArr.clone();
        if (null == sortSelectedRows || 0 == sortSelectedRows.length) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalApproveBillTplTips_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (sortSelectedRows[0] + 1 == entryEntity.size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u7f6e\u5e95\u3002", (String)"CalApproveBillTplTips_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = view.getModel().getEntryRowCount(entryName);
        int[] downIndexArr = helper.moveIndexDown(sortSelectedRows, rowCount);
        ApproveSettingHelper.setColumnInfo(view.getFormShowParameter().getFormId(), entryEntity, entryName, downIndexArr);
    }

    public static void setColumnInfo(String tplName, DynamicObjectCollection entryEntity, String entryName, int[] indexArr) {
        int i;
        SWCDataServiceHelper approveBillTplHelper = new SWCDataServiceHelper(tplName);
        DynamicObject approveBillTplDy = approveBillTplHelper.generateEmptyDynamicObject();
        DynamicObjectCollection approveBillTplEntryDys = approveBillTplDy.getDynamicObjectCollection(entryName);
        for (i = 0; i < indexArr.length; ++i) {
            DynamicObject approveBillTplEntryDy = (DynamicObject)entryEntity.get(indexArr[i]);
            DynamicObject calEntryDynamicObject = approveBillTplHelper.generateEmptyEntryDynamicObject(entryName);
            calEntryDynamicObject.set("seq", (Object)(approveBillTplEntryDys.size() + 1));
            approveBillTplEntryDy.get("seq");
            calEntryDynamicObject.set(entryMultiValueMap.get(entryName).get(0), approveBillTplEntryDy.get(entryMultiValueMap.get(entryName).get(0)));
            calEntryDynamicObject.set(entryMultiValueMap.get(entryName).get(1), approveBillTplEntryDy.get(entryMultiValueMap.get(entryName).get(1)));
            if (entryMultiValueMap.get(entryName).size() == 3) {
                calEntryDynamicObject.set(entryMultiValueMap.get(entryName).get(2), approveBillTplEntryDy.get(entryMultiValueMap.get(entryName).get(2)));
            }
            approveBillTplEntryDys.add((Object)calEntryDynamicObject);
        }
        for (i = 0; i < entryEntity.size(); ++i) {
            ((DynamicObject)entryEntity.get(i)).set(entryMultiValueMap.get(entryName).get(0), ((DynamicObject)approveBillTplEntryDys.get(i)).get(entryMultiValueMap.get(entryName).get(0)));
            ((DynamicObject)entryEntity.get(i)).set(entryMultiValueMap.get(entryName).get(1), ((DynamicObject)approveBillTplEntryDys.get(i)).get(entryMultiValueMap.get(entryName).get(1)));
            if (entryMultiValueMap.get(entryName).size() != 3) continue;
            ((DynamicObject)entryEntity.get(i)).set(entryMultiValueMap.get(entryName).get(2), ((DynamicObject)approveBillTplEntryDys.get(i)).get(entryMultiValueMap.get(entryName).get(2)));
        }
    }

    public static void setPreviewText(IFormView view, DynamicObjectCollection entityCollection) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey("flexpanelap_text");
        int index = 0;
        int size = 0;
        for (DynamicObject entity : entityCollection) {
            if (!entity.get("isenable").equals(Boolean.TRUE)) continue;
            ApproveSettingHelper.cretePreviewTextFlexPanel(view, panelAp, index++, entity.getString("displayname"), entity.getString("fieldtype"), entity.getString("valuetype"), null, null, null, "preview", HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)entity));
            ++size;
        }
        int modFour = size % 4;
        if (modFour != 0) {
            int addItemNum = 4 - modFour;
            for (int i = 0; i < addItemNum; ++i) {
                FlexPanelAp blankPanelAp = new FlexPanelAp();
                blankPanelAp.setKey("flexpanelap_blank" + i);
                blankPanelAp.setWidth(new LocaleString("23%"));
                panelAp.getItems().add(blankPanelAp);
            }
        }
        view.updateControlMetadata(panelAp.getKey(), panelAp.createControl());
    }

    /*
     * WARNING - void declaration
     */
    public static FlexPanelAp setOverViewText(IFormView view, DynamicObjectCollection entityCollection, Map<Long, DataSet> taskdDataMap, Map<Long, Map<String, String>> selectFieldMap, Map<Long, DynamicObject[]> tasklPersonMap, LinkedHashSet<String> calPersonColList, List<Long> calPersonIds) {
        QFilter salaryItemFilter;
        SWCDataServiceHelper salaryItemHelper;
        DynamicObject[] salaryItemDyArr;
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey("flexpanelap_text");
        panelAp.setHeight(new LocaleString("100%"));
        int index = 0;
        Long calTaskId = 0L;
        for (Map.Entry<Long, DataSet> entry : taskdDataMap.entrySet()) {
            calTaskId = entry.getKey();
        }
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject calTaskDy = taskHelper.queryOne("id,payrollgroupv.currency,payrollgroupv.currency.sign,payrollgroupv.currency.amtprecision", new QFilter[]{taskFilter});
        String currencySign = calTaskDy.getString("payrollgroupv.currency.sign");
        Integer amtPrecision = calTaskDy.getInt("payrollgroupv.currency.amtprecision");
        String currencyStr = SerializationUtils.serializeToBase64((Object)calTaskDy.getDynamicObject("payrollgroupv.currency"));
        view.getParentView().getPageCache().put("calcurrency", currencyStr);
        HashSet<String> fieldSet = new HashSet<String>(16);
        ArrayList<Long> salaryItems = new ArrayList<Long>(10);
        HashMap<String, Integer> scaleMap = new HashMap<String, Integer>(16);
        for (Map.Entry<Long, DataSet> entry : taskdDataMap.entrySet()) {
            Field[] fields;
            RowMeta rowMeta = entry.getValue().getRowMeta();
            Field[] fieldArray = fields = rowMeta.getFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                String name = field.getName();
                fieldSet.add(name);
                String[] stringArray = name.split("item_");
                if (stringArray.length <= 1) continue;
                String[] itemArrSplit = stringArray[1].split("_");
                salaryItems.add(Long.valueOf(itemArrSplit[0]));
            }
        }
        logger.info("setOverViewText fieldSet: {}", (Object)JSON.toJSONString(fieldSet));
        if (!CollectionUtils.isEmpty(salaryItems) && null != (salaryItemDyArr = (salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem")).query("id, dataprecision.scale", new QFilter[]{salaryItemFilter = new QFilter("id", "in", salaryItems)})) && salaryItemDyArr.length > 0) {
            for (Field field : salaryItemDyArr) {
                scaleMap.put(field.getString("id"), field.getInt("dataprecision.scale"));
            }
        }
        if (null == currencySign) {
            currencySign = "\uffe5";
        }
        for (DynamicObject entity : entityCollection) {
            Object data;
            if (!entity.get("isenable").equals(Boolean.TRUE)) continue;
            boolean isPersonNum = false;
            String personFiled = null;
            String fieldType = entity.getString("fieldtype");
            String valueType = entity.getString("valuetype");
            HashMap hashMap = new HashMap(taskdDataMap.size());
            Integer scale = 2;
            for (Map.Entry entry : taskdDataMap.entrySet()) {
                void var30_54;
                block36: {
                    String selectField;
                    block34: {
                        block35: {
                            String[] items;
                            data = ((DataSet)entry.getValue()).copy();
                            Object var30_42 = null;
                            selectField = selectFieldMap.get(entry.getKey()).get(entity.getString("displayname"));
                            logger.info("setOverViewText selectFieldMap: {}, selectField: {}", (Object)JSON.toJSONString(selectFieldMap), (Object)JSON.toJSONString((Object)selectField));
                            String[] stringArray = items = selectField != null ? selectField.split("item_") : new String[]{};
                            if (items.length > 1) {
                                int one = ApproveSettingHelper.getOne();
                                String[] itemsArray = items[one].split("_");
                                Integer n = scale = scaleMap.get(itemsArray[0]) == null ? scale : (Integer)scaleMap.get(itemsArray[0]);
                            }
                            if (!data.isEmpty() || calPersonColList.contains(selectField)) break block34;
                            if (!StringUtils.equals((CharSequence)valueType, (CharSequence)"1")) break block35;
                            String string = ZERO;
                            break block36;
                        }
                        if (!StringUtils.equals((CharSequence)valueType, (CharSequence)"2") && !StringUtils.equals((CharSequence)valueType, (CharSequence)"3")) break block36;
                        String string = ApproveSettingHelper.formatNum(BIG_DECIMAL_ZERO, fieldType, scale, amtPrecision);
                        break block36;
                    }
                    if (calPersonColList.contains(selectField)) {
                        isPersonNum = true;
                        personFiled = selectField;
                    } else {
                        Iterator iterator = data.iterator();
                        while (iterator.hasNext()) {
                            Row row = (Row)iterator.next();
                            if (StringUtils.equals((CharSequence)valueType, (CharSequence)"1")) {
                                if (null == selectField || selectField.contains("null") || !fieldSet.contains(selectField) || null == row.getLong(selectField)) {
                                    String string = ZERO;
                                    continue;
                                }
                                String string = String.valueOf(row.getLong(selectField));
                                continue;
                            }
                            if (!StringUtils.equals((CharSequence)valueType, (CharSequence)"2") && !StringUtils.equals((CharSequence)valueType, (CharSequence)"3")) continue;
                            if (null == selectField || selectField.contains("null")) {
                                String string = ApproveSettingHelper.formatNum(BIG_DECIMAL_ZERO, fieldType, scale, amtPrecision);
                                continue;
                            }
                            String field = "sys_" + selectField;
                            if (StringUtils.equals((CharSequence)entity.getString("datasource"), (CharSequence)"1")) {
                                if (!fieldSet.contains(field) || null == row.getBigDecimal(field)) {
                                    String string = ApproveSettingHelper.formatNum(BIG_DECIMAL_ZERO, fieldType, scale, amtPrecision);
                                    continue;
                                }
                                String string = ApproveSettingHelper.formatNum(row.getBigDecimal(field), fieldType, scale, amtPrecision);
                                continue;
                            }
                            if (fieldSet.contains(selectField)) {
                                if (null == row.getBigDecimal(selectField)) {
                                    String string = ApproveSettingHelper.formatNum(BIG_DECIMAL_ZERO, fieldType, scale, amtPrecision);
                                    continue;
                                }
                                String string = ApproveSettingHelper.formatNum(row.getBigDecimal(selectField), fieldType, scale, amtPrecision);
                                continue;
                            }
                            String string = ApproveSettingHelper.formatNum(BIG_DECIMAL_ZERO, fieldType, scale, amtPrecision);
                        }
                    }
                }
                hashMap.put(entry.getKey(), var30_54);
            }
            BigDecimal totalValue = BigDecimal.ZERO;
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
            for (Map.Entry entry : hashMap.entrySet()) {
                String value = (String)entry.getValue();
                if (SWCStringUtils.isNotEmpty((String)value)) {
                    BigDecimal taskValue = new BigDecimal(value);
                    totalValue = totalValue.add(taskValue);
                }
                arrayList.addAll(Arrays.asList((Object[])tasklPersonMap.get(entry.getKey())));
            }
            data = null;
            if (isPersonNum) {
                data = ApproveSettingHelper.setPersonNum(arrayList, personFiled);
            } else {
                switch (valueType) {
                    case "1": 
                    case "2": {
                        data = ApproveSettingHelper.formatNum(totalValue, fieldType, scale, amtPrecision);
                        break;
                    }
                    case "3": {
                        if (arrayList.size() == 0) {
                            data = BigDecimal.ZERO.toString();
                            break;
                        }
                        if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"amount")) {
                            data = totalValue.divide(new BigDecimal(arrayList.size()), (int)amtPrecision, 4).toString();
                            break;
                        }
                        data = totalValue.divide(new BigDecimal(arrayList.size()), (int)scale, 4).toString();
                        break;
                    }
                }
            }
            ApproveSettingHelper.cretePreviewTextFlexPanel(view, panelAp, index++, entity.getString("displayname"), fieldType, valueType, currencySign, (String)data, calPersonIds, "hsas_approvebill", HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)entity));
        }
        return panelAp;
    }

    private static String setPersonNum(List<DynamicObject> calPersonData, String selectField) {
        long num = calPersonData.stream().map(calPerson -> calPerson.get(selectField)).distinct().count();
        return String.valueOf(num);
    }

    private static String formatNum(BigDecimal num, String fieldType, Integer scale, Integer amtPrecision) {
        if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"amount")) {
            return num.setScale((int)amtPrecision, 4).toString();
        }
        return num.setScale((int)scale, 4).toString();
    }

    public static void cretePreviewTextFlexPanel(IFormView view, FlexPanelAp flexPanelAp, int index, String name, String dataType, String selectValue, String currencySign, String num, List<Long> calPersonIds, String type, Map<String, Object> overViewEntry) {
        if (null == selectValue) {
            return;
        }
        int textSize = 16;
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setGrow(0);
        panelAp.setKey("flexpanelap_text" + index);
        panelAp.setDirection("column");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("18px");
        style.setMargin(margin);
        panelAp.setStyle(style);
        panelAp.setWidth(new LocaleString("200px"));
        LabelAp labelAp = new LabelAp();
        labelAp.setName(new LocaleString(name));
        labelAp.setFontSize(14);
        labelAp.setKey("label_description" + index);
        labelAp.setForeColor("#666666");
        panelAp.getItems().add(labelAp);
        labelAp = new LabelAp();
        labelAp.setKey("label_description_num" + String.valueOf(index));
        labelAp.setForeColor("#212121");
        labelAp.setFontSize(textSize);
        labelAp.setFontWeight("700");
        labelAp.setLineHeight("24px");
        labelAp.setHeight(new LocaleString("24px"));
        Tips ctlTips = new Tips();
        ctlTips.setType("text");
        ctlTips.setTriggerType("hover");
        ctlTips.setShowIcon(false);
        ctlTips.setPlace("bottom");
        labelAp.setCtlTips(ctlTips);
        if (selectValue.equals("1")) {
            if (SWCStringUtils.equals((String)type, (String)"preview")) {
                labelAp.setName(new LocaleString("8,888"));
                ctlTips.setContent(new LocaleString("8,888"));
            } else {
                num = BankOfferHelper.fmtMicrometer(num);
                labelAp.setName(new LocaleString(MessageFormat.format("{0}", num)));
                ctlTips.setContent(new LocaleString(MessageFormat.format("{0}", num)));
            }
        } else if (selectValue.equals("2") || selectValue.equals("3")) {
            if (dataType.equals("amount")) {
                if (SWCStringUtils.equals((String)type, (String)"preview")) {
                    labelAp.setName(new LocaleString("\uffe588,888.88"));
                    ctlTips.setContent(new LocaleString("\uffe588,888.88"));
                } else {
                    num = BankOfferHelper.fmtMicrometer(num);
                    labelAp.setName(new LocaleString(currencySign + num));
                    ctlTips.setContent(new LocaleString(currencySign + num));
                }
            } else if (SWCStringUtils.equals((String)type, (String)"preview")) {
                labelAp.setName(new LocaleString("8,888.88"));
                ctlTips.setContent(new LocaleString("8,888.88"));
            } else {
                num = BankOfferHelper.fmtMicrometer(num);
                labelAp.setName(new LocaleString(num));
                ctlTips.setContent(new LocaleString(num));
            }
        } else {
            ApproveOverViewDealEvent approveOverViewDealEvent = new ApproveOverViewDealEvent(type, calPersonIds, "", overViewEntry);
            ApproveSettingHelper.dealOverViewValue(approveOverViewDealEvent);
            labelAp.setName(new LocaleString(approveOverViewDealEvent.getValue()));
            ctlTips.setContent(new LocaleString(approveOverViewDealEvent.getValue()));
        }
        panelAp.getItems().add(labelAp);
        flexPanelAp.getItems().add(panelAp);
        view.updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
    }

    private static void dealOverViewValue(ApproveOverViewDealEvent approveOverViewDealEvent) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultApproveOverViewDealExtService(), IApproveOverViewDealExtService.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.approve.IApproveOverViewDealExtService#dealOverViewValue", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.dealOverViewValue(approveOverViewDealEvent);
            return null;
        });
        logger.info("IApproveOverViewDealExtService end event");
    }

    private static int getOne() {
        return 1;
    }

    public static Map<String, String> setFieldMap(Long orgId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        try (DataSet salaryItem = ApproveSettingService.getSalaryItem(orgId);){
            for (Row row : salaryItem) {
                if (null == row.getString("datatype.storagetype")) {
                    fieldMap.put(row.getString("name"), "text-item_" + row.getString("id"));
                    continue;
                }
                fieldMap.put(row.getString("name"), row.getString("datatype.storagetype") + "-item_" + row.getString("id"));
            }
        }
        fieldMap.put(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalApproveBillTpl_0", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_salaryfile.employee.empnumber");
        fieldMap.put(ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTpl_1", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_personhrv.name");
        fieldMap.put(ResManager.loadKDString((String)"\u56fd\u7c4d", (String)"CalApproveBillTpl_2", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_personalinfov.nationality.name");
        fieldMap.put(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalApproveBillTpl_3", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_salaryfilev.number");
        fieldMap.put(ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53", (String)"CalApproveBillTpl_4", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_salaryfilev.paysubject.name");
        fieldMap.put(ResManager.loadKDString((String)"\u53d1\u85aa\u72b6\u6001", (String)"CalApproveBillTpl_5", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_salaryfilev.paystatus");
        fieldMap.put(ResManager.loadKDString((String)"\u4ee3\u7ba1\u5458\u5de5", (String)"CalApproveBillTpl_6", (String)"swc-hsas-business", (Object[])new Object[0]), "text-other_salaryfilev.isescrowstaff");
        return fieldMap;
    }

    public static void showChangeForm(IFormView view, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("continue_close", plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"CalApproveBillTplHelpTips_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"CalApproveBillTplHelpTips_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u5c1a\u672a\u7ef4\u62a4\u5b8c\u6210\u5ba1\u6279\u5355\u6a21\u677f\u4fe1\u606f\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u89c6\u4e3a\u653e\u5f03\u672c\u6b21\u65b0\u589e\u3002", (String)"CalApproveBillTplHelpTips_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        view.showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
    }

    public static void showPageOne(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"pageone"});
        view.setVisible(Boolean.FALSE, new String[]{"pagetwo", "pagethree", "pagefour", "viewsetflex", "abstractflex"});
    }

    public static void showPageTwo(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"pagetwo", "flexpanelap_hidden"});
        view.setVisible(Boolean.FALSE, new String[]{"pageone", "pagethree", "pagefour", "flexpanelap_show", "viewsetflex"});
    }

    public static void showPageThree(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"pageone", "pagetwo", "pagefour", "ruletitle"});
        view.setVisible(Boolean.TRUE, new String[]{"pagethree", "viewsetflex"});
    }

    public static void showPageFour(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"pageone", "pagetwo", "pagethree"});
        view.setVisible(Boolean.TRUE, new String[]{"pagefour"});
    }

    public static void showDetail(IFormView view, List<TreeNode> schemeNodes) {
        ApproveSettingHelper.showHiddenPreview(view);
        DynamicObjectCollection schemeDyCollection = view.getModel().getEntryEntity("schemeentryentity");
        for (DynamicObject schemeDy : schemeDyCollection) {
            String referReportName = schemeDy.getString("referreport");
            schemeDy.set("referreportname", (Object)referReportName);
            if (StringUtils.equals((CharSequence)"3", (CharSequence)schemeDy.getString("referreport"))) {
                String approvePayDetail = schemeDy.getString("approvepaydetail");
                if (approvePayDetail == null) continue;
                String[] payDetailArr = approvePayDetail.split(",");
                StringJoiner payDetailStr = new StringJoiner(",");
                for (String payDetail : payDetailArr) {
                    String fieldName = ApproveSettingHelper.getPayDetailFieldMap().get(payDetail);
                    if (!StringUtils.isNotEmpty((CharSequence)fieldName)) continue;
                    payDetailStr.add(fieldName);
                }
                schemeDy.set("reportschemename", (Object)payDetailStr.toString());
                continue;
            }
            DynamicObject reportSchemeDy = schemeDy.getDynamicObject("reportscheme");
            if (null == reportSchemeDy) continue;
            String reportSchemeName = reportSchemeDy.getString("name");
            schemeDy.set("reportschemename", (Object)reportSchemeName);
        }
        ApproveSettingHelper.buildLeftTree(view, schemeNodes);
        DynamicObjectCollection specialDyCollection = view.getModel().getEntryEntity("specialentryentity");
        ApproveSettingHelper.initSpecialEntity(view, specialDyCollection);
        ApproveSettingHelper.showAllPage(view);
    }

    public static void showHiddenPreview(IFormView view) {
        String isShowPreviewTab = view.getPageCache().get("isShowPreviewTab");
        if (!StringUtils.equals((CharSequence)isShowPreviewTab, (CharSequence)"true")) {
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap_hidden"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelap_show"});
    }

    public static void showEditView(IFormView view) {
        ApproveSettingHelper.showAllPage(view);
        ApproveSettingHelper.showEditToolbar(view);
    }

    public static void showAllPage(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"pageone", "pagetwo", "pagethree", "pagefour"});
        view.setVisible(Boolean.TRUE, new String[]{"preview_show"});
        view.getPageCache().put("isShowPreviewTab", "true");
        view.setVisible(Boolean.FALSE, new String[]{"wizardap"});
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelap_hidden"});
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelap_show"});
        view.setVisible(Boolean.TRUE, new String[]{"carddesc"});
        view.setVisible(Boolean.TRUE, new String[]{"ruletitle"});
        Container pageOnePanel = (Container)view.getControl("pageone");
        pageOnePanel.setCollapseable(true);
        pageOnePanel.setCollapse(false);
        Container pageTwoPanel = (Container)view.getControl("pagetwo");
        pageTwoPanel.setCollapseable(true);
        pageTwoPanel.setCollapse(false);
        Container viewSetPanel = (Container)view.getControl("viewsetflex");
        viewSetPanel.setCollapseable(true);
        viewSetPanel.setCollapse(false);
        view.updateView("pageone");
        view.updateView("pagetwo");
        view.updateView("viewsetflex");
    }

    public static void showEditToolbar(IFormView view) {
        String entityId = view.getEntityId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"hsas_approvebilltpl")) {
            view.setVisible(Boolean.TRUE, new String[]{"tbmain"});
        }
        view.setVisible(Boolean.TRUE, new String[]{"tbmain", "creator", "createtime"});
        view.setVisible(Boolean.FALSE, new String[]{"tpassistant"});
        view.setVisible(Boolean.FALSE, new String[]{"abstractflex"});
    }

    public static void buildLeftTree(IFormView view, List<TreeNode> schemeNodes) {
        TreeView treeView = (TreeView)view.getControl("schemetreeviewap");
        DynamicObjectCollection schemeEntryEntity = view.getModel().getEntryEntity("schemeentryentity");
        if (CollectionUtils.isEmpty((Collection)schemeEntryEntity)) {
            treeView.deleteAllNodes();
            return;
        }
        ApproveSettingHelper.buildLeftTree(schemeNodes, schemeEntryEntity, treeView);
        DynamicObjectCollection defaultDyCollection = view.getModel().getEntryEntity("defaultruleentity");
        if (!CollectionUtils.isEmpty((Collection)defaultDyCollection)) {
            ArrayList<DynamicObject> defaultDyList = new ArrayList<DynamicObject>((Collection<DynamicObject>)defaultDyCollection);
            Map<String, TreeNode> treeNodeMap = schemeNodes.stream().collect(Collectors.toMap(TreeNode::getId, treeNode -> treeNode, (o1, o2) -> o1));
            ApproveSettingHelper.showColumn(treeView, defaultDyList, treeNodeMap, "defaultruleentity");
        }
    }

    public static void initSpecialEntity(IFormView view, DynamicObjectCollection specialDyCollection) {
        if (CollectionUtils.isEmpty((Collection)specialDyCollection)) {
            return;
        }
        for (DynamicObject specialDy : specialDyCollection) {
            List<Object> filterRow;
            String agentSchemeSet;
            StringJoiner approveScheme = new StringJoiner("\uff1b");
            StringJoiner agentScheme = new StringJoiner("\uff1b");
            DynamicObjectCollection apvEntryEntity = specialDy.getDynamicObjectCollection("approvespecialruleentity");
            DynamicObjectCollection ageEntryEntity = specialDy.getDynamicObjectCollection("agentspecialruleentity");
            for (DynamicObject apvDy : apvEntryEntity) {
                approveScheme.add(apvDy.getString("apvspecialschename"));
            }
            String approveSchemeSet = approveScheme.toString();
            specialDy.set("approveschemeset", (Object)approveSchemeSet);
            if (!CollectionUtils.isEmpty((Collection)ageEntryEntity)) {
                for (DynamicObject ageDy : ageEntryEntity) {
                    agentScheme.add(ageDy.getString("agespecialschename"));
                }
                agentSchemeSet = agentScheme.toString();
            } else {
                agentSchemeSet = ResManager.loadKDString((String)"\u4e0e\u5ba1\u6279\u4eba\u4e00\u81f4", (String)"CalApproveBillTpl_23", (String)"swc-hsas-business", (Object[])new Object[0]);
            }
            specialDy.set("agentschemeset", (Object)agentSchemeSet);
            String condition = specialDy.getString("condition");
            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)specialDy.getString("condition"), FilterCondition.class);
                filterRow = filterCondition.getFilterRow();
            } else {
                filterRow = new ArrayList<SimpleFilterRow>(10);
            }
            specialDy.set("conditiontxt", (Object)ApproveSettingHelper.getConditionTxt(filterRow, ApproveSettingHelper.getApproveBillTplSpRuleMap()));
            specialDy.set("executeseq", (Object)specialDy.getInt("seq"));
        }
        view.updateView("specialentryentity");
    }

    public static String getConditionTxt(List<SimpleFilterRow> filterRow, Map<String, String> filedNameLangMap) {
        StringBuilder conditionTxt = new StringBuilder();
        for (int j = 0; j < filterRow.size(); ++j) {
            SimpleFilterRow simpleFilterRow = filterRow.get(j);
            String filterName = filedNameLangMap.get(simpleFilterRow.getFieldName());
            String filterType = (String)HSASCompareType.getCompareTypeMap().get(simpleFilterRow.getCompareType());
            List filterValues = simpleFilterRow.getValue();
            if (null == filterName || filterType == null) continue;
            String leftBracket = simpleFilterRow.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                leftBracket = " " + leftBracket;
            }
            String preString = leftBracket + " [" + filterName + "] " + filterType;
            conditionTxt.append(preString);
            StringBuilder valueTxt = new StringBuilder();
            int filterValuesSize = filterValues.size();
            for (int i = 0; i < filterValuesSize; ++i) {
                FilterValue filterValue = (FilterValue)filterValues.get(i);
                valueTxt.append(filterValue.getValue());
                if (i == filterValuesSize - 1) continue;
                if ("between".equals(filterType)) {
                    valueTxt.append('~');
                    continue;
                }
                valueTxt.append('\u3001');
            }
            if (SWCStringUtils.isNotEmpty((String)valueTxt.toString())) {
                conditionTxt.append(" <").append((CharSequence)valueTxt).append('>');
            }
            conditionTxt.append(' ');
            String rightBracket = simpleFilterRow.getRightBracket();
            if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                conditionTxt.append(rightBracket).append(' ');
            }
            if (j == filterRow.size() - 1) continue;
            String logic = (String)HSASCompareType.getLogicTypeMap().get(simpleFilterRow.getLogic());
            conditionTxt.append(logic);
        }
        return conditionTxt.toString();
    }

    public static Map<String, String> getPayDetailFieldMap() {
        LinkedHashMap<String, String> filedNameLangMap = new LinkedHashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTpl_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryfilehis.person.name", name);
        name = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalApproveBillTpl_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryfilehis.employee.empnumber", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"CalApproveBillTpl_24", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryfilehis.number", name);
        name = ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7", (String)"CalApproveBillTpl_25", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("org.name", name);
        name = ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"CalApproveBillTpl_26", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("adminorg.name", name);
        name = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4", (String)"CalApproveBillTpl_27", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("empgroup.name", name);
        name = ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"CalApproveBillTpl_28", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("company.name", name);
        name = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"CalApproveBillTpl_29", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("department.name", name);
        name = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"CalApproveBillTpl_30", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("position.name", name);
        name = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"CalApproveBillTpl_31", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("job.name", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"CalApproveBillTpl_32", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("laborreltype.name", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u72b6\u6001", (String)"CalApproveBillTpl_33", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("laborrelstatus.name", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1", (String)"CalApproveBillTpl_37", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.number", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"CalApproveBillTpl_38", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.payrollgroup.name", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"CalApproveBillTpl_40", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrolldate", name);
        name = ResManager.loadKDString((String)"\u6838\u7b97\u9891\u5ea6", (String)"CalApproveBillTpl_42", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.calfrequency.name", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u65e5\u671f", (String)"CalApproveBillTpl_43", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.STARTDATE", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u65e5\u671f", (String)"CalApproveBillTpl_44", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.ENDDATE", name);
        name = ResManager.loadKDString((String)"\u9884\u8ba1\u652f\u4ed8\u65e5\u671f", (String)"CalApproveBillTpl_45", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("caltask.paydate", name);
        name = ResManager.loadKDString((String)"\u5b9e\u53d1\u9879\u76ee", (String)"CalApproveBillTpl_46", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryitem.name", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"CalApproveBillTpl_63", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paycurrency.name", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"CalApproveBillTpl_49", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payamount", name);
        name = ResManager.loadKDString((String)"\u6838\u7b97\u5e01\u79cd", (String)"CalApproveBillTpl_64", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("calcurrency.name", name);
        name = ResManager.loadKDString((String)"\u6838\u7b97\u91d1\u989d", (String)"CalApproveBillTpl_52", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("calamount", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u5f62\u5f0f", (String)"CalApproveBillTpl_56", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paytype.name", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53", (String)"CalApproveBillTpl_57", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paysubjecthis.name", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7", (String)"CalApproveBillTpl_59", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpayorg.name", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"CalApproveBillTpl_60", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpayaccount", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c", (String)"CalApproveBillTpl_61", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpaybank.name", name);
        return filedNameLangMap;
    }

    public static Map<String, String> getPayDetailFieldNameMap() {
        LinkedHashMap<String, String> filedNameLangMap = new LinkedHashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTpl_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "salaryfilehis.person.name");
        name = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalApproveBillTpl_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "salaryfilehis.employee.empnumber");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"CalApproveBillTpl_24", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "salaryfilehis.number");
        name = ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7", (String)"CalApproveBillTpl_25", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "org.name");
        name = ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"CalApproveBillTpl_26", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "adminorg.name");
        name = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4", (String)"CalApproveBillTpl_27", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "empgroup.name");
        name = ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"CalApproveBillTpl_28", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "company.name");
        name = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"CalApproveBillTpl_29", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "department.name");
        name = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"CalApproveBillTpl_30", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "position.name");
        name = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"CalApproveBillTpl_31", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "job.name");
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"CalApproveBillTpl_32", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "laborreltype.name");
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u72b6\u6001", (String)"CalApproveBillTpl_33", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "laborrelstatus.name");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1", (String)"CalApproveBillTpl_37", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.number");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"CalApproveBillTpl_38", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.payrollgroup.name");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"CalApproveBillTpl_40", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "payrolldate");
        name = ResManager.loadKDString((String)"\u6838\u7b97\u9891\u5ea6", (String)"CalApproveBillTpl_42", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.calfrequency.name");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u65e5\u671f", (String)"CalApproveBillTpl_43", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.STARTDATE");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u65e5\u671f", (String)"CalApproveBillTpl_44", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.ENDDATE");
        name = ResManager.loadKDString((String)"\u9884\u8ba1\u652f\u4ed8\u65e5\u671f", (String)"CalApproveBillTpl_45", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "caltask.paydate");
        name = ResManager.loadKDString((String)"\u5b9e\u53d1\u9879\u76ee", (String)"CalApproveBillTpl_46", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "salaryitem.name");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"CalApproveBillTpl_63", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paycurrency.name");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"CalApproveBillTpl_49", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "payamount");
        name = ResManager.loadKDString((String)"\u6838\u7b97\u5e01\u79cd", (String)"CalApproveBillTpl_64", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "calcurrency.name");
        name = ResManager.loadKDString((String)"\u6838\u7b97\u91d1\u989d", (String)"CalApproveBillTpl_52", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "calamount");
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u5f62\u5f0f", (String)"CalApproveBillTpl_56", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paytype.name");
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53", (String)"CalApproveBillTpl_57", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paysubjecthis.name");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7", (String)"CalApproveBillTpl_59", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpayorg.name");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"CalApproveBillTpl_60", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpayaccount");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c", (String)"CalApproveBillTpl_61", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpaybank.name");
        return filedNameLangMap;
    }

    public static void addPayDetailColumn(IFormView view, TreeView tree, String entryentityname) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryentityname);
        List selectedNodesList = tree.getTreeState().getSelectedNodes();
        ArrayList resultNodesList = new ArrayList(selectedNodesList);
        int selectSize = resultNodesList.size();
        if (selectSize == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"CalApproveBillTpl_62", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        int count = model.getEntryRowCount(entryentityname);
        HashMap<String, String> fieldNameMap = new HashMap<String, String>(16);
        for (Object dynamicObject : entryEntity) {
            String fieldName = dynamicObject.getString("fieldname");
            fieldNameMap.put(fieldName, "1");
        }
        int newSize = 0;
        for (Map selectedNodes : resultNodesList) {
            String fieldName = (String)selectedNodes.get("text");
            if (fieldNameMap.containsKey(fieldName)) continue;
            ++newSize;
        }
        if (newSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow(entryentityname, newSize);
        int tag = count;
        for (Map selectedNodes : resultNodesList) {
            String fieldName = (String)selectedNodes.get("text");
            if (fieldNameMap.containsKey(fieldName)) continue;
            view.getModel().setValue("fieldname", (Object)fieldName, tag);
            ++tag;
        }
        view.sendFormAction(view);
    }

    public static void assembleData(DynamicObject data) {
        DynamicObjectCollection scheneEntry = data.getDynamicObjectCollection("schemeentryentity");
        HashMap<Long, Long> schemeBoIdMap = new HashMap<Long, Long>();
        for (Object dynamicObject : scheneEntry) {
            Long schemeId = dynamicObject.getLong("id");
            Long schemeBoId = dynamicObject.getLong("entryboid3");
            schemeBoIdMap.put(schemeBoId, schemeId);
        }
        DynamicObjectCollection defaultRuleEntry = data.getDynamicObjectCollection("defaultruleentity");
        for (DynamicObject dynamicObject : defaultRuleEntry) {
            Long defaultschemeentryboid = dynamicObject.getLong("defaultschemeentryboid");
            Long schemeId = (Long)schemeBoIdMap.get(defaultschemeentryboid);
            dynamicObject.set("defaultschemeentry", (Object)schemeId);
        }
        DynamicObjectCollection specialRuleEntry = data.getDynamicObjectCollection("specialentryentity");
        for (DynamicObject dynamicObject : specialRuleEntry) {
            DynamicObjectCollection apvSpecialRuleEntry = dynamicObject.getDynamicObjectCollection("approvespecialruleentity");
            for (DynamicObject object : apvSpecialRuleEntry) {
                Long defaultschemeentryboid = object.getLong("apvspecialschentryboid");
                Long schemeId = (Long)schemeBoIdMap.get(defaultschemeentryboid);
                object.set("apvspecialschentry", (Object)schemeId);
            }
            DynamicObjectCollection agentSpecialRuleEntry = dynamicObject.getDynamicObjectCollection("agentspecialruleentity");
            for (DynamicObject object : agentSpecialRuleEntry) {
                Long defaultschemeentryboid = object.getLong("agespecialschentryboid");
                Long schemeId = (Long)schemeBoIdMap.get(defaultschemeentryboid);
                object.set("agespecialschentry", (Object)schemeId);
            }
        }
    }

    public static Map<String, String> getPaySalaryAccountSpRuleMap() {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_payaccountpersonquery");
        List selectFields = queryEntityType.getSelectFields();
        return selectFields.stream().collect(Collectors.toMap(QuerySelectField::getAlias, QuerySelectField::getDisplayName));
    }

    static {
        defaultValueList.add("defaultschemeentry");
        defaultValueList.add("defaultschemename");
        defaultValueList.add("defaultschemeentryboid");
        approveValueList.add("apvspecialschentry");
        approveValueList.add("apvspecialschename");
        agentValueList.add("agespecialschentry");
        agentValueList.add("agespecialschename");
        entryMultiValueMap.put("defaultruleentity", defaultValueList);
        entryMultiValueMap.put("approvespecialruleentity", approveValueList);
        entryMultiValueMap.put("agentspecialruleentity", agentValueList);
        BIG_DECIMAL_ZERO = BigDecimal.valueOf(0.0);
    }
}

