/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.assignbankcard;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.assignbankcard.AssignBankCardType;
import kd.swc.hsas.business.assignbankcard.MatchBankCardByRuleThread;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCListUtils;

public class MatchBankCardByRuleService {
    private static final Log logger = LogFactory.getLog(MatchBankCardByRuleService.class);
    private static final int batchSize = 500;
    private AssignBankCardType assignBankCardType;

    public MatchBankCardByRuleService(AssignBankCardType assignBankCardType) {
        this.assignBankCardType = assignBankCardType;
    }

    public AssignBankCardType matchBankCardByRule() {
        List<AssignBankCardDTO> detailCardMatchByRuleList = this.assignBankCardType.getDetailCardMatchByRule();
        List dtoSplits = SWCListUtils.split(detailCardMatchByRuleList, (int)500);
        CountDownLatch countDownLatch = new CountDownLatch(dtoSplits.size());
        RequestContext requestContext = RequestContext.get();
        dtoSplits.forEach(dtoSplit -> {
            MatchBankCardByRuleThread matchBankCardByRuleThread = new MatchBankCardByRuleThread(requestContext, countDownLatch, (List<AssignBankCardDTO>)dtoSplit, this.assignBankCardType);
            SWCThreadPoolFactory.getBankcardMatchThreadPool().execute((Runnable)matchBankCardByRuleThread);
        });
        try {
            boolean success = countDownLatch.await(5 * dtoSplits.size(), TimeUnit.SECONDS);
            if (success) {
                logger.info("All details match success.");
            } else {
                logger.info("Some details have error.");
            }
        }
        catch (InterruptedException e) {
            logger.error("Details match error:", (Throwable)e);
        }
        return this.assignBankCardType;
    }
}

