/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.assignbankcard;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PaySalaryDTO;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.common.util.GeneralFilterCompareService;

public class MatchBankCardByRuleStrategy {
    private static final Log logger = LogFactory.getLog(MatchBankCardByRuleStrategy.class);

    public boolean matchBankCard(AssignBankCardDTO assignBankCardDTO) {
        DynamicObject payDetail = assignBankCardDTO.getPayDetail();
        if (payDetail == null) {
            logger.info("Paydetail Null Pointer Exception\uff1a");
            return false;
        }
        Long payDetailId = payDetail.getLong("id");
        DynamicObject payRule = assignBankCardDTO.getPayRule();
        if (payRule == null) {
            logger.info("PayRule Null Pointer Exception,paydetail Id\uff1a", (Object)payDetailId);
            return false;
        }
        PersonRangeDTO personRange = assignBankCardDTO.getPersonRange();
        Integer seq = assignBankCardDTO.getSeq();
        if (seq == null || seq == 0) {
            logger.info("Seq Null Pointer Exception,paydetail Id:", (Object)payDetailId);
            return false;
        }
        List<PaySalaryDTO> matchRuleList = this.matchRule(payRule, personRange);
        if (matchRuleList == null || matchRuleList.isEmpty()) {
            logger.info("Can't match rule,paydetail Id\uff1a", (Object)payDetailId);
            return false;
        }
        PaySalaryDTO matchRule = matchRuleList.get(seq - 1);
        Long payCategoryId = matchRule.getPayCategoryId();
        Long relationId = matchRule.getPayrollacRelationId();
        Long bankPurposeId = matchRule.getBankPurposeId();
        Long perBankCardId = 0L;
        Long bankCardId = 0L;
        if (PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payCategoryId)) {
            List<DynamicObject> perBankCardList = assignBankCardDTO.getPerBankCardList();
            HashMap perBankCardMap = CollectionUtils.isNotEmpty(perBankCardList) ? perBankCardList.stream().collect(Collectors.toMap(perBankCard -> perBankCard.getLong("sourcevid"), perBankCard -> perBankCard, (o1, o2) -> o1)) : new HashMap(16);
            Set<Long> perBankCardSet = this.matchPerBankCard(payDetailId, bankPurposeId, relationId, perBankCardList);
            if (perBankCardSet == null || perBankCardSet.isEmpty()) {
                logger.info("Person has no bank card match:", (Object)payDetailId);
                return false;
            }
            if (perBankCardSet.size() > 1) {
                logger.info("Person has more than one bank card match:", (Object)payDetailId);
                return false;
            }
            perBankCardId = perBankCardSet.iterator().next();
            DynamicObject perBankCard2 = (DynamicObject)perBankCardMap.get(perBankCardId);
            if (perBankCard2 != null) {
                bankCardId = perBankCard2.getLong("bankdeposit.id");
            }
        }
        assignBankCardDTO.setChosenPerBankCard(perBankCardId);
        assignBankCardDTO.setChosenBankId(bankCardId);
        return true;
    }

    private List<PaySalaryDTO> matchRule(DynamicObject payRule, PersonRangeDTO personRange) {
        DynamicObjectCollection specialEntity = payRule.getDynamicObjectCollection("specialentryentity");
        if (specialEntity.isEmpty() || personRange == null) {
            DynamicObjectCollection defaultRule = payRule.getDynamicObjectCollection("opentryentity");
            return PaySalarySettingHelper.createDefaultRuleData(defaultRule);
        }
        GeneralFilterCompareService service = new GeneralFilterCompareService();
        DynamicObject matchRule = specialEntity.stream().filter(object -> service.isMatch(object.getString("rulecontent"), personRange.getDtoNameLangMap())).findFirst().orElse(null);
        if (matchRule != null) {
            DynamicObjectCollection specialRule = matchRule.getDynamicObjectCollection("subentryentity");
            return PaySalarySettingHelper.createSpecialRuleData(specialRule);
        }
        return null;
    }

    private Set<Long> matchPerBankCard(Long payDetailId, Long bankPurposeId, Long relationId, List<DynamicObject> perBankCardList) {
        if (perBankCardList == null || perBankCardList.size() == 0) {
            logger.info("Person Has No Bank Card Exception,paydetail Id is:", (Object)payDetailId);
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        return perBankCardList.stream().filter(card -> {
            Long bankRelationId = card.getLong("accountrelation.id");
            Set bankPurposeIdSet = card.getDynamicObjectCollection("cardpurpose").stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toSet());
            return !(bankPurposeId != 0L && !bankPurposeIdSet.contains(bankPurposeId) || relationId != 0L && !bankRelationId.equals(relationId));
        }).map(card -> card.getLong("sourcevid")).collect(Collectors.toSet());
    }
}

