/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.attbizdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.attbizdata.AttBizDataListHelper;
import kd.swc.hsas.business.attintegrate.IntegrateState;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.AttDataTypeEnum;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AttBizDataServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(AttBizDataServiceHelper.class);
    public static final String LOCK_KEY_TEMPLATE = "attBizDataRecord_{0}_{1}";
    private static final String ATTITEMTYPE_DETAIL = "0";

    public static Map<String, Object> saveAttBizData(List<Map<String, Object>> params, boolean relateByAttFileId, String attDataType) {
        if (CollectionUtils.isEmpty(params)) {
            return new HashMap<String, Object>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_depemp");
        HashSet<Long> attBizItemIdSet = new HashSet<Long>(params.size());
        HashSet<Long> depEmpIdSet = new HashSet<Long>(params.size());
        for (Map<String, Object> param : params) {
            attBizItemIdSet.add((Long)param.get("attbizitem"));
            depEmpIdSet.add((Long)param.get("depemp"));
        }
        DynamicObjectCollection depEmps = helper.queryOriginalCollection("id,adminorg.id", new QFilter[]{new QFilter("id", "in", depEmpIdSet)});
        Map<Long, DynamicObject> depEmpMap = depEmps.stream().collect(Collectors.toMap(depEmp -> depEmp.getLong("id"), depEmp -> depEmp));
        helper.setEntityName("hsbs_attbizitem");
        QFilter filter = new QFilter("id", "in", attBizItemIdSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection attBizItems = helper.queryOriginalCollection("id,name,scalelimit,minvalue,isminvalnull,maxvalue,ismaxvalnull", new QFilter[]{filter});
        Map<Long, DynamicObject> attBizItemMap = attBizItems.stream().collect(Collectors.toMap(attBizItem -> attBizItem.getLong("id"), attBizItem -> attBizItem));
        HashSet<Long> failAttFileIdSet = new HashSet<Long>(params.size());
        HashSet<String> failUniqueCodeSet = new HashSet<String>(params.size());
        ArrayList failInfoList = new ArrayList(params.size());
        for (Map<String, Object> param : params) {
            DynamicObject depEmp2 = depEmpMap.get(param.getOrDefault("depemp", 0L));
            DynamicObject attBizItem2 = attBizItemMap.get(param.getOrDefault("attbizitem", 0L));
            HashMap<String, Object> failInfo = new HashMap<String, Object>(2);
            failInfo.put("bizuniquecode", param.get("bizuniquecode"));
            Long attFileId = (Long)param.get("attfileid");
            String uniqueCode = (String)param.get("bizuniquecode");
            failInfo.put("uniqueCode", uniqueCode);
            if (depEmp2 == null) {
                failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6001.getCode());
                failInfoList.add(failInfo);
                failAttFileIdSet.add(attFileId);
                failUniqueCodeSet.add(uniqueCode);
                continue;
            }
            if (attBizItem2 == null) {
                failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6002.getCode());
                failInfoList.add(failInfo);
                failAttFileIdSet.add(attFileId);
                failUniqueCodeSet.add(uniqueCode);
                continue;
            }
            if (!relateByAttFileId || !failAttFileIdSet.contains(attFileId)) continue;
            failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_3060.getCode());
            failInfoList.add(failInfo);
            failUniqueCodeSet.add(uniqueCode);
        }
        String bizdataEntityKey = AttDataTypeEnum.SUM.getCode().equals(attDataType) ? "hsas_attbizdatasummary" : "hsas_attbizdatadetail";
        DynamicObjectCollection newAttBizDataCollection = new DynamicObjectCollection();
        HashSet<String> successUniqueCodeSet = new HashSet<String>(params.size());
        long[] ids = DB.genLongIds((String)bizdataEntityKey, (int)params.size());
        MainEntityType attBizDataType = EntityMetadataCache.getDataEntityType((String)(AttDataTypeEnum.SUM.getCode().equals(attDataType) ? "hsas_attbizdatasummary" : "hsas_attbizdatadetail"));
        int idIndex = 0;
        Date date = new Date();
        for (Map<String, Object> param : params) {
            Long attFileId = (Long)param.get("attfileid");
            String uniqueCode = (String)param.get("bizuniquecode");
            if (failUniqueCodeSet.contains(uniqueCode)) continue;
            if (relateByAttFileId && failAttFileIdSet.contains(attFileId)) {
                HashMap<String, String> failInfo = new HashMap<String, String>(2);
                failInfo.put("uniqueCode", uniqueCode);
                failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_3060.getCode());
                failInfoList.add(failInfo);
                continue;
            }
            successUniqueCodeSet.add(uniqueCode);
            DynamicObject newAttBizData = (DynamicObject)attBizDataType.createInstance();
            newAttBizData.set("id", (Object)ids[idIndex++]);
            newAttBizData.set("batchnumber", param.get("batchnumber"));
            newAttBizData.set("bizuniquecode", param.get("bizuniquecode"));
            newAttBizData.set("identifynumber", param.get("identifynumber"));
            newAttBizData.set("employee", param.get("employee"));
            newAttBizData.set("depemp", param.get("depemp"));
            newAttBizData.set("person", param.get("person"));
            newAttBizData.set("adminorg", param.get("adminorg"));
            newAttBizData.set("attbizitem", param.get("attbizitem"));
            newAttBizData.set("decimalvalue", param.getOrDefault("decimalvalue", BigDecimal.ZERO));
            newAttBizData.set("textvalue", param.getOrDefault("textvalue", " "));
            newAttBizData.set("amountvalue", param.getOrDefault("amountvalue", BigDecimal.ZERO));
            newAttBizData.set("currency", param.get("currency"));
            newAttBizData.set("description", param.get("description"));
            newAttBizData.set("datevalue", param.get("datevalue"));
            newAttBizData.set("attstartdate", param.get("attstartdate"));
            newAttBizData.set("attenddate", param.get("attenddate"));
            newAttBizData.set("datasource", param.getOrDefault("datasource", "1"));
            newAttBizData.set("srcsystem", param.getOrDefault("srcsystem", ATTITEMTYPE_DETAIL));
            newAttBizData.set("groupid", (Object)String.valueOf(attFileId));
            Long creator = (Long)param.get("creator");
            if (creator == null) {
                creator = RequestContext.get().getCurrUserId();
            }
            newAttBizData.set("creator", (Object)creator);
            newAttBizData.set("modifier", (Object)creator);
            newAttBizData.set("createtime", (Object)date);
            newAttBizData.set("modifytime", (Object)date);
            newAttBizData.set("billstatus", param.getOrDefault("billstatus", "A"));
            newAttBizData.set("auditstatus", param.getOrDefault("auditstatus", "A"));
            newAttBizDataCollection.add((Object)newAttBizData);
        }
        if (!CollectionUtils.isEmpty((Collection)newAttBizDataCollection)) {
            DynamicObject[] newAttBizDatas = (DynamicObject[])newAttBizDataCollection.toArray((Object[])new DynamicObject[0]);
            new SWCDataServiceHelper(bizdataEntityKey).save(newAttBizDatas);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("successUniqueCodeSet", successUniqueCodeSet);
        result.put("failInfoList", failInfoList);
        return result;
    }

    public static Map<String, Object> deleteAttBizDataByGroupId(String batchnumber, List<String> groupIdList, String attDataType, QFilter dateFilter) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (CollectionUtils.isEmpty(groupIdList)) {
            result.put("successIdentifyNumberList", new ArrayList(0));
            result.put("failInfoList", new ArrayList(0));
            result.put("identifyNumberToAttBizDataMap", new HashMap(0));
            return result;
        }
        ArrayList<String> successIdentifyNumberList = new ArrayList<String>(groupIdList.size());
        ArrayList failInfoList = new ArrayList(groupIdList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper(AttDataTypeEnum.SUM.getCode().equals(attDataType) ? "hsas_attbizdatasummary" : "hsas_attbizdatadetail");
        QFilter filter = new QFilter("groupid", "in", groupIdList);
        if (dateFilter != null) {
            filter.and(dateFilter);
        }
        filter.and(new QFilter("batchnumber", "=", (Object)batchnumber));
        DynamicObjectCollection attBizDatas = helper.queryOriginalCollection("id,attstartdate,attenddate,groupid,identifynumber,usagecount,batchnumber,depemp.id,attbizitem.id,textvalue, nocounttimes", new QFilter[]{filter});
        Map<String, List<DynamicObject>> attFileToAttBizDataMap = attBizDatas.stream().collect(Collectors.groupingBy(attBizData -> (String)attBizData.get("groupid")));
        ArrayList<Long> successDataIdList = new ArrayList<Long>(attBizDatas.size());
        for (Map.Entry<String, List<DynamicObject>> entry : attFileToAttBizDataMap.entrySet()) {
            int count;
            int noCntUsageCount;
            int usageCount;
            boolean isFail = false;
            for (DynamicObject attBizData2 : entry.getValue()) {
                usageCount = attBizData2.getInt("usagecount");
                count = usageCount + (noCntUsageCount = attBizData2.getInt("nocounttimes"));
                if (count <= 0) continue;
                isFail = true;
                break;
            }
            for (DynamicObject attBizData2 : entry.getValue()) {
                usageCount = attBizData2.getInt("usagecount");
                noCntUsageCount = attBizData2.getInt("nocounttimes");
                count = usageCount + noCntUsageCount;
                HashMap<String, String> failInfo = new HashMap<String, String>(2);
                String identifyNumber = attBizData2.getString("identifynumber");
                failInfo.put("identifynumber", identifyNumber);
                if (count > 0) {
                    failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6013.getCode());
                    failInfoList.add(failInfo);
                    continue;
                }
                if (isFail) {
                    failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6015.getCode());
                    failInfoList.add(failInfo);
                    continue;
                }
                successDataIdList.add(attBizData2.getLong("id"));
                successIdentifyNumberList.add(identifyNumber);
            }
        }
        HashMap<String, DynamicObject> identifyNumberToAttBizDataMap = new HashMap<String, DynamicObject>(attBizDatas.size());
        for (DynamicObject attBizData3 : attBizDatas) {
            identifyNumberToAttBizDataMap.put(attBizData3.getString("identifynumber"), attBizData3);
        }
        helper.delete(successDataIdList.toArray());
        result.put("successIdentifyNumberList", successIdentifyNumberList);
        result.put("failInfoList", failInfoList);
        result.put("identifyNumberToAttBizDataMap", identifyNumberToAttBizDataMap);
        return result;
    }

    public static Map<String, Object> deleteAttBizData(Set<Long> attBizDataIdSet, boolean relateByAttFileId, String attDataType) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (CollectionUtils.isEmpty(attBizDataIdSet)) {
            result.put("successIdentifyNumberList", new ArrayList(0));
            result.put("failInfoList", new ArrayList(0));
            return result;
        }
        ArrayList<String> successIdentifyNumberList = new ArrayList<String>(attBizDataIdSet.size());
        ArrayList failInfoList = new ArrayList(attBizDataIdSet.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper(AttDataTypeEnum.SUM.getCode().equals(attDataType) ? "hsas_attbizdatasummary" : "hsas_attbizdatadetail");
        DynamicObjectCollection attBizDatas = helper.queryOriginalCollection("id,attstartdate,attenddate,groupid,identifynumber,usagecount", new QFilter[]{new QFilter("id", "in", attBizDataIdSet)});
        Map<String, List<DynamicObject>> attFileToAttBizDataMap = attBizDatas.stream().collect(Collectors.groupingBy(attBizData -> (String)attBizData.get("groupid")));
        ArrayList<Long> successDataIdList = new ArrayList<Long>(attBizDatas.size());
        for (Map.Entry<String, List<DynamicObject>> entry : attFileToAttBizDataMap.entrySet()) {
            int usageCount;
            boolean isFail = false;
            if (relateByAttFileId) {
                for (DynamicObject attBizData2 : entry.getValue()) {
                    usageCount = attBizData2.getInt("usagecount");
                    if (usageCount <= 0) continue;
                    isFail = true;
                    break;
                }
            }
            for (DynamicObject attBizData2 : entry.getValue()) {
                usageCount = attBizData2.getInt("usagecount");
                HashMap<String, String> failInfo = new HashMap<String, String>(2);
                String identifyNumber = attBizData2.getString("identifynumber");
                failInfo.put("identifynumber", identifyNumber);
                if (usageCount > 0) {
                    failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6013.getCode());
                    failInfoList.add(failInfo);
                    continue;
                }
                if (isFail) {
                    failInfo.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_6015.getCode());
                    failInfoList.add(failInfo);
                    continue;
                }
                successDataIdList.add(attBizData2.getLong("id"));
                successIdentifyNumberList.add(identifyNumber);
            }
        }
        helper.delete(successDataIdList.toArray());
        result.put("successIdentifyNumberList", successIdentifyNumberList);
        result.put("failInfoList", failInfoList);
        return result;
    }

    public static boolean checkBigDecimalValue(IntegrateState itemState, DynamicObject attBizItem, BigDecimal value) {
        boolean checkResult;
        BigDecimal minValue = attBizItem.getBigDecimal("minvalue");
        BigDecimal maxValue = attBizItem.getBigDecimal("maxvalue");
        boolean isMinValNull = attBizItem.getBoolean("isminvalnull");
        boolean isMaxValNull = attBizItem.getBoolean("ismaxvalnull");
        if (isMinValNull && isMaxValNull) {
            checkResult = true;
        } else if (isMinValNull) {
            checkResult = maxValue.compareTo(value) >= 0;
        } else if (isMaxValNull) {
            checkResult = minValue.compareTo(value) <= 0;
        } else {
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
        }
        if (!checkResult) {
            itemState.setCheckPass(false);
            itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6003.getCode());
            return false;
        }
        int scalelimit = attBizItem.getInt("scalelimit");
        int scale = value.scale();
        if (scale > scalelimit) {
            itemState.setCheckPass(false);
            itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6007.getCode());
            return false;
        }
        return true;
    }

    public static Map<String, String> getExistAttBizDataInfo(SWCDataServiceHelper helper, Set<Long> depEmpIdSet, Set<Long> attBizItemIdSet, Set<Date> attStartDateSet, Set<Date> attEndDateSet) {
        QFilter filter = new QFilter("depemp", "in", depEmpIdSet);
        filter.and(new QFilter("attbizitem", "in", attBizItemIdSet));
        filter.and(new QFilter("attstartdate", "in", attStartDateSet));
        filter.and(new QFilter("attenddate", "in", attEndDateSet));
        filter.and(new QFilter("auditstatus", "!=", (Object)"F"));
        DynamicObjectCollection attBizDatas = helper.queryOriginalCollection("depemp.id,attbizitem.id,attstartdate,attenddate,identifynumber", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)attBizDatas)) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, String> attBizDataKeyMap = new HashMap<String, String>(attBizDatas.size() * 2);
        for (DynamicObject attBizData : attBizDatas) {
            String attBizDataKey = AttBizDataServiceHelper.getAttBizDataKey(attBizData.getDate("attstartdate"), attBizData.getDate("attenddate"), attBizData.getLong("depemp.id"), attBizData.getLong("attbizitem.id"));
            attBizDataKeyMap.put(attBizDataKey, attBizData.getString("identifynumber"));
        }
        return attBizDataKeyMap;
    }

    public static String getAttBizDataKey(Date attStartDate, Date attEndDate, Long depEmpId, Long attBizItemId) {
        if (attStartDate == null || attEndDate == null || depEmpId == null || attBizItemId == null) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder();
        try {
            attStartDate = SWCDateTimeUtils.formatDateToDate((Date)attStartDate, (String)"yyyy-MM-dd");
            attEndDate = SWCDateTimeUtils.formatDateToDate((Date)attEndDate, (String)"yyyy-MM-dd");
        }
        catch (Exception exception) {
            LOGGER.error("format date error", (Throwable)exception);
        }
        keyBuilder.append(SWCDateTimeUtils.format((Date)attStartDate, (String)"yyyy-MM-dd"));
        keyBuilder.append('_');
        keyBuilder.append(SWCDateTimeUtils.format((Date)attEndDate, (String)"yyyy-MM-dd"));
        keyBuilder.append('_');
        keyBuilder.append(depEmpId);
        keyBuilder.append('_');
        keyBuilder.append(attBizItemId);
        return keyBuilder.toString();
    }

    public static DynamicObjectCollection queryAttBizItem(Set<Long> attBizItemIdSet, String attItemType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_attbizitem");
        QFilter qFilter = new QFilter("id", "in", attBizItemIdSet);
        qFilter.and("attitemtype", "=", (Object)attItemType);
        AttBizDataListHelper attBizDataListHelper = new AttBizDataListHelper();
        QFilter permissionFilter = attItemType.equals(ATTITEMTYPE_DETAIL) ? attBizDataListHelper.getAttBizDataBizItemFilter("hsas_attbizdatadetail", "4730fc9f000003ae") : attBizDataListHelper.getAttBizDataBizItemFilter("hsas_attbizdatasummary", "4730fc9f000003ae");
        if (permissionFilter != null) {
            qFilter.and(permissionFilter);
        }
        return helper.queryOriginalCollection("id", new QFilter[]{qFilter});
    }
}

