/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.attintegrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hsas.business.attbizdata.AttBizDataServiceHelper;
import kd.swc.hsas.business.attintegrate.enums.OperationType;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.AttDataTypeEnum;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataSrcSystemEnum;
import kd.swc.hsbp.common.enums.IntegrationProcessStateEnum;
import kd.swc.hsbp.common.enums.IntegrationStatusEnum;
import kd.swc.hsbp.common.enums.ProcessResultEnum;

public class AttIntegWithdrawHelper {
    private static final Log log = LogFactory.getLog(AttIntegWithdrawHelper.class);
    private static final String VERSION = "version";
    private static final String ATT_FILE = "attfile";

    public static Map<String, Object> batchWithdraw(Map<String, Object> params) {
        Map<String, Object> result;
        if (params == null || params.isEmpty()) {
            return new HashMap<String, Object>();
        }
        log.info("AttIntegWithdrawHelper#batchWithdraw \u4f20\u5165\u53c2\u6570\uff1a{}", params);
        String version = (String)params.get(VERSION);
        List attFileList = (List)params.get(ATT_FILE);
        String sessionId = (String)params.get("sessionid");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegsumlog");
        QFilter filter = new QFilter("operationtype", "=", (Object)OperationType.PUSH.getCode());
        filter.and(new QFilter("batchversionid", "=", (Object)version));
        DynamicObject sumLog = helper.queryOriginalOne("storepage,attdatatype,earliestattstartdate,lastattstartdate,earliestattenddate,lastattenddate", new QFilter[]{filter});
        String attDataType = sumLog.getString("attdatatype");
        if (!"1".equals(sumLog.get("storepage"))) {
            result = AttIntegWithdrawHelper.doBatchWithdraw(version, attFileList, "hsas_nonrecurbizdata", attDataType, sessionId, null);
        } else {
            Date earliestStartDate = sumLog.getDate("earliestattstartdate");
            Date lastStartDate = sumLog.getDate("lastattstartdate");
            Date earliestEndDate = sumLog.getDate("earliestattenddate");
            Date lastEndDate = sumLog.getDate("lastattenddate");
            QFilter dateFilter = null;
            if (earliestStartDate != null && lastStartDate != null && earliestEndDate != null && lastEndDate != null) {
                dateFilter = new QFilter("attstartdate", ">=", (Object)earliestStartDate);
                dateFilter.and(new QFilter("attstartdate", "<=", (Object)lastStartDate));
                dateFilter.and(new QFilter("attenddate", ">=", (Object)earliestStartDate));
                dateFilter.and(new QFilter("attenddate", "<=", (Object)lastEndDate));
            }
            String bizDataEntityKey = AttDataTypeEnum.DETAIL.getCode().equals(attDataType) ? "hsas_attbizdatadetail" : "hsas_attbizdatasummary";
            result = AttIntegWithdrawHelper.doBatchWithdraw(version, attFileList, bizDataEntityKey, attDataType, sessionId, dateFilter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> doBatchWithdraw(String version, List<Long> attFileList, String bizDataEntityKey, String attDataType, String sessionId, QFilter dateFilter) {
        long summaryLogId;
        ArrayList<String> groupIds = new ArrayList<String>(attFileList.size());
        for (Long attFileId : attFileList) {
            groupIds.add(String.valueOf(attFileId));
        }
        log.info("AttIntegWithdrawHelper#batchWithdraw groupIds \uff1a{}", groupIds);
        ArrayList successfileid = new ArrayList(groupIds.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegsumlog");
        DynamicObject sumLog = helper.queryOriginalOne("id,sessionid", new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)});
        if (sumLog == null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hsas_attintegsumlog");
            summaryLogId = AttIntegWithdrawHelper.genLongId((EntityType)entityType);
            log.info("\u6c47\u603b\u65e5\u5fd7id \uff1a{}", (Object)summaryLogId);
            String storePage = "hsas_nonrecurbizdata".equals(bizDataEntityKey) ? "0" : "1";
            AttIntegWithdrawHelper.initSummaryLog(summaryLogId, version, storePage, attDataType, sessionId);
        } else {
            summaryLogId = sumLog.getLong("id");
        }
        int dataLimit = AttDataTypeEnum.DETAIL.getCode().equals(attDataType) ? 200 : 1000;
        int index = 0;
        ArrayList<String> newList = new ArrayList<String>(dataLimit);
        ArrayList errorInfo = new ArrayList(groupIds.size());
        for (String groupId : groupIds) {
            newList.add(groupId);
            if (dataLimit != newList.size() && ++index != groupIds.size()) continue;
            TXHandle txHandle = TX.required();
            try {
                Map<String, Object> result = "hsas_nonrecurbizdata".equals(bizDataEntityKey) ? AttIntegWithdrawHelper.withdrawData(summaryLogId, newList, version) : AttIntegWithdrawHelper.withdrawDataForAttBizData(bizDataEntityKey, summaryLogId, newList, version, dateFilter, attDataType);
                List successResult = (List)result.get("successfileid");
                List failResult = (List)result.get("errorinfo");
                if (!CollectionUtils.isEmpty((Collection)successResult)) {
                    successfileid.addAll(successResult);
                }
                if (CollectionUtils.isEmpty((Collection)failResult)) continue;
                errorInfo.addAll(failResult);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.info("withdraw data fail : {}", (Object)e);
            }
            finally {
                txHandle.close();
                newList.clear();
            }
        }
        DynamicObject summaryLogData = AttIntegWithdrawHelper.querySummaryLogData(summaryLogId);
        if (summaryLogData != null) {
            Date createTime = summaryLogData.getDate("createtime");
            Date endTime = new Date();
            long timeConsume = endTime.getTime() - createTime.getTime();
            summaryLogData.set("endtime", (Object)endTime);
            summaryLogData.set("timeconsume", (Object)(timeConsume / 1000L));
            summaryLogData.set("integrationstatus", (Object)IntegrationStatusEnum.COMPLETE.getCode());
            AttIntegWithdrawHelper.updateSummaryLogData(summaryLogData);
        }
        HashMap<String, Object> summaryResult = new HashMap<String, Object>(2);
        List successfileList = successfileid.stream().distinct().map(fid -> Long.parseLong(fid)).collect(Collectors.toList());
        summaryResult.put("success", Boolean.TRUE);
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>(2);
        summaryResult.put("data", data);
        data.put("successfileids", successfileList);
        data.put("errorinfo", errorInfo);
        log.info("\u64a4\u56de\u7ed3\u679c\u96c6\u5408 \uff1a{}", summaryResult);
        return summaryResult;
    }

    private static void initSummaryLog(Long summaryLogId, String version, String storePage, String attDataType, String sessionId) {
        log.info("initSummaryLog param: summaryLogId={} ,version={} ,batchVersionId ={}", (Object)summaryLogId, (Object)version);
        DynamicObject summargLogDyObj = BusinessDataServiceHelper.newDynamicObject((String)"hsas_attintegsumlog");
        summargLogDyObj.set("id", (Object)summaryLogId);
        String number = CodeRuleHelper.getNumber((DynamicObject)summargLogDyObj, null);
        long userId = RequestContext.get().getCurrUserId();
        summargLogDyObj.set("number", (Object)number);
        summargLogDyObj.set("batchversionid", (Object)version);
        summargLogDyObj.set("frontendsystem", (Object)BizDataSrcSystemEnum.WTC.getCode());
        summargLogDyObj.set("operationtype", (Object)OperationType.WITHDRAW.getCode());
        summargLogDyObj.set("integrationstatus", (Object)IntegrationStatusEnum.RUNNING.getCode());
        summargLogDyObj.set("integrationquantity", (Object)0);
        summargLogDyObj.set("successquantity", (Object)0);
        summargLogDyObj.set("failquantity", (Object)0);
        summargLogDyObj.set("endtime", (Object)new Date());
        summargLogDyObj.set("storepage", (Object)storePage);
        summargLogDyObj.set("attdatatype", (Object)attDataType);
        summargLogDyObj.set("sessionid", (Object)sessionId);
        summargLogDyObj.set("creator", (Object)userId);
        Object result = AttIntegWithdrawHelper.saveSummaryLogData(summargLogDyObj);
        log.info("\u4fdd\u5b58\u6c47\u603b\u65e5\u5fd7\u8fd4\u56de\u7ed3\u679c\u96c6\uff1a{}", (Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)((DynamicObject)result)));
    }

    private static Map<String, Object> withdrawData(long summaryLogId, List<String> groupIds, String batchnumber) {
        log.info("withdrawData param: summaryLogId={} ,groupIds={} ", (Object)summaryLogId, groupIds);
        ArrayList<DynamicObject> withdrawBizDatas = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> noWithdrawBizDatas = new ArrayList<DynamicObject>();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter filter = new QFilter("groupid", "in", groupIds);
        filter.and(new QFilter("batchnumber", "=", (Object)batchnumber));
        DynamicObject[] bizDataList = helper.query("id,groupid,depemp.id,usagecount,bizitem.id,identifynumber,datavalue,bsed,nocounttimes", new QFilter[]{filter});
        Map<String, List<DynamicObject>> bizDataByGroupId = Arrays.stream(bizDataList).collect(Collectors.groupingBy(dy -> dy.getString("groupid")));
        LinkedHashMap<String, String> noWithdrawBizDataMsgs = new LinkedHashMap<String, String>(bizDataByGroupId.size());
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(groupIds.size());
        for (Map.Entry<String, List<DynamicObject>> bizData : bizDataByGroupId.entrySet()) {
            Map<String, String> checkDataResults = AttIntegWithdrawHelper.checkData(bizData.getValue(), errorInfoList);
            log.info("\u6821\u9a8c\u7ed3\u679c\u96c6 \uff1a{}", checkDataResults);
            if (checkDataResults.size() == 0) {
                withdrawBizDatas.addAll((Collection<DynamicObject>)bizData.getValue());
                continue;
            }
            noWithdrawBizDataMsgs.putAll(checkDataResults);
            noWithdrawBizDatas.addAll((Collection<DynamicObject>)bizData.getValue());
        }
        AttIntegWithdrawHelper.saveLog(summaryLogId, withdrawBizDatas, noWithdrawBizDatas, noWithdrawBizDataMsgs, "hsas_nonrecurbizdata");
        Set errorfileid = noWithdrawBizDatas.stream().map(biz -> biz.getString("groupid")).collect(Collectors.toSet());
        ArrayList<String> successfileid = new ArrayList<String>(groupIds.size() - errorfileid.size());
        successfileid.addAll(groupIds);
        successfileid.removeAll(errorfileid);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("successfileid", successfileid);
        result.put("errorinfo", errorInfoList);
        log.info("\u8fd4\u56de\u7ed3\u679c\u96c6\uff0c\u5206\u6279 \uff1a{}", result);
        return result;
    }

    private static void updateSummaryLog(Long summaryLogId, int successQuantity, int failQuantity, int integrationQuantity) {
        DynamicObject summaryLogData = AttIntegWithdrawHelper.querySummaryLogData(summaryLogId);
        if (summaryLogData != null) {
            summaryLogData.set("successquantity", (Object)(successQuantity += summaryLogData.getInt("successquantity")));
            summaryLogData.set("failquantity", (Object)(failQuantity += summaryLogData.getInt("failquantity")));
            summaryLogData.set("integrationquantity", (Object)(integrationQuantity += summaryLogData.getInt("integrationquantity")));
            Object result = AttIntegWithdrawHelper.updateSummaryLogData(summaryLogData);
            log.info("\u66f4\u65b0\u6c47\u603b\u65e5\u5fd7\u8fd4\u56de\u7ed3\u679c\u96c6\uff1a{}", (Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)((DynamicObject)result)));
        }
    }

    private static Map<String, Object> withdrawDataForAttBizData(String entityKey, long summaryLogId, List<String> groupIds, String batchnumber, QFilter dateFilter, String attDataType) {
        log.info("withdrawDataForAttBizData param: summaryLogId={} ,groupIds={} ", (Object)summaryLogId, groupIds);
        Map<String, Object> deleteResult = AttBizDataServiceHelper.deleteAttBizDataByGroupId(batchnumber, groupIds, attDataType, dateFilter);
        List successIdentifyNumberList = (List)deleteResult.get("successIdentifyNumberList");
        List failInfoList = (List)deleteResult.get("failInfoList");
        Map identifyNumberToAttBizDataMap = (Map)deleteResult.get("identifyNumberToAttBizDataMap");
        ArrayList<DynamicObject> withdrawAttBizDatas = new ArrayList<DynamicObject>(successIdentifyNumberList.size());
        ArrayList<DynamicObject> noWithdrawAttBizDatas = new ArrayList<DynamicObject>(failInfoList.size());
        HashSet<String> failFileIdSet = new HashSet<String>(failInfoList.size());
        HashMap<String, String> noWithdrawAttBizDataMsgs = new HashMap<String, String>(failInfoList.size());
        for (Object identifyNumber : successIdentifyNumberList) {
            DynamicObject attBizData = (DynamicObject)identifyNumberToAttBizDataMap.get(identifyNumber);
            if (attBizData == null) continue;
            withdrawAttBizDatas.add(attBizData);
        }
        HashMap<String, Set> errorCodeMap = new HashMap<String, Set>(groupIds.size());
        for (Map failInfo : failInfoList) {
            String identifyNumber = (String)failInfo.get("identifynumber");
            DynamicObject dynamicObject = (DynamicObject)identifyNumberToAttBizDataMap.get(identifyNumber);
            if (dynamicObject == null) continue;
            noWithdrawAttBizDatas.add(dynamicObject);
            String groupId = dynamicObject.getString("groupid");
            String reasonCode = (String)failInfo.get("reasonCode");
            failFileIdSet.add(groupId);
            noWithdrawAttBizDataMsgs.put(groupId + dynamicObject.getLong("depemp.id") + dynamicObject.getLong("attbizitem.id"), reasonCode);
            Set errorCodes = errorCodeMap.computeIfAbsent(groupId, key -> new HashSet(16));
            errorCodes.add(reasonCode);
        }
        AttIntegWithdrawHelper.saveLog(summaryLogId, withdrawAttBizDatas, noWithdrawAttBizDatas, noWithdrawAttBizDataMsgs, entityKey);
        ArrayList<String> successFileIdList = new ArrayList<String>(groupIds.size() - failFileIdSet.size());
        successFileIdList.addAll(groupIds);
        successFileIdList.removeAll(failFileIdSet);
        ArrayList errorInfoList = new ArrayList(errorCodeMap.size());
        for (Map.Entry entry : errorCodeMap.entrySet()) {
            HashMap<String, Object> errorInfo = new HashMap<String, Object>(2);
            errorInfo.put("attfileid", Long.valueOf((String)entry.getKey()));
            errorInfo.put("errorcodes", ((Set)entry.getValue()).stream().sorted().collect(Collectors.toList()));
            errorInfoList.add(errorInfo);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("successfileid", successFileIdList);
        result.put("errorinfo", errorInfoList);
        log.info("\u8fd4\u56de\u7ed3\u679c\u96c6\uff0c\u5206\u6279 \uff1a{}", result);
        return result;
    }

    private static void saveLog(Long summaryLog, List<DynamicObject> withdrawBizDatas, List<DynamicObject> noWithdrawBizDatas, Map<String, String> noWithdrawBizDataMsgs, String bizDataEntityKey) {
        Map<String, List<DynamicObject>> withdrawBizDataMap = withdrawBizDatas.stream().collect(Collectors.groupingBy(dy -> dy.getLong("groupid") + "&" + dy.getLong("depemp.id")));
        Map<String, List<DynamicObject>> noWithdrawBizDataMap = noWithdrawBizDatas.stream().collect(Collectors.groupingBy(dy -> dy.getLong("groupid") + "&" + dy.getLong("depemp.id")));
        log.info("\u53ef\u64a4\u56de\u7684\u4e1a\u52a1\u6570\u636e\u96c6\u5408keys -> \uff1a{}", withdrawBizDataMap.keySet());
        log.info("\u4e0d\u53ef\u64a4\u56de\u7684\u4e1a\u52a1\u6570\u636e\u96c6\u5408keys -> \uff1a{}", noWithdrawBizDataMap.keySet());
        int successQuantity = withdrawBizDataMap.size();
        int failQuantity = noWithdrawBizDataMap.size();
        int integrationQuantity = successQuantity + failQuantity;
        AttIntegWithdrawHelper.updateSummaryLog(summaryLog, successQuantity, failQuantity, integrationQuantity);
        if (!withdrawBizDataMap.isEmpty()) {
            AttIntegWithdrawHelper.saveAttIntegDetailLog(summaryLog, withdrawBizDataMap, ProcessResultEnum.SUCCESS.getCode(), null, bizDataEntityKey);
        }
        if (!noWithdrawBizDataMap.isEmpty()) {
            AttIntegWithdrawHelper.saveAttIntegDetailLog(summaryLog, noWithdrawBizDataMap, ProcessResultEnum.FAILURE.getCode(), noWithdrawBizDataMsgs, bizDataEntityKey);
        }
    }

    private static void saveAttIntegDetailLog(Long pkId, Map<String, List<DynamicObject>> bizDataMap, String result, Map<String, String> bizDataCheckDataResults, String bizDataEntityKey) {
        log.info("saveAttIntegDetailLog param: pkId={} ,result={} ", (Object)pkId, (Object)result);
        HashMap<Long, List<DynamicObject>> itemLogMap = new HashMap<Long, List<DynamicObject>>(bizDataMap.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hsas_attintegdetaillog");
        DynamicObjectCollection detailLogColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        for (Map.Entry<String, List<DynamicObject>> bizData : bizDataMap.entrySet()) {
            String bizDataKey = bizData.getKey();
            long id = AttIntegWithdrawHelper.genLongId((EntityType)entityType);
            String[] split = bizDataKey.split("&");
            DynamicObject detailLogDyObj = detailLogColl.addNew();
            detailLogDyObj.set("id", (Object)id);
            detailLogDyObj.set("attintegsumlog", (Object)pkId);
            detailLogDyObj.set(ATT_FILE, (Object)split[0]);
            detailLogDyObj.set("depemp", (Object)split[1]);
            detailLogDyObj.set("processstate", (Object)IntegrationProcessStateEnum.COMPLETE.getCode());
            detailLogDyObj.set("processresult", (Object)result);
            itemLogMap.put(id, bizData.getValue());
        }
        SWCDataServiceHelper detailLogHelper = new SWCDataServiceHelper("hsas_attintegdetaillog");
        detailLogHelper.save(detailLogColl);
        AttIntegWithdrawHelper.saveAttIntegItemLog(itemLogMap, result, bizDataCheckDataResults, bizDataEntityKey, pkId);
    }

    private static void saveAttIntegItemLog(Map<Long, List<DynamicObject>> itemLogMap, String result, Map<String, String> bizDataCheckDataResults, String bizDataEntityKey, Long sumLogId) {
        String itemIdKey;
        String itemKey;
        log.info("saveAttIntegItemLog param: result={} ,bizDataCheckDataResults={} ", (Object)result, bizDataCheckDataResults);
        ArrayList<Long> deleteBizDataIds = new ArrayList<Long>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hsas_attintegitemlog");
        DynamicObjectCollection itemLogColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        if ("hsas_nonrecurbizdata".equals(bizDataEntityKey)) {
            itemKey = "bizitem";
            itemIdKey = "bizitem.id";
        } else {
            itemKey = "attbizitem";
            itemIdKey = "attbizitem.id";
        }
        for (Map.Entry<Long, List<DynamicObject>> itemLog : itemLogMap.entrySet()) {
            List<DynamicObject> bizDataList = itemLog.getValue();
            Long detailLogId = itemLog.getKey();
            for (DynamicObject bizData : bizDataList) {
                if (ProcessResultEnum.FAILURE.getCode().equals(result)) {
                    String bizDataFailStatusCode;
                    DynamicObject itemLogDyObj = itemLogColl.addNew();
                    itemLogDyObj.set("integdetailedlog", (Object)detailLogId);
                    itemLogDyObj.set(itemKey, (Object)bizData.getLong(itemIdKey));
                    itemLogDyObj.set("state", (Object)result);
                    itemLogDyObj.set("tagnumber", (Object)bizData.getString("identifynumber"));
                    itemLogDyObj.set("attintegsumlog", (Object)sumLogId);
                    String onlyNumber = bizData.getString("groupid") + bizData.getLong("depemp.id") + bizData.getLong(itemIdKey);
                    if (bizDataCheckDataResults != null && StringUtils.isNotBlank((CharSequence)(bizDataFailStatusCode = bizDataCheckDataResults.get(onlyNumber)))) {
                        itemLogDyObj.set("reason", (Object)bizDataFailStatusCode);
                    }
                    if ("hsas_nonrecurbizdata".equals(bizDataEntityKey)) {
                        itemLogDyObj.set("bsed", (Object)bizData.getDate("bsed"));
                        itemLogDyObj.set("value", (Object)bizData.getString("datavalue"));
                        continue;
                    }
                    itemLogDyObj.set("attstartdate", (Object)bizData.getDate("attstartdate"));
                    itemLogDyObj.set("attenddate", (Object)bizData.getDate("attenddate"));
                    itemLogDyObj.set("value", (Object)bizData.getString("textvalue"));
                    continue;
                }
                deleteBizDataIds.add(bizData.getLong("id"));
            }
        }
        if (ProcessResultEnum.FAILURE.getCode().equals(result)) {
            SWCDataServiceHelper detailLogHelper = new SWCDataServiceHelper("hsas_attintegitemlog");
            detailLogHelper.save(itemLogColl);
        }
        log.info("result : {} ; \u6536\u96c6\u5220\u9664\u7684\u4e1a\u52a1\u6570\u636eid\u96c6\uff1a{}; ", (Object)result, deleteBizDataIds);
        if (ProcessResultEnum.SUCCESS.getCode().equals(result) && "hsas_nonrecurbizdata".equals(bizDataEntityKey)) {
            AttIntegWithdrawHelper.deleteBizData(deleteBizDataIds);
        }
    }

    private static void deleteBizData(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        helper.delete(ids.toArray());
    }

    private static Map<String, String> checkData(List<DynamicObject> bizDatas, List<Map<String, Object>> errorInfoList) {
        boolean existSuccess = false;
        HashSet<String> errorCodeSet = new HashSet<String>(16);
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>(bizDatas.size());
        for (DynamicObject bizData : bizDatas) {
            int noCntUsageCount;
            int usageCount = bizData.getInt("usagecount");
            int count = usageCount + (noCntUsageCount = bizData.getInt("nocounttimes"));
            if (count > 0) {
                results.put(bizData.getString("groupid") + bizData.getLong("depemp.id") + bizData.getLong("bizitem.id"), BizDataFailStatusEnum.FAILSTATUS_1050.getCode());
                errorCodeSet.add(BizDataFailStatusEnum.FAILSTATUS_1050.getCode());
                continue;
            }
            existSuccess = true;
        }
        for (DynamicObject bizData : bizDatas) {
            String key = bizData.getString("groupid") + bizData.getLong("depemp.id") + bizData.getLong("bizitem.id");
            if (errorCodeSet.size() <= 0 || results.containsKey(key)) continue;
            errorCodeSet.add(BizDataFailStatusEnum.FAILSTATUS_6015.getCode());
            results.put(key, BizDataFailStatusEnum.FAILSTATUS_6015.getCode());
        }
        if (existSuccess && errorCodeSet.size() > 0) {
            errorCodeSet.add(BizDataFailStatusEnum.FAILSTATUS_6015.getCode());
        }
        if (errorCodeSet.size() > 0) {
            List errorCodeList = errorCodeSet.stream().sorted().collect(Collectors.toList());
            HashMap<String, Object> errorInfo = new HashMap<String, Object>(2);
            errorInfo.put("attfileid", Long.valueOf(bizDatas.get(0).getString("groupid")));
            errorInfo.put("errorcodes", errorCodeList);
            errorInfoList.add(errorInfo);
        }
        return results;
    }

    private static long genLongId(EntityType type) {
        ORM orm = ORM.create();
        return orm.genLongId((IDataEntityType)type);
    }

    private static DynamicObject querySummaryLogData(Long summargLogId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegsumlog");
        return helper.queryOne("id,integrationquantity,successquantity,failquantity,createtime,endtime,timeconsume,integrationstatus", new QFilter[]{new QFilter("id", "=", (Object)summargLogId)});
    }

    private static Object updateSummaryLogData(DynamicObject summargLogDyObj) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegsumlog");
        return helper.updateOne(summargLogDyObj);
    }

    private static Object saveSummaryLogData(DynamicObject summargLogDyObj) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegsumlog");
        return helper.saveOne(summargLogDyObj);
    }
}

