/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.attintegrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.attintegrate.AttIntegrateBatchMsgPublishTask;
import kd.swc.hsas.business.attintegrate.enums.OperationType;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.enums.AttDataTypeEnum;
import kd.swc.hsbp.common.enums.BizDataSrcSystemEnum;
import kd.swc.hsbp.common.enums.GlobalAttRecordStateEnum;
import kd.swc.hsbp.common.enums.IntegrationProcessStateEnum;
import kd.swc.hsbp.common.enums.IntegrationStatusEnum;
import kd.swc.hsbp.common.enums.MessageStateEnum;
import kd.swc.hsbp.common.enums.WriteBackStateEnum;

public class AttIntegrateManager {
    private static final Log logger = LogFactory.getLog(AttIntegrateManager.class);
    private SWCDataServiceHelper summaryLogService = new SWCDataServiceHelper("hsas_attintegsumlog");
    private SWCDataServiceHelper batchLogService = new SWCDataServiceHelper("hsas_attintegbatchlog");
    private SWCDataServiceHelper integMapScmService = new SWCDataServiceHelper("hsbs_attintegmapscm");
    private SWCDataServiceHelper newIntegMapScmService = new SWCDataServiceHelper("hsbs_attintegmapscmnew");
    private static final Integer INTEGRATE_FILE_BATCH_SIZE_FOR_DETAIL = 100;
    private static final Integer INTEGRATE_FILE_BATCH_SIZE = 1000;
    private boolean initSuccess = true;
    private boolean asyncModel = true;
    private Integer attScheme;
    private GlobalAttRecordStateEnum globalErrorEnum = null;

    public AttIntegrateManager() {
        this.init();
    }

    public void setAsyncModel(boolean asyncModel) {
        this.asyncModel = asyncModel;
    }

    private void init() {
        long beginTime = System.currentTimeMillis();
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"wtcinte");
        Boolean enableWtcInte = (Boolean)paramMap.get("enableWtcInte");
        this.attScheme = paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
        List mapRuleList = (List)paramMap.get("mapRuleList");
        if (!enableWtcInte.booleanValue() || WtcInteCfgConstants.FIELD_SCHEME_TWO.equals(this.attScheme)) {
            logger.warn("enableWtcInte is close or scheme is secound");
            this.globalErrorEnum = GlobalAttRecordStateEnum.DISENABLE_ATT_INTEGRATE_MAP_SCHEME;
            this.initSuccess = false;
            return;
        }
        if (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(this.attScheme)) {
            this.checkInitForAttBizData(mapRuleList);
        } else {
            this.checkInitForBizData();
        }
        long cost = System.currentTimeMillis() - beginTime;
        logger.info("AttIntegrateManager.init,cost time is {} s", (Object)(cost / 1000L));
    }

    private void checkInitForAttBizData(List<Map<String, Object>> mapRuleList) {
        DynamicObject[] schemes = this.newIntegMapScmService.query("id,org.id,sumentryentity.sumattitem,sumentryentity.sumattbizitem,detailentryentity.detailattitem,detailentryentity.detailattbizitem,itemscope,enable,status", new QFilter[]{new QFilter("id", "in", mapRuleList.stream().map(mapRule -> mapRule.get("attintegmapscm")).collect(Collectors.toSet()))});
        if (schemes.length == 0) {
            logger.warn("hsbs_attintegmapscmnew data is empty");
            this.globalErrorEnum = GlobalAttRecordStateEnum.ATT_INTEGRATE_MAP_SCHEME_NOT_MATCH;
            this.initSuccess = false;
        }
    }

    private void checkInitForBizData() {
        DynamicObject[] result = this.integMapScmService.query("org,country,attperiod,calperiodtype,matchtype,attitem,bizitem", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (result.length == 0) {
            logger.warn("hsbs_attintegmapscm data is empty");
            this.globalErrorEnum = GlobalAttRecordStateEnum.ATT_INTEGRATE_MAP_SCHEME_NOT_MATCH;
            this.initSuccess = false;
        }
    }

    public Map<String, Object> dispatchTask(String batchVersionId, int fileCount, Long operator, String dataType) {
        if (!this.initSuccess) {
            return this.getGlobalAttRecordStateResult(this.globalErrorEnum);
        }
        if (WtcInteCfgConstants.FIELD_SCHEME_THREE.equals(this.attScheme) && "2".equals(dataType)) {
            logger.warn("scheme 3 cannot collect detail data");
            return this.getGlobalAttRecordStateResult(GlobalAttRecordStateEnum.ATT_DATA_NOT_SUPPORT);
        }
        DynamicObject summaryLog = this.summaryLogService.queryOne("id,batchversionid,filequantity,processstate,writebackstate,attdatatype,storepage", new QFilter[]{new QFilter("batchversionid", "=", (Object)batchVersionId), new QFilter("operationtype", "=", (Object)OperationType.PUSH.getCode())});
        if (summaryLog == null) {
            if (fileCount == 0) {
                logger.warn("fileCount is zero,batchVersionId={}", (Object)batchVersionId);
                throw new KDBizException("fileCount is zero");
            }
            summaryLog = this.initSummaryLog(batchVersionId, operator, OperationType.PUSH.getCode(), fileCount, dataType);
            this.summaryLogService.saveOne(summaryLog);
        }
        DynamicObject[] batchLogs = this.createBatchLog(summaryLog, operator);
        this.batchLogService.save(batchLogs);
        SWCThreadPoolFactory.getAttIntegrateThreadPool().submit((Callable)new AttIntegrateBatchMsgPublishTask(RequestContext.get()));
        return this.getGlobalAttRecordStateResult(GlobalAttRecordStateEnum.SUCCESS);
    }

    private DynamicObject[] createBatchLog(DynamicObject summaryLog, Long operatorId) {
        int batchSize = AttDataTypeEnum.DETAIL.getCode().equals(summaryLog.getString("attdatatype")) ? INTEGRATE_FILE_BATCH_SIZE_FOR_DETAIL : INTEGRATE_FILE_BATCH_SIZE;
        int fileCount = summaryLog.getInt("filequantity");
        ArrayList<DynamicObject> batchLogList = new ArrayList<DynamicObject>(fileCount / batchSize + 1);
        int i = 0;
        while (i <= fileCount) {
            int begin = i;
            int end = Math.min(begin + batchSize, fileCount) - 1;
            i = end + 1;
            if (begin > end) break;
            DynamicObject batchLog = this.batchLogService.generateEmptyDynamicObject();
            batchLog.set("attintegsumlog", (Object)summaryLog.getLong("id"));
            batchLog.set("startindex", (Object)begin);
            batchLog.set("endindex", (Object)end);
            batchLog.set("msgstate", (Object)MessageStateEnum.PENDING.getCode());
            batchLog.set("processstate", (Object)IntegrationProcessStateEnum.PENDING.getCode());
            batchLog.set("writebackstate", (Object)WriteBackStateEnum.INCOMPLETE.getCode());
            batchLog.set("creator", (Object)operatorId);
            batchLogList.add(batchLog);
        }
        return batchLogList.toArray(new DynamicObject[0]);
    }

    private DynamicObject initSummaryLog(String batchVersionId, Long operator, String operationType, int fileCount, String dataType) {
        DynamicObject logObj = this.summaryLogService.generateEmptyDynamicObject();
        logObj.set("number", (Object)CodeRuleHelper.getNumber((DynamicObject)logObj, null));
        logObj.set("frontendsystem", (Object)BizDataSrcSystemEnum.WTC.getCode());
        logObj.set("createtime", (Object)new Date());
        logObj.set("creator", (Object)operator);
        logObj.set("operationtype", (Object)operationType);
        logObj.set("integrationstatus", (Object)IntegrationStatusEnum.RUNNING.getCode());
        logObj.set("batchversionid", (Object)batchVersionId);
        logObj.set("filequantity", (Object)fileCount);
        logObj.set("processstate", (Object)IntegrationProcessStateEnum.PENDING.getCode());
        logObj.set("writebackstate", (Object)WriteBackStateEnum.INCOMPLETE.getCode());
        logObj.set("attdatatype", (Object)dataType);
        logObj.set("storepage", (Object)(WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(this.attScheme) ? "1" : "0"));
        return logObj;
    }

    private Map<String, Object> getGlobalAttRecordStateResult(GlobalAttRecordStateEnum stateEnum) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", stateEnum.isSuccess());
        result.put("errorCode", stateEnum.getStatusEnum().getCode());
        result.put("message", stateEnum.getStatusEnum().getDesc());
        return result;
    }
}

