/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.excel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.swc.hsas.business.bankoffer.excel.BaseCellStyleGenerator;
import kd.swc.hsas.business.bankoffer.excel.CellStyleFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class CustomParamCellStyleGenerator
extends BaseCellStyleGenerator {
    private Map<String, Object> params;
    private Map<String, Object> fontParams;

    public CustomParamCellStyleGenerator ofParams(Map<String, Object> params) {
        this.params = params;
        if (params != null) {
            this.fontParams = new HashMap<String, Object>(params.size());
            HashSet<String> specKey = new HashSet<String>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("font.")) continue;
                this.fontParams.put(key.substring(5), entry.getValue());
                specKey.add(key);
            }
            params.keySet().removeAll(specKey);
        }
        return this;
    }

    @Override
    protected void doDecorate(CellStyle cellStyle, Workbook wb) {
        String alignment;
        if (this.params == null) {
            return;
        }
        Object dataFormat = this.params.get("dataFormat");
        if (dataFormat instanceof String) {
            DataFormat format = wb.createDataFormat();
            cellStyle.setDataFormat(format.getFormat((String)dataFormat));
        }
        if (this.fontParams != null && this.fontParams.size() > 0) {
            Font font = wb.getFontAt(cellStyle.getFontIndexAsInt());
            Font newFont = CellStyleFactory.cloneFont(font, wb, this.fontParams);
            cellStyle.setFont(newFont);
        }
        if (StringUtils.isNotBlank((CharSequence)(alignment = MapUtils.getString(this.params, (Object)"alignment")))) {
            cellStyle.setAlignment(HorizontalAlignment.forInt((int)Integer.parseInt(alignment)));
        }
    }
}

