/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.excel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.KDBizException;
import kd.swc.hsas.business.bankoffer.excel.DataProvider;
import kd.swc.hsas.business.bankoffer.vo.DataBatch;
import kd.swc.hsbp.common.util.SWCListUtils;

public abstract class PageBatchDataProvider
implements DataProvider {
    private final Map<String, Item> itemMap = new ConcurrentHashMap<String, Item>(4);
    private final Map<String, ArrayBlockingQueue<DataBatch>> dataListMap = new ConcurrentHashMap<String, ArrayBlockingQueue<DataBatch>>(4);

    @Override
    public boolean hasNextData(String dataKey) {
        Item item = this.itemMap.get(dataKey);
        if (item == null) {
            return false;
        }
        return item.hasNext();
    }

    @Override
    public DataBatch getNextData(String dataKey) {
        ArrayBlockingQueue<DataBatch> dataQueue = this.dataListMap.get(dataKey);
        if (dataQueue == null) {
            return null;
        }
        return dataQueue.poll();
    }

    @Override
    public void completeBatch(DataBatch dataBatch) {
        Item item = this.itemMap.get(dataBatch.getDataKey());
        if (item == null) {
            return;
        }
        item.completeIncr();
    }

    public PageBatchDataProvider addData(List splitPayDetail) {
        return this.addData("defaultData", splitPayDetail);
    }

    public PageBatchDataProvider addData(String dataKey, List splitPayDetail) {
        if (this.itemMap.containsKey(dataKey)) {
            throw new KDBizException("Data repeat added");
        }
        Item item = new Item(splitPayDetail.size(), 500);
        int size = item.leftPage();
        ArrayBlockingQueue<DataBatch> dataQueue = new ArrayBlockingQueue<DataBatch>(size);
        this.itemMap.put(dataKey, item);
        this.dataListMap.put(dataKey, dataQueue);
        List splitPayDetailMapList = SWCListUtils.split((List)splitPayDetail, (int)500);
        for (int i = 0; i < splitPayDetailMapList.size(); ++i) {
            List payDetails = (List)splitPayDetailMapList.get(i);
            int startRow = i * 500;
            List data = payDetails;
            if (data == null) {
                data = Collections.emptyList();
            }
            DataBatch dataBatch = new DataBatch(data, startRow, dataKey);
            try {
                dataQueue.put(dataBatch);
                continue;
            }
            catch (InterruptedException e) {
                this.rePutData(dataQueue, dataBatch);
                Thread.currentThread().interrupt();
            }
        }
        return this;
    }

    private void rePutData(ArrayBlockingQueue<DataBatch> dataQueue, DataBatch dataBatch) {
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
            dataQueue.put(dataBatch);
        }
        catch (InterruptedException e) {
            this.rePutData(dataQueue, dataBatch);
            Thread.currentThread().interrupt();
        }
    }

    static class Item {
        private final AtomicInteger unCompleteCount;

        public Item(int totalSize, int pageSize) {
            int i = totalSize / pageSize;
            if (totalSize % pageSize > 0) {
                ++i;
            }
            this.unCompleteCount = new AtomicInteger(i);
        }

        public int leftPage() {
            return this.unCompleteCount.intValue();
        }

        public void completeIncr() {
            this.unCompleteCount.decrementAndGet();
        }

        public boolean hasNext() {
            return this.unCompleteCount.intValue() > 0;
        }
    }
}

