/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.excel;

import com.google.common.collect.HashBasedTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.excel.DataTypeEnum;
import kd.swc.hsas.business.bankoffer.excel.DefaultCellStyleNameEnum;
import kd.swc.hsas.business.bankoffer.vo.HeadCellBar;
import kd.swc.hsas.business.bankoffer.vo.HeadCellInfo;
import kd.swc.hsas.business.bankoffer.vo.SheetInfo;
import kd.swc.hsas.business.bankoffer.vo.WorkbookInfo;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class WorkbookBankOfferDeclareExport {
    public static WorkbookInfo generate(Map<String, Object> param) {
        HeadCellInfo cellInfo;
        DynamicObject bankOfferTpl = (DynamicObject)param.get("bankOfferTpl");
        Map filedNameMap = (Map)param.get("fieldNameMap");
        String fileName = (String)param.get("filename");
        WorkbookInfo workbookInfo = new WorkbookInfo();
        workbookInfo.setNeedTemplate(false);
        workbookInfo.setFileName(fileName);
        SheetInfo sheetInfo = new SheetInfo();
        sheetInfo.setName("sheet1");
        sheetInfo.setNeedFillHead(true);
        HeadCellBar headCellBar = new HeadCellBar();
        DynamicObjectCollection excelEntry = bankOfferTpl.getDynamicObjectCollection("exceltitleent");
        int i = 0;
        for (DynamicObject excelDy : excelEntry) {
            boolean isEmpty = excelDy.getBoolean("isempty");
            if (isEmpty) {
                ++i;
                continue;
            }
            DynamicObjectCollection headContentEntry = excelDy.getDynamicObjectCollection("headcontententity");
            for (DynamicObject headContentDy : headContentEntry) {
                String col = headContentDy.getString("collocation");
                cellInfo = new HeadCellInfo();
                cellInfo.setColNum(WorkbookBankOfferDeclareExport.getColNum(col));
                cellInfo.setRowNum(i);
                String headType = headContentDy.getString("headtype");
                if ("2".equals(headType)) {
                    String subHeadContent = headContentDy.getString("subheadcontent");
                    cellInfo.setDefaultDesc(subHeadContent);
                } else {
                    String fieldShowType = headContentDy.getString("fieldshowtype");
                    String selectField = headContentDy.getString("selectfield");
                    String subHeadContent = headContentDy.getString("subheadcontent");
                    if ("2".equals(fieldShowType)) {
                        cellInfo.setDefaultDesc((String)filedNameMap.get(selectField));
                    } else {
                        String value = (String)filedNameMap.get(selectField);
                        if (SWCStringUtils.isEmpty((String)value)) {
                            cellInfo.setDefaultDesc(subHeadContent + "\uff1a");
                        } else {
                            cellInfo.setDefaultDesc(subHeadContent + "\uff1a" + value);
                        }
                    }
                }
                String alignment = headContentDy.getString("alignment");
                HashMap<String, Object> alignmentMap = new HashMap<String, Object>(16);
                alignmentMap.put("alignment", alignment);
                cellInfo.setHeadStyleParam(alignmentMap);
                headCellBar.addHeadCellInfos(cellInfo);
            }
            ++i;
        }
        HashBasedTable filedDataTypeTable = (HashBasedTable)param.get("filedDataTypeTable");
        DynamicObjectCollection detailEntry = bankOfferTpl.getDynamicObjectCollection("detailent");
        int j = 0;
        for (DynamicObject detailDy : detailEntry) {
            String fieldName = detailDy.getString("fieldname");
            String dataType = (String)filedDataTypeTable.get((Object)detailDy.getString("fieldquerytable"), (Object)detailDy.getString("fieldselect"));
            cellInfo = new HeadCellInfo(String.valueOf(j));
            headCellBar.addHeadCellInfos(cellInfo);
            cellInfo.setColNum(j);
            cellInfo.setRowNum(i);
            cellInfo.setDefaultDesc(fieldName);
            if (SWCStringUtils.isNotEmpty((String)dataType)) {
                cellInfo.setDataType(dataType);
                if (DataTypeEnum.BIG_DECIMAL.name().equals(dataType)) {
                    if (detailDy.getBoolean("isshowthousandth")) {
                        cellInfo.setBaseFormat("#,##0");
                    } else {
                        cellInfo.setBaseFormat("0");
                    }
                    if (SWCStringUtils.isNotEmpty((String)detailDy.getString("fixway"))) {
                        cellInfo.setBaseFormat(cellInfo.getBaseFormat() + "_ ");
                    }
                }
            }
            ++j;
        }
        sheetInfo.setBodyRow(i + 1);
        sheetInfo.setHeadCellBar(headCellBar);
        workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
        workbookInfo.ready();
        return workbookInfo;
    }

    public static WorkbookInfo generateErrorWb(Map<String, Object> param) {
        String fileName = (String)param.get("filename");
        Map filedNameMap = (Map)param.get("fieldNameMap");
        Object errorDTO = param.get("errorDTO");
        WorkbookInfo workbookInfo = new WorkbookInfo();
        workbookInfo.setNeedTemplate(false);
        workbookInfo.setFileName(fileName);
        SheetInfo sheetInfo = new SheetInfo();
        sheetInfo.setName("sheet1");
        sheetInfo.setNeedFillHead(true);
        HeadCellBar headCellBar = new HeadCellBar();
        String[] filedNameArr = BankOfferHelper.getFiledName(errorDTO);
        int i = 0;
        for (String filedName : filedNameArr) {
            if ("id".equals(filedName) || "serialVersionUID".equals(filedName)) continue;
            HeadCellInfo cellInfo = new HeadCellInfo(filedName);
            cellInfo.setHeadStyle(DefaultCellStyleNameEnum.HEAD);
            headCellBar.addHeadCellInfos(cellInfo);
            cellInfo.setColNum(i);
            cellInfo.setRowNum(0);
            cellInfo.setDefaultDesc((String)filedNameMap.get(filedName));
            if (!"errorMsg".equals(filedName)) continue;
            HashMap<String, Object> cond = new HashMap<String, Object>(16);
            cond.put("font.color", (short)10);
            cellInfo.setBodyStyleParam(cond);
            cellInfo.setWidth(10000);
        }
        sheetInfo.setBodyRow(i + 1);
        sheetInfo.setHeadCellBar(headCellBar);
        workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
        workbookInfo.ready();
        return workbookInfo;
    }

    private static int getColNum(String col) {
        col = col.toUpperCase();
        char[] arr = col.toCharArray();
        int colNum = 0;
        for (int i = 0; i < arr.length; ++i) {
            int temp = arr[i] - 65;
            colNum = colNum * 26 + temp + 1;
        }
        return colNum - 1;
    }
}

