/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.strategy;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.BaseExportService;
import kd.swc.hsas.business.bankoffer.excel.ExcelHelper;
import kd.swc.hsas.business.bankoffer.excel.PageBatchDataProvider;
import kd.swc.hsas.business.bankoffer.excel.WorkbookBankOfferDeclareExport;
import kd.swc.hsas.business.bankoffer.vo.ExportResult;
import kd.swc.hsas.business.bankoffer.vo.WorkbookInfo;
import kd.swc.hsas.business.bankoffer.vo.exportPackage.DataPackage;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.common.dto.BankOfferSplitBatchDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExportService
extends BaseExportService {
    private static final Log logger = LogFactory.getLog(ExcelExportService.class);

    public ExcelExportService(DataPackage dataPackage) {
        super(dataPackage);
    }

    @Override
    public List<List<Object>> getDataList(List<Long> splitPayDetailIds, List<BankOfferExportFiledDTO> exportFiledDTO, HashBasedTable<Long, Integer, Object> dataTable) {
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>(splitPayDetailIds.size());
        splitPayDetailIds.forEach(payDetailId -> {
            ArrayList list = new ArrayList(exportFiledDTO.size());
            exportFiledDTO.forEach(exportFiled -> {
                String fieldSource = exportFiled.getFieldSource();
                Integer seq = exportFiled.getSeq();
                if ("3".equals(fieldSource)) {
                    list.add(seq, String.valueOf(dataList.size() + 1));
                } else {
                    Object payDetailObjValue = dataTable.get(payDetailId, (Object)seq);
                    payDetailObjValue = payDetailObjValue != null ? payDetailObjValue : "";
                    int fieldLength = exportFiled.getFieldLength();
                    String fixWay = exportFiled.getFixWay();
                    String fixContent = exportFiled.getFixContent();
                    if (SWCStringUtils.isNotEmpty((String)fixWay)) {
                        String fieldValue = this.dealDataBefore(payDetailObjValue);
                        if (SWCStringUtils.isNotEmpty((String)fieldValue)) {
                            fieldValue = BankOfferHelper.swallowField(fieldValue, fixWay, fieldLength, fixContent);
                        }
                        list.add(seq, fieldValue);
                    } else {
                        list.add(seq, payDetailObjValue);
                    }
                }
            });
            dataList.add(list);
        });
        return dataList;
    }

    private String dealDataBefore(Object value) {
        String str = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : String.valueOf(value);
        return str;
    }

    @Override
    public List<BaseExportService.BaseBankOfferBatchExportThread> dealExportDataBefore(List<BankOfferSplitBatchDTO> splitBatchDTOList) {
        DataPackage dataPackage = this.getDataPackage();
        BankOfferBatchExportDTO batchExport = dataPackage.getBatchExport();
        DynamicObject bankOfferTpl = dataPackage.getBankOfferTpl();
        RequestContext requestContext = dataPackage.getRequestContext();
        BankOfferSelectTplDTO selectTpl = dataPackage.getSelectTpl();
        HashBasedTable<String, String, String> filedDataTypeTable = dataPackage.getFiledDataTypeTable();
        ArrayList<BaseExportService.BaseBankOfferBatchExportThread> exportThreadList = new ArrayList<BaseExportService.BaseBankOfferBatchExportThread>(splitBatchDTOList.size());
        splitBatchDTOList.forEach(data -> exportThreadList.add(new ExcelBatchExportThread(requestContext, (BankOfferSplitBatchDTO)data, batchExport, bankOfferTpl, selectTpl, filedDataTypeTable)));
        return exportThreadList;
    }

    class ExcelBatchExportThread
    extends BaseExportService.BaseBankOfferBatchExportThread {
        private HashBasedTable<String, String, String> filedDataTypeTable;

        public ExcelBatchExportThread(RequestContext requestContext, BankOfferSplitBatchDTO splitBatch, BankOfferBatchExportDTO dto, DynamicObject bankOfferTpl, BankOfferSelectTplDTO selectTpl, HashBasedTable<String, String, String> filedDataTypeTable) {
            super(requestContext, splitBatch, dto, bankOfferTpl, selectTpl);
            this.filedDataTypeTable = filedDataTypeTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getExportUrl() throws Exception {
            Map filedNameMap = this.splitBatch.getFiledNameMap();
            List dataList = this.splitBatch.getDataList();
            ExportResult exportResult = new ExportResult(0);
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("bankOfferTpl", this.bankOfferTpl);
            param.put("fieldNameMap", filedNameMap);
            param.put("filename", this.fileExportName);
            param.put("filedDataTypeTable", this.filedDataTypeTable);
            WorkbookInfo workbookInfo = WorkbookBankOfferDeclareExport.generate(param);
            SXSSFWorkbook wb = new SXSSFWorkbook(workbookInfo.getRowAccessWindowSize());
            ExcelHelper.writeData((Workbook)wb, workbookInfo, new PageBatchDataProvider(){}.addData(dataList), exportResult, this.exportFileDTO, false);
            String url = "";
            try {
                if (exportResult.isFailue()) {
                    String string = "";
                    return string;
                }
                url = BankOfferHelper.writeFile((Workbook)wb, this.fileExportName);
            }
            finally {
                wb.close();
            }
            return url;
        }
    }
}

