/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.vo;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.swc.hsas.business.bankoffer.excel.InputStreamLoader;
import kd.swc.hsas.business.bankoffer.vo.SheetInfo;

public class WorkbookInfo
implements Serializable {
    private static final long serialVersionUID = 2338256755127672132L;
    public static final String EXTENSION_NAME_2003 = ".xls";
    public static final String EXTENSION_NAME_2007 = ".xlsx";
    private int rowAccessWindowSize = 120;
    private String extensionName = ".xlsx";
    private String fileName;
    private List<SheetInfo> sheetInfoList;
    private boolean ready;
    private boolean needTemplate;
    private Map<String, List<?>> dataListMap;
    private String resourceType;
    private String url;

    public String fullName() {
        return this.fileName + this.extensionName;
    }

    public boolean ready() {
        this.ready = true;
        for (SheetInfo sheetInfo : this.sheetInfoList) {
            if (sheetInfo.ready()) continue;
            this.ready = false;
            return false;
        }
        this.ready = true;
        return true;
    }

    public InputStream getResource() {
        return InputStreamLoader.loadWith(this.getResourceType(), this.getUrl());
    }

    public boolean hasResource() {
        return StringUtils.isNotEmpty((CharSequence)this.getResourceType()) && StringUtils.isNotEmpty((CharSequence)this.getUrl());
    }

    public WorkbookInfo ofVersion2007() {
        this.setExtensionName(EXTENSION_NAME_2007);
        return this;
    }

    public WorkbookInfo ofVersion2003() {
        this.setExtensionName(EXTENSION_NAME_2003);
        return this;
    }

    public int getRowAccessWindowSize() {
        return this.rowAccessWindowSize;
    }

    public void setRowAccessWindowSize(int rowAccessWindowSize) {
        this.rowAccessWindowSize = rowAccessWindowSize;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<SheetInfo> getSheetInfoList() {
        return this.sheetInfoList;
    }

    public void setSheetInfoList(List<SheetInfo> sheetInfoList) {
        this.sheetInfoList = sheetInfoList;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Map<String, List<?>> getDataListMap() {
        return this.dataListMap;
    }

    public void setDataListMap(Map<String, List<?>> dataListMap) {
        this.dataListMap = dataListMap;
    }

    public boolean isNeedTemplate() {
        return this.needTemplate;
    }

    public void setNeedTemplate(boolean needTemplate) {
        this.needTemplate = needTemplate;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

