/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataHelper {
    public final Log log = LogFactory.getLog(BizDataHelper.class);
    private static final String MONTHANDYEAR_OPTION_PRE = "-1";
    private static final String MONTHANDYEAR_OPTION_CUR = "0";
    private static final String MONTHANDYEAR_OPTION_AFTER = "1";
    private static final String MONTHANDYEAR_OPTION_PRE3 = "-3";

    public List<Long> getBizDataIdList(SWCDataServiceHelper helper, QFilter filter) {
        DynamicObject[] bizDataColl = helper.query("id", new QFilter[]{filter});
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            bizDataIdList.add(bizDataObj.getLong("id"));
        }
        return bizDataIdList;
    }

    public DynamicObject[] getBizDataColl(SWCDataServiceHelper helper, QFilter filter) {
        DynamicObject[] bizDataColl = helper.query("id, bsed, salaryfile.id, bizitem.id,bsled,identifynumber,datavalue,currency.id,frequency.id,description,auditstatus,datasources,usagecount", new QFilter[]{filter});
        return bizDataColl;
    }

    public DynamicObject[] getBizDataOrderByColl(SWCDataServiceHelper helper, QFilter filter, String orderBy) {
        DynamicObject[] bizDataColl = helper.query("id, bsed, salaryfile.id, bizitem.id,bsled,identifynumber,datavalue,currency.id,frequency.id,description,auditstatus,datasources,usagecount,nocounttimes", new QFilter[]{filter}, orderBy);
        return bizDataColl;
    }

    public List<List<DynamicObject>> getSamePersonSameItemBizDatas(List<DynamicObject> auditBizDataList) {
        Map<String, List<DynamicObject>> map = auditBizDataList.stream().collect(Collectors.groupingBy(data -> data.getString("salaryfile.id") + "-" + data.getString("bizitem.id")));
        ArrayList<List<DynamicObject>> bizDataList = new ArrayList<List<DynamicObject>>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            List<DynamicObject> dataList = entry.getValue();
            for (int index = 0; index < dataList.size(); ++index) {
                List<DynamicObject> subList;
                if (bizDataList.size() <= index) {
                    subList = new ArrayList();
                    bizDataList.add(subList);
                } else {
                    subList = (List)bizDataList.get(index);
                }
                subList.add(dataList.get(index));
            }
        }
        return bizDataList;
    }

    public Object getDateValue(String strValue) {
        Date dataValue = null;
        try {
            dataValue = SWCDateTimeUtils.parseDate((String)strValue, (String)"yyyy-MM-dd");
        }
        catch (ParseException e1) {
            this.log.error((Throwable)e1);
        }
        return dataValue;
    }

    public QFilter buildUsageCountOptionFilter(Object value) {
        List<String> valueList = new ArrayList(3);
        if (!SWCObjectUtils.isEmpty((Object)value) && value instanceof String) {
            String str = value.toString();
            valueList.add(str);
        } else {
            valueList = (List)value;
        }
        QFilter filter0 = null;
        QFilter filter1 = null;
        QFilter filter2 = null;
        QFilter filter3 = null;
        Iterator iterator = valueList.iterator();
        while (iterator.hasNext()) {
            String valueStr;
            switch (valueStr = (String)iterator.next()) {
                case "0": {
                    filter0 = new QFilter("usagecount", "=", (Object)0);
                    break;
                }
                case "1": {
                    filter1 = new QFilter("usagecount", "=", (Object)1);
                    break;
                }
                case "2": {
                    filter2 = new QFilter("usagecount", ">=", (Object)1);
                    break;
                }
                case "3": {
                    filter3 = new QFilter("usagecount", ">", (Object)1);
                    break;
                }
            }
        }
        QFilter newFilter = null;
        if (filter0 != null) {
            if (newFilter != null) {
                newFilter.or(filter0);
            } else {
                newFilter = filter0;
            }
        }
        if (filter1 != null) {
            if (newFilter != null) {
                newFilter.or(filter1);
            } else {
                newFilter = filter1;
            }
        }
        if (filter2 != null) {
            if (newFilter != null) {
                newFilter.or(filter2);
            } else {
                newFilter = filter2;
            }
        }
        if (filter3 != null) {
            if (newFilter != null) {
                newFilter.or(filter3);
            } else {
                newFilter = filter3;
            }
        }
        return newFilter;
    }

    public QFilter buildMonthAndYearsFilter(Object value, Boolean isRecur) {
        String str = value.toString();
        Date startDate = new Date();
        Date endDate = new Date();
        Calendar calendar = Calendar.getInstance();
        switch (str) {
            case "-1": {
                calendar.set(2, calendar.get(2) - 1);
                calendar.set(5, 1);
                startDate = calendar.getTime();
                calendar.set(5, calendar.getActualMaximum(5));
                endDate = calendar.getTime();
                break;
            }
            case "0": {
                calendar.add(2, 0);
                calendar.set(5, 1);
                startDate = calendar.getTime();
                calendar.add(2, 1);
                calendar.set(5, 0);
                endDate = calendar.getTime();
                break;
            }
            case "1": {
                calendar.set(2, calendar.get(2) + 1);
                calendar.set(5, 1);
                startDate = calendar.getTime();
                calendar.set(5, calendar.getActualMaximum(5));
                endDate = calendar.getTime();
                break;
            }
            case "-3": {
                calendar.setTime(endDate);
                calendar.add(2, -2);
                startDate = calendar.getTime();
                break;
            }
        }
        QFilter newFilter = null;
        if (isRecur.booleanValue()) {
            QFilter filter = new QFilter("bsled", ">", (Object)startDate);
            filter.or("bsled", "is null", null);
            newFilter = new QFilter("bsed", "<", (Object)endDate);
            newFilter.and(filter);
        } else {
            newFilter = new QFilter("calperiod.startdate", "<", (Object)endDate);
            newFilter.and("calperiod.enddate", ">", (Object)startDate);
        }
        return newFilter;
    }

    public Map<Long, DynamicObject> getCalPeriodAndBizDataRel(List<Long> needUpdateList, boolean isRecur) {
        Map<Long, List<DynamicObject>> calBizDataRelMap = this.getCalPeriodColl(needUpdateList, isRecur);
        if (calBizDataRelMap == null || calBizDataRelMap.size() == 0) {
            return null;
        }
        HashMap<Long, DynamicObject> bizDataAndMaxCalPeriodIdMap = new HashMap<Long, DynamicObject>(needUpdateList.size());
        for (Long needUpdateId : needUpdateList) {
            Date calPeriodStartDate = null;
            DynamicObject calPeriod = null;
            List<DynamicObject> bizDataRelList = calBizDataRelMap.get(needUpdateId);
            if (bizDataRelList == null || bizDataRelList.size() == 0) continue;
            for (DynamicObject calBizDataObj : bizDataRelList) {
                Date calPeriodStartDateTemp = calBizDataObj.getDate("calperiod.startdate");
                if (calPeriodStartDate != null && calPeriodStartDate.compareTo(calPeriodStartDateTemp) > 0) continue;
                calPeriodStartDate = calPeriodStartDateTemp;
                calPeriod = calBizDataObj;
            }
            bizDataAndMaxCalPeriodIdMap.put(needUpdateId, calPeriod);
        }
        return bizDataAndMaxCalPeriodIdMap;
    }

    private Map<Long, List<DynamicObject>> getCalPeriodColl(List<Long> needUpdateList, boolean isRecur) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calnonbizdatarel");
        if (isRecur) {
            helper = new SWCDataServiceHelper("hsas_calbizdatarel");
        }
        QFilter filter = new QFilter("bizdataid", "in", needUpdateList);
        DynamicObjectCollection calBizDataRelColl = helper.queryOriginalCollection("id, bizdataid, calperiod.id, calperiod.name, calperiod.startdate, calperiod.enddate", new QFilter[]{filter});
        HashMap<Long, List<DynamicObject>> calBizDataRelMap = new HashMap<Long, List<DynamicObject>>(calBizDataRelColl.size());
        List calBizDataRelList = null;
        for (DynamicObject calBizDataRel : calBizDataRelColl) {
            Long bizDataId = calBizDataRel.getLong("bizdataid");
            calBizDataRelList = calBizDataRelMap.getOrDefault(bizDataId, new ArrayList());
            calBizDataRelList.add(calBizDataRel);
            calBizDataRelMap.put(bizDataId, calBizDataRelList);
        }
        return calBizDataRelMap;
    }

    public List<Long> filterRejectIdList(ListSelectedRowCollection selectedRows, SWCDataServiceHelper helper) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("auditstatus", "=", (Object)"C");
        filter.and("datasources", "in", (Object)new String[]{"3"});
        filter.and("id", "in", bizDataIdList);
        filter.and("usagecount", "<=", (Object)0);
        List<Long> rejectIdList = this.getBizDataIdList(helper, filter);
        return rejectIdList;
    }

    public Table<Long, Long, List<DynamicObject>> getRecurBizData(Set<Long> salaryFileIds, Set<Long> bizItemIds) {
        QFilter filter = new QFilter("auditstatus", "=", (Object)"C");
        filter.and("salaryfile.id", "in", salaryFileIds);
        filter.and("bizitem.id", "in", bizItemIds);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        String orderBy = "salaryfile.number asc";
        DynamicObject[] bizDataColl = serviceHelper.query("id, salaryfile.id, bizitem.id, bsed, bsled, identifynumber,datavalue,currency.id,frequency.id,description,auditstatus,modifytime,modifier,datasources", new QFilter[]{filter}, orderBy);
        HashBasedTable table = HashBasedTable.create();
        ArrayList<DynamicObject> bizDataList = null;
        for (DynamicObject bizDataObj : bizDataColl) {
            Long bizItemId;
            Long salaryFileId = bizDataObj.getLong("salaryfile.id");
            bizDataList = (ArrayList<DynamicObject>)table.get((Object)salaryFileId, (Object)(bizItemId = Long.valueOf(bizDataObj.getLong("bizitem.id"))));
            if (bizDataList == null) {
                bizDataList = new ArrayList<DynamicObject>();
            }
            bizDataList.add(bizDataObj);
            table.put((Object)salaryFileId, (Object)bizItemId, bizDataList);
        }
        return table;
    }

    public List<DynamicObject> dealNeedUpdateBsledData(Table<Long, Long, List<DynamicObject>> oldRecurBizData, DynamicObject data) {
        Long salaryFileId = data.getLong("salaryfile.id");
        Long bizItemId = data.getLong("bizitem.id");
        Date newBsed = data.getDate("bsed");
        Date newBsled = data.getDate("bsled");
        List<DynamicObject> needUpdateObjList = this.dealNeedUpdateBsledData(oldRecurBizData, salaryFileId, bizItemId, newBsed, newBsled);
        return needUpdateObjList;
    }

    public List<DynamicObject> dealNeedUpdateBsledDataByCondition(Table<Long, Long, List<DynamicObject>> oldRecurBizData, JSONObject dataObj) {
        Long salaryFileId = dataObj.getLong("salaryFileId");
        Long bizItemId = dataObj.getLong("bizItemId");
        Date newBsed = dataObj.getDate("bsed");
        Date newBsled = dataObj.getDate("bsled");
        List<DynamicObject> needUpdateObjList = this.dealNeedUpdateBsledData(oldRecurBizData, salaryFileId, bizItemId, newBsed, newBsled);
        return needUpdateObjList;
    }

    public List<DynamicObject> dealNeedUpdateBsledData(Table<Long, Long, List<DynamicObject>> oldRecurBizData, Long salaryFileId, Long bizItemId, Date newBsed, Date newBsled) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newBsed);
        calendar.add(5, -1);
        Date updateBlsed = calendar.getTime();
        List dynamicObjects = (List)oldRecurBizData.get((Object)salaryFileId, (Object)bizItemId);
        if (dynamicObjects == null) {
            return null;
        }
        ArrayList<DynamicObject> needUpdateObjList = new ArrayList<DynamicObject>(dynamicObjects.size());
        for (DynamicObject obj : dynamicObjects) {
            Date oldBsed = obj.getDate("bsed");
            Date oldBsled = obj.getDate("bsled");
            if (oldBsled == null) {
                if (newBsled != null || newBsed.compareTo(oldBsed) <= 0) continue;
                obj.set("bsled", (Object)updateBlsed);
                needUpdateObjList.add(obj);
                continue;
            }
            if (newBsled == null) {
                if (newBsed.compareTo(oldBsled) > 0) continue;
                obj.set("bsled", (Object)updateBlsed);
                needUpdateObjList.add(obj);
                continue;
            }
            if (newBsed.compareTo(oldBsed) <= 0 || newBsled.compareTo(oldBsled) < 0 || newBsed.compareTo(oldBsled) > 0) continue;
            obj.set("bsled", (Object)updateBlsed);
            needUpdateObjList.add(obj);
        }
        return needUpdateObjList;
    }

    public List<String> getUpdateBsledErrorList(Date bsed, Date bsled, List<DynamicObject> dynamicObjects, String identifyNumber) {
        ArrayList<String> errorIdentifyNumList = new ArrayList<String>(dynamicObjects.size());
        for (DynamicObject bizData : dynamicObjects) {
            Date oldBsled;
            Date oldBsed;
            String newIdentifyNum = bizData.getString("identifynumber");
            if (SWCStringUtils.equals((String)identifyNumber, (String)newIdentifyNum) || this.checkAddData(bsed, bsled, oldBsed = bizData.getDate("bsed"), oldBsled = bizData.getDate("bsled"))) continue;
            errorIdentifyNumList.add(newIdentifyNum);
        }
        return errorIdentifyNumList;
    }

    private boolean checkAddData(Date bsed, Date bsled, Date oldBsed, Date oldBsled) {
        boolean flag = false;
        if (oldBsled == null) {
            if (bsled == null) {
                if (bsed.compareTo(oldBsed) > 0) {
                    flag = true;
                }
            } else if (bsled.compareTo(oldBsed) < 0) {
                flag = true;
            }
        } else if (bsled == null) {
            if (bsed.compareTo(oldBsed) > 0) {
                flag = true;
            }
        } else if (bsled.compareTo(oldBsed) < 0) {
            flag = true;
        } else if (bsed.compareTo(oldBsed) > 0 && bsled.compareTo(oldBsled) >= 0) {
            flag = true;
        }
        return flag;
    }

    public Table<Long, Long, Set<DynamicObject>> checkBizDateUpdateBsledFailTable(SWCDataServiceHelper recurHelper, Set<Long> salaryFileIdSet, Set<Long> bizItemIdSet, Map<String, String> cacheAuditStatusMap) {
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        filter.and("bizitem.id", "in", bizItemIdSet);
        filter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] failDatas = recurHelper.query("id, salaryfile.id, bizitem.id, bsed, bsled, identifynumber, auditstatus", new QFilter[]{filter});
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject updateData : failDatas) {
            Long bizItemId;
            Long salaryFileId = updateData.getLong("salaryfile.id");
            HashSet<DynamicObject> bizDataIdSet = (HashSet<DynamicObject>)table.get((Object)salaryFileId, (Object)(bizItemId = Long.valueOf(updateData.getLong("bizitem.id"))));
            if (bizDataIdSet == null) {
                bizDataIdSet = new HashSet<DynamicObject>(16);
            }
            bizDataIdSet.add(updateData);
            table.put((Object)salaryFileId, (Object)bizItemId, bizDataIdSet);
            if (cacheAuditStatusMap == null) continue;
            String identifyNumber = updateData.getString("identifynumber");
            String auditStatus = updateData.getString("auditstatus");
            cacheAuditStatusMap.put(identifyNumber, auditStatus);
        }
        return table;
    }

    public void sortListData(List<DynamicObject> auditBizDataList) {
        auditBizDataList.sort((o1, o2) -> {
            if (o1 != null && o2 != null && o1.getDate("bsed") != null && o2.getDate("bsed") != null) {
                return o1.getDate("bsed").compareTo(o2.getDate("bsed"));
            }
            return 1;
        });
    }

    public boolean checkUpdateBsledIsOverlap(long updateId, Date updateBsledDate, Date updateDataBsed, Set<DynamicObject> bizDataIdSet) {
        for (DynamicObject oldBizDataObj : bizDataIdSet) {
            long oldDataId = oldBizDataObj.getLong("id");
            Date oldBsed = oldBizDataObj.getDate("bsed");
            Date oldBsled = oldBizDataObj.getDate("bsled");
            if (oldDataId == updateId || (SWCObjectUtils.isEmpty((Object)updateBsledDate) || updateDataBsed.compareTo(oldBsed) > 0 || updateBsledDate.compareTo(oldBsed) < 0) && (oldBsled != null || updateDataBsed.compareTo(oldBsed) <= 0)) continue;
            this.log.info("checkUpdateBsledIsOverlap param => updateId is :{}, updateDataBsed is :{}, updateBsledDate is :{}, oldBsed is :{}, oldBsled is:{}", new Object[]{updateId, updateDataBsed, updateBsledDate, oldBsed, oldBsled});
            return false;
        }
        return true;
    }

    public boolean checkRecoverBsledIsOverlap(Set<Long> updateIdSet, Date updateBsledDate, Date updateDataBsed, Set<DynamicObject> bizDataIdSet) {
        for (DynamicObject oldBizDataObj : bizDataIdSet) {
            long oldDataId = oldBizDataObj.getLong("id");
            Date oldBsed = oldBizDataObj.getDate("bsed");
            Date oldBsled = oldBizDataObj.getDate("bsled");
            if (updateIdSet.contains(oldDataId)) continue;
            if (SWCObjectUtils.isEmpty((Object)updateBsledDate)) {
                if (SWCObjectUtils.isEmpty((Object)oldBsled)) {
                    this.log.info("checkRecoverBsledIsOverlap updateBsledDate is null and oldBsled is null");
                    return false;
                }
                if (updateDataBsed.compareTo(oldBsled) <= 0) {
                    this.log.info("checkRecoverBsledIsOverlap updateDataBsed <= oldBsled");
                    return false;
                }
            }
            if ((SWCObjectUtils.isEmpty((Object)updateBsledDate) || updateDataBsed.compareTo(oldBsed) > 0 || updateBsledDate.compareTo(oldBsed) < 0) && (oldBsled != null || updateDataBsed.compareTo(oldBsed) <= 0)) continue;
            this.log.info("checkUpdateBsledIsOverlap param => updateDataBsed is :{}, updateBsledDate is :{}, oldBsed is :{}, oldBsled is:{}", new Object[]{updateDataBsed, updateBsledDate, oldBsed, oldBsled});
            return false;
        }
        return true;
    }

    public Set<String> getOverlapIdentifyNumbers(long updateId, Date updateBsledDate, Date updateDataBsed, Set<DynamicObject> bizDataIdSet) {
        HashSet<String> overlapNumbers = new HashSet<String>(16);
        for (DynamicObject oldBizDataObj : bizDataIdSet) {
            long oldDataId = oldBizDataObj.getLong("id");
            Date oldBsed = oldBizDataObj.getDate("bsed");
            Date oldBsled = oldBizDataObj.getDate("bsled");
            if (oldDataId == updateId || updateDataBsed.compareTo(oldBsed) >= 0 || !SWCObjectUtils.isEmpty((Object)updateBsledDate) && (SWCObjectUtils.isEmpty((Object)updateBsledDate) || updateBsledDate.compareTo(oldBsed) < 0)) continue;
            overlapNumbers.add(oldBizDataObj.getString("identifynumber"));
        }
        return overlapNumbers;
    }

    public DynamicObjectCollection getBizItemPropInfo(long bizItemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "=", (Object)bizItemId);
        DynamicObject bizItemObj = helper.queryOne("bizitempropentry.bizitemprop,bizitempropentry.status,bizitempropentry.enable", new QFilter[]{filter});
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            return null;
        }
        DynamicObjectCollection bizItemPropColl = bizItemObj.getDynamicObjectCollection("bizitempropentry");
        return bizItemPropColl;
    }

    public void updateFileInfoInBizDataTab(DynamicObject[] dataEntities) {
        DynamicObject[] bizDataColl;
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(dataEntities.length);
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long salaryFileId = dataEntity.getLong("id");
            salaryFileIds.add(salaryFileId);
            salaryFileMap.put(salaryFileId, dataEntity);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        String selectProperties = "id, salaryfile.id, org, payrollregion, payrollgroup, adminorg, empgroup";
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIds);
        for (DynamicObject bizData : bizDataColl = helper.query(selectProperties, new QFilter[]{filter})) {
            long salaryFileId = bizData.getLong("salaryfile.id");
            DynamicObject salaryFileObj = (DynamicObject)salaryFileMap.get(salaryFileId);
            bizData.set("org", (Object)salaryFileObj.getLong("org.id"));
            bizData.set("payrollregion", (Object)salaryFileObj.getLong("payrollregion.id"));
            bizData.set("payrollgroup", (Object)salaryFileObj.getLong("payrollgroup.id"));
            bizData.set("adminorg", (Object)salaryFileObj.getLong("adminorg.id"));
            bizData.set("empgroup", (Object)salaryFileObj.getLong("empgroup.id"));
        }
        helper.update(bizDataColl);
    }

    public List<DynamicObject> queryEffectOrAffectedBizDatas(QFilter filter, boolean needFilterSelf) {
        ArrayList<DynamicObject> returnList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        DynamicObject[] queryDatas = helper.query("bizdatacode,opbizdatacode,bsed,bsled,isabandon,modifier,modifytime,beforebsled,afterbsled", new QFilter[]{filter});
        if (queryDatas == null || queryDatas.length == 0) {
            return returnList;
        }
        if (!needFilterSelf) {
            for (DynamicObject dynamicObject : queryDatas) {
                returnList.add(dynamicObject);
            }
            return returnList;
        }
        for (DynamicObject queryObj : queryDatas) {
            String opBizDataCode;
            String bizDataCode = queryObj.getString("bizdatacode");
            if (SWCStringUtils.equals((String)bizDataCode, (String)(opBizDataCode = queryObj.getString("opbizdatacode")))) continue;
            returnList.add(queryObj);
        }
        return returnList;
    }

    public static QFilter getClassificationFilter() {
        return new QFilter("classification", "!=", (Object)MONTHANDYEAR_OPTION_AFTER);
    }

    public Map<String, Map<String, Object>> getSalaryFileIdByPayRollGrpId(Set<Long> personIdSet, Long payRollGroupId) {
        QFilter filter = new QFilter("person.id", "in", personIdSet);
        filter.and("payrollgroup.id", "=", (Object)payRollGroupId);
        filter.and("iscurrentversion", "=", (Object)MONTHANDYEAR_OPTION_AFTER);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection salaryFileColl = helper.queryOriginalCollection("id,person.id,org.id,payrollregion.id,status,adminorg.id,empgroup.id,payrollgroup.id,number", new QFilter[]{filter});
        HashMap<String, Map<String, Object>> queryMap = new HashMap<String, Map<String, Object>>(salaryFileColl.size());
        for (DynamicObject salaryFileObj : salaryFileColl) {
            String personIdStr = salaryFileObj.getString("person.id");
            Long salaryFileId = salaryFileObj.getLong("id");
            String status = salaryFileObj.getString("status");
            HashMap<String, Object> salaryFileMap = new HashMap<String, Object>(3);
            salaryFileMap.put("salaryFileId", salaryFileId);
            salaryFileMap.put("status", status);
            salaryFileMap.put("adminOrgId", salaryFileObj.getLong("adminorg.id"));
            salaryFileMap.put("empGroupId", salaryFileObj.getLong("empgroup.id"));
            salaryFileMap.put("payRollGroupId", salaryFileObj.getLong("payrollgroup.id"));
            salaryFileMap.put("orgId", salaryFileObj.getLong("org.id"));
            salaryFileMap.put("payRollRegionId", salaryFileObj.getLong("payrollregion.id"));
            salaryFileMap.put("salaryFileNumber", salaryFileObj.getString("number"));
            queryMap.put(personIdStr, salaryFileMap);
        }
        return queryMap;
    }

    public Map<String, Object> getPayRollGroupOrgId(Long payRollGroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "=", (Object)payRollGroupId);
        DynamicObject payRollGroupObj = helper.queryOne("org.id,org.name", new QFilter[]{filter});
        if (SWCObjectUtils.isEmpty((Object)payRollGroupObj)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> payRollGroupMap = new HashMap<String, Object>(3);
        payRollGroupMap.put("payRollGroupId", payRollGroupObj.getLong("org.id"));
        payRollGroupMap.put("payRollGroupName", payRollGroupObj.getString("org.name"));
        return payRollGroupMap;
    }
}

