/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.service;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataRecoverBsledService {
    public final Log log = LogFactory.getLog(BizDataRecoverBsledService.class);

    public void recoverBsledDatas(List<String> bizDataCodeList, String operateType, Date modifyTime, String opreason) {
        this.log.info("BizDataRecoverBsledService recoverBsledDatas bizDataCodeList is:{}", bizDataCodeList);
        BizDataHelper helper = new BizDataHelper();
        QFilter effectFilter = new QFilter("opbizdatacode", "in", bizDataCodeList);
        effectFilter.and("isabandon", "!=", (Object)"1");
        List<DynamicObject> effectBizDataList = helper.queryEffectOrAffectedBizDatas(effectFilter, true);
        if (effectBizDataList == null || effectBizDataList.size() == 0) {
            this.log.info("BizDataRecoverBsledService recoverBsledDatas effectBizDataList is null");
            return;
        }
        HashMap<String, String> effectBizDataCodeMap = new HashMap<String, String>(effectBizDataList.size());
        for (DynamicObject effectBizData : effectBizDataList) {
            effectBizDataCodeMap.put(effectBizData.getString("bizdatacode"), effectBizData.getString("opbizdatacode"));
        }
        QFilter affectedFilter = new QFilter("bizdatacode", "in", bizDataCodeList);
        affectedFilter.and("isabandon", "!=", (Object)"1");
        List<DynamicObject> affectedBizDataList = helper.queryEffectOrAffectedBizDatas(affectedFilter, false);
        Set<String> recoverBizDataCodeSet = this.filterUnCoverBizDatas(effectBizDataList, affectedBizDataList);
        if (recoverBizDataCodeSet == null || recoverBizDataCodeSet.size() == 0) {
            this.log.info("BizDataRecoverBsledService filterUnCoverBizDatas recoverBizDataCodeSet is null");
            return;
        }
        this.filterLastBizDataByStatus(recoverBizDataCodeSet);
        if (recoverBizDataCodeSet == null || recoverBizDataCodeSet.size() == 0) {
            this.log.info("BizDataRecoverBsledService filterLastBizDataByStatus recoverBizDataCodeSet is null");
            return;
        }
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter recurFilter = new QFilter("identifynumber", "in", recoverBizDataCodeSet);
        recurFilter.and("auditstatus", "=", (Object)"C");
        DynamicObject[] recurBizDatas = recurBizHelper.query("id,salaryfile.id,bizitem.id,bsled,identifynumber,modifier,modifytime,datasources,bsed,bsled", new QFilter[]{recurFilter});
        if (recurBizDatas == null || recurBizDatas.length == 0) {
            return;
        }
        HashSet<Long> salaryFileIds = new HashSet<Long>(recurBizDatas.length);
        HashSet<Long> bizItemIds = new HashSet<Long>(recurBizDatas.length);
        for (DynamicObject recurBizData : recurBizDatas) {
            Long salaryFileId = recurBizData.getLong("salaryfile.id");
            Long bizItemId = recurBizData.getLong("bizitem.id");
            salaryFileIds.add(salaryFileId);
            bizItemIds.add(bizItemId);
        }
        Table<Long, Long, List<DynamicObject>> recurBizDataTable = helper.getRecurBizData(salaryFileIds, bizItemIds);
        ArrayList<DynamicObject> needRecoverDataList = new ArrayList<DynamicObject>(recurBizDatas.length);
        for (DynamicObject recurBizData : recurBizDatas) {
            if (!this.checkUpdateBsled(recurBizData, recurBizDataTable)) continue;
            needRecoverDataList.add(recurBizData);
        }
        if (needRecoverDataList.size() == 0) {
            this.log.info("BizDataRecoverBsledService needRecoverDataList is null");
            return;
        }
        DynamicObject[] needAbandonDatas = this.buildNeedUpdateBsledInfo(needRecoverDataList, effectBizDataList, modifyTime);
        HashMap<String, Date> beforeBsledMap = new HashMap<String, Date>(effectBizDataList.size());
        for (DynamicObject effectBizData : effectBizDataList) {
            String bizDataCode = effectBizData.getString("bizdatacode");
            Date beforeBsled = effectBizData.getDate("beforebsled");
            beforeBsledMap.put(bizDataCode, beforeBsled);
        }
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] bsledSaveDatas = new DynamicObject[needRecoverDataList.size()];
        ArrayList<BizDataModifyRecEntity> dataModifyRecsList = new ArrayList<BizDataModifyRecEntity>(10);
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        for (int index = 0; index < needRecoverDataList.size(); ++index) {
            DynamicObject needRecoverData = (DynamicObject)needRecoverDataList.get(index);
            String bizDataCode = needRecoverData.getString("identifynumber");
            DynamicObject bsledSaveData = bsledHelper.generateEmptyDynamicObject();
            bsledSaveData.set("salaryfile", needRecoverData.get("salaryfile.id"));
            bsledSaveData.set("bizitem", needRecoverData.get("bizitem.id"));
            bsledSaveData.set("bizdatacode", (Object)bizDataCode);
            bsledSaveData.set("opbizdatacode", effectBizDataCodeMap.get(bizDataCode));
            Date beforeBsled = needRecoverData.getDate("bsled");
            bsledSaveData.set("beforebsled", (Object)beforeBsled);
            Date afterBsled = (Date)beforeBsledMap.get(bizDataCode);
            bsledSaveData.set("afterbsled", (Object)afterBsled);
            bsledSaveData.set("optype", (Object)operateType);
            bsledSaveData.set("modifier", (Object)userId);
            bsledSaveData.set("modifytime", (Object)modifyTime);
            bsledSaveData.set("isabandon", (Object)"1");
            bsledSaveDatas[index] = bsledSaveData;
            needRecoverData.set("bsled", beforeBsledMap.get(bizDataCode));
            needRecoverData.set("modifier", (Object)userId);
            if (modifyTime != null) {
                needRecoverData.set("modifytime", (Object)modifyTime);
            } else {
                needRecoverData.set("modifytime", (Object)new Date());
            }
            BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(needRecoverData.getLong("salaryfile.id"));
            dataModifyRec.setBizDataNum(bizDataCode);
            dataModifyRec.setOpBizDataNum((String)effectBizDataCodeMap.get(bizDataCode));
            dataModifyRec.setBizItemId(needRecoverData.getLong("bizitem.id"));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            if (beforeBsled != null) {
                String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
                dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
            }
            if (afterBsled != null) {
                String afterUpdateBsed = SWCDateTimeUtils.format((Date)afterBsled, (String)"yyyy-MM-dd");
                dataModifyRec.setAfterUpdate(afterUpdateBsed);
            }
            dataModifyRec.setDataSources(needRecoverData.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_REJECT.getCode());
            dataModifyRec.setDataId(needRecoverData.getLong("id"));
            dataModifyRec.setModelType("1");
            dataModifyRec.setDescription(opreason);
            dataModifyRecsList.add(dataModifyRec);
        }
        DynamicObject[] needUpdateArray = new DynamicObject[needRecoverDataList.size()];
        for (int index = 0; index < needRecoverDataList.size(); ++index) {
            needUpdateArray[index] = (DynamicObject)needRecoverDataList.get(index);
        }
        ArrayList paramList = new ArrayList(needRecoverDataList.size());
        for (DynamicObject needRecoverData : needRecoverDataList) {
            String dataSources = needRecoverData.getString("datasources");
            if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            String bizDataCode = needRecoverData.getString("identifynumber");
            paramMap.put("bizdatacode", bizDataCode);
            paramMap.put("operatebizdatacode", effectBizDataCodeMap.get(bizDataCode));
            paramMap.put("bizitem", needRecoverData.getLong("bizitem.id"));
            paramMap.put("salaryfile", needRecoverData.getLong("salaryfile.id"));
            paramMap.put("modeltype", "1");
            paramMap.put("operate", operateType);
            paramMap.put("bsled", beforeBsledMap.get(bizDataCode));
            paramMap.put("modifier", userId);
            paramList.add(paramMap);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (needUpdateArray.length > 0) {
                recurBizHelper.update(needUpdateArray);
            }
            if (dataModifyRecsList.size() > 0) {
                BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecsList);
            }
            if (paramList.size() > 0) {
                Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{paramList});
                this.log.info("BizDataRecoverBsledService updateBizData is:{}", (Object)result);
            }
            if (bsledSaveDatas.length > 0) {
                bsledHelper.save(bsledSaveDatas);
            }
            if (needAbandonDatas != null && needAbandonDatas.length > 0) {
                bsledHelper.update(needAbandonDatas);
            }
        }
    }

    private DynamicObject[] buildNeedUpdateBsledInfo(List<DynamicObject> needRecoverDataList, List<DynamicObject> effectBizDataList, Date modifyTime) {
        HashSet<String> bizDataCodeSet = new HashSet<String>(needRecoverDataList.size());
        for (DynamicObject needRecoverData : needRecoverDataList) {
            bizDataCodeSet.add(needRecoverData.getString("identifynumber"));
        }
        ArrayList<DynamicObject> needUpdateList = new ArrayList<DynamicObject>(effectBizDataList.size());
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject effectBizData : effectBizDataList) {
            String bizDataCode = effectBizData.getString("bizdatacode");
            if (!bizDataCodeSet.contains(bizDataCode)) continue;
            effectBizData.set("isabandon", (Object)"1");
            effectBizData.set("modifier", (Object)userId);
            effectBizData.set("modifytime", (Object)modifyTime);
            needUpdateList.add(effectBizData);
        }
        if (needUpdateList.size() == 0) {
            return new DynamicObject[0];
        }
        DynamicObject[] needUpdateArray = new DynamicObject[needUpdateList.size()];
        for (int index = 0; index < needUpdateList.size(); ++index) {
            needUpdateArray[index] = (DynamicObject)needUpdateList.get(index);
        }
        return needUpdateArray;
    }

    private boolean checkUpdateBsled(DynamicObject data, Table<Long, Long, List<DynamicObject>> recurBizData) {
        BizDataHelper bizDataHelper;
        List<String> errorIdentifyNumList;
        String identifyNumber = data.getString("identifynumber");
        Long salaryFileId = data.getLong("salaryfile.id");
        Long bizItemId = data.getLong("bizitem.id");
        Date newBsled = data.getDate("bsled");
        Date newBsed = data.getDate("bsed");
        List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
        return dynamicObjects == null || dynamicObjects.size() <= 0 || (errorIdentifyNumList = (bizDataHelper = new BizDataHelper()).getUpdateBsledErrorList(newBsed, newBsled, dynamicObjects, identifyNumber)).size() <= 0;
    }

    public void filterLastBizDataByStatus(Set<String> recoverBizDataCodeSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        QFilter filter = new QFilter("bizdatacode", "in", recoverBizDataCodeSet);
        filter.and("isabandon", "!=", (Object)"1");
        String orderBy = "bizdatacode asc, modifytime asc";
        DynamicObject[] queryDatas = helper.query("bizdatacode,optype", new QFilter[]{filter}, orderBy);
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        HashMap<String, String> optypeMap = new HashMap<String, String>(queryDatas.length);
        for (DynamicObject queryObj : queryDatas) {
            String bizdatacode = queryObj.getString("bizdatacode");
            String opType = queryObj.getString("optype");
            optypeMap.put(bizdatacode, opType);
        }
        HashSet needFilterSet = new HashSet(16);
        for (Map.Entry entry : optypeMap.entrySet()) {
            String opType = (String)entry.getValue();
            if (!SWCStringUtils.equals((String)opType, (String)BizDataOperateEnum.OPERATE_ITF_UPDATE.getCode()) && !SWCStringUtils.equals((String)opType, (String)BizDataOperateEnum.OPERATE_UPDATE.getCode()) && !SWCStringUtils.equals((String)opType, (String)BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode())) continue;
            needFilterSet.add(entry.getKey());
        }
        this.log.info("filterLastBizDataByStatus needFilterSet is:{}", needFilterSet);
        recoverBizDataCodeSet.removeAll(needFilterSet);
    }

    public Set<String> filterUnCoverBizDatas(List<DynamicObject> effectBizDataList, List<DynamicObject> affectedBizDataList) {
        HashSet<String> effectBizDataCodeSet = new HashSet<String>(effectBizDataList.size());
        HashMap<String, String> effectMap = new HashMap<String, String>(effectBizDataList.size());
        for (DynamicObject dynamicObject : effectBizDataList) {
            String bizDataCode = dynamicObject.getString("bizdatacode");
            String opBizDataCode = dynamicObject.getString("opbizdatacode");
            effectMap.put(opBizDataCode, bizDataCode);
        }
        for (Map.Entry entry : effectMap.entrySet()) {
            effectBizDataCodeSet.add((String)entry.getValue());
        }
        if (affectedBizDataList == null || affectedBizDataList.size() == 0) {
            return effectBizDataCodeSet;
        }
        HashSet<String> affectedBizDataCodeSet = new HashSet<String>(affectedBizDataList.size());
        for (DynamicObject affectedObj : affectedBizDataList) {
            String bizDataCode = affectedObj.getString("bizdatacode");
            String affectedBizDataCode = (String)effectMap.get(bizDataCode);
            if (!SWCStringUtils.isNotEmpty((String)affectedBizDataCode)) continue;
            affectedBizDataCodeSet.add(affectedBizDataCode);
        }
        this.log.info("filterUnCoverBizDatas affectedBizDataCodeSet is:{}", affectedBizDataCodeSet);
        effectBizDataCodeSet.removeAll(affectedBizDataCodeSet);
        return effectBizDataCodeSet;
    }
}

