/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataRollBackService {
    private final Log log = LogFactory.getLog(BizDataRollBackService.class);
    private static final int ROLLBACK_BATCHSIZE = 500;
    private static final String HPDI_TAG = "hpdi";
    private static Set<String> cannotRollBackOpType = new HashSet<String>(16);
    private static Set<String> cannotRecoverOpTypes = new HashSet<String>(16);

    public Map<String, Object> rollBackBizData(Map<String, Object> params) {
        this.log.info("BizDataRollBackService rollBackBizData params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        List dataMapList = (List)params.get("data");
        if (CollectionUtils.isEmpty((Collection)dataMapList)) {
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, null, "data is empty");
            return responseMap;
        }
        String opSystem = MapUtils.getString(params, (Object)"opsystem");
        if (SWCStringUtils.isEmpty((String)opSystem)) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1080.getCode();
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, errorCode, BizDataFailStatusEnum.getDesc((String)errorCode));
            return responseMap;
        }
        if (dataMapList.size() > 500) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1024.getCode();
            String msg = MessageFormat.format(BizDataFailStatusEnum.getDesc((String)errorCode), 500);
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, errorCode, msg);
            return responseMap;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataMapList.size());
        HashSet<String> bizDataCodeSet = new HashSet<String>(dataMapList.size());
        HashSet<Long> bizItemIdSet = new HashSet<Long>(dataMapList.size());
        for (Map dataMap : dataMapList) {
            Long bizItemId = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            bizItemIdSet.add(bizItemId);
            bizDataCodeSet.add(MapUtils.getString((Map)dataMap, (Object)"bizdatacode"));
        }
        Map<Long, Boolean> bizItemRecurMap = this.getBizItemMap(bizItemIdSet);
        HashMap<String, Long> bizDataCodeAndItemRelMap = new HashMap<String, Long>(dataMapList.size());
        SWCDataServiceHelper modifyRecHelper = new SWCDataServiceHelper("hsas_bizdatamodifyrecord");
        QFilter modifyRecFilter = new QFilter("bizdatanum", "in", bizDataCodeSet);
        modifyRecFilter.and("operate", "=", (Object)BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
        DynamicObject[] transPayRollGrpDatas = modifyRecHelper.query("bizdatanum", new QFilter[]{modifyRecFilter});
        HashSet<String> transGrpBizDataCodeSet = new HashSet<String>(16);
        if (transPayRollGrpDatas != null) {
            for (DynamicObject transPayRollGrpObj : transPayRollGrpDatas) {
                transGrpBizDataCodeSet.add(transPayRollGrpObj.getString("bizdatanum"));
            }
        }
        for (Map dataMap : dataMapList) {
            HashMap<String, String> resltMap;
            Long bizItemId = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            String bizDataCode = MapUtils.getString((Map)dataMap, (Object)"bizdatacode");
            Boolean isRecur = bizItemRecurMap.get(bizItemId);
            if (isRecur == null) {
                resltMap = new HashMap<String, String>(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1021.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1021.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            if (!isRecur.booleanValue()) {
                resltMap = new HashMap(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1103.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1103.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            if (transGrpBizDataCodeSet.contains(bizDataCode)) {
                resltMap = new HashMap(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1150.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1150.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            bizDataCodeAndItemRelMap.put(bizDataCode, bizItemId);
        }
        if (bizDataCodeAndItemRelMap.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        QFilter bizDataFilter = new QFilter("identifynumber", "in", bizDataCodeAndItemRelMap.keySet());
        bizDataFilter.and("opsystem", "=", (Object)opSystem);
        SWCDataServiceHelper recurBizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        String orderBy = "bsed desc";
        DynamicObject[] bizDataColl = bizDataHelper.getBizDataOrderByColl(recurBizDataHelper, bizDataFilter, orderBy);
        HashMap<String, Long> queryBizDataCodeAndItemRelMap = new HashMap<String, Long>(bizDataColl.length);
        HashMap<String, Integer> queryBizDataCodeAndUsageCountMap = new HashMap<String, Integer>(bizDataColl.length);
        HashMap<String, Integer> bizDataCodeAndNoCountTimesMap = new HashMap<String, Integer>(bizDataColl.length);
        for (DynamicObject bizDataObj : bizDataColl) {
            String bizDataCode = bizDataObj.getString("identifynumber");
            queryBizDataCodeAndItemRelMap.put(bizDataCode, bizDataObj.getLong("bizitem.id"));
            queryBizDataCodeAndUsageCountMap.put(bizDataCode, bizDataObj.getInt("usagecount"));
            bizDataCodeAndNoCountTimesMap.put(bizDataCode, bizDataObj.getInt("nocounttimes"));
        }
        HashSet<String> checkPassBizDataCodeSet = new HashSet<String>(16);
        for (Map.Entry entry : bizDataCodeAndItemRelMap.entrySet()) {
            String bizDataCode = (String)entry.getKey();
            Long bizItemId = (Long)entry.getValue();
            Long queryBizItemId = (Long)queryBizDataCodeAndItemRelMap.get(bizDataCode);
            if (queryBizItemId == null || bizItemId.longValue() != queryBizItemId.longValue()) {
                HashMap<String, String> resltMap = new HashMap<String, String>(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1022.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1022.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            Integer queryUsageCount = (Integer)queryBizDataCodeAndUsageCountMap.get(bizDataCode);
            Integer noCountTimes = (Integer)bizDataCodeAndNoCountTimesMap.get(bizDataCode);
            if (queryUsageCount == null) {
                queryUsageCount = 0;
            }
            if (noCountTimes == null) {
                noCountTimes = 0;
            }
            if ((queryUsageCount = Integer.valueOf(queryUsageCount + noCountTimes)) > 0) {
                HashMap<String, String> resltMap = new HashMap<String, String>(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1050.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1050.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            checkPassBizDataCodeSet.add(bizDataCode);
        }
        if (checkPassBizDataCodeSet.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<DynamicObject> bizDataList = new ArrayList<DynamicObject>(10);
        for (DynamicObject bizDataObj : bizDataColl) {
            String bizDataCode = bizDataObj.getString("identifynumber");
            if (!checkPassBizDataCodeSet.contains(bizDataCode)) continue;
            bizDataList.add(bizDataObj);
        }
        List<Map<String, Object>> calHPDIBizDataList = this.doRollBackEvent(bizDataList, resultList, opSystem);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        responseMap.put("calHPDIBizDataList", calHPDIBizDataList);
        return responseMap;
    }

    private void buildErrorResponseMap(Map<String, Object> responseMap, Boolean sueecss, String errorcode, String message) {
        responseMap.put("sueecss", sueecss);
        responseMap.put("errorcode", errorcode);
        responseMap.put("message", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> doRollBackEvent(List<DynamicObject> bizDataList, List<Map<String, Object>> resultList, String opSystem) {
        HashMap<String, DynamicObject> latestRelatedDataMap = new HashMap<String, DynamicObject>(16);
        Table<Long, Long, Set<DynamicObject>> bizDataTable = this.getAllBizDataTable(bizDataList, latestRelatedDataMap);
        HashMap<String, List<DynamicObject>> effectBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        HashMap<String, List<DynamicObject>> affectedBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        this.getBizDataBsledInfo(bizDataList, effectBizDataMap, affectedBizDataMap);
        ArrayList<String> needRollBackBizDataCodeList = new ArrayList<String>(10);
        ArrayList<Map<String, Object>> calHPDIBizDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> needAbandonBsledBizDataCodeList = new ArrayList<String>(10);
        ArrayList<DynamicObject> needRecoverBizDataList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needAddBizDataBsledRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<BizDataModifyRecEntity> needSaveLogDataList = new ArrayList<BizDataModifyRecEntity>(10);
        Long userId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        for (DynamicObject bizDataObj : bizDataList) {
            Long bizItemId;
            String bizDataCode = bizDataObj.getString("identifynumber");
            List affectedBizDataList = (List)affectedBizDataMap.get(bizDataCode);
            if (affectedBizDataList != null && affectedBizDataList.size() > 0 && !this.checkAllowRollback(affectedBizDataList)) {
                HashMap<String, String> resltMap = new HashMap<String, String>(4);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1150.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1150.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
                continue;
            }
            List effectBizDataList = (List)effectBizDataMap.get(bizDataCode);
            String affectedBizDataCode = this.isEffectOtherBizDataCode(effectBizDataList, bizDataCode);
            if (SWCStringUtils.isEmpty((String)affectedBizDataCode)) {
                needRollBackBizDataCodeList.add(bizDataCode);
                needAbandonBsledBizDataCodeList.add(bizDataCode);
                effectBizDataMap.remove(bizDataCode);
                affectedBizDataMap.remove(bizDataCode);
                this.delBizDataBySalaryFileAndBizItem(bizDataTable, bizDataObj);
                continue;
            }
            Long salaryFileId = bizDataObj.getLong("salaryfile.id");
            DynamicObject[] allBizDataSet = (DynamicObject[])bizDataTable.get((Object)salaryFileId, (Object)(bizItemId = Long.valueOf(bizDataObj.getLong("bizitem.id"))));
            if (!this.checkBizDataAuditStatus(affectedBizDataCode, (Set<DynamicObject>)allBizDataSet, bizDataObj)) {
                needRollBackBizDataCodeList.add(bizDataCode);
                needAbandonBsledBizDataCodeList.add(bizDataCode);
                effectBizDataMap.remove(bizDataCode);
                affectedBizDataMap.remove(bizDataCode);
                this.delBizDataBySalaryFileAndBizItem(bizDataTable, bizDataObj);
                continue;
            }
            if (this.checkBizDataBsledRecover(affectedBizDataCode, bizDataCode, bizDataObj, effectBizDataList, (Set<DynamicObject>)allBizDataSet)) {
                needRollBackBizDataCodeList.add(bizDataCode);
                needAbandonBsledBizDataCodeList.add(bizDataCode);
                effectBizDataMap.remove(bizDataCode);
                affectedBizDataMap.remove(bizDataCode);
                this.delBizDataBySalaryFileAndBizItem(bizDataTable, bizDataObj);
                continue;
            }
            if (!this.checkLatestRecordOpTypeRecover(affectedBizDataCode, latestRelatedDataMap)) {
                needRollBackBizDataCodeList.add(bizDataCode);
                needAbandonBsledBizDataCodeList.add(bizDataCode);
                effectBizDataMap.remove(bizDataCode);
                affectedBizDataMap.remove(bizDataCode);
                this.delBizDataBySalaryFileAndBizItem(bizDataTable, bizDataObj);
                continue;
            }
            Map<String, Object> recoverBsledMap = this.recoverAffectedBizdataBsled(affectedBizDataCode, bizDataObj, effectBizDataList, (Set<DynamicObject>)allBizDataSet, needRecoverBizDataList, userId, modifyTime);
            this.buildAddBizDataBsledRecordData(affectedBizDataCode, bizDataCode, recoverBsledMap, needAddBizDataBsledRecordList, needSaveLogDataList, bizDataObj, userId, modifyTime, opSystem);
            this.buildCalHPDIBizData(calHPDIBizDataList, affectedBizDataCode, bizDataCode, bizDataObj, recoverBsledMap, userId);
            needRollBackBizDataCodeList.add(bizDataCode);
            needAbandonBsledBizDataCodeList.add(bizDataCode);
            effectBizDataMap.remove(bizDataCode);
            affectedBizDataMap.remove(bizDataCode);
            affectedBizDataMap.remove(affectedBizDataCode);
            this.delBizDataBySalaryFileAndBizItem(bizDataTable, bizDataObj);
        }
        String statusFlag = "";
        String code = null;
        String errorMsg = null;
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper recurBizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
            if (needRecoverBizDataList.size() > 0) {
                int size = needRecoverBizDataList.size();
                DynamicObject[] needRecoverBizDataArray = new DynamicObject[size];
                for (int index = 0; index < size; ++index) {
                    needRecoverBizDataArray[index] = (DynamicObject)needRecoverBizDataList.get(index);
                }
                recurBizDataHelper.update(needRecoverBizDataArray);
            }
            if (needRollBackBizDataCodeList.size() > 0) {
                QFilter recurBizDataFilter = new QFilter("identifynumber", "in", needRollBackBizDataCodeList);
                recurBizDataHelper.deleteByFilter(new QFilter[]{recurBizDataFilter});
            }
            SWCDataServiceHelper bizDataBsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
            if (needAbandonBsledBizDataCodeList.size() > 0) {
                DynamicObject[] bizDataBsledRecordDatas;
                QFilter bizDataBsledRecord = new QFilter("bizdatacode", "in", needAbandonBsledBizDataCodeList);
                bizDataBsledRecord.or("opbizdatacode", "in", needAbandonBsledBizDataCodeList);
                bizDataBsledRecord.and("isabandon", "!=", (Object)"1");
                for (DynamicObject bizDataBsledRecordObj : bizDataBsledRecordDatas = bizDataBsledRecordHelper.query("id,isabandon,modifytime,modifier", new QFilter[]{bizDataBsledRecord})) {
                    bizDataBsledRecordObj.set("isabandon", (Object)"1");
                    bizDataBsledRecordObj.set("modifytime", (Object)modifyTime);
                    bizDataBsledRecordObj.set("modifier", (Object)userId);
                }
                bizDataBsledRecordHelper.update(bizDataBsledRecordDatas);
            }
            if (needAddBizDataBsledRecordList.size() > 0) {
                int size = needAddBizDataBsledRecordList.size();
                DynamicObject[] needAddBizDataBsledRecordArray = new DynamicObject[size];
                for (int index = 0; index < size; ++index) {
                    needAddBizDataBsledRecordArray[index] = (DynamicObject)needAddBizDataBsledRecordList.get(index);
                }
                bizDataBsledRecordHelper.save(needAddBizDataBsledRecordArray);
            }
            if (needSaveLogDataList.size() > 0) {
                this.log.info("BizDataRollBackService save bizData log");
                BizDataModifyRecHelper.saveBizDataModifyRec(needSaveLogDataList);
            }
            for (String bizDataCode : needRollBackBizDataCodeList) {
                HashMap<String, String> resltMap = new HashMap<String, String>(4);
                statusFlag = "1";
                resltMap.put("bizdatacode", bizDataCode);
                resltMap.put("status", statusFlag);
                resltMap.put("errorcode", code);
                resltMap.put("errormsg", errorMsg);
                resultList.add(resltMap);
            }
            ArrayList<Map<String, Object>> size = calHPDIBizDataList;
            return size;
        }
    }

    private void buildCalHPDIBizData(List<Map<String, Object>> calHPDIBizDataList, String affectedBizDataCode, String effectBizDataCode, DynamicObject bizDataObj, Map<String, Object> recoverBsledMap, Long userId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("bizdatacode", affectedBizDataCode);
        paramMap.put("operatebizdatacode", effectBizDataCode);
        paramMap.put("bizitem", bizDataObj.getLong("bizitem.id"));
        paramMap.put("salaryfile", bizDataObj.getLong("salaryfile.id"));
        paramMap.put("modeltype", "1");
        paramMap.put("operate", BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode());
        if (recoverBsledMap != null) {
            paramMap.put("bsled", recoverBsledMap.get("afterbsled"));
        }
        paramMap.put("modifier", userId);
        calHPDIBizDataList.add(paramMap);
    }

    private void buildAddBizDataBsledRecordData(String affectedBizDataCode, String effectBizDataCode, Map<String, Object> recoverBsledMap, List<DynamicObject> needAddBizDataBsledRecordList, List<BizDataModifyRecEntity> needSaveLogDataList, DynamicObject bizDataObj, Long userId, Date modifyTime, String opSystem) {
        String datasources;
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        DynamicObject bsledSaveData = bsledHelper.generateEmptyDynamicObject();
        Long salaryFileId = bizDataObj.getLong("salaryfile.id");
        bsledSaveData.set("salaryfile", (Object)salaryFileId);
        Long bizItemId = bizDataObj.getLong("bizitem.id");
        bsledSaveData.set("bizitem", (Object)bizItemId);
        bsledSaveData.set("bizdatacode", (Object)affectedBizDataCode);
        bsledSaveData.set("opbizdatacode", (Object)effectBizDataCode);
        Date beforeBsled = (Date)recoverBsledMap.get("beforebsled");
        bsledSaveData.set("beforebsled", (Object)beforeBsled);
        Date afterBsled = (Date)recoverBsledMap.get("afterbsled");
        bsledSaveData.set("afterbsled", (Object)afterBsled);
        if (SWCStringUtils.equals((String)opSystem, (String)HPDI_TAG)) {
            bsledSaveData.set("optype", (Object)BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode());
        } else {
            bsledSaveData.set("optype", (Object)BizDataOperateEnum.OPERATE_ITF_ROLLBACK.getCode());
        }
        bsledSaveData.set("modifier", (Object)userId);
        bsledSaveData.set("modifytime", (Object)modifyTime);
        bsledSaveData.set("isabandon", (Object)"1");
        needAddBizDataBsledRecordList.add(bsledSaveData);
        BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
        dataModifyRec.setSalaryFileId(salaryFileId);
        dataModifyRec.setBizDataNum(affectedBizDataCode);
        dataModifyRec.setOpBizDataNum(effectBizDataCode);
        dataModifyRec.setBizItemId(bizItemId);
        dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
        if (beforeBsled != null) {
            String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
            dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
        }
        if (afterBsled != null) {
            String afterUpdateBsed = SWCDateTimeUtils.format((Date)afterBsled, (String)"yyyy-MM-dd");
            dataModifyRec.setAfterUpdate(afterUpdateBsed);
        }
        if (SWCStringUtils.isNotEmpty((String)(datasources = (String)recoverBsledMap.get("datasources")))) {
            dataModifyRec.setDataSources(datasources);
        }
        if (SWCStringUtils.equals((String)opSystem, (String)HPDI_TAG)) {
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode());
        } else {
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ITF_ROLLBACK.getCode());
        }
        Long affectedBizDataId = (Long)recoverBsledMap.get("affectedBizDataId");
        if (affectedBizDataId != null) {
            dataModifyRec.setDataId(affectedBizDataId);
        }
        dataModifyRec.setModelType("1");
        needSaveLogDataList.add(dataModifyRec);
    }

    private Map<String, Object> recoverAffectedBizdataBsled(String affectedBizDataCode, DynamicObject bizDataObj, List<DynamicObject> effectBizDataList, Set<DynamicObject> allBizDataSet, List<DynamicObject> needRecoverBizDataList, Long userId, Date modifyTime) {
        Date affectedBizDataBsled = null;
        for (DynamicObject effectBizDataObj : effectBizDataList) {
            String bizDataCode = effectBizDataObj.getString("bizdatacode");
            String opBizDataCode = effectBizDataObj.getString("opbizdatacode");
            if (!SWCStringUtils.equals((String)affectedBizDataCode, (String)bizDataCode) || !SWCStringUtils.equals((String)bizDataObj.getString("identifynumber"), (String)opBizDataCode)) continue;
            affectedBizDataBsled = effectBizDataObj.getDate("beforebsled");
            break;
        }
        HashMap<String, Object> bsledMap = new HashMap<String, Object>(3);
        for (DynamicObject dynamicObj : allBizDataSet) {
            String bizDataCode = dynamicObj.getString("identifynumber");
            if (!SWCStringUtils.equals((String)bizDataCode, (String)affectedBizDataCode)) continue;
            bsledMap.put("beforebsled", dynamicObj.getDate("bsled"));
            bsledMap.put("afterbsled", affectedBizDataBsled);
            bsledMap.put("affectedBizDataId", dynamicObj.getLong("id"));
            bsledMap.put("datasources", dynamicObj.getString("datasources"));
            dynamicObj.set("bsled", (Object)affectedBizDataBsled);
            dynamicObj.set("modifytime", (Object)modifyTime);
            dynamicObj.set("modifier", (Object)userId);
            needRecoverBizDataList.add(dynamicObj);
            break;
        }
        return bsledMap;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkBizDataBsledRecover(String affectedBizDataCode, String effectBizDataCode, DynamicObject bizDataObj, List<DynamicObject> effectBizDataList, Set<DynamicObject> allBizDataSet) {
        void var10_14;
        Long affectedBizDataId = null;
        HashSet<Long> checkBizDataIdSet = new HashSet<Long>(2);
        Date affectedBizDataBsed = null;
        for (DynamicObject dynamicObject : allBizDataSet) {
            String string = dynamicObject.getString("identifynumber");
            if (!SWCStringUtils.equals((String)string, (String)affectedBizDataCode)) continue;
            affectedBizDataId = dynamicObject.getLong("id");
            affectedBizDataBsed = dynamicObject.getDate("bsed");
            checkBizDataIdSet.add(affectedBizDataId);
            break;
        }
        Long effectBizDataId = null;
        for (DynamicObject dynamicObject : allBizDataSet) {
            String bizDataCode = dynamicObject.getString("identifynumber");
            if (!SWCStringUtils.equals((String)bizDataCode, (String)effectBizDataCode)) continue;
            effectBizDataId = dynamicObject.getLong("id");
            checkBizDataIdSet.add(effectBizDataId);
            break;
        }
        Object var10_12 = null;
        for (DynamicObject effectBizDataObj : effectBizDataList) {
            String bizDataCode = effectBizDataObj.getString("bizdatacode");
            String opBizDataCode = effectBizDataObj.getString("opbizdatacode");
            if (!SWCStringUtils.equals((String)affectedBizDataCode, (String)bizDataCode) || !SWCStringUtils.equals((String)bizDataObj.getString("identifynumber"), (String)opBizDataCode)) continue;
            Date date = effectBizDataObj.getDate("beforebsled");
            break;
        }
        if (affectedBizDataId == null) {
            return false;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        return !bizDataHelper.checkRecoverBsledIsOverlap(checkBizDataIdSet, (Date)var10_14, affectedBizDataBsed, allBizDataSet);
    }

    private boolean checkBizDataAuditStatus(String affectedBizDataCode, Set<DynamicObject> allBizDataSet, DynamicObject bizDataObj) {
        if (allBizDataSet == null || allBizDataSet.size() == 0) {
            return false;
        }
        for (DynamicObject checkBizDataObj : allBizDataSet) {
            String checkBizDataCode = checkBizDataObj.getString("identifynumber");
            if (!SWCStringUtils.equals((String)checkBizDataCode, (String)affectedBizDataCode)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLatestRecordOpTypeRecover(String affectedBizDataCode, Map<String, DynamicObject> latestRelatedDataMap) {
        DynamicObject bsledRecord = latestRelatedDataMap.get(affectedBizDataCode);
        if (SWCObjectUtils.isEmpty((Object)bsledRecord)) {
            return true;
        }
        return !cannotRecoverOpTypes.contains(bsledRecord.getString("optype"));
    }

    private void delBizDataBySalaryFileAndBizItem(Table<Long, Long, Set<DynamicObject>> bizDataTable, DynamicObject bizDataObj) {
        Long bizItemId;
        Long salaryFileId = bizDataObj.getLong("salaryfile.id");
        Set bizDataSet = (Set)bizDataTable.get((Object)salaryFileId, (Object)(bizItemId = Long.valueOf(bizDataObj.getLong("bizitem.id"))));
        if (bizDataSet == null || bizDataSet.size() == 0) {
            return;
        }
        String bizDataCode = bizDataObj.getString("identifynumber");
        HashSet<DynamicObject> newBizDataSet = new HashSet<DynamicObject>(bizDataSet.size());
        for (DynamicObject obj : bizDataSet) {
            String checkBizDataCode = obj.getString("identifynumber");
            if (SWCStringUtils.equals((String)bizDataCode, (String)checkBizDataCode)) continue;
            newBizDataSet.add(obj);
        }
        bizDataTable.put((Object)salaryFileId, (Object)bizItemId, newBizDataSet);
    }

    private String isEffectOtherBizDataCode(List<DynamicObject> effectBizDataList, String checkBizDataCode) {
        if (effectBizDataList == null || effectBizDataList.size() == 0) {
            return null;
        }
        for (DynamicObject effectBizDataObj : effectBizDataList) {
            String opBizDataCode = effectBizDataObj.getString("opbizdatacode");
            String bizDataCode = effectBizDataObj.getString("bizdatacode");
            String isAbandon = effectBizDataObj.getString("isabandon");
            if (!SWCStringUtils.equals((String)opBizDataCode, (String)checkBizDataCode) || SWCStringUtils.equals((String)bizDataCode, (String)checkBizDataCode) || SWCStringUtils.equals((String)isAbandon, (String)"1")) continue;
            return bizDataCode;
        }
        return null;
    }

    private boolean checkAllowRollback(List<DynamicObject> affectedBizDataList) {
        boolean result = true;
        for (DynamicObject affectedBizData : affectedBizDataList) {
            if ("1".equals(affectedBizData.getString("isabandon")) || !cannotRollBackOpType.contains(affectedBizData.getString("optype"))) continue;
            result = false;
            break;
        }
        return result;
    }

    private void getBizDataBsledInfo(List<DynamicObject> bizDataList, Map<String, List<DynamicObject>> effectBizDataMap, Map<String, List<DynamicObject>> affectedBizDataMap) {
        HashSet<String> bizDataCodeSet = new HashSet<String>(bizDataList.size());
        for (DynamicObject bizDataObj : bizDataList) {
            bizDataCodeSet.add(bizDataObj.getString("identifynumber"));
        }
        if (bizDataCodeSet.size() == 0) {
            return;
        }
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        QFilter filter = new QFilter("bizdatacode", "in", bizDataCodeSet);
        filter.or("opbizdatacode", "in", bizDataCodeSet);
        filter.and("isabandon", "!=", (Object)"1");
        String orderBy = "modifytime desc";
        String queryField = "bizdatacode,opbizdatacode,beforebsled,afterbsled,optype,isabandon";
        DynamicObject[] bsledRecordDatas = bsledHelper.query(queryField, new QFilter[]{filter}, orderBy);
        if (bsledRecordDatas == null || bsledRecordDatas.length == 0) {
            return;
        }
        for (DynamicObject bsledRecordObj : bsledRecordDatas) {
            String bizDataCode = bsledRecordObj.getString("bizdatacode");
            List<DynamicObject> affectedBizDataList = affectedBizDataMap.get(bizDataCode);
            if (affectedBizDataList == null) {
                affectedBizDataList = new ArrayList<DynamicObject>(10);
                affectedBizDataMap.put(bizDataCode, affectedBizDataList);
            }
            affectedBizDataList.add(bsledRecordObj);
            String opBizDataCode = bsledRecordObj.getString("opbizdatacode");
            List<DynamicObject> effectBizDataList = effectBizDataMap.get(opBizDataCode);
            if (effectBizDataList == null) {
                effectBizDataList = new ArrayList<DynamicObject>(10);
                effectBizDataMap.put(opBizDataCode, effectBizDataList);
            }
            effectBizDataList.add(bsledRecordObj);
        }
    }

    private Table<Long, Long, Set<DynamicObject>> getAllBizDataTable(List<DynamicObject> bizDataList, Map<String, DynamicObject> latestRelatedDataMap) {
        HashMap<Long, HashSet<Long>> salaryFileIdAndBizItemIdRelMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
        for (DynamicObject bizDataObj : bizDataList) {
            Long salaryFileId = bizDataObj.getLong("salaryfile.id");
            long bizItemId = bizDataObj.getLong("bizitem.id");
            salaryFileIdSet.add(salaryFileId);
            bizItemIdSet.add(bizItemId);
            HashSet<Long> cacheBizItemIdSet = (HashSet<Long>)salaryFileIdAndBizItemIdRelMap.get(salaryFileId);
            if (cacheBizItemIdSet == null) {
                cacheBizItemIdSet = new HashSet<Long>(16);
            }
            cacheBizItemIdSet.add(bizItemId);
            salaryFileIdAndBizItemIdRelMap.put(salaryFileId, cacheBizItemIdSet);
        }
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        filter.and("bizitem.id", "in", bizItemIdSet);
        filter.and("auditstatus", "=", (Object)"C");
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        DynamicObject[] failDatas = recurHelper.query("id, salaryfile.id, bizitem.id, bsed, bsled, identifynumber, auditstatus,modifytime,modifier,datasources", new QFilter[]{filter});
        HashBasedTable table = HashBasedTable.create();
        HashSet<String> relatedBizDataCodes = new HashSet<String>(failDatas.length);
        for (DynamicObject updateData : failDatas) {
            Long salaryFileId = updateData.getLong("salaryfile.id");
            Long bizItemId = updateData.getLong("bizitem.id");
            Set cacheBizitemIdSet = (Set)salaryFileIdAndBizItemIdRelMap.get(salaryFileId);
            if (cacheBizitemIdSet == null || !cacheBizitemIdSet.contains(bizItemId)) continue;
            HashSet<DynamicObject> bizDataIdSet = (HashSet<DynamicObject>)table.get((Object)salaryFileId, (Object)bizItemId);
            if (bizDataIdSet == null) {
                bizDataIdSet = new HashSet<DynamicObject>(16);
            }
            bizDataIdSet.add(updateData);
            table.put((Object)salaryFileId, (Object)bizItemId, bizDataIdSet);
            relatedBizDataCodes.add(updateData.getString("identifynumber"));
        }
        this.fillLatestBsledRecord(latestRelatedDataMap, relatedBizDataCodes);
        return table;
    }

    private void fillLatestBsledRecord(Map<String, DynamicObject> latestRelatedDataMap, Set<String> relatedBizDataCodes) {
        if (CollectionUtils.isEmpty(relatedBizDataCodes)) {
            return;
        }
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        QFilter filter = new QFilter("bizdatacode", "in", relatedBizDataCodes);
        filter.and("isabandon", "!=", (Object)"1");
        String orderBy = "createtime desc";
        String queryField = "bizdatacode,opbizdatacode,beforebsled,afterbsled,optype,isabandon";
        Object[] bsledRecordDatas = bsledHelper.query(queryField, new QFilter[]{filter}, orderBy);
        if (SWCArrayUtils.isEmpty((Object[])bsledRecordDatas)) {
            return;
        }
        for (Object record : bsledRecordDatas) {
            String bizDataCode = record.getString("bizdatacode");
            if (latestRelatedDataMap.containsKey(bizDataCode)) continue;
            latestRelatedDataMap.put(bizDataCode, (DynamicObject)record);
        }
    }

    private Map<Long, Boolean> getBizItemMap(Set<Long> bizItemSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "in", bizItemSet);
        DynamicObject[] bizItemColl = helper.query("id,cycle,ctrlstrategy,bizitempropentry.bizitemprop", new QFilter[]{filter});
        HashMap<Long, Boolean> bizItemIsRecurMap = new HashMap<Long, Boolean>(bizItemColl.length);
        for (DynamicObject bizItem : bizItemColl) {
            Boolean isRecurItem = bizItem.getBoolean("cycle");
            bizItemIsRecurMap.put(bizItem.getLong("id"), isRecurItem);
        }
        return bizItemIsRecurMap;
    }

    static {
        cannotRollBackOpType.add(BizDataOperateEnum.OPERATE_ADD.getCode());
        cannotRollBackOpType.add(BizDataOperateEnum.OPERATE_MANUAL_ADD.getCode());
        cannotRollBackOpType.add(BizDataOperateEnum.OPERATE_ITF_ADD.getCode());
        cannotRollBackOpType.add(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
        cannotRecoverOpTypes.add(BizDataOperateEnum.OPERATE_ITF_UPDATE.getCode());
        cannotRecoverOpTypes.add(BizDataOperateEnum.OPERATE_UPDATE.getCode());
        cannotRecoverOpTypes.add(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
    }
}

