/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.transversetable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListHelper;
import kd.swc.hsbp.common.enums.BizDataRecordAuditStateEnum;
import kd.swc.hsbp.common.enums.BizDataRecordDataSourceEnum;
import kd.swc.hsbp.common.enums.BizDataRecordSrcSystem;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataRecordListExportService {
    protected static final Log logger = LogFactory.getLog(BizDataRecordListExportService.class);
    private static final Object DATATYPE = "dataType";

    public List<Map<String, Object>> getExportData(QFilter[] filters, Long bizItemGroupId, int currentPage, int pageSize) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(16);
        String fields = this.buildExportQuerySql();
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"hsas_bizdatarecord", (String)fields, (QFilter[])filters, (String)"id desc", (int)currentPage, (int)pageSize);
        int size = coll.length;
        int seq = currentPage * pageSize + 1;
        for (int i = 0; i < size; ++i) {
            DynamicObject bizDataRecordObj = coll[i];
            bizDataRecordIdSet.add(bizDataRecordObj.getLong("id"));
            HashMap<String, Object> valueMap = new HashMap<String, Object>(30);
            this.buildBizDataRecordData(valueMap, bizDataRecordObj);
            valueMap.put("fseq", seq);
            valueMap.put("id", bizDataRecordObj.getLong("id"));
            ++seq;
            dataList.add(valueMap);
        }
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject[] nonBizDatas = bizDataRecordListHelper.getNonBizDataRecordDatasByIds(bizDataRecordIdSet);
        if (nonBizDatas != null && nonBizDatas.length > 0) {
            this.buildBizItemData(dataList, nonBizDatas);
        }
        return dataList;
    }

    private void buildBizItemData(List<Map<String, Object>> dataList, DynamicObject[] nonBizDatas) {
        HashMap<Long, HashMap<String, String>> cacheNonBizDataMap = new HashMap<Long, HashMap<String, String>>(16);
        for (DynamicObject nonBizDataObj : nonBizDatas) {
            DynamicObject bizItemObj = nonBizDataObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) continue;
            String bizItemNumber = bizItemObj.getString("number");
            long bizDataRecordId = nonBizDataObj.getLong("bizdatarecord");
            String bizItemVal = nonBizDataObj.getString("datavalue");
            HashMap<String, String> valMap = (HashMap<String, String>)cacheNonBizDataMap.get(bizDataRecordId);
            if (valMap == null || valMap.size() == 0) {
                valMap = new HashMap<String, String>(1);
            }
            valMap.put(bizItemNumber, bizItemVal);
            cacheNonBizDataMap.put(bizDataRecordId, valMap);
        }
        for (Map map : dataList) {
            Map valMap;
            Long bizDataRecordId = (Long)map.get("id");
            if (bizDataRecordId == null || (valMap = (Map)cacheNonBizDataMap.get(bizDataRecordId)) == null || valMap.size() == 0) continue;
            for (Map.Entry entry : valMap.entrySet()) {
                String bizItemNumber = (String)entry.getKey();
                String bizItemVal = (String)entry.getValue();
                map.put(bizItemNumber.toLowerCase(), bizItemVal);
            }
        }
    }

    public Sheet write2ExportContent(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headerMap, Map<String, Map<String, Object>> bizItemDetailMap) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headerMap);
        this.createContentColumn(sheet.getWorkbook(), sheet, beginIndex, exportDataList, headList, bizItemDetailMap);
        return sheet;
    }

    private void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, List<Map<String, String>> headList, Map<String, Map<String, Object>> bizItemDetailMap) {
        if (exportDataList.isEmpty()) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = null;
            exportDataMap = exportDataList.get(rowIndex - beginIndex);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                String cellStyleKey;
                CellStyle defaultStyle;
                int usageCount;
                Object value;
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = headList.get(columnIndex).get("key");
                if (null == key || null == (value = exportDataMap.get(key)) || SWCStringUtils.isEmpty((String)value.toString()) || SWCStringUtils.equals((String)key, (String)"usagecount") && (usageCount = ((Integer)value).intValue()) == 0) continue;
                Map<String, Object> itemInfo = this.getItemInfo(bizItemDetailMap, key);
                if (value != null) {
                    logger.info("bizitem value is :{} , bizitem iteminfo is:{}", value, itemInfo);
                }
                if ((defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey = BizDataRecordListExportService.getCellStyleKey(itemInfo))) == null) {
                    defaultStyle = this.getDefaultCellStyle(itemInfo, wb);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                String dataType = "";
                if (null == itemInfo) {
                    if (value instanceof String) {
                        dataType = "text";
                    } else if (value instanceof Date) {
                        dataType = "date";
                    } else if (value instanceof BigDecimal) {
                        dataType = "num";
                    }
                } else {
                    dataType = (String)itemInfo.get("dataType");
                    logger.info("bizitem number is:{}", (Object)key);
                }
                this.parseCellValue(columnCell, value, dataType);
                columnCell.setCellType(BizDataRecordListExportService.getCellType(dataType));
                columnCell.setCellStyle(defaultStyle);
            }
        }
    }

    public CellStyle getDefaultCellStyle(Map<String, Object> itemInfoMap, SXSSFWorkbook wb) {
        String dataType = "";
        Integer scale = 0;
        CellStyle cellStyle = wb.createCellStyle();
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get("dataType");
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            this.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            BizDataRecordListExportService.getDateCellStyle(wb, cellStyle);
        } else if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            this.getAmountCellStyle(wb, cellStyle, scale);
        } else {
            BizDataRecordListExportService.getStringCellStyle(wb, cellStyle);
        }
        return cellStyle;
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    public static String getCellStyleKey(Map<String, Object> itemInfoMap) {
        StringBuilder keyBuilder = new StringBuilder();
        String dataType = "";
        Integer scale = 0;
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get("dataType");
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(scale);
        return keyBuilder.toString();
    }

    private Map<String, Object> getItemInfo(Map<String, Map<String, Object>> itemInfo, String key) {
        if (itemInfo == null || itemInfo.size() == 0) {
            return null;
        }
        for (Map.Entry<String, Map<String, Object>> entry : itemInfo.entrySet()) {
            String itemKey = entry.getKey();
            if (!SWCStringUtils.equals((String)key, (String)itemKey.toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    private void parseCellValue(SXSSFCell cell, Object value, String dataType) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            String fmt = "yyyy-MM-dd";
            if (value instanceof Date) {
                String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCDateTimeUtils.format((Date)dateValue, (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                cell.setCellValue(valueStr);
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)"num") || SWCStringUtils.equals((String)dataType, (String)"amount")) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    private void buildBizDataRecordData(Map<String, Object> valueMap, DynamicObject bizDataRecordObj) {
        String salaryfileName = bizDataRecordObj.getString("salaryfile.name");
        valueMap.put("salaryfile.name", salaryfileName);
        String salaryfileEmployeeEmpnumber = bizDataRecordObj.getString("salaryfile.employee.empnumber");
        valueMap.put("salaryfile.employee.empnumber", salaryfileEmployeeEmpnumber);
        String salaryfileNumber = bizDataRecordObj.getString("salaryfile.number");
        valueMap.put("salaryfile.number", salaryfileNumber);
        String currencyName = bizDataRecordObj.getString("currency.name");
        valueMap.put("currency.name", currencyName);
        Date bsed = bizDataRecordObj.getDate("bsed");
        valueMap.put("bsed", SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"));
        String frequencyName = bizDataRecordObj.getString("frequency.name");
        valueMap.put("frequency.name", frequencyName);
        String description = bizDataRecordObj.getString("description");
        valueMap.put("description", description);
        String auditstatus = bizDataRecordObj.getString("auditstatus");
        valueMap.put("auditstatus", BizDataRecordAuditStateEnum.getDesc((String)auditstatus));
        int usagecount = bizDataRecordObj.getInt("usagecount");
        valueMap.put("usagecount", usagecount);
        String salaryfilePayrollgroupName = bizDataRecordObj.getString("salaryfile.payrollgroup.name");
        valueMap.put("salaryfile.payrollgroup.name", salaryfilePayrollgroupName);
        String salaryfilePayrollregionName = bizDataRecordObj.getString("salaryfile.payrollregion.name");
        valueMap.put("salaryfile.payrollregion.name", salaryfilePayrollregionName);
        String salaryfileAdminorgName = bizDataRecordObj.getString("salaryfile.adminorg.name");
        valueMap.put("salaryfile.adminorg.name", salaryfileAdminorgName);
        String salaryfileEmpgroupName = bizDataRecordObj.getString("salaryfile.empgroup.name");
        valueMap.put("salaryfile.empgroup.name", salaryfileEmpgroupName);
        String datasources = bizDataRecordObj.getString("datasources");
        valueMap.put("datasources", BizDataRecordDataSourceEnum.getDesc((String)datasources));
        String batchnumber = bizDataRecordObj.getString("batchnumber");
        valueMap.put("batchnumber", batchnumber);
        String identifynumber = bizDataRecordObj.getString("identifynumber");
        valueMap.put("identifynumber", identifynumber);
        String srcsystem = bizDataRecordObj.getString("srcsystem");
        valueMap.put("srcsystem", BizDataRecordSrcSystem.getDesc((String)srcsystem));
        String bizdataaccesstplName = bizDataRecordObj.getString("bizdataaccesstpl.name");
        valueMap.put("bizdataaccesstpl.name", bizdataaccesstplName);
        Date createtime = bizDataRecordObj.getDate("createtime");
        valueMap.put("createtime", HRInteDateTimeUtil.formatDate((String)"hsas_bizdatarecord", (String)"createtime", (Date)createtime));
        String opreason = bizDataRecordObj.getString("opreason");
        valueMap.put("opreason", opreason);
    }

    private String buildExportQuerySql() {
        String fields = "salaryfile,currency,bsed,frequency,description,auditstatus,usagecount,datasources,batchnumber,identifynumber,srcsystem,bizdataaccesstpl,createtime,opreason";
        return fields;
    }

    public Map<String, String> getExportHeaders(DynamicObjectCollection bizItemColl) {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(30);
        headerMap.put("fseq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BizDataRecordListExportService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"BizDataRecordListExportService_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.employee.empnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BizDataRecordListExportService_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.number", ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848", (String)"BizDataRecordListExportService_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        for (DynamicObject bizItemObj : bizItemColl) {
            DynamicObject bizItemInfo = bizItemObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemInfo)) continue;
            String bizItemNumber = bizItemInfo.getString("number");
            String bizItemName = bizItemInfo.getString("name");
            headerMap.put(bizItemNumber.toLowerCase(), bizItemName);
        }
        headerMap.put("currency.name", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BizDataRecordListExportService_21", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"BizDataRecordListExportService_5", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("frequency.name", ResManager.loadKDString((String)"\u9891\u5ea6", (String)"BizDataRecordListExportService_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("description", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BizDataRecordListExportService_7", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("auditstatus", ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"BizDataRecordListExportService_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("usagecount", ResManager.loadKDString((String)"\u4f7f\u7528\u6b21\u6570", (String)"BizDataRecordListExportService_9", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.payrollgroup.name", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"BizDataRecordListExportService_10", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.payrollregion.name", ResManager.loadKDString((String)"\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730", (String)"BizDataRecordListExportService_11", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.adminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"BizDataRecordListExportService_12", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.empgroup.name", ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4", (String)"BizDataRecordListExportService_13", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("datasources", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90", (String)"BizDataRecordListExportService_14", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("batchnumber", ResManager.loadKDString((String)"\u6279\u6b21\u53f7", (String)"BizDataRecordListExportService_15", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("identifynumber", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7", (String)"BizDataRecordListExportService_16", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("srcsystem", ResManager.loadKDString((String)"\u524d\u7aef\u7cfb\u7edf", (String)"BizDataRecordListExportService_17", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("bizdataaccesstpl.name", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f", (String)"BizDataRecordListExportService_18", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"BizDataRecordListExportService_19", (String)"swc-hsas-business", (Object[])new Object[0]));
        headerMap.put("opreason", ResManager.loadKDString((String)"\u5f02\u5e38\u8bf4\u660e", (String)"BizDataRecordListExportService_20", (String)"swc-hsas-business", (Object[])new Object[0]));
        return headerMap;
    }

    public Sheet write2ExportHead(SXSSFSheet sheet, Map<String, String> headerMap) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headerMap);
        this.createHeadColumn(sheet.getWorkbook(), sheet, headList);
        return sheet;
    }

    private void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, String>> headList) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        int headSize = headList.size();
        for (int i = 0; i < headSize; ++i) {
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headString = headList.get(i).get("value");
            cell.setCellValue(headString);
            CellStyle headColumnStyle = this.getHeadColumnStyle(wb);
            cell.setCellStyle(headColumnStyle);
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.LEFT);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public List<Map<String, String>> HeadMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            HashMap<String, String> itemMap = new HashMap<String, String>(2);
            itemMap.put("key", entry.getKey());
            itemMap.put("value", entry.getValue());
            list.add(itemMap);
        }
        return list;
    }
}

