/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.transversetable;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.task.MultithreadedQueryTask;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import org.apache.commons.lang.ArrayUtils;

public class BizDataRecordListHelper {
    public final Log log = LogFactory.getLog(BizDataRecordListHelper.class);

    public DynamicObject getBizItemInfoByBizItemGroupId(long bizItemGroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        String sql = "entryentity.bizitem";
        QFilter filter = new QFilter("id", "=", (Object)bizItemGroupId);
        String orderBy = "entryentity.seq asc";
        return helper.queryOne(sql, new QFilter[]{filter}, orderBy);
    }

    public DynamicObject[] getDataType() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_datatype");
        String sql = "id,storagetype";
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        return helper.query(sql, new QFilter[]{filter});
    }

    public DynamicObject[] batchQueryNonBizDataRecordDatas(Set<Long> bizDataRecordIsSet, int totalDataBitchSize) {
        QFilter filter = new QFilter("bizdatarecord", "in", bizDataRecordIsSet);
        String field = "id,bizitem,datavalue,bizdatarecord,currency,salaryfile.id,org.id,payrollregion.id,payrollgroup.id,adminorg.id,empgroup.id,salaryfile.person.id,salaryfile.org.id,salaryfile.payrollregion.id";
        DynamicObject[] coll = null;
        try {
            coll = this.getData("hsas_nonrecurbizdata", field, new QFilter[]{filter}, "id", totalDataBitchSize);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return coll;
    }

    private DynamicObject[] getData(String entityName, String selectProperties, QFilter[] filters, String orderBy, int batchSize) throws InterruptedException {
        int total = new SWCDataServiceHelper(entityName).count(filters);
        Object[] coll = null;
        int num = 1;
        if (total > batchSize) {
            num = total / batchSize;
            if (total % batchSize > 0) {
                ++num;
            }
        }
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList<Future> futureList = new ArrayList<Future>(num);
        int index = 0;
        while (index < num) {
            int currPageIndex = index++;
            int currPageSize = batchSize;
            MultithreadedQueryTask task = new MultithreadedQueryTask(entityName, selectProperties, filters, orderBy, currPageIndex, currPageSize, latch);
            Future future = SWCThreadPoolFactory.getBizdataRecordQueryThreadpool().submit((Callable)task);
            futureList.add(future);
        }
        try {
            boolean flag = latch.await(10L, TimeUnit.MINUTES);
            if (!flag) {
                return new DynamicObject[0];
            }
            for (Future future : futureList) {
                if (coll == null) {
                    coll = (DynamicObject[])future.get();
                    continue;
                }
                coll = (DynamicObject[])ArrayUtils.addAll((Object[])coll, (Object[])((Object[])future.get()));
            }
        }
        catch (ExecutionException e) {
            this.log.error((Throwable)e);
        }
        return coll;
    }

    public DynamicObject[] getNonBizDataRecordDatasByIds(Set<Long> bizDataRecordIsSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter filter = new QFilter("bizdatarecord", "in", bizDataRecordIsSet);
        String field = "id,bizitem,datavalue,bizdatarecord,currency";
        DynamicObject[] coll = helper.query(field, new QFilter[]{filter});
        return coll;
    }
}

