/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.transversetable;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListHelper;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataRecordListService {
    public final Log log = LogFactory.getLog(BizDataRecordListService.class);
    private final int bitchSize = 1000;
    private final int bizDataQuerySize = 500;

    public void getBizDataRecordDatas(DynamicObjectCollection bizDataRecordDatas, Map<Long, String> dataTypeMap) {
        DynamicObject[] nonRecurBizDatas;
        ArrayList<DynamicObject> nonBizDataRecordDataList = new ArrayList<DynamicObject>(10);
        BizDataRecordListHelper helper = new BizDataRecordListHelper();
        long startTime = System.currentTimeMillis();
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(bizDataRecordDatas.size());
        for (DynamicObject bizDataRecordObj : bizDataRecordDatas) {
            if (!SWCObjectUtils.isEmpty((Object)bizDataRecordObj)) {
                bizDataRecordIdSet.add(bizDataRecordObj.getLong("id"));
            }
            if (bizDataRecordIdSet.size() != 500) continue;
            DynamicObject[] nonRecurBizDatas2 = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000);
            if (nonRecurBizDatas2 != null && nonRecurBizDatas2.length > 0) {
                for (DynamicObject nonRecurBizObj : nonRecurBizDatas2) {
                    nonBizDataRecordDataList.add(nonRecurBizObj);
                }
            }
            bizDataRecordIdSet.clear();
        }
        if (bizDataRecordIdSet != null && bizDataRecordIdSet.size() > 0 && (nonRecurBizDatas = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000)) != null && nonRecurBizDatas.length > 0) {
            for (DynamicObject nonRecurBizObj : nonRecurBizDatas) {
                nonBizDataRecordDataList.add(nonRecurBizObj);
            }
        }
        this.log.info("BizDataRecordListService query data use time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (nonBizDataRecordDataList == null || nonBizDataRecordDataList.size() == 0) {
            return;
        }
        this.log.info("BizDataRecordListService query data size:{}", (Object)nonBizDataRecordDataList.size());
        startTime = System.currentTimeMillis();
        HashMap<Long, DynamicObject> bizDataRecordMap = new HashMap<Long, DynamicObject>(bizDataRecordDatas.size());
        for (DynamicObject bizDataRecordObj : bizDataRecordDatas) {
            Long bizDataRecordId = bizDataRecordObj.getLong("id");
            bizDataRecordMap.put(bizDataRecordId, bizDataRecordObj);
        }
        this.log.info("BizDataRecordListService transfer bizDataRecordDatas use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        for (DynamicObject nonRecurBizDataObj : nonBizDataRecordDataList) {
            Long bizDataRecordId = nonRecurBizDataObj.getLong("bizdatarecord");
            DynamicObject bizDataRecordObj = (DynamicObject)bizDataRecordMap.get(bizDataRecordId);
            if (bizDataRecordObj == null) continue;
            this.buildBizDataRecordDatas(nonRecurBizDataObj, bizDataRecordObj, dataTypeMap);
        }
        this.log.info("BizDataRecordListService build data use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void buildBizDataRecordDatas(DynamicObject nonRecurBizDataObj, DynamicObject bizDataRecordObj, Map<Long, String> dataTypeMap) {
        DynamicObject bizItemObj = nonRecurBizDataObj.getDynamicObject("bizitem");
        String bizItemNumber = bizItemObj.getString("number");
        String columnKey = bizItemNumber.toLowerCase();
        String bizItemVal = nonRecurBizDataObj.getString("datavalue");
        DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
        String dataType = dataTypeMap.get(dataTypeObj.getLong("id"));
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return;
        }
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            bizDataRecordObj.set(columnKey, (Object)bizItemVal);
        } else if (SWCShowType.NUM.getCode().equals(dataType)) {
            bizDataRecordObj.set(columnKey, (Object)new BigDecimal(bizItemVal));
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            try {
                bizDataRecordObj.set(columnKey, (Object)SWCDateTimeUtils.parseDate((String)bizItemVal, (String)"yyy-MM-dd"));
            }
            catch (ParseException e) {
                this.log.error(e.getMessage());
            }
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            DynamicObject currencyObj = nonRecurBizDataObj.getDynamicObject("currency");
            if (SWCObjectUtils.isEmpty((Object)currencyObj)) {
                return;
            }
            int amtprecision = currencyObj.getInt("amtprecision");
            bizDataRecordObj.set(columnKey, (Object)this.getAmountValueByAmtprecision(amtprecision, bizItemVal));
        }
    }

    private String getAmountValueByAmtprecision(int amtprecision, String dataValue) {
        String amtStr = this.getAmtprecision(amtprecision);
        DecimalFormat format = new DecimalFormat(amtStr);
        return format.format(new BigDecimal(dataValue));
    }

    private String getAmtprecision(int amtprecision) {
        switch (amtprecision) {
            case 0: {
                return "0";
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "0.00";
            }
            case 3: {
                return "0.000";
            }
            case 4: {
                return "0.0000";
            }
            case 5: {
                return "0.00000";
            }
            case 6: {
                return "0.000000";
            }
            case 7: {
                return "0.0000000";
            }
            case 8: {
                return "0.00000000";
            }
            case 9: {
                return "0.000000000";
            }
            case 10: {
                return "0.0000000000";
            }
        }
        return "0.0000";
    }
}

