/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.calreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CalRecordViewHelper {
    public DynamicObject getCalReportInfoById(Long calRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        String field = "id,caltask.id,caltask.number,caltask.name,optype,sucesscount,failcount,totalcount,salaryitemcount,calversionno,creator.name,starttime,endtime,calstatus";
        QFilter filter = new QFilter("id", "=", (Object)calRecordId);
        return helper.queryOne(field, new QFilter[]{filter});
    }

    public List<Map<String, Object>> getCalFailGroupInfo(long recordId, String calStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ffailtype,ferrorelement,ffailmsg,count(0) num ");
        sql.append("FROM t_hsas_caldetail where frecordid = ? ");
        sql.append(" and fcalstatus = ? ");
        sql.append("group by ffailtype,ferrorelement,ffailmsg order by ffailtype asc");
        return (List)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString(), (Object[])new Object[]{recordId, calStatus}, rs -> {
            ArrayList resultList = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                result.put("failType", rs.getString("ffailtype"));
                result.put("errorElement", rs.getString("ferrorelement"));
                result.put("failMsg", rs.getString("ffailmsg"));
                result.put("count", rs.getInt("num"));
                resultList.add(result);
            }
            return resultList;
        });
    }

    public List<Map<String, Object>> getCalMessageGroupData(long recordId) {
        String querySql = " SELECT fcalpersonid,fformulaid,fmessage FROM t_hsas_calmessage  where frecordid = ? group by fcalpersonid,fformulaid,fmessage ";
        return (List)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])new Object[]{recordId}, rs -> {
            HashMap resultMap = new HashMap(16);
            String key = null;
            HashMap<String, Object> tempMap = null;
            while (rs.next()) {
                long formulaId = rs.getLong("fformulaid");
                String message = rs.getString("fmessage");
                key = formulaId + message;
                tempMap = (HashMap<String, Object>)resultMap.get(key);
                if (tempMap == null) {
                    tempMap = new HashMap<String, Object>(3);
                    tempMap.put("fformulaid", formulaId);
                    tempMap.put("fmessage", message);
                    tempMap.put("count", 1);
                    resultMap.put(key, tempMap);
                    continue;
                }
                Integer count = (Integer)tempMap.get("count");
                count = count + 1;
                tempMap.put("count", count);
            }
            return new ArrayList(resultMap.values());
        });
    }

    public Map<Long, String> getFormulaMap(Set<Long> formulaIdSet, String calVersionNo) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calversion");
        String fields = "id,formulav.name,formulav.boid";
        QFilter filter = new QFilter("calversionno", "=", (Object)calVersionNo);
        filter.and("formulav.boid", "in", formulaIdSet);
        DynamicObjectCollection data = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "index asc");
        LinkedHashMap<Long, String> formulaMap = new LinkedHashMap<Long, String>(data.size());
        for (DynamicObject obj : data) {
            formulaMap.put(obj.getLong("formulav.boid"), obj.getString("formulav.name"));
        }
        return formulaMap;
    }
}

