/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.calrule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CalRuleCommonService {
    private Map<Long, DynamicObject> importDyMap = null;

    private CalRuleCommonService() {
    }

    private CalRuleCommonService(Map<Long, DynamicObject> importDyMap) {
        this.importDyMap = importDyMap;
    }

    public static CalRuleCommonService createInstance() {
        return new CalRuleCommonService();
    }

    public static CalRuleCommonService createInstanceForImport(OperateOption operateOption, ExtendedDataEntity[] dataEntities) {
        boolean currImportUpdateOrIncludeNew;
        if (operateOption == null || ArrayUtils.isEmpty((Object[])dataEntities)) {
            return null;
        }
        Map<Long, DynamicObject> currImportDyMap = null;
        String importType = operateOption.getVariableValue("importtype", null);
        boolean bl = currImportUpdateOrIncludeNew = "override".equals(importType) || "overridenew".equals(importType);
        if (currImportUpdateOrIncludeNew) {
            ExtendedDataEntity dataEntity = dataEntities[0];
            String entryName = dataEntity.getDataEntity().getDataEntityType().getName();
            Set pkIdSet = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).filter(pkId -> pkId != 0L).collect(Collectors.toSet());
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entryName);
            QFilter filter = new QFilter("id", "in", pkIdSet);
            DynamicObject[] dyInfo = helper.loadDynamicObjectArray(filter.toArray());
            currImportDyMap = Arrays.stream(dyInfo).collect(Collectors.toMap(key -> key.getLong("id"), dy -> dy));
        }
        return new CalRuleCommonService(currImportDyMap);
    }

    public boolean checkFexFieldChangedWhenImport(ExtendedDataEntity dataEntity, Collection<String> fixFields) {
        DynamicObject dynamicObjectInDb;
        boolean isInvalid = false;
        DynamicObject dyFromImport = dataEntity.getDataEntity();
        if (!CollectionUtils.isEmpty(this.importDyMap) && !CollectionUtils.isEmpty(fixFields) && (dynamicObjectInDb = this.importDyMap.get(dyFromImport.getLong("id"))) != null) {
            for (String fixField : fixFields) {
                if (HRStringUtils.equals((String)dynamicObjectInDb.getString(fixField), (String)dyFromImport.getString(fixField))) continue;
                isInvalid = true;
                break;
            }
        }
        return isInvalid;
    }
}

