/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.api.CalPersonSplit;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalModeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;

public class PreCalCheckService {
    private static final Log logger = LogFactory.getLog(PreCalCheckService.class);
    private Long calTaskId;
    private Long calRecordId;

    public PreCalCheckService(Long calTaskId, Long calRecordId) {
        this.calRecordId = calRecordId;
        this.calTaskId = calTaskId;
    }

    public Map<String, Object> handlePreTaxCal(DynamicObject[] calPersonArray, Map<String, String> calModeMap, boolean openTaxCal, CalPersonSplit split) {
        logger.info("handlePreTaxCal begin");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObjectCollection calDetailList = new DynamicObjectCollection();
        Map<String, List<Long>> calModeGroupIdListMap = split.splitCalPersonByCalMode(calPersonArray, calModeMap, calDetailList, openTaxCal, this.calTaskId, this.calRecordId);
        List<Long> calOrReCalIdList = calModeGroupIdListMap.get("calOrReCalIdList");
        List<Long> onlyPreCalIdList = calModeGroupIdListMap.get("onlyPreCalIdList");
        List<Long> pushTaxIdList = calModeGroupIdListMap.get("pushTaxIdList");
        List<Long> afterCalIdList = calModeGroupIdListMap.get("afterCalIdList");
        List<Long> pullTaxIdList = calModeGroupIdListMap.get("pullTaxIdList");
        logger.info("PreCalCheckService_calModeGroupIdListMap:{}", (Object)calModeGroupIdListMap.toString());
        DynamicObjectCollection calBatchDataList = new DynamicObjectCollection();
        ArrayList<String> calBatchIdList = new ArrayList<String>(10);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", this.calRecordId));
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", this.calRecordId));
        if (!CollectionUtils.isEmpty(afterCalIdList)) {
            this.addCalBatchData(afterCalIdList, calBatchDataList, appCache, this.calRecordId, "afterTaxCal", calBatchIdList);
            FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)afterCalIdList.size(), (int)0, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", this.calRecordId));
            FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)afterCalIdList.size(), (int)0, (int)0, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", this.calRecordId));
        }
        if (!CollectionUtils.isEmpty(pullTaxIdList)) {
            this.addCalBatchData(pullTaxIdList, calBatchDataList, appCache, this.calRecordId, "pullTax", calBatchIdList);
            FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)pullTaxIdList.size(), (int)0, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", this.calRecordId));
        }
        if (!CollectionUtils.isEmpty(calOrReCalIdList)) {
            String calType = "cal";
            if (openTaxCal) {
                calType = "preTaxCal";
            }
            this.addCalBatchData(calOrReCalIdList, calBatchDataList, appCache, this.calRecordId, calType, calBatchIdList);
        }
        if (!CollectionUtils.isEmpty(onlyPreCalIdList)) {
            this.addCalBatchData(onlyPreCalIdList, calBatchDataList, appCache, this.calRecordId, "onlyPreTaxCal", calBatchIdList);
            this.addTypeCalProgress(onlyPreCalIdList, calProgressAppCache);
        }
        if (!CollectionUtils.isEmpty(pushTaxIdList)) {
            this.addCalBatchData(pushTaxIdList, calBatchDataList, appCache, this.calRecordId, "taxCal", calBatchIdList);
            FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)pushTaxIdList.size(), (int)0, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", this.calRecordId));
        }
        resultMap.put("calBatchDataList", calBatchDataList);
        resultMap.put("calBatchIdList", calBatchIdList);
        resultMap.put("calDetailList", calDetailList);
        logger.info("handlePreTaxCal end");
        return resultMap;
    }

    private void addTypeCalProgress(List<Long> onlyPreCalIdList, ISWCAppCache calProgressAppCache) {
        HashMap<String, Integer> typeCountMap = (HashMap<String, Integer>)calProgressAppCache.get(String.format(Locale.ROOT, "cal_type_count_progress_%s", this.calRecordId), Map.class);
        if (typeCountMap == null) {
            typeCountMap = new HashMap<String, Integer>(16);
        }
        typeCountMap.put("onlyPreCalCount", onlyPreCalIdList.size());
        calProgressAppCache.put(String.format(Locale.ROOT, "cal_type_count_progress_%s", this.calRecordId), typeCountMap);
    }

    private String getCalMode(String calType) {
        String calMode = null;
        switch (calType) {
            case "preTaxCal": {
                calMode = CalModeEnum.CAL.getCode();
                break;
            }
            case "onlyPreTaxCal": {
                calMode = CalModeEnum.ONLYPRECAL.getCode();
                break;
            }
            case "taxCal": {
                calMode = CalModeEnum.PUSHTAX.getCode();
                break;
            }
            case "pullTax": {
                calMode = CalModeEnum.PULLTAX.getCode();
                break;
            }
            case "afterTaxCal": {
                calMode = CalModeEnum.AFTERCAL.getCode();
                break;
            }
            default: {
                calMode = CalModeEnum.CAL.getCode();
            }
        }
        return calMode;
    }

    private void addCalBatchData(List<Long> calPersonIdList, DynamicObjectCollection calBatchDataList, ISWCAppCache appCache, long calRecordId, String calType, List<String> calBatchIdList) {
        List splitCalPersonIdList = SWCListUtils.split(calPersonIdList, (int)CalHelper.getSplitCount());
        long[] calBatchIdArray = this.getCalBatchPkId(splitCalPersonIdList.size());
        String calMode = this.getCalMode(calType);
        int index = 0;
        HashMap<String, Object> calBatchMap = null;
        for (List tempIdList : splitCalPersonIdList) {
            long calBatchId = calBatchIdArray[index];
            calBatchDataList.add((Object)CalTableCalHelper.buildCalBatchObj(calRecordId, tempIdList.size(), calBatchId, "1", calMode));
            calBatchIdList.add(String.valueOf(calBatchId));
            calBatchMap = new HashMap<String, Object>(3);
            calBatchMap.put("calPersonIdList", tempIdList);
            calBatchMap.put("calType", calType);
            appCache.put(String.format(Locale.ROOT, "calbatch_%s", calBatchId), calBatchMap);
            ++index;
        }
    }

    private long[] getCalBatchPkId(int count) {
        long[] calBatchIdArray = DB.genLongIds((String)"t_hsas_calbatch", (int)count);
        return calBatchIdArray;
    }
}

