/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.common.enums.PayDetailAbandonReasonEnum;
import kd.swc.hsas.common.enums.PayDetailPayEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class CalDetailHelper {
    private static final String KEY_EDIT_STATUS = "99";

    public Map<String, Integer> queryCalDetail(Long calRecordId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FFAILTYPE failtype, COUNT(FFAILTYPE) count ");
        sql.append("FROM T_HSAS_CALDETAIL ");
        sql.append("WHERE FCALSTATUS = '2'");
        sql.append("AND FRECORDID = ?");
        sql.append("GROUP BY FFAILTYPE ");
        return (Map)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString(), (Object[])new Object[]{calRecordId}, (ResultSetHandler)new ResultSetHandler<Map<String, Integer>>(){

            public Map<String, Integer> handle(ResultSet rs) throws Exception {
                HashMap<String, Integer> result = new HashMap<String, Integer>(16);
                while (rs.next()) {
                    result.put(rs.getString("failtype"), rs.getInt("count"));
                }
                return result;
            }
        });
    }

    public static boolean hasOnHoldReleaseAgencyBill(List<Long> calPersons) {
        boolean flag = false;
        List partition = Lists.partition(calPersons, (int)1000);
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter onHoldFilter = new QFilter("onholdstatus", "=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()));
        QFilter agencyStateFilter = new QFilter("agencypaystate", "=", (Object)"1");
        QFilter abandonedStatusFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        for (List calPersonPartitions : partition) {
            QFilter calPersonIdFilter = new QFilter("calpersonid", "in", (Object)calPersonPartitions);
            calPersonIdFilter.and(onHoldFilter);
            calPersonIdFilter.and(agencyStateFilter);
            calPersonIdFilter.and(abandonedStatusFilter);
            int count = swcDataServiceHelper.count(new QFilter[]{calPersonIdFilter});
            if (count <= 0) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static List<DynamicObject> unApproveHandlePayDetail(List<Long> unPayDetailCalPersonIds, List<Long> updateStatusCalPersons, List<Long> updateCalStatusCalPersons) {
        DynamicObject[] payDetails = CalDetailHelper.queryPayDetails(unPayDetailCalPersonIds);
        Map<Long, String> tagMap = CalDetailHelper.handlePayDetail(updateStatusCalPersons, updateCalStatusCalPersons, payDetails);
        ArrayList<DynamicObject> updatePayDetails = new ArrayList<DynamicObject>(payDetails.length);
        for (DynamicObject payDetail : payDetails) {
            String reasonEnumCode = tagMap.get(payDetail.getLong("calpersonid"));
            if (!SWCStringUtils.equals((String)KEY_EDIT_STATUS, (String)reasonEnumCode)) {
                payDetail.set("abandonedstatus", (Object)Boolean.TRUE);
                payDetail.set("abandonedres", (Object)PayDetailAbandonReasonEnum.getDesc((String)reasonEnumCode));
                String holdStatus = payDetail.getString("onholdstatus");
                if (StringUtils.equals((CharSequence)holdStatus, (CharSequence)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()))) {
                    payDetail.set("onholdstatus", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode()));
                }
                updatePayDetails.add(payDetail);
                continue;
            }
            if (!SWCStringUtils.equals((String)PayDetailPayEnum.OBLIGATION.getCode(), (String)payDetail.getString("paystate"))) continue;
            payDetail.set("paystate", (Object)PayDetailPayEnum.SAVE.getCode());
            updatePayDetails.add(payDetail);
        }
        return updatePayDetails;
    }

    @NotNull
    private static Map<Long, String> handlePayDetail(List<Long> updateStatusCalPersons, List<Long> updateCalStatusCalPersons, DynamicObject[] payDetails) {
        HashMap<Long, String> tagMap = new HashMap<Long, String>(payDetails.length);
        HashSet<String> accStatusSet = new HashSet<String>(Arrays.asList("C", "E"));
        for (DynamicObject payDetail : payDetails) {
            String acctModifyStatus;
            if (SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()), (String)payDetail.getString("onholdstatus"))) {
                if (SWCStringUtils.equals((String)"1", (String)payDetail.getString("agencypaystate"))) {
                    CalDetailHelper.setPayDetailDisApproveStatus(tagMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.PAY_RELIEF_DISAPPROVE.getCode());
                    updateStatusCalPersons.add(payDetail.getLong("calpersonid"));
                } else {
                    CalDetailHelper.setPayDetailDisApproveStatus(tagMap, payDetail.getLong("calpersonid"), KEY_EDIT_STATUS);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(acctModifyStatus = payDetail.getString("acctmodifybill.billstatus"))) && !accStatusSet.contains(acctModifyStatus)) {
                CalDetailHelper.setPayDetailDisApproveStatus(tagMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.ACCOUNT_MODIFY_DISAPPROVE.getCode());
                updateStatusCalPersons.add(payDetail.getLong("calpersonid"));
            }
            if (SWCStringUtils.equals((String)"0", (String)payDetail.getString("agencypaystate")) || SWCStringUtils.equals((String)BankOfferEnum.UNDEXPORT.getCode(), (String)payDetail.getString("bankofferstatus")) || SWCStringUtils.equals((String)BankOfferEnum.INVALIDED.getCode(), (String)payDetail.getString("bankofferstatus"))) {
                CalDetailHelper.setPayDetailDisApproveStatus(tagMap, payDetail.getLong("calpersonid"), "edit");
                updateCalStatusCalPersons.add(payDetail.getLong("calpersonid"));
            }
            if (!SWCStringUtils.equals((String)payDetail.getString("paystate"), (String)PayStateEnum.PAYFAIL.getCode())) continue;
            CalDetailHelper.setPayDetailDisApproveStatus(tagMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.PAYFAIL_DISAPPROVE.getCode());
            updateStatusCalPersons.add(payDetail.getLong("calpersonid"));
        }
        return tagMap;
    }

    private static DynamicObject[] queryPayDetails(List<Long> unPayDetailCalPersonIds) {
        SWCDataServiceHelper payDetailDataServiceHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter calPersonIdsFilter = new QFilter("calpersonid", "in", unPayDetailCalPersonIds);
        calPersonIdsFilter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        return payDetailDataServiceHelper.query("id,paystate,agencypaystate,onholdstatus,bankofferstatus,calpersonid,abandonedstatus,abandonedres,acctmodifybill.billstatus,acctmodifybill.id", new QFilter[]{calPersonIdsFilter});
    }

    private static void setPayDetailDisApproveStatus(Map<Long, String> payDetailStatusMap, Long calPersonId, String status) {
        String disApproveStatus = payDetailStatusMap.getOrDefault(calPersonId, KEY_EDIT_STATUS);
        payDetailStatusMap.put(calPersonId, disApproveStatus.compareTo(status) < 0 ? disApproveStatus : status);
    }
}

