/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.impl.DefaultCalPersonSplit;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class CalHelper {
    private static final Log logger = LogFactory.getLog(CalHelper.class);
    private static final int DEFAULT_COUNT = 2500;
    private static final String TAXSTATUS_STOP = "0";
    private static Map<String, Integer> infoLevelMap = new HashMap<String, Integer>(4);

    public static int getSplitCount() {
        Map paramDataMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"calbatchparam");
        if (paramDataMap == null || paramDataMap.size() == 0) {
            return 2500;
        }
        String threadDealCount = (String)paramDataMap.get("threadDealCount");
        String batchCount = (String)paramDataMap.get("batchCount");
        if (SWCStringUtils.isEmpty((String)threadDealCount) || SWCStringUtils.isEmpty((String)batchCount)) {
            return 2500;
        }
        BigDecimal splitCount = new BigDecimal(threadDealCount).multiply(new BigDecimal(batchCount));
        return splitCount.intValue();
    }

    public static String initCalFormulaGradeInfo(CalPayRollTask calPayRollTask, Map<String, Object> versionData) {
        Map<String, String> operationParam = calPayRollTask.getOperationParam();
        CalTableCalService calService = new CalTableCalService();
        Map<String, Object> formulaAndGradeMap = calService.getCalFormulaGradeVInfo(Long.valueOf(operationParam.get("calRuleHisId")), operationParam.get("calType"), operationParam.get("startdate"), operationParam.get("enddate"), operationParam.get("TAXITEMSCHEMEVID"));
        String calVersionNo = calService.getTaskCalVersionNo(calPayRollTask.getCalPayRollTaskId());
        if (SWCStringUtils.isEmpty((String)calVersionNo)) {
            calVersionNo = CalTableCalHelper.createCalVersion(formulaAndGradeMap);
            formulaAndGradeMap.put("calVersionNo", calVersionNo);
            calService.cacheVersionData(versionData, formulaAndGradeMap, false);
            return null;
        }
        formulaAndGradeMap.put("calVersionNo", calVersionNo);
        DynamicObjectCollection dynamicObjects = calService.getCalVersionFormulaGradeVInfo(calVersionNo, Long.valueOf(operationParam.get("calRuleHisId")));
        Map<String, Object> calversionDataMap = calService.assembleFormulaGradeByDyObj(dynamicObjects);
        calversionDataMap.put("calVersionNo", calVersionNo);
        Map<String, String> diffMap = calService.checkCalVersionDiff(dynamicObjects, formulaAndGradeMap);
        if (diffMap.size() == 0) {
            calService.cacheVersionData(versionData, formulaAndGradeMap, false);
            return null;
        }
        versionData.put("formula_grade_cachekey", formulaAndGradeMap);
        versionData.put("formula_grade_verionold", calversionDataMap);
        return CalHelper.buildConfirmMessage(diffMap);
    }

    private static String buildConfirmMessage(Map<String, String> diffMap) {
        String msg = ResManager.loadKDString((String)"\u6709\u5982\u4e0b\u8ba1\u7b97\u5143\u7d20\u4ea7\u751f\u65b0\u7248\u672c\uff0c\u662f\u5426\u5e94\u7528\u65b0\u7248\u672c\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"HSASCalTableList_128", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (SWCStringUtils.isNotEmpty((String)diffMap.get("diffFormula")) && SWCStringUtils.isNotEmpty((String)diffMap.get("diffGrade"))) {
            String msg1 = ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\uff1a{0},\u6570\u636e\u5206\u7ea7\uff1a{1}", (String)"CalConfirmPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            msg = msg + MessageFormat.format(msg1, diffMap.get("diffFormula"), diffMap.get("diffGrade"));
        } else {
            if (SWCStringUtils.isNotEmpty((String)diffMap.get("diffFormula"))) {
                String msg2 = ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\uff1a{0}", (String)"CalConfirmPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                msg = msg + MessageFormat.format(msg2, diffMap.get("diffFormula"));
            }
            if (SWCStringUtils.isNotEmpty((String)diffMap.get("diffGrade"))) {
                String msg3 = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\uff1a{0}", (String)"CalConfirmPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                msg = msg + MessageFormat.format(msg3, diffMap.get("diffGrade"));
            }
        }
        return msg;
    }

    public static Map<String, Object> startCal(CalPayRollTask calPayRollTask, Map<String, Object> versionData, Map<String, String> calModeMap, boolean resultCheck, String batchnum, String cacheUUID) throws Exception {
        CalTableCalService calService = new CalTableCalService();
        Long calPayRollTaskId = calPayRollTask.getCalPayRollTaskId();
        List<Long> calPersonIds = calPayRollTask.getCalPersons();
        Map<String, String> operationParam = calPayRollTask.getOperationParam();
        Long taxItemSchemeVid = operationParam.get("TAXITEMSCHEMEVID") == null ? null : Long.valueOf(operationParam.get("TAXITEMSCHEMEVID"));
        Map<String, Object> map = calService.cal(calPersonIds, calPayRollTaskId, operationParam.get("calType"), Integer.valueOf(operationParam.get("salaryItemCount")), versionData.get("calVersionNo").toString(), calModeMap, taxItemSchemeVid, resultCheck, DefaultCalPersonSplit.getInstance(), batchnum, cacheUUID, false);
        List calPersonIdList = (List)map.remove("calpersonidList");
        calPayRollTask.setCalPersons(calPersonIdList);
        map.put("calTaskId", calPayRollTask.getCalPayRollTaskId());
        map.put("calTaskName", calPayRollTask.getName());
        map.put("starttime", new Date());
        map.put("calType", operationParam.get("calType"));
        return map;
    }

    public static Map<Long, DynamicObject> collectPersonInfoMap(List<Long> calPersonIdList, Map<Long, Long> salaryFilePersonIndexRelMap, Map<Long, Long> salaryFileCalPersonRelMap, List<Long> needTaxCalIdList) {
        logger.info("begin collectPersonInfoMap");
        if (CollectionUtils.isEmpty(calPersonIdList)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("id,salaryfile.id,salaryfile.person.id,salaryfile.paystatus,salaryfile.employee.empnumber,salaryfile.employee.showname", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
        if (CollectionUtils.isEmpty((Collection)calPersons)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        List personIdList = calPersons.stream().map(calPerson -> calPerson.getLong("salaryfile.person.id")).collect(Collectors.toList());
        helper.setEntityName("hsas_personhr");
        DynamicObjectCollection personhrs = helper.queryOriginalCollection("id,personindexid", new QFilter[]{new QFilter("id", "in", personIdList)});
        if (CollectionUtils.isEmpty((Collection)personhrs)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> personHrIndexMap = personhrs.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("personindexid")));
        HashMap<Long, DynamicObject> personhrMap = new HashMap<Long, DynamicObject>(personhrs.size());
        Long personIndexId = null;
        Long personId = null;
        for (DynamicObject calPerson2 : calPersons) {
            personId = calPerson2.getLong("salaryfile.person.id");
            personIndexId = personHrIndexMap.get(personId);
            if (!personhrMap.containsKey(personIndexId)) {
                personhrMap.put(personIndexId, calPerson2);
            }
            if (!needTaxCalIdList.contains(calPerson2.getLong("id"))) continue;
            salaryFilePersonIndexRelMap.put(calPerson2.getLong("salaryfile.id"), personIndexId);
            salaryFileCalPersonRelMap.put(calPerson2.getLong("id"), calPerson2.getLong("salaryfile.id"));
        }
        logger.info("end collectPersonInfoMap");
        return personhrMap;
    }

    private static List<CalPayRollTask> getNeedTaxCalDataMap(List<CalPayRollTask> validDatas, List<Long> needTaxCalIdList) {
        ArrayList<CalPayRollTask> taxCalTaskDataList = new ArrayList<CalPayRollTask>(validDatas.size());
        for (CalPayRollTask task : validDatas) {
            if (!"1".equals(task.getOpenTaxCal())) continue;
            taxCalTaskDataList.add(task);
            needTaxCalIdList.addAll(task.getCalPersons());
        }
        return taxCalTaskDataList;
    }

    public static Map<String, Object> checkCert(List<Long> calPersonIdList, List<CalPayRollTask> validDatas) {
        Map<String, Object> result;
        logger.info("begin checkCert");
        try {
            List messageList;
            HashMap<Long, Long> salaryFilePersonIndexRelMap = new HashMap<Long, Long>(calPersonIdList.size());
            HashMap<Long, Long> salaryFileCalPersonRelMap = new HashMap<Long, Long>(calPersonIdList.size());
            ArrayList<Long> needTaxCalIdList = new ArrayList<Long>(16);
            List<CalPayRollTask> taxCalTaskDataList = CalHelper.getNeedTaxCalDataMap(validDatas, needTaxCalIdList);
            Map<Long, DynamicObject> personMap = CalHelper.collectPersonInfoMap(calPersonIdList, salaryFilePersonIndexRelMap, salaryFileCalPersonRelMap, needTaxCalIdList);
            ArrayList<Long> personIndexIdList = new ArrayList<Long>(personMap.keySet());
            ArrayList<Long> existPidList = new ArrayList<Long>(personIndexIdList.size());
            result = CalHelper.checkCertDetail(personMap, personIndexIdList, existPidList);
            if (!Boolean.TRUE.equals(result.get("success"))) {
                return result;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
            Map calCertResult = SWCCertCommonHelper.verifyCert((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", existPidList);
            result = CalHelper.handleCheckCertResult(calCertResult, resultMap);
            if (!Boolean.TRUE.equals(result.get("success"))) {
                return result;
            }
            if (taxCalTaskDataList.size() > 0) {
                HashMap<Long, List<Long>> noTaxFileTaskMap = new HashMap<Long, List<Long>>(16);
                HashMap<Long, List<Long>> noAuditTaxFileMap = new HashMap<Long, List<Long>>(16);
                Map<Long, List<Long>> countryMap = CalHelper.filterNoTaxFileData(salaryFilePersonIndexRelMap, salaryFileCalPersonRelMap, taxCalTaskDataList, noTaxFileTaskMap, noAuditTaxFileMap);
                HashMap<String, Object> params = null;
                for (Map.Entry<Long, List<Long>> entry : countryMap.entrySet()) {
                    if (entry.getValue().size() == 0) continue;
                    params = new HashMap<String, Object>(2);
                    params.put("countryid", entry.getKey());
                    params.put("data", entry.getValue());
                    CalHelper.printLog("checkCertInSIT request=>", params);
                    Map taxResult = (Map)SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"checkCertInSIT", (Object[])new Object[]{params});
                    CalHelper.printLog("checkCertInSIT respones=>", taxResult);
                    result = CalHelper.handleCheckCertResult((Map)taxResult.get("data"), resultMap);
                    if (Boolean.TRUE.equals(result.get("success"))) continue;
                    return result;
                }
                ISWCAppCache appCache = null;
                List noTaxFileList = null;
                List noAuditTaxFileList = null;
                for (CalPayRollTask task : taxCalTaskDataList) {
                    appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "caltask_notaxfile_%s", task.getCalPayRollTaskId()));
                    noTaxFileList = (List)noTaxFileTaskMap.get(task.getCalPayRollTaskId());
                    noAuditTaxFileList = (List)noAuditTaxFileMap.get(task.getCalPayRollTaskId());
                    if (!SWCListUtils.isEmpty((List)noTaxFileList)) {
                        appCache.put("noTaxFileList", (Object)noTaxFileList);
                    }
                    if (SWCListUtils.isEmpty((List)noAuditTaxFileList)) continue;
                    appCache.put("noAuditTaxFileList", (Object)noAuditTaxFileList);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(messageList = (List)resultMap.get("messageList")))) {
                StringBuilder sb = new StringBuilder();
                for (String message : messageList) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(message);
                }
                result.put("msg", sb.toString());
                result.put("messageList", messageList);
                result.put("isCurrentView", Boolean.FALSE);
                result.put("msgType", SWCStringUtils.equals((String)((String)resultMap.get("showMessageType")), (String)"1") ? "1" : "2");
                result.put("infoType", resultMap.get("infoType"));
            }
        }
        catch (Exception exception) {
            logger.error("checkCert error", (Throwable)exception);
            return CalHelper.getExceptionResult(exception);
        }
        logger.info("end checkCert");
        return result;
    }

    private static Map<String, Object> getExceptionResult(Exception exception) {
        HashMap<String, Object> exceptionResult = new HashMap<String, Object>(4);
        String errorMsg = exception.getMessage();
        if (SWCStringUtils.isEmpty((String)errorMsg)) {
            errorMsg = ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CalHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        exceptionResult.put("msg", errorMsg);
        exceptionResult.put("msgType", "1");
        exceptionResult.put("success", Boolean.FALSE);
        exceptionResult.put("isCurrentView", Boolean.TRUE);
        return exceptionResult;
    }

    public static void printLog(String msg, Object obj) {
        try {
            logger.info(msg, (Object)SWCJSONUtils.toString((Object)obj));
            logger.info(SWCJSONUtils.toString((Object)obj));
        }
        catch (Exception e) {
            logger.error(msg, (Throwable)e);
        }
    }

    private static Map<Long, List<Long>> getSalaryTaxFileRelMap(DynamicObjectCollection salaryTaxFileRelList) {
        HashMap<Long, List<Long>> salaryTaxFileRelMap = new HashMap<Long, List<Long>>(salaryTaxFileRelList.size());
        ArrayList<Long> taxFileIdList = null;
        for (DynamicObject obj : salaryTaxFileRelList) {
            taxFileIdList = (ArrayList<Long>)salaryTaxFileRelMap.get(obj.getLong("salaryfile.id"));
            if (taxFileIdList == null) {
                taxFileIdList = new ArrayList<Long>(10);
                salaryTaxFileRelMap.put(obj.getLong("salaryfile.id"), taxFileIdList);
            }
            taxFileIdList.add(obj.getLong("taxfile"));
        }
        return salaryTaxFileRelMap;
    }

    private static Map<Long, List<Long>> filterNoTaxFileData(Map<Long, Long> salaryFilePersonIndexRelMap, Map<Long, Long> salaryFileCalPersonRelMap, List<CalPayRollTask> taxCalTaskDataList, Map<Long, List<Long>> noTaxFileTaskMap, Map<Long, List<Long>> noAuditTaxFileMap) {
        HashMap<Long, List<Long>> countryMap = new HashMap<Long, List<Long>>(16);
        DynamicObjectCollection salaryTaxFileRelList = CalHelper.getSalaryTaxFileRelData(salaryFilePersonIndexRelMap.keySet());
        Map<Long, List<Long>> salaryTaxFileRelMap = CalHelper.getSalaryTaxFileRelMap(salaryTaxFileRelList);
        List<Map<String, Object>> dataList = CalHelper.getDataList(taxCalTaskDataList, salaryTaxFileRelMap, salaryFileCalPersonRelMap);
        Map<Long, Map<String, Object>> taxFileMap = CalHelper.queryTaxFileInfo(dataList);
        Long salaryFileId = null;
        List<Long> taxFileIdList = null;
        List tempList = null;
        List noTaxFileList = null;
        List noAuditTaxFileList = null;
        for (CalPayRollTask task : taxCalTaskDataList) {
            if (task.getCalPersons() == null) continue;
            tempList = countryMap.getOrDefault(task.getCountryId(), new ArrayList(10));
            noTaxFileList = noTaxFileTaskMap.getOrDefault(task.getCalPayRollTaskId(), new ArrayList(10));
            noAuditTaxFileList = noAuditTaxFileMap.getOrDefault(task.getCalPayRollTaskId(), new ArrayList(10));
            for (Long calPersonId : task.getCalPersons()) {
                salaryFileId = salaryFileCalPersonRelMap.get(calPersonId);
                taxFileIdList = salaryTaxFileRelMap.get(salaryFileId);
                if (SWCListUtils.isEmpty(taxFileIdList)) {
                    noTaxFileList.add(calPersonId);
                    continue;
                }
                if (!CalHelper.isNeedCheckCert(taxFileIdList, taxFileMap, noAuditTaxFileList, calPersonId, noTaxFileList) || tempList.contains(salaryFilePersonIndexRelMap.get(salaryFileId))) continue;
                tempList.add(salaryFilePersonIndexRelMap.get(salaryFileId));
            }
            countryMap.put(task.getCountryId(), tempList);
            noTaxFileTaskMap.put(task.getCalPayRollTaskId(), noTaxFileList);
            noAuditTaxFileMap.put(task.getCalPayRollTaskId(), noAuditTaxFileList);
        }
        return countryMap;
    }

    private static boolean isNeedCheckCert(List<Long> taxFileIdList, Map<Long, Map<String, Object>> taxFileMap, List<Long> noAuditTaxFileList, Long calPersonId, List<Long> noTaxFileList) {
        Map<String, Object> taxFileInfoMap = null;
        boolean isNeedCheck = false;
        boolean isNotAudit = false;
        boolean isNoTaxFile = false;
        for (Long taxFileId : taxFileIdList) {
            taxFileInfoMap = taxFileMap.get(taxFileId);
            if (taxFileInfoMap == null) {
                isNoTaxFile = true;
                continue;
            }
            if (!"C".equals(taxFileInfoMap.get("status"))) {
                isNotAudit = true;
                continue;
            }
            if (TAXSTATUS_STOP.equals(taxFileInfoMap.get("taxstatus"))) continue;
            isNeedCheck = true;
        }
        if (isNeedCheck) {
            return true;
        }
        if (isNotAudit) {
            noAuditTaxFileList.add(calPersonId);
            return false;
        }
        if (isNoTaxFile) {
            noTaxFileList.add(calPersonId);
        }
        return false;
    }

    private static List<Map<String, Object>> getDataList(List<CalPayRollTask> taxCalTaskDataList, Map<Long, List<Long>> salaryTaxFileRelMap, Map<Long, Long> salaryFileCalPersonRelMap) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        Long salaryFileId = null;
        List<Long> taxFileIdList = null;
        HashMap<String, Long> tempMap = null;
        HashSet<String> countryTaxFileSet = new HashSet<String>(16);
        for (CalPayRollTask task : taxCalTaskDataList) {
            if (task.getCalPersons() == null) continue;
            for (Long calPersonId : task.getCalPersons()) {
                salaryFileId = salaryFileCalPersonRelMap.get(calPersonId);
                taxFileIdList = salaryTaxFileRelMap.get(salaryFileId);
                if (SWCListUtils.isEmpty(taxFileIdList)) continue;
                for (Long taxFileId : taxFileIdList) {
                    if (!countryTaxFileSet.add(task.getCountryId() + "@;@" + taxFileId)) continue;
                    tempMap = new HashMap<String, Long>(2);
                    tempMap.put("regionId", task.getCountryId());
                    tempMap.put("taxFileId", taxFileId);
                    dataList.add(tempMap);
                }
            }
        }
        return dataList;
    }

    private static Map<Long, Map<String, Object>> queryTaxFileInfo(List<Map<String, Object>> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<String, Object> request = new HashMap<String, Object>(6);
        HashSet<String> propsSet = new HashSet<String>(2);
        propsSet.add("status");
        propsSet.add("taxstatus");
        request.put("data", dataList);
        request.put("props", propsSet);
        request.put("includeStop", Boolean.TRUE);
        request.put("useHis", 1);
        request.put("includeAbandon", 0);
        request.put("dataStatus", 0);
        logger.info("findPropOfTaxFile start,request=>{}", (Object)((Object)request).toString());
        Map response = null;
        try {
            response = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findPropOfTaxFile", (Object[])new Object[]{request});
        }
        catch (Exception ex) {
            logger.error("findPropOfTaxFile error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u6863\u6848\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\u3002", (String)"CalHelper_1", (String)"swc-hsas-business", (Object[])new Object[0])), new Object[0]);
        }
        if (response == null) {
            logger.error("findPropOfTaxFile response is null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u6863\u6848\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"CalHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        logger.info("findPropOfTaxFile end,response=>{}", (Object)response.toString());
        if (!((Boolean)response.get("success")).booleanValue()) {
            throw new KDBizException((String)response.get("message"));
        }
        Map data = (Map)response.get("data");
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u6863\u6848\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"CalHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        return data;
    }

    private static DynamicObjectCollection getSalaryTaxFileRelData(Set<Long> fileIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        String fields = "salaryfile.id,taxfile";
        QFilter filter = new QFilter("salaryfile.id", "in", fileIdSet);
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection data = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (data == null) {
            return new DynamicObjectCollection();
        }
        return data;
    }

    private static Map<String, Object> handleCheckCertResult(Map<String, Object> certResult, Map<String, Object> resultMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Map msg = (Map)certResult.get("msg");
        Boolean isForbidden = (Boolean)certResult.get("isforbidden");
        boolean needShowMessage = Boolean.parseBoolean((String)msg.get("showMessage"));
        String message = (String)msg.get("message");
        String showMessageType = (String)msg.get("showMessageType");
        String infoType = (String)msg.get("infoType");
        if (isForbidden.booleanValue()) {
            result.put("msg", message);
            result.put("msgType", SWCStringUtils.equals((String)showMessageType, (String)"1") ? "1" : "2");
            result.put("success", Boolean.FALSE);
            result.put("isCurrentView", Boolean.TRUE);
        } else {
            if (needShowMessage) {
                List messageList;
                int compareResult = CalHelper.compareInfoLevel((String)resultMap.get("infoType"), infoType);
                if (compareResult < 0) {
                    resultMap.put("showMessageType", showMessageType);
                    resultMap.put("infoType", infoType);
                    ArrayList<String> messageList2 = new ArrayList<String>(10);
                    messageList2.add(message);
                    resultMap.put("messageList", messageList2);
                } else if (compareResult == 0 && !(messageList = (List)resultMap.getOrDefault("messageList", new ArrayList(10))).contains(message)) {
                    messageList.add(message);
                    resultMap.put("messageList", messageList);
                }
            }
            result.put("success", Boolean.TRUE);
        }
        return result;
    }

    private static Map<String, Object> checkCertDetail(Map<Long, DynamicObject> personMap, List<Long> pidList, List<Long> existPidList) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        logger.info("checkCertDetail begin");
        ArrayList<Long> unExistPidList = new ArrayList<Long>(pidList);
        DynamicObject[] certDetails = SWCCertCommonHelper.queryCertDetail((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", pidList);
        if (certDetails != null && certDetails.length != 0) {
            existPidList.addAll(Arrays.stream(certDetails).map(certDetail -> certDetail.getLong("pid")).collect(Collectors.toList()));
        }
        unExistPidList.removeAll(existPidList);
        if (unExistPidList.size() == 0) {
            result.put("success", Boolean.TRUE);
            return result;
        }
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask");
        String groupName = HRCertCommonHelper.getGroupName((String)groupId);
        int errorCount = 0;
        StringBuilder messageBuilder = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> personEntry : personMap.entrySet()) {
            DynamicObject calPerson = personEntry.getValue();
            if (!unExistPidList.contains(personEntry.getKey()) || SWCStringUtils.equals((String)TAXSTATUS_STOP, (String)calPerson.getString("salaryfile.paystatus"))) continue;
            ++errorCount;
            if (messageBuilder.length() > 0) {
                messageBuilder.append("<br/>");
            }
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a{2}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"CalHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            msg = MessageFormat.format(msg, calPerson.getString("salaryfile.employee.showname"), calPerson.getString("salaryfile.employee.empnumber"), groupName);
            messageBuilder.append(msg);
        }
        if (errorCount == 0) {
            result.put("success", Boolean.TRUE);
        } else if (errorCount == 1) {
            result.put("msg", messageBuilder.toString());
            result.put("msgType", "1");
            result.put("success", Boolean.FALSE);
            result.put("isCurrentView", Boolean.TRUE);
        } else {
            result.put("msg", messageBuilder.toString());
            result.put("msgType", "3");
            result.put("success", Boolean.FALSE);
            result.put("isCurrentView", Boolean.TRUE);
        }
        logger.info("checkCertDetail end");
        return result;
    }

    public static FormShowParameter getOperationResultParameter(String message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationresult");
        parameters.setShowTitle(false);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;text-align:left;margin-top: 40px;word-wrap:break-word;word-break:break-all;width:100%;font-size:12px'>");
        buf.append(message).append("<br/>");
        parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", null);
        return parameters;
    }

    public static int compareInfoLevel(String infoType1, String infoType2) {
        Integer infoLevel1 = infoLevelMap.get(infoType1);
        Integer infoLevel2 = infoLevelMap.get(infoType2);
        if (SWCStringUtils.isEmpty((String)infoType1) || infoLevel1 == null) {
            return -1;
        }
        if (SWCStringUtils.isEmpty((String)infoType2) || infoLevel2 == null) {
            return 1;
        }
        return infoLevel1.compareTo(infoLevel2);
    }

    public static String getReportNum() {
        String reportNum = null;
        Date data = new Date();
        reportNum = DateUtils.formatDate((Date)data, (Object[])new Object[]{"yyyyMMddHHmmss"});
        return reportNum;
    }

    public static DynamicObjectCollection getCalPersonData(List<Long> calPersonIdList, Long calTaskId, QFilter authFilter) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,calstatus";
        QFilter qFilter = new QFilter("caltask", "=", (Object)calTaskId);
        if (!SWCListUtils.isEmpty(calPersonIdList)) {
            qFilter.and("id", "in", calPersonIdList);
        }
        if (authFilter != null) {
            qFilter.and(authFilter);
        }
        qFilter.and("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()));
        String[] calStatusArray = new String[]{CalStateEnum.UNCAL.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode()};
        qFilter.and("calstatus", "in", (Object)calStatusArray);
        return calPersonHelper.queryOriginalCollection(fields, new QFilter[]{qFilter});
    }

    public static void groupByCalStatusForCalPerson(DynamicObjectCollection calPersonDataList, Map<String, String> operationParam) {
        String calState = null;
        int unCalState = 0;
        int partialCaledState = 0;
        int errorState = 0;
        int caledState = 0;
        for (DynamicObject calPerson : calPersonDataList) {
            calState = calPerson.getString("calstatus");
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.UNCAL.getCode())) {
                ++unCalState;
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PARTIAL_CALED.getCode())) {
                ++partialCaledState;
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PRECAL_ERROR.getCode()) || SWCStringUtils.equals((String)calState, (String)CalStateEnum.PUSHTAX_ERROR.getCode()) || SWCStringUtils.equals((String)calState, (String)CalStateEnum.TAXCAL_ERROR.getCode()) || SWCStringUtils.equals((String)calState, (String)CalStateEnum.PULLTAX_ERROR.getCode()) || SWCStringUtils.equals((String)calState, (String)CalStateEnum.AFTERCAL_ERROR.getCode())) {
                ++errorState;
                continue;
            }
            if (!SWCStringUtils.equals((String)calState, (String)CalStateEnum.ALL_CALED.getCode())) continue;
            ++caledState;
        }
        operationParam.put("uncalstate", String.valueOf(unCalState));
        operationParam.put("partialcaledstate", String.valueOf(partialCaledState));
        operationParam.put("errorstate", String.valueOf(errorState));
        operationParam.put("caledstate", String.valueOf(caledState));
    }

    public static void handlePrompts(Map<String, Object> result, IFormView view) {
        String msg = (String)result.get("msg");
        if (SWCStringUtils.isNotEmpty((String)msg)) {
            IFormView showView;
            boolean isCurrentView = (Boolean)result.get("isCurrentView");
            String msgType = (String)result.get("msgType");
            IFormView iFormView = showView = isCurrentView ? view : view.getParentView();
            if (SWCStringUtils.equals((String)"1", (String)msgType)) {
                showView.showErrorNotification(msg);
            } else if (SWCStringUtils.equals((String)"2", (String)msgType)) {
                showView.showTipNotification(msg);
            } else if (SWCStringUtils.equals((String)"3", (String)msgType)) {
                showView.showForm(CalHelper.getOperationResultParameter(msg));
            }
            if (!isCurrentView) {
                view.sendFormAction(showView);
            }
        }
    }

    public static long getCalRecordPkId() {
        return DB.genLongId((String)"t_hsas_calrecord");
    }

    static {
        infoLevelMap.put("FORBIDDEN", 4);
        infoLevelMap.put("EXCEED", 3);
        infoLevelMap.put("WARNING", 2);
        infoLevelMap.put("NORMAL", 1);
    }
}

