/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.vo.CalPayRollTaskProcessVO;
import kd.swc.hsas.common.vo.CalProcessVO;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalProcessHandler {
    public static final String SAVEPROGRESSBARAP = "saveprogressbarap";
    public static final String CALPROGRESSBARAP = "calprogressbarap";
    private int allCalCount;
    private int successCount;
    private int failCount;
    private Date startTime;

    public CalProcessHandler(int allCalCount, int successCount, int failCount, Date startTime) {
        this.allCalCount = allCalCount;
        this.successCount = successCount;
        this.failCount = failCount;
        this.startTime = startTime;
    }

    public int getCalProcess() {
        BigDecimal calCount = new BigDecimal(this.allCalCount);
        BigDecimal caledCount = new BigDecimal(this.getCaledCount());
        if (caledCount.compareTo(calCount) == 0) {
            return 100;
        }
        if (BigDecimal.ZERO.compareTo(caledCount) == 0) {
            return 0;
        }
        BigDecimal progress = caledCount.divide(calCount, 2, 4).multiply(new BigDecimal("100"));
        if (progress.intValue() == 100 && this.allCalCount != this.getCaledCount()) {
            return 99;
        }
        return progress.intValue();
    }

    public int getCaledCount() {
        return this.successCount + this.failCount;
    }

    public int getPendingCount() {
        return this.allCalCount - this.successCount - this.failCount;
    }

    public String getCalText() {
        return this.getCalText(this.getCalProcess());
    }

    public String getCalText(int calProgressPercent) {
        StringBuilder calText = new StringBuilder();
        if (calProgressPercent <= 0) {
            calText.append("<div><span style='font-size:12px;color:#007fff'>");
            calText.append(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"CalProgressPlugin_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (calProgressPercent >= 100) {
            calText.append("<div><span style='font-size:12px;color:#5fbf00'>");
            calText.append(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"CalProgressPlugin_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else {
            calText.append("<div><span style='font-size:12px;color:#007fff'>");
            calText.append(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"CalProgressPlugin_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        calText.append("</span></div>");
        return calText.toString();
    }

    public int getAllCalCount() {
        return this.allCalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public static CalProcessHandler buildCalProcessHandler(String type, CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        int allCalCount = 0;
        Integer successCount = 0;
        Integer failCount = 0;
        for (CalProcessVO calProcessVO : calPayRollTaskProcessVO.getCalProcessVOs()) {
            allCalCount += calProcessVO.getCalCount();
            Long calRecordId = calProcessVO.getCalRecordId();
            ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
            Map saveProgressMap = (Map)calProgressAppCache.get(String.format(Locale.ROOT, "calrecord_progress_%s", calRecordId), Map.class);
            if (saveProgressMap == null) {
                saveProgressMap = FormulaCacheUtils.getCalProgerssFromPage((long)calRecordId, (String)String.format(Locale.ROOT, "calrecord_progress_%s", calRecordId));
            }
            if (null == saveProgressMap || saveProgressMap.size() <= 0) continue;
            successCount = successCount + (Integer)saveProgressMap.get("sucesscount");
            failCount = failCount + (Integer)saveProgressMap.get("failcount");
        }
        return new CalProcessHandler(allCalCount, successCount, failCount, calPayRollTaskProcessVO.getStartTime());
    }

    public static CalProcessHandler buildCancelCalProcessHandler(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_CAL");
        int allCalCount = 0;
        Integer successCount = 0;
        Integer failCount = 0;
        for (CalProcessVO calProcessVO : calPayRollTaskProcessVO.getCalProcessVOs()) {
            allCalCount += calProcessVO.getCalCount();
            Long calRecordId = calProcessVO.getCalRecordId();
            Map progressMap = (Map)appCache.get(MessageFormat.format("tax_record_progress_{0}", String.valueOf(calRecordId)), Map.class);
            if (progressMap == null || progressMap.size() <= 0) continue;
            successCount = successCount + (Integer)progressMap.get("successcount");
            failCount = failCount + (Integer)progressMap.get("failcount");
        }
        return new CalProcessHandler(allCalCount, successCount, failCount, calPayRollTaskProcessVO.getStartTime());
    }

    public static void changeGreenProgressColor(IFormView view, String key) {
        HashMap<String, String> ctl = new HashMap<String, String>(2);
        ctl.put("id", key);
        ctl.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG4kIC5rZC1wcm9ncmVzcy1iZ3tcbsKgwqBiYWNrZ3JvdW5kOiMxQkE4NTQgIWltcG9ydGFudDtcbn1cbiJ9");
        view.updateControlMetadata(key, ctl);
    }

    public static boolean isParentRequestList(IFormView view) {
        IFormView parentView = view.getParentView();
        return parentView instanceof ListView && SWCStringUtils.equals((String)((ListView)parentView).getBillFormId(), (String)"hsas_calrequest");
    }

    public static void grandfatherShow(IFormView view, FormShowParameter parameter) {
        IFormView grandfatherView = view.getParentView().getParentView();
        if (grandfatherView != null) {
            grandfatherView.showForm(parameter);
            view.sendFormAction(grandfatherView);
        } else {
            view.getParentView().showForm(parameter);
            view.sendFormAction(view.getParentView());
        }
        view.close();
    }

    public static void openRequestList(IFormView view) {
        IFormView parentView = view.getParentView();
        if (CalProcessHandler.isParentRequestList(view)) {
            ((ListView)parentView).refresh();
        } else {
            ListShowParameter calRequestListForm = CalRequestHelper.getCalRequestListForm();
            parentView.showForm((FormShowParameter)calRequestListForm);
        }
        view.close();
        view.sendFormAction(parentView);
    }

    public static void filterStopTask(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        List recordIds = calPayRollTaskProcessVO.getCalProcessVOs().stream().map(CalProcessVO::getCalRecordId).collect(Collectors.toList());
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("id", "in", recordIds);
        filter.and("calstatus", "=", (Object)"3");
        DynamicObjectCollection stopedRecords = recordHelper.queryOriginalCollection("id", filter.toArray());
        Set stopedRecordIds = stopedRecords.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        calPayRollTaskProcessVO.getCalProcessVOs().removeIf(o -> stopedRecordIds.contains(o.getCalRecordId()));
    }
}

