/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.sdk.swc.hsas.common.enums.SalaryItemTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizConsumeMethodEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections.MapUtils;

public class CalResultQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(CalResultQueryHelper.class);
    private static final String HSAS_SALARYCALRESULTQUERY = "hsas_salarycalresultquery";
    private static final String ATTITEMTYPE_SUMMARY = "1";
    private static final String ATTITEMTYPE_DETAIL = "0";
    private static final String CYCLE_YES = "1";
    private static final String CYCLE_NO = "0";

    public List<Long> getCalPersonIds(QFilter[] qFilters, String orderBys, int start, int limit) {
        List pkObjList = HRQueryEntityHelper.getInstance().queryAllPkByKSql(this.getQueryEntityType(), qFilters, orderBys, start, limit);
        List<Object> pkList = Lists.newArrayListWithExpectedSize((int)16);
        if (pkObjList != null) {
            pkList = pkObjList.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
        }
        return pkList;
    }

    public DynamicObjectCollection getCalPersonInfos(List<String> calPersonFields, QFilter[] qFilters, String orderBys, int start, int limit) {
        List<Long> pkList = this.getCalPersonIds(qFilters, orderBys, start, limit);
        return this.getCalPersonInfos(calPersonFields, pkList, orderBys, 0, -1);
    }

    public DynamicObjectCollection getCalPersonInfos(List<String> calPersonFields, List<Long> pkList, String orderBys, int start, int limit) {
        String selectProperties = String.join((CharSequence)",", calPersonFields);
        QFilter qFilter = new QFilter("id", "in", pkList);
        DynamicObjectCollection coll = null;
        boolean isLimitCount = true;
        if (limit <= 0) {
            isLimitCount = false;
        }
        try (DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(this.getQueryEntityType(), selectProperties, new QFilter[]{qFilter}, orderBys, isLimitCount, start, limit);){
            coll = ORM.create().toPlainDynamicObjectCollection(dataSet);
        }
        return coll;
    }

    public Map<Long, Map<Long, Object>> getCalResult(List<Long> pkList, String itemType, List<Long> itemIdList) {
        Map<Long, Map<String, Object>> itemInfoMap = this.getCalItemMap(itemType, itemIdList);
        Map<Long, Map<Long, Object>> resultMap = this.buildEntryData(pkList, itemType, itemIdList, itemInfoMap);
        return resultMap;
    }

    public Map<Long, Map<Long, Object>> getCalResult(List<Long> pkList, String itemType, Map<Long, Map<String, Object>> itemInfoMap) {
        if (itemInfoMap == null) {
            return new HashMap<Long, Map<Long, Object>>(16);
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>(itemInfoMap.keySet());
        Map<Long, Map<Long, Object>> resultMap = this.buildEntryData(pkList, itemType, itemIdList, itemInfoMap);
        return resultMap;
    }

    private Map<Long, Map<Long, Object>> buildEntryData(List<Long> pkList, String itemType, List<Long> itemIds, Map<Long, Map<String, Object>> itemInfoMap) {
        SalaryItemTypeEnum itemEnum = SalaryItemTypeEnum.getEnumByCode((String)itemType);
        QFilter entryFilter = new QFilter(itemEnum.getWholeItemFieldCode(), "in", itemIds);
        QFilter calPersonFilter = new QFilter("calpersonid", "in", pkList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_caltable");
        HashMap<Long, Map<Long, Object>> dataMap = new HashMap<Long, Map<Long, Object>>(itemIds.size());
        String selectProperties = itemEnum.getSelectProperties();
        if (itemEnum == SalaryItemTypeEnum.ITEMSL) {
            selectProperties = selectProperties + ",hsas_caltableentry.slprorationindex";
        } else if (itemEnum == SalaryItemTypeEnum.ITEMBS) {
            selectProperties = selectProperties + ",hsas_calbsentry.bsprorationindex";
        }
        try (DataSet dataSet = helper.queryDataSet("QueryServiceHelper.hsas_caltable", selectProperties, new QFilter[]{calPersonFilter, entryFilter});){
            HashMap<Long, Map> allProrationIndexMap = new HashMap<Long, Map>(16);
            for (Row row : dataSet) {
                Long calPersonId = row.getLong("calpersonid");
                HashMap<Long, Object> rowMap = (HashMap<Long, Object>)dataMap.get(calPersonId);
                if (rowMap == null) {
                    rowMap = new HashMap<Long, Object>(16);
                    dataMap.put(calPersonId, rowMap);
                }
                Long itemId = row.getLong(itemEnum.getWholeItemFieldCode());
                if (itemEnum == SalaryItemTypeEnum.ITEMSL) {
                    if (row.getInteger("hsas_caltableentry.slprorationindex") != 0) {
                        continue;
                    }
                } else if (itemEnum == SalaryItemTypeEnum.ITEMBS) {
                    Map prorationIndexMap = allProrationIndexMap.computeIfAbsent(calPersonId, key -> new HashMap(16));
                    int prorationIndex = prorationIndexMap.getOrDefault(itemId, 0);
                    int newIndex = row.getInteger("hsas_calbsentry.bsprorationindex");
                    if (newIndex < prorationIndex) continue;
                    prorationIndexMap.put(itemId, newIndex);
                }
                String storageType = MapUtils.getString(itemInfoMap.get(itemId), (Object)"storageType");
                rowMap.put(itemId, row.get(itemEnum.getWholeValueFieldCode(storageType)));
            }
        }
        return dataMap;
    }

    public Map<Long, Map<Long, Object>> getCalResultByCalTableId(List<Long> pkList, String itemType, List<Long> itemIdList) {
        Map<Long, Map<String, Object>> itemInfoMap = this.getCalItemMap(itemType, itemIdList);
        Map<Long, Map<Long, Object>> resultMap = this.buildEntryDataByCalTableId(pkList, itemType, itemIdList, itemInfoMap);
        return resultMap;
    }

    public Map<Long, Map<Long, Object>> getCalResultByCalTableId(List<Long> pkList, String itemType, Map<Long, Map<String, Object>> itemInfoMap) {
        if (itemInfoMap == null) {
            return new HashMap<Long, Map<Long, Object>>(16);
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>(itemInfoMap.keySet());
        Map<Long, Map<Long, Object>> resultMap = this.buildEntryDataByCalTableId(pkList, itemType, itemIdList, itemInfoMap);
        return resultMap;
    }

    private Map<Long, Map<Long, Object>> buildEntryDataByCalTableId(List<Long> pkList, String itemType, List<Long> itemIds, Map<Long, Map<String, Object>> itemInfoMap) {
        SalaryItemTypeEnum itemEnum = SalaryItemTypeEnum.getEnumByCode((String)itemType);
        QFilter entryFilter = new QFilter(itemEnum.getWholeItemFieldCode(), "in", itemIds);
        QFilter idFilter = new QFilter("id", "in", pkList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_caltable");
        HashMap<Long, Map<Long, Object>> dataMap = new HashMap<Long, Map<Long, Object>>(itemIds.size());
        try (DataSet dataSet = helper.queryDataSet("QueryServiceHelper.hsas_caltable", itemEnum.getSelectProperties(), new QFilter[]{idFilter, entryFilter});){
            for (Row row : dataSet) {
                Long calTableId = row.getLong("id");
                HashMap<Long, Object> rowMap = (HashMap<Long, Object>)dataMap.get(calTableId);
                if (rowMap == null) {
                    rowMap = new HashMap<Long, Object>(16);
                    dataMap.put(calTableId, rowMap);
                }
                Long itemId = row.getLong(itemEnum.getWholeItemFieldCode());
                String storageType = MapUtils.getString(itemInfoMap.get(itemId), (Object)"storageType");
                rowMap.put(itemId, row.get(itemEnum.getWholeValueFieldCode(storageType)));
            }
        }
        return dataMap;
    }

    public Map<Long, Map<String, Object>> getCalItemMap(String itemType, List<Long> itemIdList) {
        SalaryItemTypeEnum itemTypeEnum = SalaryItemTypeEnum.getEnumByCode((String)itemType);
        HRBaseServiceHelper itemSlHelper = new HRBaseServiceHelper(itemTypeEnum.getEntityCode());
        QFilter qFilter = new QFilter("id", "in", itemIdList);
        String selectProperties = "id,number,name,uniquecode,datatype.showtype,datatype.storagetype";
        selectProperties = SalaryItemTypeEnum.ITEMBS.getCode().equals(itemType) ? selectProperties + ",scalelimit" : (SalaryItemTypeEnum.ITEMFT.getCode().equals(itemType) ? selectProperties + ",dataprecision.scale,dataround.id" : selectProperties + ",dataprecision.scale,dataround.id,datalength");
        DynamicObject[] itemDys = itemSlHelper.query(selectProperties, qFilter.toArray());
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(itemIdList.size());
        for (DynamicObject item : itemDys) {
            Long itemId = item.getLong("id");
            HashMap<String, String> itemInfoMap = (HashMap<String, String>)resultMap.get(itemId);
            if (itemInfoMap == null) {
                itemInfoMap = new HashMap<String, String>(16);
                resultMap.put(itemId, itemInfoMap);
            }
            itemInfoMap.put("number", item.getString("number"));
            itemInfoMap.put("name", item.getString("name"));
            itemInfoMap.put("storageType", item.getString("datatype.storagetype"));
            itemInfoMap.put("showType", item.getString("datatype.showtype"));
            itemInfoMap.put("uniqueCode", item.getString("uniquecode"));
            if (SalaryItemTypeEnum.ITEMBS.getCode().equals(itemType)) {
                itemInfoMap.put("scale", (String)((Object)Integer.valueOf(item.getInt("scalelimit"))));
                continue;
            }
            itemInfoMap.put("scale", (String)((Object)Integer.valueOf(item.getInt("dataprecision.scale"))));
            itemInfoMap.put("dataround", (String)((Object)Long.valueOf(item.getLong("dataround.id"))));
            if (SalaryItemTypeEnum.ITEMFT.getCode().equals(itemType)) continue;
            itemInfoMap.put("datalength", (String)((Object)Integer.valueOf(item.getInt("datalength"))));
        }
        return resultMap;
    }

    private QueryEntityType getQueryEntityType() {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)HSAS_SALARYCALRESULTQUERY);
        return queryEntityType;
    }

    public Map<String, Object> getSalaryItemRelBizItemResult(Map<String, Object> requestMap) {
        LOGGER.info("getSalaryItemRelBizItemResult start");
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        if (!this.checkParam(requestMap, responseMap)) {
            return responseMap;
        }
        LOGGER.info("requestMap = {}", (Object)requestMap.toString());
        try {
            ArrayList<Long> bizItemPropIdList;
            List calPersonIdList = (List)requestMap.get("calPersonIdList");
            List salaryItemIdList = (List)requestMap.get("salaryItemIdList");
            Boolean isNeedProrationDate = (Boolean)requestMap.get("isNeedProrationDate");
            List<Long> calTableIdList = this.getCalTableIdList(calPersonIdList);
            HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
            Map<Long, List<Map<String, Object>>> slBsRelInfoMap = this.getCalTableSlBsRelData(calTableIdList, salaryItemIdList, isNeedProrationDate, bizItemIdSet);
            if (slBsRelInfoMap.size() == 0) {
                responseMap.put("success", Boolean.TRUE);
                responseMap.put("message", null);
                responseMap.put("data", this.buildEmptyDataList(calPersonIdList));
                return responseMap;
            }
            DynamicObjectCollection bizDataList = this.getBizItemInfoData(bizItemIdSet);
            HashSet<Long> recBizItemIdSet = new HashSet<Long>(16);
            HashSet<Long> nonRecBizItemIdSet = new HashSet<Long>(16);
            HashSet<Long> attItemSumIdSet = new HashSet<Long>(16);
            HashSet<Long> attItemIdSet = new HashSet<Long>(16);
            Map<Long, String> bizItemMap = this.splitItemType(bizDataList, recBizItemIdSet, nonRecBizItemIdSet, attItemSumIdSet, attItemIdSet);
            ArrayList<String> bizDataPropList = (ArrayList<String>)requestMap.get("bizDataPropList");
            if (bizDataPropList == null) {
                bizDataPropList = new ArrayList<String>(0);
            }
            if ((bizItemPropIdList = (ArrayList<Long>)requestMap.get("bizItemPropIdList")) == null) {
                bizItemPropIdList = new ArrayList<Long>(0);
            }
            Map<String, List<Map<String, Object>>> recBizDataMap = this.getBizDataMap(recBizItemIdSet, calPersonIdList, bizDataPropList, bizItemPropIdList, "1");
            Map<String, List<Map<String, Object>>> nonRecBizDataMap = this.getBizDataMap(nonRecBizItemIdSet, calPersonIdList, bizDataPropList, bizItemPropIdList, "0");
            Map<String, List<Map<String, Object>>> attrBizDataSumMap = this.getAttrBizData(attItemSumIdSet, calPersonIdList, "1");
            Map<String, List<Map<String, Object>>> attrBizDataDetailMap = this.getAttrBizData(attItemIdSet, calPersonIdList, "0");
            ArrayList dataList = new ArrayList(calPersonIdList.size());
            HashMap<String, Serializable> dataMap = null;
            List<Map<String, Object>> relDataList = null;
            ArrayList<Map<String, Object>> itemRelList = null;
            for (Long calPersonId : calPersonIdList) {
                relDataList = slBsRelInfoMap.get(calPersonId);
                dataMap = new HashMap<String, Serializable>(2);
                dataMap.put("calPersonId", calPersonId);
                if (relDataList == null) {
                    dataMap.put("itemRelList", new ArrayList(0));
                    dataList.add(dataMap);
                    continue;
                }
                itemRelList = new ArrayList<Map<String, Object>>(10);
                for (Map<String, Object> temMap : relDataList) {
                    this.handleBizDataResult(temMap, recBizDataMap, itemRelList, isNeedProrationDate, false, bizItemMap);
                    this.handleBizDataResult(temMap, nonRecBizDataMap, itemRelList, isNeedProrationDate, false, bizItemMap);
                    this.handleBizDataResult(temMap, attrBizDataSumMap, itemRelList, isNeedProrationDate, true, bizItemMap);
                    this.handleBizDataResult(temMap, attrBizDataDetailMap, itemRelList, isNeedProrationDate, true, bizItemMap);
                }
                dataMap.put("itemRelList", itemRelList);
                dataList.add(dataMap);
            }
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", null);
            responseMap.put("data", dataList);
            LOGGER.info("getSalaryItemRelBizItemResult end");
            return responseMap;
        }
        catch (Exception ex) {
            LOGGER.error("getSalaryItemRelBizItemResult error.", (Throwable)ex);
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", ex.getMessage());
            responseMap.put("data", null);
            return responseMap;
        }
    }

    private void handleBizDataResult(Map<String, Object> slBsRelMap, Map<String, List<Map<String, Object>>> bizDataMap, List<Map<String, Object>> itemRelList, Boolean isNeedProrationDate, boolean isAttrItem, Map<Long, String> bizItemMap) {
        String dataKey = slBsRelMap.get("calPersonId") + "@" + slBsRelMap.get("bizItemId");
        List<Map<String, Object>> tempList = bizDataMap.get(dataKey);
        if (SWCListUtils.isEmpty(tempList)) {
            return;
        }
        Long bizItemId = (Long)slBsRelMap.get("bizItemId");
        String consumeMethod = bizItemMap.get(bizItemId);
        ArrayList<Map<String, Object>> bizDataList = new ArrayList<Map<String, Object>>(tempList.size());
        for (Map<String, Object> temMap : tempList) {
            if (!this.isMatchCondition(temMap, slBsRelMap, isAttrItem, bizItemMap)) continue;
            if (BizConsumeMethodEnum.AVE.getCode().equals(consumeMethod) || BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
                this.addItemRelListData(slBsRelMap, itemRelList, isNeedProrationDate, temMap);
                continue;
            }
            bizDataList.add(temMap);
        }
        if (bizDataList.size() == 0) {
            return;
        }
        Map<String, Object> matchMap = null;
        if (BizConsumeMethodEnum.MIN.getCode().equals(consumeMethod)) {
            matchMap = this.getMinValueObj(bizDataList);
        } else if (BizConsumeMethodEnum.MAX.getCode().equals(consumeMethod)) {
            matchMap = this.getMaxValueObj(bizDataList);
        } else if (BizConsumeMethodEnum.NEWEST.getCode().equals(consumeMethod)) {
            matchMap = this.getNewEstObj(bizDataList, isAttrItem);
        } else if (BizConsumeMethodEnum.EARLIEST.getCode().equals(consumeMethod)) {
            matchMap = this.getEarliestObj(bizDataList, isAttrItem);
        }
        if (matchMap == null) {
            return;
        }
        this.addItemRelListData(slBsRelMap, itemRelList, isNeedProrationDate, matchMap);
    }

    private void addItemRelListData(Map<String, Object> slBsRelMap, List<Map<String, Object>> itemRelList, Boolean isNeedProrationDate, Map<String, Object> temMap) {
        HashMap<String, Object> itemRelMap = new HashMap<String, Object>(16);
        itemRelMap.putAll(slBsRelMap);
        itemRelMap.putAll(temMap);
        itemRelMap.remove("calPersonId");
        itemRelMap.remove("bsed");
        itemRelMap.remove("attStartDate");
        itemRelMap.remove("attEndDate");
        if (!isNeedProrationDate.booleanValue()) {
            itemRelMap.remove("startDate");
            itemRelMap.remove("endDate");
        }
        itemRelList.add(itemRelMap);
    }

    private Map<String, Object> getEarliestObj(List<Map<String, Object>> bizDataList, boolean isAttrItem) {
        Map<String, Object> earliestMap = null;
        Date earliestDate = null;
        for (Map<String, Object> tempMap : bizDataList) {
            Date tempDate = null;
            tempDate = isAttrItem ? (Date)tempMap.get("attstartdate") : (Date)tempMap.get("bsed");
            if (earliestDate == null) {
                earliestDate = tempDate;
                earliestMap = tempMap;
                continue;
            }
            if (earliestDate.compareTo(tempDate) <= 0) continue;
            earliestDate = tempDate;
            earliestMap = tempMap;
        }
        return earliestMap;
    }

    private Map<String, Object> getNewEstObj(List<Map<String, Object>> bizDataList, boolean isAttrItem) {
        Map<String, Object> newEstMap = null;
        Date newEstDate = null;
        for (Map<String, Object> tempMap : bizDataList) {
            Date tempDate = null;
            tempDate = isAttrItem ? (Date)tempMap.get("attenddate") : (Date)tempMap.get("bsed");
            if (newEstDate == null) {
                newEstDate = tempDate;
                newEstMap = tempMap;
                continue;
            }
            if (newEstDate.compareTo(tempDate) >= 0) continue;
            newEstDate = tempDate;
            newEstMap = tempMap;
        }
        return newEstMap;
    }

    private Map<String, Object> getMaxValueObj(List<Map<String, Object>> bizDataList) {
        BigDecimal maxValue = null;
        Map<String, Object> maxObjMap = null;
        for (Map<String, Object> tempMap : bizDataList) {
            BigDecimal tempVal = (BigDecimal)tempMap.get("itemValue");
            if (maxValue == null) {
                maxValue = tempVal;
                maxObjMap = tempMap;
                continue;
            }
            if (tempVal.compareTo(maxValue) <= 0) continue;
            maxValue = tempVal;
            maxObjMap = tempMap;
        }
        return maxObjMap;
    }

    private Map<String, Object> getMinValueObj(List<Map<String, Object>> bizDataList) {
        BigDecimal minValue = null;
        Map<String, Object> minObjMap = null;
        for (Map<String, Object> tempMap : bizDataList) {
            BigDecimal tempVal = (BigDecimal)tempMap.get("itemValue");
            if (minValue == null) {
                minValue = tempVal;
                minObjMap = tempMap;
                continue;
            }
            if (tempVal.compareTo(minValue) >= 0) continue;
            minValue = tempVal;
            minObjMap = tempMap;
        }
        return minObjMap;
    }

    private boolean isMatchCondition(Map<String, Object> temMap, Map<String, Object> slBsRelMap, boolean isAttrItem, Map<Long, String> bizItemMap) {
        Date endDate = (Date)slBsRelMap.get("endDate");
        Date startDate = (Date)slBsRelMap.get("startDate");
        if (isAttrItem) {
            Date attStartDate = (Date)temMap.get("attStartDate");
            Date attEndDate = (Date)temMap.get("attEndDate");
            return !SWCDateUtils.after((Date)startDate, (Date)attStartDate) && !SWCDateUtils.before((Date)endDate, (Date)attEndDate);
        }
        Date bsed = (Date)temMap.get("bsed");
        Date bsled = (Date)temMap.get("bsled");
        boolean isRecu = (Boolean)temMap.get("isRecu");
        if (isRecu) {
            return !SWCDateUtils.after((Date)bsed, (Date)endDate) && (bsled == null || !SWCDateUtils.before((Date)bsled, (Date)startDate));
        }
        Long bizItemId = (Long)slBsRelMap.get("bizItemId");
        String consumeMethod = bizItemMap.get(bizItemId);
        Integer prorationIndex = (Integer)slBsRelMap.get("prorationIndex");
        if (!SWCDateUtils.after((Date)bsed, (Date)endDate)) {
            if (prorationIndex > 0 && (BizConsumeMethodEnum.NEWEST.getCode().equals(consumeMethod) || BizConsumeMethodEnum.EARLIEST.getCode().equals(consumeMethod))) {
                return true;
            }
            return !SWCDateUtils.before((Date)bsed, (Date)startDate);
        }
        return false;
    }

    private Map<Long, String> splitItemType(DynamicObjectCollection bizDataList, Set<Long> recBizItemIdSet, Set<Long> nonRecBizItemIdSet, Set<Long> attItemSumIdSet, Set<Long> attItemIdSet) {
        HashMap<Long, String> bizItemMap = new HashMap<Long, String>(16);
        for (DynamicObject bizItem : bizDataList) {
            bizItemMap.put(bizItem.getLong("id"), bizItem.getString("consumemethod"));
            if ("1".equals(bizItem.getString("classification"))) {
                if ("1".equals(bizItem.getString("attitemtype"))) {
                    attItemSumIdSet.add(bizItem.getLong("id"));
                    continue;
                }
                attItemIdSet.add(bizItem.getLong("id"));
                continue;
            }
            if ("1".equals(bizItem.getString("cycle"))) {
                recBizItemIdSet.add(bizItem.getLong("id"));
                continue;
            }
            nonRecBizItemIdSet.add(bizItem.getLong("id"));
        }
        return bizItemMap;
    }

    private Map<String, List<Map<String, Object>>> getBizDataMap(Set<Long> recBizItemIdSet, List<Long> calPersonIdList, List<String> bizDataPropList, List<Long> bizItemPropIdList, String cycleType) {
        LOGGER.info("getBizDataMap start,cycleType = {}", (Object)cycleType);
        if (recBizItemIdSet.size() == 0) {
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("bizitem.id", "in", recBizItemIdSet);
        filter.and("actualcomsume", "=", (Object)"1");
        SWCDataServiceHelper helper = null;
        helper = "1".equals(cycleType) ? new SWCDataServiceHelper("hsas_calbizdatarel") : new SWCDataServiceHelper("hsas_calnonbizdatarel");
        String fields = "calpersonid,bizitem.id,bizdataid";
        DynamicObjectCollection calBizDataRelList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if ("1".equals(cycleType)) {
            helper.setEntityName("hsas_calbsnocntrel");
        } else {
            helper.setEntityName("hsas_noncalbsnocntrel");
        }
        calBizDataRelList.addAll((Collection)helper.queryOriginalCollection(fields, new QFilter[]{filter}));
        HashMap<Long, ArrayList<String>> bizDataMap = new HashMap<Long, ArrayList<String>>(16);
        List tempList = null;
        for (DynamicObject obj : calBizDataRelList) {
            tempList = (ArrayList<String>)bizDataMap.get(obj.getLong("bizdataid"));
            if (tempList == null) {
                tempList = new ArrayList<String>(10);
                bizDataMap.put(obj.getLong("bizdataid"), (ArrayList<String>)tempList);
            }
            tempList.add(obj.getLong("calpersonid") + "@" + obj.getLong("bizitem.id"));
        }
        if (bizDataMap.size() == 0) {
            LOGGER.info("bizDataMap is empty");
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        LOGGER.info("bizDataMap : {}", (Object)((Object)bizDataMap).toString());
        filter = new QFilter("id", "in", bizDataMap.keySet());
        if ("1".equals(cycleType)) {
            helper.setEntityName("hsas_recurbizdata");
        } else {
            helper.setEntityName("hsas_nonrecurbizdata");
        }
        StringBuilder fieldsSb = new StringBuilder();
        if (!bizDataPropList.contains("datavalue")) {
            fieldsSb.append("datavalue,");
        }
        if (!bizDataPropList.contains("currency.id")) {
            fieldsSb.append("currency.id,");
        }
        if ("1".equals(cycleType)) {
            fieldsSb.append("id,bizitem.datatype.id,bsed,bsled,recurbizpropentry,recurbizpropentry.bizitemprop,recurbizpropentry.propdatavalue");
        } else {
            fieldsSb.append("id,bizitem.datatype.id,bsed,bsled");
        }
        fields = bizDataPropList.size() > 0 ? fieldsSb.append(',').append(String.join((CharSequence)",", bizDataPropList)).toString() : fieldsSb.toString();
        DynamicObject[] bizDataList = helper.query(fields, new QFilter[]{filter}, "bsed desc");
        HashMap<String, List<Map<String, Object>>> recBizDataMap = new HashMap<String, List<Map<String, Object>>>(bizDataList.length);
        HashMap<String, Object> tempMap = null;
        ArrayList tempBizist = null;
        for (DynamicObject obj : bizDataList) {
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("currencyId", obj.getLong("currency.id"));
            tempMap.put("bizDataId", obj.getLong("id"));
            tempMap.put("dataTypeId", obj.getLong("bizitem.datatype.id"));
            tempMap.put("bsed", obj.getDate("bsed"));
            tempMap.put("bsled", obj.getDate("bsled"));
            tempMap.put("itemValue", this.dealValue(obj.getString("datavalue"), obj.getLong("bizitem.datatype.id")));
            tempMap.put("bizDataPropMap", this.getBizDataPropMap(bizDataPropList, obj));
            if ("1".equals(cycleType)) {
                tempMap.put("bizItemPropMap", this.getBizItemPropMap(bizItemPropIdList, obj));
                tempMap.put("isRecu", true);
            } else {
                tempMap.put("isRecu", false);
                tempMap.put("bizItemPropMap", new HashMap(0));
            }
            tempList = (List)bizDataMap.get(obj.getLong("id"));
            for (String dataKey : tempList) {
                tempBizist = (ArrayList)recBizDataMap.get(dataKey);
                if (tempBizist == null) {
                    tempBizist = new ArrayList(10);
                    recBizDataMap.put(dataKey, tempBizist);
                }
                tempBizist.add(tempMap);
            }
        }
        LOGGER.info("getBizDataMap end,cycleType = {}", (Object)cycleType);
        return recBizDataMap;
    }

    private Map<Long, Object> getBizItemPropMap(List<Long> bizItemPropIdList, DynamicObject obj) {
        if (SWCListUtils.isEmpty(bizItemPropIdList)) {
            return new HashMap<Long, Object>(0);
        }
        HashMap<Long, Object> bizItemPropMap = new HashMap<Long, Object>(bizItemPropIdList.size());
        DynamicObjectCollection propDataList = obj.getDynamicObjectCollection("recurbizpropentry");
        if (propDataList.size() == 0) {
            return new HashMap<Long, Object>(0);
        }
        for (DynamicObject temp : propDataList) {
            if (!bizItemPropIdList.contains(temp.getLong("bizitemprop.id"))) continue;
            bizItemPropMap.put(temp.getLong("bizitemprop.id"), this.dealValue(temp.getString("propdatavalue"), temp.getLong("bizitemprop.datatype.id")));
        }
        return bizItemPropMap;
    }

    private Map<String, Object> getBizDataPropMap(List<String> bizDataPropList, DynamicObject obj) {
        if (SWCListUtils.isEmpty(bizDataPropList)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> bizDataPropMap = new HashMap<String, Object>(bizDataPropList.size());
        for (String field : bizDataPropList) {
            bizDataPropMap.put(field, obj.get(field));
        }
        return bizDataPropMap;
    }

    private Object dealValue(String value, long dataTypeId) {
        Object result = null;
        if (DataTypeEnum.AMOUNT.getDbId() == dataTypeId || DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            result = new BigDecimal(value);
        } else if (DataTypeEnum.DATE.getDbId() == dataTypeId) {
            try {
                result = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOGGER.error("dealValue error", (Throwable)e);
            }
        } else {
            result = value;
        }
        return result;
    }

    private DynamicObjectCollection getBizItemInfoData(Set<Long> bizItemIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "in", bizItemIdSet);
        String fields = "id,datatype.id,classification,attitemtype,cycle,consumemethod";
        DynamicObjectCollection bizDataList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return bizDataList;
    }

    private List<Map<String, Object>> buildEmptyDataList(List<Long> calPersonIdList) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(calPersonIdList.size());
        HashMap<String, Serializable> tempMap = null;
        for (Long calPersonId : calPersonIdList) {
            tempMap = new HashMap<String, Serializable>(2);
            tempMap.put("calPersonId", calPersonId);
            tempMap.put("itemRelList", new ArrayList(0));
            dataList.add(tempMap);
        }
        return dataList;
    }

    private Map<Long, List<Map<String, Object>>> getCalTableSlBsRelData(List<Long> calTableIdList, List<Long> salaryItemIdList, Boolean isNeedProrationDate, Set<Long> bizItemIdSet) {
        LOGGER.info("getCalTableSlBsRelData start");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        if (!SWCListUtils.isEmpty(salaryItemIdList)) {
            filter.and("hsas_calslbsrelentry.slitem.id", "in", salaryItemIdList);
        }
        String fields = "id,calpersonid,hsas_calslbsrelentry.slitem.id,hsas_calslbsrelentry.bsitem.id,hsas_calslbsrelentry.relprorationindex";
        DynamicObjectCollection slBsRelDataList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (slBsRelDataList.size() == 0) {
            LOGGER.info("slBsRelDataList is empty");
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        Set slItemIdSet = slBsRelDataList.stream().map(obj -> obj.getLong("hsas_calslbsrelentry.slitem.id")).collect(Collectors.toSet());
        filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_caltableentry.salaryitem.id", "in", slItemIdSet);
        fields = "id,calpersonid,hsas_caltableentry.salaryitem.id,hsas_caltableentry.slstartdate,hsas_caltableentry.slenddate,hsas_caltableentry.slprorationindex";
        DynamicObjectCollection slResultList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map<String, DynamicObject> slResultMap = slResultList.stream().collect(Collectors.toMap(obj -> obj.getLong("calpersonid") + "@" + obj.getLong("hsas_caltableentry.salaryitem.id") + "@" + obj.getInt("hsas_caltableentry.slprorationindex"), obj -> obj));
        HashMap<Long, List<Map<String, Object>>> slBsRelInfoMap = new HashMap<Long, List<Map<String, Object>>>(16);
        ArrayList tempList = null;
        HashMap<String, Serializable> tempMap = null;
        DynamicObject slResult = null;
        String groupKey = null;
        for (DynamicObject tempObj : slBsRelDataList) {
            tempList = (ArrayList)slBsRelInfoMap.get(tempObj.getLong("calpersonid"));
            if (tempList == null) {
                tempList = new ArrayList(10);
                slBsRelInfoMap.put(tempObj.getLong("calpersonid"), tempList);
            }
            bizItemIdSet.add(tempObj.getLong("hsas_calslbsrelentry.bsitem.id"));
            tempMap = new HashMap<String, Serializable>(16);
            tempMap.put("calPersonId", Long.valueOf(tempObj.getLong("calpersonid")));
            tempMap.put("salaryItemId", Long.valueOf(tempObj.getLong("hsas_calslbsrelentry.slitem.id")));
            tempMap.put("bizItemId", Long.valueOf(tempObj.getLong("hsas_calslbsrelentry.bsitem.id")));
            tempMap.put("prorationIndex", Integer.valueOf(tempObj.getInt("hsas_calslbsrelentry.relprorationindex")));
            groupKey = tempObj.getLong("calpersonid") + "@" + tempObj.getLong("hsas_calslbsrelentry.slitem.id") + "@" + tempObj.getLong("hsas_calslbsrelentry.relprorationindex");
            slResult = slResultMap.get(groupKey);
            if (slResult != null) {
                tempMap.put("startDate", slResult.getDate("hsas_caltableentry.slstartdate"));
                tempMap.put("endDate", slResult.getDate("hsas_caltableentry.slenddate"));
            } else {
                tempMap.put("startDate", null);
                tempMap.put("endDate", null);
            }
            tempList.add(tempMap);
        }
        LOGGER.info("getCalTableSlBsRelData end");
        return slBsRelInfoMap;
    }

    private List<Long> getCalTableIdList(List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObjectCollection calPersonDataList = helper.queryOriginalCollection("id,calresultid", new QFilter[]{filter});
        return calPersonDataList.stream().map(obj -> obj.getLong("calresultid")).collect(Collectors.toList());
    }

    private boolean checkParam(Map<String, Object> requestMap, Map<String, Object> responseMap) {
        if (requestMap == null || requestMap.size() == 0) {
            responseMap.put("success", Boolean.FALSE);
            responseMap.put("message", ResManager.loadKDString((String)"\u63a5\u53e3\u5165\u53c2\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a", (String)"CalResultQueryHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
            responseMap.put("data", null);
            return false;
        }
        List calPersonIdList = (List)requestMap.get("calPersonIdList");
        Boolean isNeedProrationDate = (Boolean)requestMap.get("isNeedProrationDate");
        if (SWCListUtils.isEmpty((List)calPersonIdList)) {
            responseMap.put("success", Boolean.FALSE);
            responseMap.put("message", ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355ID\u96c6\u5408\u4e3a\u7a7a", (String)"CalResultQueryHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            responseMap.put("data", null);
            return false;
        }
        if (isNeedProrationDate == null) {
            responseMap.put("success", Boolean.FALSE);
            responseMap.put("message", ResManager.loadKDString((String)"\u662f\u5426\u8fd4\u56de\u5206\u6bb5\u65e5\u671f\u4e3a\u7a7a", (String)"CalResultQueryHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            responseMap.put("data", null);
            return false;
        }
        if (calPersonIdList.size() > 500) {
            responseMap.put("success", Boolean.FALSE);
            responseMap.put("message", ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355ID\u53c2\u6570\u4e2a\u6570\u6bcf\u6279\u4e0d\u80fd\u8d85\u8fc7500", (String)"CalResultQueryHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            responseMap.put("data", null);
            return false;
        }
        return true;
    }

    private Map<String, List<Map<String, Object>>> getAttrBizData(Set<Long> attItemSumIdSet, List<Long> calPersonIdList, String type) {
        LOGGER.info("getAttrBizData start,type = {}", (Object)type);
        if (attItemSumIdSet.size() == 0) {
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and("attbizitem.id", "in", attItemSumIdSet);
        filter.and("actualcomsume", "=", (Object)"1");
        SWCDataServiceHelper helper = null;
        helper = "1".equals(type) ? new SWCDataServiceHelper("hsas_calattbizdatarel") : new SWCDataServiceHelper("hsas_calattbsdetailrel");
        String fields = "calpersonid,attbizitem.id,attbizdataid";
        DynamicObjectCollection calAttrBizDataRelList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if ("1".equals(type)) {
            helper.setEntityName("hsas_calattnocntrel");
        } else {
            helper.setEntityName("hsas_calattdetnocntrel");
        }
        calAttrBizDataRelList.addAll((Collection)helper.queryOriginalCollection(fields, new QFilter[]{filter}));
        HashMap<Long, ArrayList<String>> bizDataMap = new HashMap<Long, ArrayList<String>>(16);
        List tempList = null;
        for (DynamicObject obj : calAttrBizDataRelList) {
            tempList = (ArrayList<String>)bizDataMap.get(obj.getLong("attbizdataid"));
            if (tempList == null) {
                tempList = new ArrayList<String>(10);
                bizDataMap.put(obj.getLong("attbizdataid"), (ArrayList<String>)tempList);
            }
            tempList.add(obj.getLong("calpersonid") + "@" + obj.getLong("attbizitem.id"));
        }
        if (bizDataMap.size() == 0) {
            LOGGER.info("attr bizDataMap is empty");
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        LOGGER.info("attr bizDataMap : {}", (Object)((Object)bizDataMap).toString());
        filter = new QFilter("id", "in", bizDataMap.keySet());
        if ("1".equals(type)) {
            helper.setEntityName("hsas_attbizdatasummary");
        } else {
            helper.setEntityName("hsas_attbizdatadetail");
        }
        fields = "id,currency.id,attbizitem.datatype.id,textvalue,datevalue,decimalvalue,amountvalue,attstartdate,attenddate";
        DynamicObject[] recBizDataList = helper.query(fields, new QFilter[]{filter});
        HashMap<String, List<Map<String, Object>>> attrBizDataMap = new HashMap<String, List<Map<String, Object>>>(recBizDataList.length);
        HashMap<String, Object> tempMap = null;
        ArrayList bizDataList = null;
        for (DynamicObject obj : recBizDataList) {
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("currencyId", obj.getLong("currency.id"));
            tempMap.put("bizDataId", obj.getLong("id"));
            tempMap.put("dataTypeId", obj.getLong("attbizitem.datatype.id"));
            tempMap.put("itemValue", this.dealAttrBizDataValue(obj, obj.getLong("attbizitem.datatype.id")));
            tempMap.put("bizDataPropMap", new HashMap(0));
            tempMap.put("bizItemPropMap", new HashMap(0));
            tempMap.put("attStartDate", obj.getDate("attstartdate"));
            tempMap.put("attEndDate", obj.getDate("attenddate"));
            tempList = (List)bizDataMap.get(obj.getLong("id"));
            for (String dataKey : tempList) {
                bizDataList = (ArrayList)attrBizDataMap.get(dataKey);
                if (bizDataList == null) {
                    bizDataList = new ArrayList(10);
                    attrBizDataMap.put(dataKey, bizDataList);
                }
                bizDataList.add(tempMap);
            }
        }
        LOGGER.info("getAttrBizData end,type = {}", (Object)type);
        return attrBizDataMap;
    }

    private Object dealAttrBizDataValue(DynamicObject obj, long dataTypeId) {
        Object result = null;
        result = DataTypeEnum.AMOUNT.getDbId() == dataTypeId ? obj.getBigDecimal("amountvalue") : (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId ? obj.getBigDecimal("decimalvalue") : (DataTypeEnum.DATE.getDbId() == dataTypeId ? obj.getDate("datevalue") : obj.getString("textvalue")));
        return result;
    }
}

