/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections.CollectionUtils;

public class CalTableCalHelper {
    private static final Log logger = LogFactory.getLog(CalTableCalHelper.class);

    public static DynamicObject buildCalBatchObj(long calRecordId, int totalCount, long calBatchId, String calStatus, String calMode) {
        SWCDataServiceHelper calBatchHelper = new SWCDataServiceHelper("hsas_calbatch");
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject calBatch = calBatchHelper.generateEmptyDynamicObject();
        calBatch.set("record", (Object)calRecordId);
        calBatch.set("totalcount", (Object)totalCount);
        calBatch.set("calstatus", (Object)calStatus);
        calBatch.set("calMode", (Object)calMode);
        calBatch.set("createtime", (Object)new Date());
        calBatch.set("modifytime", (Object)new Date());
        calBatch.set("creator", (Object)userId);
        calBatch.set("modifier", (Object)userId);
        calBatch.set("id", (Object)calBatchId);
        return calBatch;
    }

    public static DynamicObjectCollection getCalRuleFormula(long calRuleHisVid) {
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleHisVid);
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        String fields = "calruleitementry.formula.id,calruleitementry.seq";
        DynamicObjectCollection calRuleHisData = calRuleHisHelper.queryOriginalCollection(fields, new QFilter[]{qFilter}, "calruleitementry.seq asc");
        return calRuleHisData;
    }

    public static List<DynamicObject> getFormulaGradeData(Date startDate, Date endDate, List<Long> formulaBoIdList) {
        ArrayList<DynamicObject> formulaData = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        QFilter filter = new QFilter("boid", "in", formulaBoIdList);
        filter.and("bsed", "<=", (Object)endDate);
        filter.and("bsled", ">=", (Object)startDate);
        filter.and("datastatus", "in", Arrays.asList("0", "1", "2"));
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        String fields = "id,originalexp,boid,name,number,salaryitem.name,dependondatagrade,bsed";
        DynamicObject[] formulaCollection = formulaHelper.query(fields, new QFilter[]{filter}, "bsed desc");
        HashSet<String> formulaNumberSet = new HashSet<String>(16);
        for (DynamicObject obj : formulaCollection) {
            if (!formulaNumberSet.add(obj.getString("number"))) continue;
            formulaData.add(obj);
        }
        return formulaData;
    }

    public static DynamicObjectCollection getCalVersionData(String calVersionNo, Long calRuleVid) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calversion");
        QFilter filter = new QFilter("calversionno", "=", (Object)calVersionNo);
        filter.and("calrulev", "=", (Object)calRuleVid);
        String selectFields = "calversionno,datatype,formulav.id,formulav.boid,datagradev.id,salaryitemname";
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(selectFields, new QFilter[]{filter});
        return dynamicObjects;
    }

    public static List<Long> getFormulaBaseIdByVid(List<Long> formulaVid) {
        ArrayList<Long> formulaBaseIds = new ArrayList<Long>(formulaVid.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_formula");
        QFilter filter = new QFilter("id", "in", formulaVid);
        String selectFields = "boid";
        DynamicObjectCollection objs = helper.queryOriginalCollection(selectFields, new QFilter[]{filter});
        for (DynamicObject obj : objs) {
            formulaBaseIds.add(obj.getLong("boid"));
        }
        return formulaBaseIds;
    }

    public static String createCalVersion(Map<String, Object> formulaAndGradeMap) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calversion");
        String calversionno = CalTableCalHelper.generateCalVersionNo();
        Map dataGradeVMap = (Map)formulaAndGradeMap.get("dataGradeVMap");
        Map formulaMap = (Map)formulaAndGradeMap.get("formulaMap");
        List formulaHisList = (List)formulaMap.get("formulaDataList");
        Map formulabaseMap = (Map)formulaAndGradeMap.get("formulabaseMap");
        Map formulaVidAndGradeVidMap = (Map)formulaAndGradeMap.get("formulaVidAndGradeVidMap");
        Map taxItemSchMap = (Map)formulaAndGradeMap.get("taxItemSchVMap");
        Long calRuleHisVid = (Long)formulaAndGradeMap.get("calRuleHisVid");
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        ArrayList<DynamicObject> calVersions = new ArrayList<DynamicObject>(formulaHisList.size() + dataGradeVMap.size() + taxItemSchMap.size());
        if (taxItemSchMap.size() > 0) {
            CalTableCalHelper.createTaxItemSchVersion(type, calversionno, taxItemSchMap, calVersions, calRuleHisVid);
        }
        if (formulabaseMap instanceof LinkedHashMap) {
            HashMap<Long, Integer> formulaCalMap = new HashMap<Long, Integer>(formulabaseMap.size());
            for (Map.Entry entry : formulabaseMap.entrySet()) {
                formulaCalMap.put(Long.valueOf(String.valueOf(entry.getKey())), (Integer)entry.getValue());
            }
            CalTableCalHelper.createFormulaCalVersion(calVersions, formulaHisList, type, calversionno, calRuleHisVid, formulaCalMap, userId, now);
        } else {
            CalTableCalHelper.createFormulaCalVersion(calVersions, formulaHisList, type, calversionno, calRuleHisVid, formulabaseMap, userId, now);
        }
        HashMap<Long, Map<String, Object>> gradeVidMap = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry singleGradeVMap : dataGradeVMap.entrySet()) {
            gradeVidMap.put(Long.parseLong(((Map)singleGradeVMap.getValue()).get("id").toString()), (Map<String, Object>)singleGradeVMap.getValue());
        }
        if (formulaVidAndGradeVidMap instanceof LinkedHashMap) {
            HashMap<Long, List<Long>> gradeMap = new HashMap<Long, List<Long>>(formulaVidAndGradeVidMap.size());
            for (Map.Entry entry : formulaVidAndGradeVidMap.entrySet()) {
                gradeMap.put(Long.valueOf(String.valueOf(entry.getKey())), (List<Long>)entry.getValue());
            }
            CalTableCalHelper.createGradeCalVersion(calVersions, gradeVidMap, type, calversionno, calRuleHisVid, gradeMap, userId, now);
        } else {
            CalTableCalHelper.createGradeCalVersion(calVersions, gradeVidMap, type, calversionno, calRuleHisVid, formulaVidAndGradeVidMap, userId, now);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calversion");
        helper.save(calVersions.toArray(new DynamicObject[calVersions.size()]));
        return calversionno;
    }

    private static void createTaxItemSchVersion(MainEntityType type, String calversionno, Map<String, String> taxItemSchMap, List<DynamicObject> calVersions, Long calRuleHisVid) {
        DynamicObject newVersion = (DynamicObject)type.createInstance();
        newVersion.set("calversionno", (Object)calversionno);
        newVersion.set("calrulev", (Object)calRuleHisVid);
        newVersion.set("index", (Object)0);
        newVersion.set("datatype", (Object)"0");
        newVersion.set("showname", (Object)(taxItemSchMap.get("name") + " " + taxItemSchMap.get("bsed")));
        newVersion.set("taxprojschemev", (Object)Long.valueOf(taxItemSchMap.get("id")));
        newVersion.set("creator", (Object)RequestContext.get().getCurrUserId());
        newVersion.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newVersion.set("createtime", (Object)new Date());
        newVersion.set("modifytime", (Object)new Date());
        calVersions.add(newVersion);
    }

    private static void createFormulaCalVersion(List<DynamicObject> calVersions, List<Map<String, Object>> formulaHisList, MainEntityType type, String calversionno, Long calRuleHisVid, Map<Long, Integer> formulabaseMap, Long userId, Date now) {
        for (Map<String, Object> formulaHis : formulaHisList) {
            DynamicObject calversion = (DynamicObject)type.createInstance();
            calversion.set("calversionno", (Object)calversionno);
            calversion.set("calrulev", (Object)calRuleHisVid);
            calversion.set("formulav", formulaHis.get("id"));
            calversion.set("index", (Object)formulabaseMap.get(formulaHis.get("boid")));
            calversion.set("datatype", (Object)"1");
            try {
                calversion.set("showname", (Object)(formulaHis.get("name") + " " + SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)formulaHis.get("bsed").toString()), (String)"yyyyMMdd")));
            }
            catch (ParseException e) {
                logger.error("createCalVersion_ParseException");
            }
            calversion.set("salaryitemname", formulaHis.get("salaryitem.name"));
            calversion.set("creator", (Object)userId);
            calversion.set("modifier", (Object)userId);
            calversion.set("createtime", (Object)now);
            calversion.set("modifytime", (Object)now);
            calVersions.add(calversion);
        }
    }

    private static void createGradeCalVersion(List<DynamicObject> calVersions, Map<Long, Map<String, Object>> dataGradeVMap, MainEntityType type, String calversionno, Long calRuleHisVid, Map<Long, List<Long>> gradeVMap, Long userId, Date now) {
        int index = 1;
        for (Map.Entry<Long, List<Long>> entry : gradeVMap.entrySet()) {
            List<Long> value = entry.getValue();
            if (!CollectionUtils.isNotEmpty(value)) continue;
            for (Long singleV : value) {
                DynamicObject newVersion = (DynamicObject)type.createInstance();
                newVersion.set("calversionno", (Object)calversionno);
                newVersion.set("calrulev", (Object)calRuleHisVid);
                newVersion.set("formulav", (Object)entry.getKey());
                newVersion.set("datagradev", (Object)singleV);
                newVersion.set("index", (Object)index++);
                newVersion.set("datatype", (Object)"2");
                try {
                    newVersion.set("showname", (Object)(dataGradeVMap.get(singleV).get("name") + " " + SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)dataGradeVMap.get(singleV).get("bsed").toString()), (String)"yyyyMMdd")));
                }
                catch (ParseException e) {
                    logger.error("createCalVersion_ParseException");
                }
                newVersion.set("creator", (Object)userId);
                newVersion.set("modifier", (Object)userId);
                newVersion.set("createtime", (Object)now);
                newVersion.set("modifytime", (Object)now);
                calVersions.add(newVersion);
            }
        }
    }

    private static String generateCalVersionNo() {
        return SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
    }

    public static Map<String, Map<String, Object>> getGradeVidMap(List<String> gradeUniqueCodeList, Date startDate, Date endDate) {
        HashMap<String, Map<String, Object>> gradeVidMap = new HashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper dmHelper = new SWCDataServiceHelper("hsas_datagrade");
        QFilter hisFilter = new QFilter("uniquecode", "in", gradeUniqueCodeList);
        hisFilter.and("bsed", "<=", (Object)endDate);
        hisFilter.and("bsled", ">=", (Object)startDate);
        hisFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)hisFilter);
        String hisOrderBy = "uniquecode asc,bsed desc";
        DynamicObjectCollection versionData = dmHelper.queryOriginalCollection("id,uniquecode,number,name,bsed", new QFilter[]{hisFilter}, hisOrderBy);
        if (versionData == null || versionData.size() == 0) {
            return gradeVidMap;
        }
        HashSet<String> uniquecodeSet = new HashSet<String>(16);
        for (DynamicObject obj : versionData) {
            String uniquecode = obj.getString("uniquecode");
            if (!uniquecodeSet.add(uniquecode)) continue;
            HashMap<String, Object> single = new HashMap<String, Object>(5);
            single.put("id", obj.getLong("id"));
            single.put("uniquecode", obj.getString("uniquecode"));
            single.put("number", obj.getString("number"));
            single.put("name", obj.getString("name"));
            single.put("bsed", obj.getDate("bsed"));
            gradeVidMap.put(uniquecode, single);
        }
        return gradeVidMap;
    }

    public static void setCalTaskParam(Map<String, Object> paramMap, List<Long> passRowIdList, DynamicObject calTask) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)calTask.getLong("id"));
        filter.and(new QFilter("org", "=", (Object)calTask.getLong("org.id")));
        filter.and(new QFilter("belongperiod", "=", (Object)calTask.getDate("payrolldate")));
        QFilter filter2 = new QFilter("id", "in", passRowIdList);
        HashSet<Long> personSet = new HashSet<Long>(16);
        HashSet<Long> salaryFileSet = new HashSet<Long>(16);
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("salaryfile.employee.id,salaryfile.id", new QFilter[]{filter, filter2});
        if (!CollectionUtils.isEmpty((Collection)calPersons)) {
            for (DynamicObject calPerson : calPersons) {
                personSet.add(calPerson.getLong("salaryfile.employee.id"));
                salaryFileSet.add(calPerson.getLong("salaryFile.id"));
            }
        }
        paramMap.put("personCount", String.valueOf(personSet.size()));
        paramMap.put("salaryFileCount", String.valueOf(salaryFileSet.size()));
        long calRulevId = calTask.getLong("calrulev.id");
        SWCDataServiceHelper calRuleHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRulev = calRuleHelper.queryOne((Object)calRulevId);
        if (calRulev == null) {
            paramMap.put("salaryItemCount", 0);
            return;
        }
        DynamicObjectCollection calRuleItemEntry = calRulev.getDynamicObjectCollection("calruleitementry");
        paramMap.put("salaryItemCount", calRuleItemEntry.size());
    }

    public static Map<String, String> rollBackCalCheck(List<Long> calPersonIdList, DynamicObject calTaskInfo, Long calRecordId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        ArrayList dataMap = new ArrayList(calPersonIdList.size());
        for (Long calPersonId : calPersonIdList) {
            HashMap<String, String> srcDataMap = new HashMap<String, String>(1);
            srcDataMap.put("srcDataKey", calPersonId.toString());
            dataMap.add(srcDataMap);
        }
        HashMap<String, Object> rollBackTaxRequest = new HashMap<String, Object>(16);
        rollBackTaxRequest.put("srcType", "1");
        rollBackTaxRequest.put("payDate", calTaskInfo.getDate("paydate"));
        rollBackTaxRequest.put("country", String.valueOf(calTaskInfo.getLong("country.id")));
        rollBackTaxRequest.put("currency", calTaskInfo.getLong("payrollgroupv.currency.id"));
        rollBackTaxRequest.put("operateKey", calRecordId + "cancelcal");
        rollBackTaxRequest.put("preValidateKey", calRecordId + "cancelcal");
        rollBackTaxRequest.put("operator", RequestContext.get().getCurrUserId());
        rollBackTaxRequest.put("langeCode", Lang.get().getLangTag());
        rollBackTaxRequest.put("calTaskNumber", calTaskInfo.getString("number"));
        rollBackTaxRequest.put("calTaskName", calTaskInfo.getString("name"));
        rollBackTaxRequest.put("validate", Boolean.TRUE);
        rollBackTaxRequest.put("data", dataMap);
        CalHelper.printLog("IndividualTaxCalService.cancelCalculate interface request==>", rollBackTaxRequest);
        Map rollBackTaxResponse = null;
        try {
            rollBackTaxResponse = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"cancelCalculate", (Object[])new Object[]{rollBackTaxRequest});
        }
        catch (Exception e) {
            logger.error("IndividualTaxCalService.cancelCalculate error,msg=>", (Throwable)e);
            resultMap.put("msg", ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u4e91\u8ba1\u7b97\u56de\u6eda\u6821\u9a8c\u63a5\u53e3\u5931\u8d25\u3002", (String)"CalTableCalHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
            resultMap.put("level", String.valueOf(ErrorLevel.Error.getValue()));
            return resultMap;
        }
        CalHelper.printLog("IndividualTaxCalService.cancelCalculate interface response==>", rollBackTaxResponse);
        Boolean success = (Boolean)rollBackTaxResponse.get("success");
        if (!success.booleanValue()) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u4e2a\u7a0e\u4e91\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7ec8\u6b62\u8ba1\u7b97\u5931\u8d25\u3002", (String)"CalTableCalHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            resultMap.put("level", String.valueOf(ErrorLevel.Error.getValue()));
            return resultMap;
        }
        List responeseDataMap = (List)rollBackTaxResponse.get("data");
        if (responeseDataMap == null || responeseDataMap.size() == 0) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u8c03\u7528\u4e2a\u7a0e\u4e91\u8ba1\u7b97\u56de\u6eda\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"CalTableCalHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            resultMap.put("level", String.valueOf(ErrorLevel.Error.getValue()));
            return resultMap;
        }
        boolean isNoCheckPass = false;
        for (Map tempMap : responeseDataMap) {
            if (((Boolean)tempMap.get("success")).booleanValue()) continue;
            isNoCheckPass = true;
            break;
        }
        if (isNoCheckPass) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u4e2a\u7a0e\u4e91\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7ec8\u6b62\u8ba1\u7b97\u5931\u8d25\u3002", (String)"CalTableCalHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            resultMap.put("level", String.valueOf(ErrorLevel.Error.getValue()));
        }
        return resultMap;
    }

    public static boolean checkIsHasCalingRecord(Long taskId, String opType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
        filter.and("calstatus", "=", (Object)"1");
        filter.and("optype", "=", (Object)opType);
        int count = helper.count(new QFilter[]{filter});
        return count > 0;
    }
}

