/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;

public class CreateDynamicEntryHelper {
    public static final String DEFAULT_WIDTH = "200px";
    public static final String TEXT_ALIGN_left = "left";
    public static final String TEXT_ALIGN_CENTER = "center";
    public static final String TEXT_ALIGN_right = "right";
    public static final String LOCK_STRING = "new,edit,view,submit,audit";

    public static EntryAp createEntryAp(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setRowHeight("40px");
        return entryAp;
    }

    public static EntryFieldGroupAp createEntryFieldGroupAp(String key) {
        EntryFieldGroupAp entryFieldGroupAp = new EntryFieldGroupAp();
        entryFieldGroupAp.setName(new LocaleString(key));
        entryFieldGroupAp.setMerge(true);
        entryFieldGroupAp.setKey(key);
        entryFieldGroupAp.setTextAlign(TEXT_ALIGN_CENTER);
        return entryFieldGroupAp;
    }

    public static EntryFieldAp createDateRangeField(LocaleString name, String key) {
        EntryFieldAp fieldAp = CreateDynamicEntryHelper.createEntryFieldAp(name, key);
        DateRangeField dateRangeField = new DateRangeField();
        dateRangeField.setId(key);
        dateRangeField.setKey(key);
        dateRangeField.setStartDateFieldKey("calperiodstartdate");
        dateRangeField.setStartDateFieldName("calperiodstartdate");
        dateRangeField.setEndDateFieldKey("calperiodenddate");
        dateRangeField.setEndDateFieldName("calperiodenddate");
        fieldAp.setField((Field)dateRangeField);
        fieldAp.setLock(LOCK_STRING);
        fieldAp.setWidth(new LocaleString("230px"));
        return fieldAp;
    }

    public static EntryFieldAp createTextFieldAp(LocaleString name, String key) {
        EntryFieldAp fieldAp = CreateDynamicEntryHelper.createEntryFieldAp(name, key);
        TextField textField = new TextField();
        textField.setId(key);
        textField.setKey(key);
        textField.setDefValue(null);
        fieldAp.setField((Field)textField);
        fieldAp.setLock(LOCK_STRING);
        return fieldAp;
    }

    public static EntryFieldAp createDateTimeAp(LocaleString name, String key) {
        EntryFieldAp fieldAp = CreateDynamicEntryHelper.createEntryFieldAp(name, key);
        DateTimeField dateTimeField = new DateTimeField();
        dateTimeField.setId(key);
        dateTimeField.setKey(key);
        dateTimeField.setFieldName(name.getLocaleValue());
        dateTimeField.setMustInput(true);
        dateTimeField.setUseRegion(true);
        fieldAp.setField((Field)dateTimeField);
        return fieldAp;
    }

    public static EntryFieldAp createEntryFieldAp(LocaleString name, String key) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(name);
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFieldTextAlign(TEXT_ALIGN_CENTER);
        fieldAp.setTextAlign(TEXT_ALIGN_CENTER);
        return fieldAp;
    }

    public static EntryFieldAp createComFieldAp(String comboFieldKey, LocaleString name) {
        EntryFieldAp fieldAp = CreateDynamicEntryHelper.createEntryFieldAp(name, comboFieldKey);
        fieldAp.setComboShowStyle(1);
        fieldAp.setLock(LOCK_STRING);
        return fieldAp;
    }

    public static ComboProp createComboProp(String comboField, LocaleString name) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(comboField);
        comboProp.setDisplayName(name);
        comboProp.setDbIgnore(true);
        comboProp.setAlias("");
        comboProp.setShowStyle(1);
        return comboProp;
    }

    public static TextProp createTextProp(String name, LocaleString displayName) {
        TextProp textProp = new TextProp();
        textProp.setDisplayName(displayName);
        textProp.setName(name);
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public static DateTimeProp createDateTimeProp(String name, LocaleString displayName) {
        DateTimeProp startDateTimeProp = new DateTimeProp();
        startDateTimeProp.setDisplayName(displayName);
        startDateTimeProp.setName(name);
        startDateTimeProp.setDbIgnore(true);
        startDateTimeProp.setAlias("");
        return startDateTimeProp;
    }
}

