/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.swc.hsas.business.api.CalPersonSplit;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DefaultCalPersonSplit
implements CalPersonSplit {
    private static final DefaultCalPersonSplit INSTANCE = new DefaultCalPersonSplit();

    public static DefaultCalPersonSplit getInstance() {
        return INSTANCE;
    }

    @Override
    public Map<String, List<Long>> splitCalPersonByCalMode(DynamicObject[] calPersonArray, Map<String, String> calModeMap, DynamicObjectCollection calDetailList, boolean openTaxCal, Long calTaskId, Long calRecordId) {
        HashMap<String, List<Long>> calModeGroupIdListMap = new HashMap<String, List<Long>>(5);
        ArrayList<Long> calOrReCalIdList = new ArrayList<Long>(10);
        ArrayList<Long> onlyPreCalIdList = new ArrayList<Long>(10);
        ArrayList<Long> afterCalIdList = new ArrayList<Long>(10);
        ArrayList<Long> pushTaxIdList = new ArrayList<Long>(10);
        ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "caltask_notaxfile_%s", calTaskId));
        ArrayList noTaxFileIdList = (ArrayList)cache.get("noTaxFileList", List.class);
        ArrayList noAuditTaxFileIdList = (ArrayList)cache.get("noAuditTaxFileList", List.class);
        cache.remove("noTaxFileList");
        cache.remove("noAuditTaxFileList");
        if (noTaxFileIdList == null) {
            noTaxFileIdList = new ArrayList(0);
        }
        if (noAuditTaxFileIdList == null) {
            noAuditTaxFileIdList = new ArrayList(0);
        }
        String noTaxFileMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u672a\u5173\u8054\u4e2a\u7a0e\u6863\u6848\u3002", (String)"PreCalCheckService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noAuditTaxFileMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"PreCalCheckService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        ArrayList<Long> pullTaxIdList = new ArrayList<Long>(10);
        String calState = null;
        String calMode = null;
        for (DynamicObject calPerson : calPersonArray) {
            if (noTaxFileIdList.contains(calPerson.getLong("id"))) {
                calDetailList.add((Object)this.getCalDetail(calPerson, (DynamicObjectType)type, calTaskId, calRecordId, noTaxFileMsg));
                continue;
            }
            if (noAuditTaxFileIdList.contains(calPerson.getLong("id"))) {
                calDetailList.add((Object)this.getCalDetail(calPerson, (DynamicObjectType)type, calTaskId, calRecordId, noAuditTaxFileMsg));
                continue;
            }
            calState = calPerson.getString("calstatus");
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.UNCAL.getCode())) {
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calMode = calModeMap.get("uncalstate");
                if (SWCStringUtils.equals((String)calMode, (String)"4")) {
                    calOrReCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                onlyPreCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PARTIAL_CALED.getCode())) {
                calMode = calModeMap.get("partialcaledstate");
                if (SWCStringUtils.equals((String)calMode, (String)"1")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                    onlyPreCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                if (SWCStringUtils.equals((String)calMode, (String)"2")) {
                    if (openTaxCal) {
                        calPerson.set("calstatus", (Object)CalStateEnum.PRECAL_CALED.getCode());
                        pushTaxIdList.add(calPerson.getLong("id"));
                        continue;
                    }
                    calPerson.set("calstatus", (Object)CalStateEnum.TAX_CALED.getCode());
                    afterCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calOrReCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.ALL_CALED.getCode())) {
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calOrReCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PRECAL_ERROR.getCode())) {
                calMode = calModeMap.get("errorstate");
                if (SWCStringUtils.equals((String)calMode, (String)"1")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                    onlyPreCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calOrReCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PUSHTAX_ERROR.getCode()) || SWCStringUtils.equals((String)calState, (String)CalStateEnum.TAXCAL_ERROR.getCode())) {
                calMode = calModeMap.get("errorstate");
                if (SWCStringUtils.equals((String)calMode, (String)"1")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                    onlyPreCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                if (SWCStringUtils.equals((String)calMode, (String)"2")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.PRECAL_CALED.getCode());
                    pushTaxIdList.add(calPerson.getLong("id"));
                    continue;
                }
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calOrReCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calState, (String)CalStateEnum.PULLTAX_ERROR.getCode())) {
                calMode = calModeMap.get("errorstate");
                if (SWCStringUtils.equals((String)calMode, (String)"1")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                    onlyPreCalIdList.add(calPerson.getLong("id"));
                    continue;
                }
                if (SWCStringUtils.equals((String)calMode, (String)"2")) {
                    calPerson.set("calstatus", (Object)CalStateEnum.PRECAL_CALED.getCode());
                    pullTaxIdList.add(calPerson.getLong("id"));
                    continue;
                }
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                calOrReCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (!SWCStringUtils.equals((String)calState, (String)CalStateEnum.AFTERCAL_ERROR.getCode())) continue;
            calMode = calModeMap.get("errorstate");
            if (SWCStringUtils.equals((String)calMode, (String)"1")) {
                calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                onlyPreCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)calMode, (String)"2")) {
                calPerson.set("calstatus", (Object)CalStateEnum.TAX_CALED.getCode());
                afterCalIdList.add(calPerson.getLong("id"));
                continue;
            }
            calPerson.set("calstatus", (Object)CalStateEnum.CALING.getCode());
            calOrReCalIdList.add(calPerson.getLong("id"));
        }
        if (!openTaxCal) {
            afterCalIdList.addAll(pushTaxIdList);
            afterCalIdList.addAll(pullTaxIdList);
            pushTaxIdList.clear();
            pullTaxIdList.clear();
        }
        calModeGroupIdListMap.put("calOrReCalIdList", calOrReCalIdList);
        calModeGroupIdListMap.put("onlyPreCalIdList", onlyPreCalIdList);
        calModeGroupIdListMap.put("afterCalIdList", afterCalIdList);
        calModeGroupIdListMap.put("pushTaxIdList", pushTaxIdList);
        calModeGroupIdListMap.put("pullTaxIdList", pullTaxIdList);
        return calModeGroupIdListMap;
    }

    private DynamicObject getCalDetail(DynamicObject calPerson, DynamicObjectType type, Long calTaskId, Long calRecordId, String failMsg) {
        DynamicObject calDetail = (DynamicObject)type.createInstance();
        calDetail.set("calpersonid", (Object)calPerson.getLong("id"));
        calDetail.set("salaryfile", (Object)calPerson.getLong("salaryfile.id"));
        calDetail.set("record", (Object)calRecordId);
        calDetail.set("batch", (Object)0L);
        calDetail.set("caltask", (Object)calTaskId);
        calDetail.set("calstatus", (Object)CalStatusEnum.FAIL.getCode());
        calDetail.set("failtype", (Object)FailureTypeEnum.CHECK_FAIL.getCode());
        calDetail.set("errorelement", (Object)"-");
        calDetail.set("failmsg", (Object)failMsg);
        calDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
        calDetail.set("createtime", (Object)new Date());
        calDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
        calDetail.set("modifytime", (Object)new Date());
        return calDetail;
    }
}

