/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.itemresult;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.itemresult.BaseItemResultFactory;
import kd.swc.hsas.common.dto.calitem.AccItemResultDTO;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class AccDataResultFactory
extends BaseItemResultFactory {
    private Long calPersonId;
    private DynamicObject calPersonObj;

    public AccDataResultFactory(Long calTableId, Boolean isProration, DynamicObject currency, Long calPersonId, DynamicObject calPersonObj) {
        super(calTableId, isProration, currency);
        this.calPersonId = calPersonId;
        this.calPersonObj = calPersonObj;
    }

    @Override
    public List<BaseItemResultDTO> createItemResultDTOList(Map<Long, String> dataTypeMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter filter = new QFilter("calpersonid", "=", (Object)this.calPersonId);
        DynamicObjectCollection calTableAccDataEntry = this.getCalTableAccDataEntry(helper, filter, null);
        return this.getList(calTableAccDataEntry, dataTypeMap);
    }

    private DynamicObjectCollection getCalTableAccDataEntry(SWCDataServiceHelper helper, QFilter filter, String orderBy) {
        String selectFields = "id,accresult.acc.id,accresult.acc.datatype.id,accresult.acc.dataprecision.scale,accresult.acc.dataround.id,initvalue,currentvalue,accresult.startdate,accresult.enddate,accresult.acc.updatestrategy";
        return helper.queryOriginalCollection(selectFields, new QFilter[]{filter}, orderBy);
    }

    private List<BaseItemResultDTO> getList(DynamicObjectCollection calTableAccDataEntry, Map<Long, String> dataTypeMap) {
        ArrayList<BaseItemResultDTO> dtoList = new ArrayList<BaseItemResultDTO>(10);
        List<String> calStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PRECAL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.TAX_CALED.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode());
        for (DynamicObject entry : calTableAccDataEntry) {
            Long accId = entry.getLong("accresult.acc.id");
            Long dataTypeId = entry.getLong("accresult.acc.datatype.id");
            String showType = dataTypeMap.get(dataTypeId);
            SaveDataTypeEnum dataTypeEnum = SaveDataTypeEnum.getDataType((String)showType);
            String resultValue = this.getCalResultDataByDataType(dataTypeEnum, entry, calStatusList);
            Date startDate = entry.getDate("accresult.startdate");
            Date endDate = entry.getDate("accresult.enddate");
            AccItemResultDTO itemResultDTO = new AccItemResultDTO();
            itemResultDTO.setItemId(accId);
            itemResultDTO.setItemResult(resultValue);
            itemResultDTO.setStartDate(startDate);
            itemResultDTO.setEndDate(endDate);
            dtoList.add((BaseItemResultDTO)itemResultDTO);
        }
        return dtoList;
    }

    private String getCalResultDataByDataType(SaveDataTypeEnum dataTypeEnum, DynamicObject entry, List<String> calStatusList) {
        String value = "";
        String updatestrategy = entry.getString("accresult.acc.updatestrategy");
        String calStatus = this.calPersonObj.getString("calstatus");
        switch (dataTypeEnum) {
            case NUM: {
                Integer scale = entry.getInt("accresult.acc.dataprecision.scale");
                Long dataRoundId = entry.getLong("accresult.acc.dataround.id");
                BigDecimal initValue = entry.getBigDecimal("initvalue");
                BigDecimal currentValue = entry.getBigDecimal("currentvalue");
                BigDecimal numValue = null;
                numValue = "2".equals(updatestrategy) && calStatusList.contains(calStatus) ? initValue : initValue.add(currentValue);
                BigDecimal bigDecimal = numValue.setScale((int)scale, this.getRoundingMode(dataRoundId));
                value = bigDecimal.toPlainString();
                break;
            }
            case AMOUNT: {
                BigDecimal initValue = entry.getBigDecimal("initvalue");
                BigDecimal currentValue = entry.getBigDecimal("currentvalue");
                BigDecimal amountValue = null;
                amountValue = "2".equals(updatestrategy) && calStatusList.contains(calStatus) ? initValue : initValue.add(currentValue);
                int itemScale = this.getCurrency().getInt("amtprecision");
                value = amountValue.setScale(itemScale, RoundingMode.HALF_UP).toPlainString();
                break;
            }
        }
        return value;
    }
}

