/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.itemresult;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.itemresult.BaseItemResultFactory;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsas.common.dto.calitem.StItemResultDTO;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SlItemResultFactory
extends BaseItemResultFactory {
    private DynamicObjectCollection salaryItemEntry;
    private DynamicObject calRule;
    private Map<Long, Integer> dataPrecisionMap;
    private Date startDate;
    private Date endDate;
    private String isCalResult;
    private Map<Long, Integer> proportionScaleMap;

    public SlItemResultFactory(Long calTableId, Boolean isProration, DynamicObject currency, DynamicObjectCollection salaryItemEntry, DynamicObject calRule, Map<Long, Integer> dataPrecisionMap, Date startDate, Date endDate, Map<Long, Integer> proportionScaleMap) {
        super(calTableId, isProration, currency);
        this.salaryItemEntry = salaryItemEntry;
        this.calRule = calRule;
        this.dataPrecisionMap = dataPrecisionMap;
        this.startDate = startDate;
        this.endDate = endDate;
        this.proportionScaleMap = proportionScaleMap;
    }

    @Override
    public List<BaseItemResultDTO> createItemResultDTOList(Map<Long, String> dataTypeMap) {
        ArrayList<BaseItemResultDTO> dtoList = new ArrayList<BaseItemResultDTO>(10);
        if (!SWCStringUtils.equals((String)this.isCalResult, (String)Boolean.FALSE.toString())) {
            List salaryItemList;
            Long salaryItemId;
            Map<Long, String> salaryItemDataSourceMap = this.getSalaryItemDataSourceMap();
            HashMap<Long, List> salaryItemListMap = new HashMap<Long, List>(16);
            for (DynamicObject salaryItemResult : this.salaryItemEntry) {
                salaryItemId = salaryItemResult.getLong("salaryitem.id");
                salaryItemList = salaryItemListMap.computeIfAbsent(salaryItemId, key -> new ArrayList(10));
                salaryItemList.add(salaryItemResult);
            }
            for (Map.Entry<Long, String> entry : salaryItemDataSourceMap.entrySet()) {
                salaryItemId = entry.getKey();
                salaryItemList = (List)salaryItemListMap.get(salaryItemId);
                String dataSource = entry.getValue();
                if (CollectionUtils.isEmpty((Collection)salaryItemList)) continue;
                salaryItemList.sort(Comparator.comparingInt(obj -> obj.getInt("slprorationindex")));
                StItemResultDTO itemResultDTO = this.createItemResultDTO((DynamicObject)salaryItemList.get(0), salaryItemId, dataSource, dataTypeMap);
                dtoList.add((BaseItemResultDTO)itemResultDTO);
                boolean hasManualInput = false;
                boolean hasFormula = false;
                for (int index = 1; index < salaryItemList.size(); ++index) {
                    String childDataSource;
                    if (((DynamicObject)salaryItemList.get(index)).getBoolean("resultcover")) {
                        childDataSource = "4";
                        hasManualInput = true;
                    } else {
                        childDataSource = dataSource;
                        hasFormula = true;
                    }
                    itemResultDTO.addChildItemResult(this.createItemResultDTO((DynamicObject)salaryItemList.get(index), salaryItemId, childDataSource, dataTypeMap));
                }
                if (hasFormula && hasManualInput) {
                    itemResultDTO.setDataSource("9");
                    continue;
                }
                if (!hasManualInput) continue;
                itemResultDTO.setDataSource("4");
            }
        } else {
            for (DynamicObject salaryItemResult : this.salaryItemEntry) {
                Long salaryItemId = salaryItemResult.getLong("salaryitem.id");
                StItemResultDTO itemResultDTO = this.createItemResultDTO(salaryItemResult, salaryItemId, "7", dataTypeMap);
                dtoList.add((BaseItemResultDTO)itemResultDTO);
            }
        }
        return dtoList;
    }

    private StItemResultDTO createItemResultDTO(DynamicObject itemProration, Long salaryItemId, String dataSource, Map<Long, String> dataTypeMap) {
        Long dataType = itemProration.getLong("salaryitem.datatype.id");
        Date startDate = itemProration.getDate("slstartdate");
        Date endDate = itemProration.getDate("slenddate");
        if (startDate == null) {
            startDate = this.startDate;
        }
        if (endDate == null) {
            endDate = this.endDate;
        }
        String showType = dataTypeMap.get(dataType);
        SaveDataTypeEnum dataTypeEnum = SaveDataTypeEnum.getDataType((String)showType);
        String itemResult = this.getCalResultDataByDataType(dataTypeEnum, itemProration);
        StItemResultDTO itemResultDTO = new StItemResultDTO();
        this.setBaseItemResultData((BaseItemResultDTO)itemResultDTO, salaryItemId, dataTypeEnum.getCodeByEnum(), itemResult, startDate, endDate, null);
        itemResultDTO.setDataSource(dataSource);
        itemResultDTO.setEntryId(Long.valueOf(itemProration.getLong("id")));
        itemResultDTO.setProrationIndex(Integer.valueOf(itemProration.getInt("slprorationindex")));
        Integer scale = this.proportionScaleMap.get(itemProration.getLong("salaryitem.id"));
        if (!SWCStringUtils.equals((String)dataSource, (String)"4") && scale != null) {
            itemResultDTO.setProportion(itemProration.getBigDecimal("proportion").setScale(scale).toPlainString());
        }
        return itemResultDTO;
    }

    private Map<Long, String> getSalaryItemDataSourceMap() {
        if (this.calRule == null) {
            return new HashMap<Long, String>(0);
        }
        DynamicObjectCollection itemEntry = this.calRule.getDynamicObjectCollection("calruleitementry");
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>(16);
        for (DynamicObject item : itemEntry) {
            map.put(item.getLong("salaryitem.id"), item.getString("datasource"));
        }
        return map;
    }

    private String getCalResultDataByDataType(SaveDataTypeEnum dataTypeEnum, DynamicObject entry) {
        String value = "";
        switch (dataTypeEnum) {
            case NUM: {
                Long id = entry.getLong("salaryitem.dataprecision.id");
                Integer scale = this.dataPrecisionMap.get(id);
                Long dataRoundId = entry.getLong("salaryitem.dataround.id");
                BigDecimal numValue = entry.getBigDecimal("numvalue");
                if (entry.getInt("slprorationindex") > 0) {
                    value = numValue.toPlainString();
                    break;
                }
                BigDecimal bigDecimal = numValue.setScale((int)scale, this.getRoundingMode(dataRoundId));
                value = bigDecimal.toPlainString();
                break;
            }
            case DATE: {
                Date dateValue = entry.getDate("datevalue");
                if (dateValue == null) break;
                value = SWCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd");
                break;
            }
            case TEXT: {
                value = entry.getString("textvalue");
                break;
            }
            case AMOUNT: {
                BigDecimal amountValue = entry.getBigDecimal("calamountvalue");
                if (entry.getInt("slprorationindex") > 0) {
                    value = amountValue.toPlainString();
                    break;
                }
                int itemScale = this.getCurrency().getInt("amtprecision");
                value = amountValue.setScale(itemScale, RoundingMode.HALF_UP).toPlainString();
                break;
            }
        }
        return value;
    }

    public String getIsCalResult() {
        return this.isCalResult;
    }

    public void setIsCalResult(String isCalResult) {
        this.isCalResult = isCalResult;
    }
}

