/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.prorationresult;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.enums.ProrationResultColEnum;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class ProrationResultService {
    private final Log log = LogFactory.getLog(ProrationResultService.class);

    public Map<Long, List<Map<String, Object>>> getProrationResult(List<Long> calPersonIdList, List<Long> calResultIdList, Long calRuleVid, String calVersionNo, int amtPrecision) {
        this.log.info("getProrationResult begin,calRuleVId = {}", (Object)calRuleVid);
        Map<Long, Map<String, Map<String, String>>> itemProrationEventRelMap = this.getProrationRecordData(calPersonIdList, calRuleVid, calVersionNo);
        Map<Long, DynamicObject> calResultMap = this.getProrationResult(calResultIdList);
        HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(calResultMap.size());
        ArrayList rowList = null;
        HashMap<String, Object> rowMap = null;
        Map<String, Map<String, String>> itemEventRelMap = null;
        DynamicObjectCollection entryList = null;
        String dateRange = null;
        for (Map.Entry<Long, DynamicObject> entry : calResultMap.entrySet()) {
            Long personId = entry.getKey();
            itemEventRelMap = itemProrationEventRelMap.get(personId);
            rowList = new ArrayList(10);
            entryList = entry.getValue().getDynamicObjectCollection("hsas_caltableentry");
            entryList = entryList.stream().sorted(Comparator.comparing(obj -> obj.getString("salaryitem.number") + obj.getInt("slprorationindex"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            for (DynamicObject item : entryList) {
                if (item.getInt("slprorationindex") == 0) continue;
                dateRange = HandleProrationHelper.getDataRange((Date)item.getDate("slstartdate"), (Date)item.getDate("slenddate"));
                rowMap = new HashMap<String, Object>(9);
                String slStartDate = SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"slstartdate", (Date)item.getDate("slstartdate"));
                String slEndDate = SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"slenddate", (Date)item.getDate("slenddate"));
                rowMap.put(ProrationResultColEnum.ITEMTYPE.getCode(), ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ProrationResultService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                rowMap.put(ProrationResultColEnum.ITEMNUMBER.getCode(), item.getString("salaryitem.number"));
                rowMap.put(ProrationResultColEnum.ITEMNAME.getCode(), item.getString("salaryitem.name"));
                rowMap.put(ProrationResultColEnum.PRORATIONINDEX.getCode(), String.valueOf(item.getInt("slprorationindex")));
                rowMap.put(ProrationResultColEnum.DATATYPE.getCode(), DataTypeEnum.getNameByDbId((long)item.getLong("salaryitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.RESULTVALUE.getCode(), this.getSlItemValue(item, item.getLong("salaryitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.STARTDATE.getCode(), slStartDate);
                rowMap.put(ProrationResultColEnum.ENDDATE.getCode(), slEndDate);
                rowMap.put(ProrationResultColEnum.CHANGEREASON.getCode(), this.getChangeReasonName(dateRange, itemEventRelMap, item.getString("salaryitem.uniquecode")));
                rowMap.put(ProrationResultColEnum.RESULTCOVER.getCode(), item.getBoolean("resultcover"));
                StringBuilder idStrSb = new StringBuilder();
                String slStartDateStr = SWCDateTimeUtils.format((Date)item.getDate("slstartdate"), (String)"yyyy-MM-dd");
                String slEndDateStr = SWCDateTimeUtils.format((Date)item.getDate("slenddate"), (String)"yyyy-MM-dd");
                idStrSb.append(personId).append('#').append(item.getLong("salaryitem.id")).append('#').append(slStartDateStr).append('#').append(slEndDateStr);
                rowMap.put("idstr", idStrSb.toString());
                rowList.add(rowMap);
            }
            entryList = entry.getValue().getDynamicObjectCollection("hsas_calbsentry");
            entryList = entryList.stream().sorted(Comparator.comparing(obj -> obj.getString("bizitem.number") + obj.getInt("bsprorationindex"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            for (DynamicObject item : entryList) {
                if (item.getInt("bsprorationindex") == 0) continue;
                dateRange = HandleProrationHelper.getDataRange((Date)item.getDate("bsstartdate"), (Date)item.getDate("bsenddate"));
                rowMap = new HashMap(9);
                rowMap.put(ProrationResultColEnum.ITEMTYPE.getCode(), ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee", (String)"ProrationResultService_1", (String)"swc-hsas-business", (Object[])new Object[0]));
                rowMap.put(ProrationResultColEnum.ITEMNUMBER.getCode(), item.getString("bizitem.number"));
                rowMap.put(ProrationResultColEnum.ITEMNAME.getCode(), item.getString("bizitem.name"));
                rowMap.put(ProrationResultColEnum.PRORATIONINDEX.getCode(), String.valueOf(item.getInt("bsprorationindex")));
                rowMap.put(ProrationResultColEnum.DATATYPE.getCode(), DataTypeEnum.getNameByDbId((long)item.getLong("bizitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.RESULTVALUE.getCode(), this.getBsItemValue(item, item.getLong("bizitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.STARTDATE.getCode(), SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"bsstartdate", (Date)item.getDate("bsstartdate")));
                rowMap.put(ProrationResultColEnum.ENDDATE.getCode(), SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"bsenddate", (Date)item.getDate("bsenddate")));
                rowMap.put(ProrationResultColEnum.CHANGEREASON.getCode(), this.getChangeReasonName(dateRange, itemEventRelMap, item.getString("bizitem.uniquecode")));
                rowMap.put(ProrationResultColEnum.RESULTCOVER.getCode(), Boolean.FALSE);
                rowList.add(rowMap);
            }
            entryList = entry.getValue().getDynamicObjectCollection("hsas_calbcentry");
            entryList = entryList.stream().sorted(Comparator.comparing(obj -> obj.getString("fetchitem.number") + obj.getInt("ftprorationindex"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            for (DynamicObject item : entryList) {
                if (item.getInt("ftprorationindex") == 0) continue;
                dateRange = HandleProrationHelper.getDataRange((Date)item.getDate("bcstartdate"), (Date)item.getDate("bcenddate"));
                rowMap = new HashMap(9);
                rowMap.put(ProrationResultColEnum.ITEMTYPE.getCode(), ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee", (String)"ProrationResultService_2", (String)"swc-hsas-business", (Object[])new Object[0]));
                rowMap.put(ProrationResultColEnum.ITEMNUMBER.getCode(), item.getString("fetchitem.number"));
                rowMap.put(ProrationResultColEnum.ITEMNAME.getCode(), item.getString("fetchitem.name"));
                rowMap.put(ProrationResultColEnum.PRORATIONINDEX.getCode(), String.valueOf(item.getInt("ftprorationindex")));
                rowMap.put(ProrationResultColEnum.DATATYPE.getCode(), DataTypeEnum.getNameByDbId((long)item.getLong("fetchitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.RESULTVALUE.getCode(), this.getFtItemValue(item, item.getLong("fetchitem.datatype.id")));
                rowMap.put(ProrationResultColEnum.STARTDATE.getCode(), SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"bcstartdate", (Date)item.getDate("bcstartdate")));
                rowMap.put(ProrationResultColEnum.ENDDATE.getCode(), SWCInteDateTimeUtil.formatDate((String)"hsas_caltable", (String)"bcenddate", (Date)item.getDate("bcenddate")));
                rowMap.put(ProrationResultColEnum.CHANGEREASON.getCode(), this.getChangeReasonName(dateRange, itemEventRelMap, item.getString("fetchitem.uniquecode")));
                rowMap.put(ProrationResultColEnum.RESULTCOVER.getCode(), Boolean.FALSE);
                rowList.add(rowMap);
            }
            result.put(personId, rowList);
        }
        this.log.info("getProrationResult end,calRuleVId = {}", (Object)calRuleVid);
        return result;
    }

    private String getSlItemValue(DynamicObject item, long dataTypeId) {
        if (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            return item.getBigDecimal("numvalue").toPlainString();
        }
        if (DataTypeEnum.AMOUNT.getDbId() == dataTypeId) {
            return item.getBigDecimal("calamountvalue").toPlainString();
        }
        return null;
    }

    private String getBsItemValue(DynamicObject item, long dataTypeId) {
        if (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            return item.getBigDecimal("bsnumvalue").toPlainString();
        }
        if (DataTypeEnum.AMOUNT.getDbId() == dataTypeId) {
            return item.getBigDecimal("bscalamountvalue").toPlainString();
        }
        if (DataTypeEnum.DATE.getDbId() == dataTypeId) {
            return SWCDateTimeUtils.format((Date)item.getDate("bsdatevalue"), (String)"yyyy-MM-dd");
        }
        return item.getString("bstextvalue");
    }

    private String getFtItemValue(DynamicObject item, long dataTypeId) {
        if (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            return item.getBigDecimal("bcnumvalue").toPlainString();
        }
        if (DataTypeEnum.DATE.getDbId() == dataTypeId) {
            return SWCDateTimeUtils.format((Date)item.getDate("bcdatevalue"), (String)"yyyy-MM-dd");
        }
        return item.getString("bctextvalue");
    }

    private String getChangeReasonName(String dateRange, Map<String, Map<String, String>> itemEventRelMap, String uniqueCode) {
        if (itemEventRelMap == null) {
            return "";
        }
        Map<String, String> dateRangeMap = itemEventRelMap.get(uniqueCode);
        if (dateRangeMap == null) {
            return "";
        }
        return dateRangeMap.get(dateRange);
    }

    private Map<Long, Map<String, Map<String, String>>> getProrationRecordData(List<Long> calPersonIdList, Long calRuleVid, String calVersionNo) {
        HashMap<String, String> bsItemRelMap = new HashMap<String, String>(16);
        HashMap<String, String> ftItemRelMap = new HashMap<String, String>(16);
        this.dealFormulaDependItemRelData(calRuleVid, calVersionNo, bsItemRelMap, ftItemRelMap);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_slprorationrecord");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        String fields = "calpersonid,salaryitem.uniquecode,startdate,enddate,prorationevent.changereason.name";
        DynamicObject[] result = helper.query(fields, new QFilter[]{filter});
        HashMap<Long, Map<String, Map<String, String>>> itemProrationEventRelMap = new HashMap<Long, Map<String, Map<String, String>>>(16);
        Map itemMap = null;
        DynamicObjectCollection prorationEventList = null;
        Map dateRangeMap = null;
        Set changeReasonNameSet = null;
        String reasonName = null;
        String slUniqueCode = null;
        String dateRange = null;
        for (DynamicObject obj : result) {
            slUniqueCode = obj.getString("salaryitem.uniquecode");
            itemMap = itemProrationEventRelMap.getOrDefault(obj.getLong("calpersonid"), new HashMap());
            dateRangeMap = itemMap.getOrDefault(slUniqueCode, new HashMap());
            prorationEventList = obj.getDynamicObjectCollection("prorationevent");
            changeReasonNameSet = prorationEventList.stream().map(event -> event.getDynamicObject("fbasedataid").getString("changereason.name")).collect(Collectors.toSet());
            reasonName = SWCListUtils.join(changeReasonNameSet, (String)",");
            dateRange = HandleProrationHelper.getDataRange((Date)obj.getDate("startdate"), (Date)obj.getDate("enddate"));
            dateRangeMap.put(dateRange, reasonName);
            itemMap.put(slUniqueCode, dateRangeMap);
            this.dealItemProration(bsItemRelMap, slUniqueCode, itemMap, reasonName, dateRange);
            this.dealItemProration(ftItemRelMap, slUniqueCode, itemMap, reasonName, dateRange);
            itemProrationEventRelMap.put(obj.getLong("calpersonid"), itemMap);
        }
        return itemProrationEventRelMap;
    }

    private void dealItemProration(Map<String, String> itemRelMap, String slUniqueCode, Map<String, Map<String, String>> itemMap, String reasonName, String dateRange) {
        String itemStr = itemRelMap.get(slUniqueCode);
        if (SWCStringUtils.isEmpty((String)itemStr)) {
            return;
        }
        String[] itemArr = itemStr.split(",");
        Map dateRangeMap = null;
        for (String uniqueCode : itemArr) {
            dateRangeMap = itemMap.getOrDefault(uniqueCode, new HashMap());
            dateRangeMap.put(dateRange, reasonName);
            itemMap.put(uniqueCode, dateRangeMap);
        }
    }

    private void dealFormulaDependItemRelData(Long calRuleVid, String calVersionNo, Map<String, String> bsItemRelMap, Map<String, String> ftItemRelMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calversion");
        QFilter filter = new QFilter("calrulev.id", "=", (Object)calRuleVid);
        filter.and("calversionno", "=", (Object)calVersionNo);
        filter.and("datatype", "=", (Object)"1");
        DynamicObjectCollection calVersionData = helper.queryOriginalCollection("formulav.id", new QFilter[]{filter});
        Set formulaVidSet = calVersionData.stream().map(obj -> obj.getLong("formulav.id")).collect(Collectors.toSet());
        helper.setEntityName("hsas_formula");
        filter = new QFilter("id", "in", formulaVidSet);
        DynamicObjectCollection formulaData = helper.queryOriginalCollection("salaryitem.uniquecode,dependonbsitem,dependonftitem", new QFilter[]{filter});
        String bsItemStr = null;
        String ftItemStr = null;
        for (DynamicObject formula : formulaData) {
            bsItemStr = formula.getString("dependonbsitem");
            ftItemStr = formula.getString("dependonftitem");
            if (SWCStringUtils.isNotEmpty((String)bsItemStr)) {
                bsItemRelMap.put(formula.getString("salaryitem.uniquecode"), bsItemStr);
            }
            if (!SWCStringUtils.isNotEmpty((String)ftItemStr)) continue;
            ftItemRelMap.put(formula.getString("salaryitem.uniquecode"), ftItemStr);
        }
    }

    private Map<Long, DynamicObject> getProrationResult(List<Long> calResultIdList) {
        this.log.info("getProrationResult begin");
        QFilter filter = new QFilter("id", "in", calResultIdList);
        String fields = this.queryFields();
        long st = System.currentTimeMillis();
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        DynamicObject[] coll = null;
        try {
            coll = SWCMultithreadedQueryService.getInstance().getData("hsas_caltable", fields, new QFilter[]{filter}, null, 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        stopwatch.stop();
        if (coll == null) {
            coll = new DynamicObject[]{};
        }
        this.log.info("getProrationResult end");
        long ed = System.currentTimeMillis();
        this.log.info("step2-->dataquery-end");
        this.log.info("query time:{}", (Object)(ed - st));
        return Arrays.asList(coll).stream().collect(Collectors.toMap(obj -> obj.getLong("calpersonid"), obj -> obj));
    }

    private String queryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id,calpersonid,salaryitem.name,salaryitem.number,salaryitem.uniquecode,salaryitem.datatype.id,salaryitem.dataround.id,calamountvalue,numvalue,slstartdate,slenddate,slprorationindex,resultcover,");
        sb.append("bctextvalue,bcnumvalue,bcdatevalue,fetchitem.name,fetchitem.number,fetchitem.id,fetchitem.uniquecode,fetchitem.datatype.id,bcstartdate,bcenddate,ftprorationindex,");
        sb.append("bizitem.datatype.id,bizitem.name,bizitem.number,bizitem.uniquecode,bstextvalue,bsnumvalue,bsdatevalue,bscalamountvalue,bsstartdate,bsenddate,bsprorationindex");
        return sb.toString();
    }
}

