/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.helper.HSASCalListHelper;
import kd.swc.hsas.business.cal.impt.HSASCalTableImportLogHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.cal.thread.CalResultCoverImportTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class CalResultCoverImportService {
    private static final Log logger = LogFactory.getLog(CalResultCoverImportService.class);
    private static final int PAGE_SIZE = 500;
    private static final String SYSTEM_TYPE = "swc-hsas-business";
    private static final ExecutorService importExecutorService = ThreadPools.newExecutorService((String)"resultCoverImport", (int)2);
    private static final int DEFAULT_COUNT = 200;
    private static final int FIX_ROWS = 2;
    private List<Map<Integer, String>> dataRow;
    private List<Map<Integer, String>> dataHead;
    private List<Map<String, String>> errDataList;
    private Map<Long, List<Long>> importData;
    private Long taskId;
    private Map<String, Map<String, String>> salaryItemMap;
    private int precision;
    private Boolean taxCalEnable;
    private String coverType;
    private String traceId;

    public CalResultCoverImportService(String traceId, String coverType, List<Map<Integer, String>> dataRow, List<Map<Integer, String>> dataHead, List<Map<String, String>> errDataList, Map<Long, List<Long>> importData, Long taskId, Map<String, Map<String, String>> salaryItemMap, int precision, Boolean taxCalEnable) {
        this.dataRow = dataRow;
        this.dataHead = dataHead;
        this.errDataList = errDataList;
        this.importData = importData;
        this.taskId = taskId;
        this.salaryItemMap = salaryItemMap;
        this.precision = precision;
        this.taxCalEnable = taxCalEnable;
        this.coverType = coverType;
        this.traceId = traceId;
    }

    public CalResultCoverImportService() {
    }

    public void doImport() {
        List partitions = Lists.partition(this.dataRow, (int)200);
        logger.info("ResultCoverImportService.partitions.size:{}", (Object)partitions.size());
        ArrayList<Future<Map<String, Object>>> futureList = new ArrayList<Future<Map<String, Object>>>(partitions.size());
        CountDownLatch countDownLatch = new CountDownLatch(partitions.size());
        ArrayList<CalResultCoverImportTask> taskList = new ArrayList<CalResultCoverImportTask>(partitions.size());
        int dataIndex = 4;
        for (List partition : partitions) {
            CalResultCoverImportTask task = new CalResultCoverImportTask(this.traceId, this.coverType, dataIndex, countDownLatch, this.precision, this.taskId, this.salaryItemMap, partition, this.dataHead, this.taxCalEnable, RequestContext.get());
            taskList.add(task);
            dataIndex += 200;
        }
        try {
            List futures = importExecutorService.invokeAll(taskList);
            futureList.addAll(futures);
            boolean await = countDownLatch.await(60L, TimeUnit.MINUTES);
            if (await) {
                this.dealErrDataList(futureList);
            }
        }
        catch (Exception exception) {
            logger.error("\u5bfc\u5165\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u6570\u636e\u5f02\u5e38", (Throwable)exception);
        }
    }

    private void dealErrDataList(List<Future<Map<String, Object>>> futureList) {
        futureList.forEach(future -> {
            try {
                Map result = (Map)future.get();
                this.errDataList.addAll((List)result.get("errDataList"));
                this.importData.putAll((Map)result.get("importData"));
            }
            catch (Exception exception) {
                logger.info("import resultcover Error:", (Object)exception);
            }
        });
    }

    public void genErrDataExcel(Boolean taxCalEnable, Map<String, String> exportDescInfo, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow, List<Map<String, String>> errDataList, String fullPath, Object logId) {
        String errPath = "";
        if (errDataList.size() > 0) {
            errPath = this.genErrDataExcel(taxCalEnable, exportDescInfo, salaryItemMap, dataHead, dataRow, errDataList);
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", this.taskId));
        String errCacheKey = SWCStringUtils.equals((String)"2", (String)this.coverType) ? String.format(Locale.ROOT, "importErrorFilePath_sum_%s", this.traceId) : String.format(Locale.ROOT, "importErrorFilePath_proration_%s", this.traceId);
        appCache.put(errCacheKey, (Object)errPath);
        String cacheKey = SWCStringUtils.equals((String)"2", (String)this.coverType) ? "resultcoverimport_%s" : "prorationcoverimport_%s";
        Map<String, Integer> progressMap = CalResultCoverHelper.getImportProgressMap(this.traceId, cacheKey);
        Integer totalCnt = progressMap.get("totalcount");
        Integer successCnt = progressMap.get("successcount");
        Integer failCnt = totalCnt - successCnt;
        HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>(16);
        HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
        String errMsg = this.assembleErrMsg(errDataList, failCnt);
        infoMap.put("errFile", errPath);
        infoMap.put("srcFile", fullPath);
        infoMap.put("failed", failCnt);
        infoMap.put("total", totalCnt);
        infoMap.put("errMsg", errMsg);
        dataMap.put("complete", Boolean.TRUE);
        dataMap.put("info", infoMap);
        HSASCalTableImportLogHelper.logAll(logId, JSON.toJSONString(dataMap), dataRow.size(), failCnt);
    }

    public boolean checkDataHead(Boolean taxCalEnable, List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, Object logId, Map<String, String> exportDescInfo, String fullPath, List<Map<String, String>> errDataList, Map<String, Map<String, String>> salaryItemMap) {
        if (SWCStringUtils.equals((String)"2", (String)this.coverType)) {
            CalResultCoverService service = new CalResultCoverService();
            Map<String, Map<String, String>> salaryItemMapTemp = service.getTaskRuleSalaryItemInfo(this.taskId);
            if (salaryItemMapTemp.size() == 0) {
                errDataList.add(this.assembleErrMap(0, true, "", ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4e3a\u4e00\u4e2a\u85aa\u916c\u9879\u76ee\u586b\u5199\u7ed3\u679c\u8986\u76d6\u503c\u3002", (String)"CalResultCoverImportService_70", (String)SYSTEM_TYPE, (Object[])new Object[0])));
                return false;
            }
            salaryItemMap.putAll(salaryItemMapTemp);
            boolean headSalaryitemCheck = this.checkHeadSalaryitem(dataHead, errDataList, salaryItemMap);
            if (dataRow.size() == 0 || !headSalaryitemCheck) {
                HSASCalTableImportLogHelper.logAll(logId, "", dataRow.size(), dataRow.size());
                this.genErrDataExcel(taxCalEnable, exportDescInfo, salaryItemMap, dataHead.get(2), dataRow, errDataList, fullPath, logId);
                return false;
            }
        }
        return true;
    }

    private boolean checkHeadSalaryitem(List<Map<Integer, String>> dataHead, List<Map<String, String>> errDataList, Map<String, Map<String, String>> salaryItemMap) {
        Map<Integer, String> headItemMap = dataHead.get(2);
        for (Map.Entry<Integer, String> entry : headItemMap.entrySet()) {
            String column = entry.getValue();
            Integer columnIndex = entry.getKey();
            if (columnIndex < 4 || !SWCStringUtils.equals((String)"2", (String)this.coverType)) continue;
            if (!salaryItemMap.containsKey(column)) {
                String msg = ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e0d\u5b58\u5728\u201c{0}\u201d\u85aa\u916c\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportService_75", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                errDataList.add(this.assembleErrMap(0, true, "", MessageFormat.format(msg, column)));
                return false;
            }
            Map<String, String> itemMap = salaryItemMap.get(column);
            if (SWCStringUtils.equals((String)"1", (String)itemMap.get("allowresultcover"))) continue;
            String msg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u4e0d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportService_76", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            errDataList.add(this.assembleErrMap(0, true, "", MessageFormat.format(msg, column)));
            return false;
        }
        return true;
    }

    public Map<String, String> assembleErrMap(int dataIndex, boolean isAll, String fileNumber, String msg) {
        HashMap<String, String> errMap = new HashMap<String, String>(16);
        errMap.put("fileNumber", fileNumber);
        errMap.put("errMsg", msg);
        errMap.put("isAll", isAll ? "1" : "0");
        errMap.put("dataIndex", String.valueOf(dataIndex));
        return errMap;
    }

    private String assembleErrMsg(List<Map<String, String>> errDataList, int errSize) {
        StringBuilder sb = new StringBuilder();
        String indexMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c ", (String)"CalResultCoverImportService_77", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (SWCListUtils.isEmpty(errDataList)) {
            return sb.toString();
        }
        if (errDataList.size() == 1 && SWCStringUtils.equals((String)"1", (String)errDataList.get(0).get("isAll"))) {
            String errMsg = errDataList.get(0).get("errMsg");
            int index = 4;
            for (int i = 0; i < errSize; ++i) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(MessageFormat.format(indexMsg, index)).append(errMsg);
                ++index;
            }
        } else {
            for (Map<String, String> map : errDataList) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(MessageFormat.format(indexMsg, map.get("dataIndex"))).append(map.get("errMsg"));
            }
        }
        return sb.toString();
    }

    public void exportResultCoverData(Long taskId, String pageId, IFormView view, List<String> idStrList, String coverType, boolean exportAll) {
        try (SXSSFWorkbook wb = new SXSSFWorkbook(500);){
            Map<String, String> taskInfoMap = this.assembleExportDescInfo(taskId);
            Map<String, Object> taskMap = CalResultCoverHelper.getTaskCurrencyPrecision(taskId);
            String searchText = CalResultCoverHelper.getCacheSearchText(taskId, pageId);
            int precision = Integer.parseInt(taskMap.get("precision") + "");
            LinkedHashMap<Long, Map<Long, Object>> personCoverDataMap = new LinkedHashMap<Long, Map<Long, Object>>(16);
            LinkedHashMap<Long, Map<Long, Object>> sortedPersonCoverDataMap = new LinkedHashMap<Long, Map<Long, Object>>(16);
            LinkedHashMap<Long, Map<String, String>> personCommonInfoMap = new LinkedHashMap<Long, Map<String, String>>(16);
            Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, pageId);
            ArrayList<Map<String, String>> prorationDataList = new ArrayList<Map<String, String>>(10);
            Map<String, String> sortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap(taskId);
            if (SWCStringUtils.equals((String)"2", (String)coverType)) {
                this.assembleSumCoverDataMap(searchText, taskId, pageId, precision, idStrList, personCoverDataMap, personCommonInfoMap, exportAll);
                HashMap<String, Map<String, String>> tempPersonMap = new HashMap<String, Map<String, String>>(16);
                personCoverDataMap.keySet().stream().forEach(single -> {
                    Map map = (Map)personCommonInfoMap.get(single);
                    tempPersonMap.put(single + "", map);
                });
                Map<String, Map<String, String>> sortedSumMap = CalResultCoverHelper.sortSumPersonData(sortColumnMap, tempPersonMap);
                sortedSumMap.forEach((key, value) -> {
                    long personId = Long.parseLong(key);
                    sortedPersonCoverDataMap.put(personId, (Map<Long, Object>)personCoverDataMap.get(personId));
                });
            } else {
                List<Long> taskPersonIdList = CalResultCoverHelper.getProrationCoverDataPersonIdList(taskId, "4730fc9f000004ae");
                List<Map<String, String>> prorationCoverDataList = CalResultCoverHelper.assembleProrationDataList(taskPersonIdList, taskId, searchText, pageId);
                sortColumnMap.put("6", "itemname|asc");
                sortColumnMap.put("7", "startdate|asc");
                if (exportAll) {
                    if (SWCStringUtils.isNotEmpty((String)searchText)) {
                        Iterator<Map<String, String>> iterator = prorationCoverDataList.iterator();
                        while (iterator.hasNext()) {
                            Map<String, String> map = iterator.next();
                            String fileNumber = map.get("filenumber");
                            String name = map.get("name");
                            String empNumber = map.get("empnumber");
                            String itemName = map.get("itemname");
                            if (fileNumber.contains(searchText) || name.contains(searchText) || empNumber.contains(searchText) || itemName.contains(searchText)) continue;
                            iterator.remove();
                        }
                    }
                    prorationDataList.addAll(prorationCoverDataList);
                } else {
                    Map dataMap = prorationCoverDataList.stream().collect(Collectors.toMap(key -> (String)key.get("idstr"), Function.identity(), (v1, v2) -> v1));
                    for (String idStr : idStrList) {
                        Map map = (Map)dataMap.get(idStr);
                        if (map == null) continue;
                        prorationDataList.add(map);
                    }
                }
                CalResultCoverHelper.sortProrationPersonData(sortColumnMap, prorationDataList);
            }
            String dd = new Date().getTime() + "";
            String exportFileName = SWCStringUtils.equals((String)"1", (String)coverType) ? MessageFormat.format(ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u679c\u8986\u76d6\u6570\u636e_{0}", (String)"CalResultCoverImportService_79", (String)SYSTEM_TYPE, (Object[])new Object[0]), dd) : MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u6570\u636e_{0}", (String)"CalResultCoverImportService_50", (String)SYSTEM_TYPE, (Object[])new Object[0]), dd);
            this.createResultCoverDataSheet(precision, wb, sortedPersonCoverDataMap, personCommonInfoMap, coverType, taskInfoMap, salaryItemMap, prorationDataList);
            this.flushAllAndDownload(wb, exportFileName, view);
        }
        catch (Exception exception) {
            logger.error("CalResultCoverImportService  error ", (Throwable)exception);
            String str = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"CalResultCoverImportService_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            view.showErrorNotification(str + exception.getMessage());
        }
    }

    public Map<String, String> assembleExportDescInfo(Long calTaskId) {
        HashMap<String, String> exportDescInfo = new HashMap<String, String>(16);
        HSASCalListHelper helper = new HSASCalListHelper();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        exportDescInfo.put("taskName", taskInfo.getString("name"));
        exportDescInfo.put("payrollGroupName", taskInfo.getString("payrollgroup.name"));
        exportDescInfo.put("payrollScene", taskInfo.getString("payrollscene.name"));
        exportDescInfo.put("taskType", taskInfo.getString("tasktype"));
        exportDescInfo.put("payrollDate", SWCDateTimeUtils.format((Date)taskInfo.getDate("payrolldate"), (String)"yyyyMM"));
        exportDescInfo.put("calCount", taskInfo.getString("calcount"));
        exportDescInfo.put("currency", taskInfo.getString("payrollgroupv.currency.number"));
        return exportDescInfo;
    }

    public void assembleSumCoverDataMap(String searchText, Long taskId, String pageId, int precision, List<String> calPersonIdList, Map<Long, Map<Long, Object>> personCoverDataMap, Map<Long, Map<String, String>> personCommonInfoMap, boolean exportAll) {
        QFilter filter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        String fields = "calperson,salaryitem.id,salaryitem.datatype.id,numvalue,datevalue,textvalue,calamountvalue";
        if (exportAll) {
            filter = new QFilter("caltask", "=", (Object)taskId);
        } else {
            List personIdList = calPersonIdList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
            filter = new QFilter("calperson", "in", personIdList);
        }
        DynamicObjectCollection coverDataCollection = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, pageId);
        for (DynamicObject obj : coverDataCollection) {
            long personId = obj.getLong("calperson");
            Map coverDataMap = personCoverDataMap.computeIfAbsent(personId, single -> new HashMap(16));
            long itemId = obj.getLong("salaryitem.id");
            Map<String, String> itemMap = salaryItemMap.get(itemId + "");
            if (itemMap == null) continue;
            String dataround = itemMap.get("dataround");
            String scale = itemMap.get("scale");
            Object value = this.getItemCoverValue(precision, obj, dataround, scale);
            coverDataMap.put(itemId, value);
        }
        List<Long> personIdList = exportAll ? personCoverDataMap.keySet().stream().collect(Collectors.toList()) : calPersonIdList.stream().map(singleId -> Long.parseLong(singleId)).collect(Collectors.toList());
        Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.assembleSumPersonDataMapForView(personIdList, taskId, searchText, pageId);
        for (Map.Entry<String, Map<String, String>> entry : personSimpleDataMap.entrySet()) {
            Long personId = Long.valueOf(entry.getKey());
            Map<String, String> personMap = entry.getValue();
            String fileNumber = personMap.get("filenumber");
            String name = personMap.get("name");
            String empNumber = personMap.get("empnumber");
            if (exportAll && SWCStringUtils.isNotEmpty((String)searchText) && !fileNumber.contains(searchText) && !name.contains(searchText) && !empNumber.contains(searchText)) continue;
            Map infoMap = personCommonInfoMap.computeIfAbsent(personId, map -> new HashMap(16));
            infoMap.put("filenumber", fileNumber);
            infoMap.put("name", name);
            infoMap.put("empnumber", empNumber);
            infoMap.put("id", entry.getKey());
        }
    }

    private Object getItemCoverValue(int precision, DynamicObject obj, String dataround, String scale) {
        long dataType = obj.getLong("salaryitem.datatype.id");
        Object value = null;
        if (1010L == dataType) {
            value = obj.getBigDecimal("numvalue").setScale(Integer.parseInt(scale), CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
        } else if (1020L == dataType) {
            value = obj.getBigDecimal("calamountvalue").setScale(precision, 4).toPlainString();
        } else if (1030L == dataType) {
            value = obj.getString("textvalue");
        } else if (1050L == dataType) {
            try {
                value = SWCDateTimeUtils.parseDate((String)SWCDateTimeUtils.format((Date)obj.getDate("datevalue"), (String)"yyyy-MM-dd"));
            }
            catch (ParseException exception) {
                logger.error((Throwable)exception);
            }
        }
        return value;
    }

    private void flushAllAndDownload(SXSSFWorkbook wb, String fileName, IFormView view) throws IOException {
        String url = SWCExportDataHelper.storeFile((Workbook)wb, fileName);
        this.updateUrl(view, url);
        if (SWCStringUtils.isNotEmpty((String)url)) {
            view.download(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        catch (Exception exception) {
            logger.info(exception.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private void updateUrl(IFormView view, String url) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.saveChanges();
    }

    public void createResultCoverDataSheet(int precision, SXSSFWorkbook wb, Map<Long, Map<Long, Object>> personCoverDataMap, Map<Long, Map<String, String>> personCommonInfoMap, String coverType, Map<String, String> taskInfoMap, Map<String, Map<String, String>> salaryItemMap, List<Map<String, String>> prorationDataList) {
        String sheetName = ResManager.loadKDString((String)"\u5bfc\u51fa\u67e5\u770b\u8986\u76d6\u6570\u636e", (String)"CalResultCoverImportService_51", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        this.setSheetColumnWidth(sheet, salaryItemMap.size() + 3);
        this.writeTaskInfoRow(false, sheet, taskInfoMap, false);
        this.writeExportHeadRow(sheet, salaryItemMap, null, false, false, coverType, true);
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            if (personCoverDataMap.size() > 0) {
                this.writeSumCoverData(precision, sheet, personCoverDataMap, personCommonInfoMap, salaryItemMap);
            }
        } else if (prorationDataList.size() > 0) {
            this.writeProrationCoverData(precision, sheet, prorationDataList);
        }
    }

    public void writeProrationCoverData(int precision, SXSSFSheet sheet, List<Map<String, String>> prorationDataList) {
        int dataIndex = 2;
        for (Map<String, String> data : prorationDataList) {
            SXSSFRow row = sheet.createRow(dataIndex++);
            String fileNumber = data.get("filenumber");
            String name = data.get("name");
            String empNumber = data.get("empnumber");
            this.addPersonFixedColumnRowData(false, row, fileNumber, name, empNumber);
            this.addProrationRowData(precision, row, data);
        }
    }

    public void writeSumCoverData(int precision, SXSSFSheet sheet, Map<Long, Map<Long, Object>> personCoverDataMap, Map<Long, Map<String, String>> personCommonInfoMap, Map<String, Map<String, String>> salaryItemMap) {
        int dataIndex = 2;
        for (Map.Entry<Long, Map<String, String>> entry : personCommonInfoMap.entrySet()) {
            Long personId = entry.getKey();
            Map<String, String> personMap = entry.getValue();
            Map<Long, Object> valueMap = personCoverDataMap.get(personId);
            SXSSFRow row = sheet.createRow(dataIndex++);
            String fileNumber = personMap.get("filenumber");
            String name = personMap.get("name");
            String empNumber = personMap.get("empnumber");
            this.addPersonFixedColumnRowData(false, row, fileNumber, name, empNumber);
            this.addSalaryItemRowData(precision, row, salaryItemMap, valueMap);
        }
    }

    private void addProrationRowData(int precision, SXSSFRow row, Map<String, String> dataMap) {
        String itemName = dataMap.get("itemname");
        String startDate = dataMap.get("startdate");
        String endDate = dataMap.get("enddate");
        String coverValue = dataMap.get("covervalue");
        SXSSFCell itemCell = row.createCell(3);
        itemCell.setCellValue(itemName);
        SXSSFCell startCell = row.createCell(4);
        startCell.setCellValue(startDate);
        SXSSFCell endCell = row.createCell(5);
        endCell.setCellValue(endDate);
        SXSSFCell valueCell = row.createCell(6);
        BigDecimal showValue = new BigDecimal(coverValue).setScale(precision, 4);
        valueCell.setCellValue(showValue.toPlainString());
    }

    private void addSalaryItemRowData(int precision, SXSSFRow row, Map<String, Map<String, String>> salaryItemMap, Map<Long, Object> value) {
        int index = 3;
        logger.info("salaryItemMap:{}", (Object)salaryItemMap.toString());
        for (Map.Entry<String, Map<String, String>> itemEntry : salaryItemMap.entrySet()) {
            BigDecimal showValue;
            SXSSFCell itemCell = row.createCell(index++);
            String dataType = itemEntry.getValue().get("datatype");
            String dataround = itemEntry.getValue().get("dataround");
            int scale = Integer.parseInt(itemEntry.getValue().get("scale"));
            if (value == null || value.get(Long.parseLong(itemEntry.getKey())) == null) continue;
            if (SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)dataType)) {
                itemCell.setCellValue(SWCDateTimeUtils.format((Date)((Date)value.get(Long.parseLong(itemEntry.getKey()))), (String)"yyyy-MM-dd"));
                continue;
            }
            if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
                showValue = new BigDecimal(value.get(Long.parseLong(itemEntry.getKey())).toString()).setScale(precision, 4);
                itemCell.setCellValue(showValue.toPlainString());
                continue;
            }
            if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)dataType)) {
                showValue = new BigDecimal(value.get(Long.parseLong(itemEntry.getKey())).toString()).setScale(scale, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround)));
                itemCell.setCellValue(showValue.toPlainString());
                continue;
            }
            itemCell.setCellValue(String.valueOf(value.get(Long.parseLong(itemEntry.getKey()))));
        }
    }

    private void writeErrImportData(SXSSFSheet sheet, List<Map<String, String>> errDataList, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow) {
        int dataIndex = 3;
        if (errDataList.size() == 1 && SWCStringUtils.equals((String)"1", (String)errDataList.get(0).get("isAll"))) {
            Map<String, String> errMsgMap = errDataList.get(0);
            for (Map<Integer, String> data : dataRow) {
                SXSSFRow row = sheet.createRow(dataIndex++);
                String fileNumber = data.get(0);
                String name = data.get(1);
                String empNumber = data.get(2);
                this.addPersonFixedColumnRowData(true, row, fileNumber, name, empNumber);
                this.addErrSalaryItemRowData(errMsgMap, dataHead, row, data, sheet.getWorkbook());
            }
        } else {
            for (Map<String, String> errData : errDataList) {
                String index = errData.get("dataIndex");
                Map<Integer, String> dataMap = dataRow.get(Integer.parseInt(index) - 4);
                SXSSFRow row = sheet.createRow(dataIndex++);
                String fileNumber = dataMap.get(0);
                String name = dataMap.get(1);
                String empNumber = dataMap.get(2);
                this.addPersonFixedColumnRowData(true, row, fileNumber, name, empNumber);
                this.addErrSalaryItemRowData(errData, dataHead, row, dataMap, sheet.getWorkbook());
            }
        }
    }

    private void addErrSalaryItemRowData(Map<String, String> errMsgMap, Map<Integer, String> dataHead, SXSSFRow row, Map<Integer, String> data, SXSSFWorkbook workbook) {
        SXSSFCell errMsgCell = row.createCell(0);
        CellStyle errColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, workbook, (short)9, true);
        Font font = workbook.createFont();
        font.setColor((short)10);
        errColumnStyle.setFont(font);
        errMsgCell.setCellValue(errMsgMap.get("errMsg"));
        errMsgCell.setCellStyle(errColumnStyle);
        if (dataHead == null) {
            return;
        }
        List headList = dataHead.keySet().stream().collect(Collectors.toList());
        headList.sort((o1, o2) -> o2 - o1);
        try {
            for (int i = 0; i <= (Integer)headList.get(0); ++i) {
                if (i < 3) continue;
                SXSSFCell itemCell = row.createCell(i + 1);
                String value = data.get(i);
                if (SWCStringUtils.equals((String)"1", (String)this.coverType) && (i == 4 || i == 5)) {
                    value = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)value), (String)"yyyy-MM-dd");
                }
                itemCell.setCellValue(value);
            }
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
    }

    private void addPersonFixedColumnRowData(boolean isErrExcel, SXSSFRow row, String fileNumber, String name, String empNumber) {
        SXSSFCell fileNumberCell = row.createCell(isErrExcel ? 1 : 0);
        SXSSFCell nameCell = row.createCell(isErrExcel ? 2 : 1);
        SXSSFCell empNumberCell = row.createCell(isErrExcel ? 3 : 2);
        fileNumberCell.setCellValue(fileNumber);
        nameCell.setCellValue(name);
        empNumberCell.setCellValue(empNumber);
    }

    private void writeTaskInfoRow(boolean isErr, SXSSFSheet sheet, Map<String, String> exportDescInfo, boolean isTemplate) {
        CellStyle taskDescColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        this.addRowInfo(isErr, 0, sheet, exportDescInfo.get("taskName"), ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u540d\u79f0", (String)"CalResultCoverImportService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), taskDescColumnStyle);
        if (isTemplate) {
            SXSSFRow headRow = sheet.createRow(1);
            SXSSFCell descCell = headRow.createCell(isErr ? 1 : 0);
            String descMsg = SWCStringUtils.equals((String)"2", (String)this.coverType) ? ResManager.loadKDString((String)"\u9009\u4e2d\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\u201c\u5907\u6ce8\u201d\u5217\u540e\u4e3a\u85aa\u916c\u9879\u76ee\u5217\uff08\u586b\u5199\u85aa\u916c\u9879\u76ee\u540d\u79f0\uff09\uff0c\u53ef\u76f4\u63a5\u5728Excel\u4e2d\u589e\u52a0\u548c\u5220\u9664\u3002\u8986\u76d6\u540e\u5904\u7406\u8be6\u89c1\u201c\u53ef\u8986\u76d6\u85aa\u916c\u9879\u76ee\u5217\u8868\u53ca\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565\u201d\u9875\u7b7e\u3002", (String)"ResultCoverService_23", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9009\u4e2d\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff0c\u5bf9\u4e8e\u65e0\u9700\u8986\u76d6\u7684\u6570\u636e\u884c\u8bf7\u52a1\u5fc5\u5220\u9664\u3002\u8986\u76d6\u540e\u5904\u7406\u8be6\u89c1\u201c\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565\u201d\u9875\u7b7e\u3002", (String)"ResultCoverService_28", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            descCell.setCellValue(descMsg);
            Font font = sheet.getWorkbook().createFont();
            CellStyle descColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
            font.setColor((short)10);
            descColumnStyle.setFont(font);
            descCell.setCellStyle(descColumnStyle);
        }
    }

    private void addRowInfo(boolean isErr, int index, SXSSFSheet sheet, String value, String name, CellStyle taskDescColumnStyle) {
        SXSSFRow taskNameRow = sheet.createRow(index);
        SXSSFCell nameCell = taskNameRow.createCell(isErr ? 1 : 0);
        SXSSFCell valueCell = taskNameRow.createCell(isErr ? 2 : 1);
        nameCell.setCellValue(name);
        valueCell.setCellValue(value);
        nameCell.setCellStyle(taskDescColumnStyle);
        valueCell.setCellStyle(taskDescColumnStyle);
    }

    public void writeExportHeadRow(SXSSFSheet sheet, Map<String, Map<String, String>> salaryItemInfo, Map<Integer, String> dataHead, boolean isTemplate, boolean isErr, String coverType, boolean isView) {
        SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        SXSSFRow headRow = sheet.createRow(isTemplate ? 2 : 1);
        CellStyle headColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        CellStyle mustInputStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        if (isErr) {
            SXSSFCell errMsgCell = headRow.createCell(0);
            errMsgCell.setCellValue(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"CalResultCoverImportService_58", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            errMsgCell.setCellStyle(headColumnStyle);
        }
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        mustInputStyle.setFont(font);
        SXSSFCell salaryFileNumberCell = headRow.createCell(isErr ? 1 : 0);
        SXSSFCell nameCell = headRow.createCell(isErr ? 2 : 1);
        SXSSFCell empNumberCell = headRow.createCell(isErr ? 3 : 2);
        String fileNumer = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalResultCoverImportService_54", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (isTemplate) {
            fileNumer = "*" + fileNumer;
        }
        salaryFileNumberCell.setCellValue(fileNumer);
        salaryFileNumberCell.setCellComment(this.getComment(drawingPatriarch, salaryFileNumberCell, "text"));
        nameCell.setCellValue(ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalResultCoverImportService_55", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        nameCell.setCellComment(this.getComment(drawingPatriarch, nameCell, "text"));
        empNumberCell.setCellValue(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalResultCoverImportService_56", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        empNumberCell.setCellComment(this.getComment(drawingPatriarch, empNumberCell, "text"));
        if (SWCStringUtils.equals((String)"2", (String)coverType) && isTemplate) {
            SXSSFCell memoCell = headRow.createCell(isErr ? 4 : 3);
            memoCell.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"CalResultCoverImportService_81", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            memoCell.setCellComment(this.getComment(drawingPatriarch, memoCell, "text"));
            memoCell.setCellStyle(headColumnStyle);
        }
        nameCell.setCellStyle(headColumnStyle);
        empNumberCell.setCellStyle(headColumnStyle);
        if (isView) {
            salaryFileNumberCell.setCellStyle(headColumnStyle);
        } else {
            salaryFileNumberCell.setCellStyle(mustInputStyle);
        }
        Map<String, String> itemDataTypeMap = salaryItemInfo.values().stream().collect(Collectors.toMap(key -> (String)key.get("itemname"), value -> (String)value.get("datatype")));
        if (isErr) {
            if (SWCStringUtils.equals((String)"2", (String)coverType)) {
                List headList = dataHead.keySet().stream().collect(Collectors.toList());
                headList.sort((o1, o2) -> o2 - o1);
                headColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
                for (int i = 0; i <= (Integer)headList.get(0); ++i) {
                    if (i < 4) continue;
                    SXSSFCell salaryItemCell = headRow.createCell(i + 1);
                    salaryItemCell.setCellValue(dataHead.get(i));
                    salaryItemCell.setCellStyle(headColumnStyle);
                    salaryItemCell.setCellComment(this.getComment(drawingPatriarch, salaryItemCell, itemDataTypeMap.get(dataHead.get(i))));
                }
            } else {
                this.addProrationHeadCell(isTemplate, 4, headRow, mustInputStyle, drawingPatriarch);
                if (isTemplate) {
                    SXSSFCell memoCell = headRow.createCell(8);
                    memoCell.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"CalResultCoverImportService_81", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    memoCell.setCellStyle(headColumnStyle);
                    memoCell.setCellComment(this.getComment(drawingPatriarch, memoCell, SWCShowType.TEXT.getCode()));
                }
            }
        } else {
            int index;
            int n = index = isTemplate ? 4 : 3;
            if (SWCStringUtils.equals((String)"2", (String)coverType)) {
                headColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
                for (Map.Entry<String, Map<String, String>> itemEntry : salaryItemInfo.entrySet()) {
                    SXSSFCell salaryItemCell = headRow.createCell(index);
                    salaryItemCell.setCellValue(itemEntry.getValue().get("itemname"));
                    salaryItemCell.setCellStyle(headColumnStyle);
                    salaryItemCell.setCellComment(this.getComment(drawingPatriarch, salaryItemCell, itemEntry.getValue().get("datatype")));
                    ++index;
                }
            } else {
                this.addProrationHeadCell(isTemplate, 3, headRow, headColumnStyle, drawingPatriarch);
            }
        }
    }

    private void addProrationHeadCell(boolean isTemplate, int index, SXSSFRow headRow, CellStyle headColumnStyle, SXSSFDrawing drawingPatriarch) {
        String salaryItem = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"CalResultCoverImportService_65", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String startDate = ResManager.loadKDString((String)"\u5206\u6bb5\u5f00\u59cb\u65e5\u671f", (String)"CalResultCoverImportService_66", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String endDate = ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u675f\u65e5\u671f", (String)"CalResultCoverImportService_67", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String coverValue = ResManager.loadKDString((String)"\u8986\u76d6\u503c", (String)"CalResultCoverImportService_68", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (isTemplate) {
            salaryItem = "*".concat(salaryItem);
            startDate = "*".concat(startDate);
            endDate = "*".concat(endDate);
            coverValue = "*".concat(coverValue);
        }
        SXSSFCell salaryItemCell = headRow.createCell(index++);
        salaryItemCell.setCellValue(salaryItem);
        salaryItemCell.setCellStyle(headColumnStyle);
        salaryItemCell.setCellComment(this.getComment(drawingPatriarch, salaryItemCell, SWCShowType.TEXT.getCode()));
        SXSSFCell startDateCell = headRow.createCell(index++);
        startDateCell.setCellValue(startDate);
        startDateCell.setCellStyle(headColumnStyle);
        startDateCell.setCellComment(this.getComment(drawingPatriarch, startDateCell, SWCShowType.DATE.getCode()));
        SXSSFCell endDateCell = headRow.createCell(index++);
        endDateCell.setCellValue(endDate);
        endDateCell.setCellStyle(headColumnStyle);
        endDateCell.setCellComment(this.getComment(drawingPatriarch, endDateCell, SWCShowType.DATE.getCode()));
        SXSSFCell coverValueCell = headRow.createCell(index++);
        coverValueCell.setCellValue(coverValue);
        coverValueCell.setCellStyle(headColumnStyle);
        coverValueCell.setCellComment(this.getComment(drawingPatriarch, coverValueCell, SWCShowType.AMOUNT.getCode()));
    }

    private Comment getComment(SXSSFDrawing drawingPatriarch, SXSSFCell cell, String datatype) {
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
        String text = this.assembleCommentText(datatype);
        comment.setString((RichTextString)new XSSFRichTextString(text));
        return comment;
    }

    private String assembleCommentText(String dataType) {
        String text = SWCShowType.AMOUNT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u5b57\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_59", (String)SYSTEM_TYPE, (Object[])new Object[0]) : (SWCShowType.DATE.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\uff0c\u683c\u5f0f\u4e3aYYYY-MM-DD\u3002", (String)"CalResultCoverImportService_60", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6587\u672c\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_61", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        return text;
    }

    public static CellStyle getColumnStyle(boolean isTmpl, int precision, int scale, String columnType, HorizontalAlignment alignment, SXSSFWorkbook wb, short colorIndex, boolean needBoard) {
        short format;
        CellStyle headColumnStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        if (!isTmpl) {
            if (SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)columnType)) {
                format = dataFormat.getFormat("yyyy-MM-dd");
            } else if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)columnType)) {
                String amountFormat = CalResultCoverImportService.getAmountFormat(precision);
                format = dataFormat.getFormat(amountFormat);
            } else if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)columnType)) {
                String amountFormat = CalResultCoverImportService.getAmountFormat(scale);
                format = dataFormat.getFormat(amountFormat);
            } else {
                format = dataFormat.getFormat("text");
            }
        } else {
            format = SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)columnType) ? dataFormat.getFormat("yyyy-MM-dd") : dataFormat.getFormat("text");
        }
        headColumnStyle.setDataFormat(format);
        if (needBoard) {
            headColumnStyle.setBorderBottom(BorderStyle.HAIR);
            headColumnStyle.setBorderTop(BorderStyle.HAIR);
            headColumnStyle.setBorderLeft(BorderStyle.HAIR);
            headColumnStyle.setBorderRight(BorderStyle.HAIR);
        }
        headColumnStyle.setFillForegroundColor(colorIndex);
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(alignment);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    private static String getAmountFormat(int precision) {
        StringBuilder format = new StringBuilder("0");
        if (precision > 0) {
            format.append('.');
            for (int i = 0; i < precision; ++i) {
                format.append('0');
            }
        }
        return format.toString();
    }

    private void setSheetColumnWidth(SXSSFSheet sheet, int columnSize) {
        int columnWidth;
        int i;
        for (i = 0; i < 3; ++i) {
            columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
        for (i = 3; i < columnSize; ++i) {
            columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
    }

    public String genErrDataExcel(Boolean taxCalEnable, Map<String, String> exportDescInfo, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow, List<Map<String, String>> errDataList) {
        String url = "";
        try (SXSSFWorkbook wb = new SXSSFWorkbook(500);){
            String timeMillis = new Date().getTime() + "";
            String exportFileName = SWCStringUtils.equals((String)"1", (String)this.coverType) ? MessageFormat.format(ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u679c\u8986\u76d6_\u6570\u636e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c_{0}", (String)"CalResultCoverImportService_78", (String)SYSTEM_TYPE, (Object[])new Object[0]), timeMillis) : MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6_\u6570\u636e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c_{0}", (String)"CalResultCoverImportService_49", (String)SYSTEM_TYPE, (Object[])new Object[0]), timeMillis);
            this.createCalResultCoverFailDataSheet(exportDescInfo, salaryItemMap, wb, errDataList, dataHead, dataRow);
            ResultCoverService resultCoverService = CalResultCoverHelper.getResultCoverService(this.coverType);
            resultCoverService.createCalResultCoverDescSheet(wb, taxCalEnable, this.taskId);
            url = SWCExportDataHelper.storeFile((Workbook)wb, exportFileName);
        }
        catch (Exception exception) {
            logger.error("CalResultCoverImportService_genErrDataExcel_error ", (Throwable)exception);
        }
        return url;
    }

    public void createCalResultCoverFailDataSheet(Map<String, String> exportDescInfo, Map<String, Map<String, String>> salaryItemMap, SXSSFWorkbook wb, List<Map<String, String>> errDataList, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow) {
        String sheetName = ResManager.loadKDString((String)"\u8986\u76d6\u6570\u636e\u586b\u5199", (String)"CalResultCoverImportService_80", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        if (dataHead != null) {
            this.setSheetColumnWidth(sheet, dataHead.size() + 4);
            this.writeTaskInfoRow(true, sheet, exportDescInfo, true);
            this.writeExportHeadRow(sheet, salaryItemMap, dataHead, true, true, this.coverType, false);
        }
        if (errDataList != null && errDataList.size() > 0) {
            this.writeErrImportData(sheet, errDataList, dataHead, dataRow);
        }
    }
}

