/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultCoverService {
    private static final Log logger = LogFactory.getLog(CalResultCoverService.class);

    public DynamicObject[] getCalPersonData(List<Long> selectedRowIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,calstatus,taxstatus,onholdstatus,filenumber,name,empnumber,salaryfile.id,caltask.country.id";
        QFilter idCondition = new QFilter("id", "in", selectedRowIdList);
        return calPersonHelper.query(fields, new QFilter[]{idCondition});
    }

    public Map<String, Map<String, String>> getTaskRuleSalaryItemInfo(long taskId) {
        LinkedHashMap<String, Map<String, String>> salaryItemMap = new LinkedHashMap<String, Map<String, String>>(16);
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        if (calRuleHisObj == null || calRuleHisObj.getLong("id") <= 0L) {
            return salaryItemMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRulev = helper.queryOne((Object)calRuleHisObj.getLong("id"));
        if (calRulev == null || SWCListUtils.isEmpty((List)calRulev.getDynamicObjectCollection("calruleitementry"))) {
            return salaryItemMap;
        }
        List<Object> excludeItemIdList = new ArrayList(0);
        try {
            excludeItemIdList = CalResultCoverHelper.invokeResultCoverSalaryItemExtPoint(taskId);
            logger.info("excludeItemIdList:{}", excludeItemIdList);
        }
        catch (Exception exception) {
            logger.error("invokeResultCoverSalaryItemExtPoint error", (Throwable)exception);
        }
        DynamicObjectCollection calRuleItemEntry = calRulev.getDynamicObjectCollection("calruleitementry");
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        for (DynamicObject item : calRuleItemEntry) {
            String itemName = item.getString("salaryitem.name");
            if (SWCStringUtils.isEmpty((String)itemName)) continue;
            long itemId = item.getLong("salaryitem.id");
            if (!SWCListUtils.isEmpty(excludeItemIdList) && excludeItemIdList.contains(itemId)) continue;
            Map itemMap = salaryItemMap.getOrDefault(itemName, new HashMap(16));
            itemMap.put("itemname", itemName);
            itemMap.put("itemid", String.valueOf(itemId));
            itemMap.put("allowresultcover", item.getString("allowresultcover"));
            salaryItemMap.put(itemName, itemMap);
            itemIdList.add(itemId);
        }
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,name,calblock,datatype.storagetype,dataprecision.scale,datalength,dataround";
        QFilter filter = new QFilter("id", "in", itemIdList);
        DynamicObjectCollection dynamicObjects = salaryItemHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return salaryItemMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map itemMap = (Map)salaryItemMap.get(obj.getString("name"));
            if (itemMap == null) continue;
            itemMap.put("calblock", obj.getString("calblock"));
            itemMap.put("datatype", obj.getString("datatype.storagetype"));
            itemMap.put("scale", obj.getString("dataprecision.scale"));
            itemMap.put("datalength", obj.getString("datalength"));
            itemMap.put("dataround", obj.getString("dataround"));
        }
        return salaryItemMap;
    }

    public Map<String, Object> assembleCalParamMap(List<Long> personIdList, Long calPayRollTaskId) {
        HashMap<String, Object> calParamMap = new HashMap<String, Object>(16);
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(calPayRollTaskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleHisObj.getLong("id"));
        DynamicObjectCollection calRuleData = calRuleHisHelper.queryOriginalCollection("id,name,calruleitementry.id", new QFilter[]{qFilter});
        qFilter.and("calruleitementry.salaryitem.calblock", "=", (Object)"0");
        String calTaskStartDate = HRInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"STARTDATE", (Date)task.getDate("STARTDATE"));
        String calTaskEndDate = HRInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"ENDDATE", (Date)task.getDate("ENDDATE"));
        Boolean isHandleProration = task.getBoolean("ishandleproration");
        calParamMap.put("calTaskId", calPayRollTaskId);
        calParamMap.put("totalCount", personIdList.size());
        calParamMap.put("unCalCount", 0);
        calParamMap.put("calCount", personIdList.size());
        calParamMap.put("salaryItemCount", calRuleData.size());
        calParamMap.put("calRuleHisId", calRuleHisObj.getLong("id"));
        calParamMap.put("startdate", calTaskStartDate);
        calParamMap.put("enddate", calTaskEndDate);
        calParamMap.put("calType", "preTaxCal");
        calParamMap.put("ishandleproration", isHandleProration);
        calParamMap.put("taxitemschemev", String.valueOf(task.getLong("taxitemschemev.id")));
        return calParamMap;
    }

    public DynamicObject getCalTaskInfo(Long calTaskId) {
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,number,name,period.name";
        return calPayrollHelper.queryOne(fields, (Object)calTaskId);
    }

    public Map<Long, Map<String, String>> assembleCoverSalaryItemMap(Long calRuleVid) {
        LinkedHashMap<Long, Map<String, String>> salaryItemMap = new LinkedHashMap<Long, Map<String, String>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRulev = helper.queryOne((Object)calRuleVid);
        if (calRulev == null || SWCListUtils.isEmpty((List)calRulev.getDynamicObjectCollection("calruleitementry"))) {
            return salaryItemMap;
        }
        DynamicObjectCollection calRuleItemEntry = calRulev.getDynamicObjectCollection("calruleitementry");
        for (DynamicObject item : calRuleItemEntry) {
            long itemId;
            if (!SWCStringUtils.equals((String)"1", (String)item.getString("allowresultcover")) || (itemId = item.getLong("salaryitem.id")) == 0L) continue;
            Map itemMap = salaryItemMap.getOrDefault(itemId, new HashMap(16));
            itemMap.put("itemname", item.getString("salaryitem.name"));
            itemMap.put("itemid", String.valueOf(itemId));
            salaryItemMap.put(itemId, itemMap);
        }
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,calblock,datatype.storagetype,dataprecision.scale,datalength,dataround.id";
        QFilter filter = new QFilter("id", "in", salaryItemMap.keySet());
        DynamicObjectCollection dynamicObjects = salaryItemHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return salaryItemMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map itemMap = (Map)salaryItemMap.get(obj.getLong("id"));
            itemMap.put("calblock", obj.getString("calblock"));
            itemMap.put("datatype", obj.getString("datatype.storagetype"));
            itemMap.put("scale", obj.getString("dataprecision.scale"));
            itemMap.put("datalength", obj.getString("datalength"));
            itemMap.put("dataround", obj.getString("dataround.id"));
        }
        return salaryItemMap;
    }

    public Map<String, String> getPersonSortColumnInfo(Long calTaskId) {
        HashMap<String, String> sortMap = new HashMap<String, String>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,callistviewv.columnentryentity.field,callistviewv.columnentryentity.sort,callistviewv.columnentryentity.sortpriority";
        QFilter filter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return sortMap;
        }
        List objectList = dynamicObjects.stream().filter(obj -> obj.getInt("callistviewv.columnentryentity.sortpriority") > 0).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(objectList)) {
            return sortMap;
        }
        for (DynamicObject dyObj : objectList) {
            String field = dyObj.getString("callistviewv.columnentryentity.field");
            int sort = dyObj.getInt("callistviewv.columnentryentity.sort");
            String sortPriority = dyObj.getString("callistviewv.columnentryentity.sortpriority");
            if (sort == 1) {
                sortMap.put(sortPriority, field + "|asc");
                continue;
            }
            if (sort != 2) continue;
            sortMap.put(sortPriority, field + "|desc");
        }
        return sortMap;
    }
}

