/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.PaySalarySlipHelper;
import kd.swc.hsas.common.enums.ReleaseSalarySlipEnum;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipListDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipOperationDTO;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class CalSalarySlipService {
    private static final Log logger = LogFactory.getLog(CalSalarySlipService.class);
    private static final int DEFAULT_COUNT = 10000;

    public void sendSalarySlip(CalSalarySlipOperationDTO calSalarySlipOperationDTO) throws Exception {
        List taskIdList = calSalarySlipOperationDTO.getTaskIdList();
        logger.info("salary begin,calTaskIds = {}", (Object)taskIdList);
        List calList = calSalarySlipOperationDTO.getCalList();
        HashMap<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips = new HashMap<Long, CalSalarySlipListDTO>(taskIdList.size());
        for (Long taskId : taskIdList) {
            int calPersonCount = 0;
            ArrayList idsFirstList = new ArrayList(10);
            ArrayList idsRepeatList = new ArrayList(10);
            CalSalarySlipListDTO calSalarySlipListDTO = new CalSalarySlipListDTO(Integer.valueOf(calPersonCount), idsFirstList, idsRepeatList);
            mapCalTaskIdSalarySlips.put(taskId, calSalarySlipListDTO);
        }
        Map<Long, ReleaseSalarySlipEnum> releaseSalarySlip = PaySalarySlipHelper.getReleaseSalarySlip(taskIdList);
        long startTime = System.currentTimeMillis();
        DynamicObject[] allCalPersons = this.getCalPersonData(taskIdList, calList);
        long endTime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u6240\u6709\u6838\u7b97\u540d\u5355\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        List<DynamicObject> calPersons = this.filterReleaseSalarySlip(releaseSalarySlip, allCalPersons, mapCalTaskIdSalarySlips);
        endTime = System.currentTimeMillis();
        logger.info("\u5185\u5b58\u8fc7\u6ee4\u6838\u7b97\u540d\u5355\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
        for (Long taskId : taskIdList) {
            CalSalarySlipListDTO calSalarySlipListDTO = (CalSalarySlipListDTO)mapCalTaskIdSalarySlips.get(taskId);
            if (calSalarySlipListDTO.getCalPersonCount() != 0) continue;
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_CREATESALARY.getOperationKey());
        }
        int totalNum = calPersons.size();
        if (totalNum == 0) {
            return;
        }
        ISWCAppCache appCache = null;
        String calCacheKey = "";
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] calPersonArrays = new DynamicObject[calPersons.size()];
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            calPersonHelper.update(calPersons.toArray(calPersonArrays));
            Long recordId = this.saveCalSalarySlipRecordData(userId, totalNum, "1", "1");
            appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
            Map<Long, Long> recordIdByCalTask = this.saveCalSalarySlipCalTaskRecordData(recordId, mapCalTaskIdSalarySlips, userId, "1", "1");
            List<String> calBatchIdList = this.saveCalBatchDataRelease(mapCalTaskIdSalarySlips, recordIdByCalTask, appCache, userId);
            appCache.put("calBatchIdList", calBatchIdList);
            appCache.put("calTaskIdList", (Object)taskIdList);
            appCache.put("calSalarySlipView", (Object)calSalarySlipOperationDTO.getCalSalarySlipViewDTO());
            appCache.put("calIsUseOldView", (Object)calSalarySlipOperationDTO.getUseOldView());
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ISalarySlipService", (String)"calSalarySlipRelease", (Object[])new Object[]{recordId});
        }
    }

    @NotNull
    private List<DynamicObject> filterReleaseSalarySlip(Map<Long, ReleaseSalarySlipEnum> releaseSalarySlip, DynamicObject[] allCalPersons, Map<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips) {
        ArrayList<DynamicObject> calPersons = new ArrayList<DynamicObject>(allCalPersons.length);
        for (DynamicObject calPerson : allCalPersons) {
            Long taskId = calPerson.getLong("caltask.id");
            String calStatus = calPerson.getString("calstatus");
            String payStatus = calPerson.getString("paystatus");
            boolean flag = false;
            ReleaseSalarySlipEnum releaseSalarySlipEnum = releaseSalarySlip.get(taskId);
            switch (releaseSalarySlipEnum) {
                case AUDIT: {
                    Set auditCalState = ReleaseSalarySlipEnum.getAuditCalState();
                    if (!auditCalState.contains(calStatus)) break;
                    flag = true;
                    break;
                }
                case APPROVE: {
                    Set approveCalState = ReleaseSalarySlipEnum.getApproveCalState();
                    if (!approveCalState.contains(calStatus)) break;
                    flag = true;
                    break;
                }
                case PAY: {
                    String payState = ReleaseSalarySlipEnum.getPayState();
                    if (!SWCStringUtils.equals((String)payState, (String)payStatus)) break;
                    flag = true;
                    break;
                }
            }
            if (!flag) continue;
            CalSalarySlipListDTO calSalarySlipListDTO = mapCalTaskIdSalarySlips.get(taskId);
            String salarySlipStatus = calPerson.getString("salarystatus");
            if (ReleaseStateEnum.RELEASEFAILED.getCode().equals(salarySlipStatus) || ReleaseStateEnum.UNRELEASE.getCode().equals(salarySlipStatus)) {
                calSalarySlipListDTO.getCalFirst().add(calPerson.getLong("id"));
            } else {
                calSalarySlipListDTO.getCalRepeat().add(calPerson.getLong("id"));
            }
            calSalarySlipListDTO.setCalPersonCount(Integer.valueOf(calSalarySlipListDTO.getCalPersonCount() + 1));
            calPerson.set("salarystatus", (Object)ReleaseStateEnum.RELEASEING.getCode());
            mapCalTaskIdSalarySlips.put(taskId, calSalarySlipListDTO);
            calPersons.add(calPerson);
        }
        return calPersons;
    }

    public void recoverSalarySlip(List<Long> taskIdList, List<Long> calList) throws Exception {
        QFilter salaryFilter;
        DynamicObject[] calPersons;
        int totalNum;
        HashMap<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips = new HashMap<Long, CalSalarySlipListDTO>(taskIdList.size());
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter taskIdFilter = new QFilter("caltask", "in", taskIdList);
        if (null != calList && !calList.isEmpty()) {
            taskIdFilter.and(new QFilter("id", "in", calList));
        }
        if ((totalNum = (calPersons = calPersonHelper.query("id,salarystatus,caltask,calmainid", new QFilter[]{taskIdFilter, salaryFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RELEASED.getCode())})).length) == 0) {
            PaySalarySlipHelper.unSalarySlipLock(taskIdList, CalPersonOperationEnum.OP_RECOVERSALARY.getOperationKey());
            return;
        }
        DynamicObject[] dynamicObjectArray = taskIdList.iterator();
        while (dynamicObjectArray.hasNext()) {
            Long taskIdObj;
            Long taskId = taskIdObj = dynamicObjectArray.next();
            ArrayList idsList = new ArrayList(10);
            CalSalarySlipListDTO calSalarySlipListDTO = new CalSalarySlipListDTO(Integer.valueOf(0), idsList);
            mapCalTaskIdSalarySlips.put(taskId, calSalarySlipListDTO);
        }
        for (DynamicObject calPerson : calPersons) {
            Long taskId = calPerson.getLong("caltask.id");
            Long calMainId = calPerson.getLong("calmainid");
            calPerson.set("salarystatus", (Object)ReleaseStateEnum.RECOVEREING.getCode());
            if (calMainId == 0L) {
                CalSalarySlipListDTO calSalarySlipListDTO = (CalSalarySlipListDTO)mapCalTaskIdSalarySlips.get(taskId);
                calSalarySlipListDTO.getCalRecover().add(calPerson.getLong("id"));
                calSalarySlipListDTO.setCalPersonCount(Integer.valueOf(calSalarySlipListDTO.getCalPersonCount() + 1));
                mapCalTaskIdSalarySlips.put(taskId, calSalarySlipListDTO);
                continue;
            }
            --totalNum;
        }
        ISWCAppCache appCache = null;
        String calCacheKey = "";
        Long userId = RequestContext.get().getCurrUserId();
        try (TXHandle txHandle = TX.requiresNew();){
            calPersonHelper.update(calPersons);
            Long recordId = this.saveCalSalarySlipRecordData(userId, totalNum, "3", "1");
            appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
            Map<Long, Long> recordIdByCalTask = this.saveCalSalarySlipCalTaskRecordData(recordId, mapCalTaskIdSalarySlips, userId, "3", "1");
            List<String> calBatchIdList = this.saveCalBatchDataRecover(mapCalTaskIdSalarySlips, recordIdByCalTask, appCache, userId);
            appCache.put("calBatchIdList", calBatchIdList);
            appCache.put("calTaskIdList", taskIdList);
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ISalarySlipService", (String)"calSalarySlipRecover", (Object[])new Object[]{recordId});
        }
    }

    private QFilter[] getQFilter(List<QFilter> filters) {
        QFilter[] newFilters = new QFilter[filters.size()];
        newFilters = filters.toArray(newFilters);
        return newFilters;
    }

    private DynamicObject[] getCalPersonData(List<Long> taskIdList, List<Long> calList) {
        QFilter[] calFilter;
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryUnPayFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusUnPayFilter();
        QFilter salaryPayedFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusPayedFilter();
        salaryUnPayFilter.or(salaryPayedFilter);
        if (calList == null) {
            List<QFilter> permFilter = PaySalarySlipHelper.getPermFilter();
            QFilter calTaskIdFilter = new QFilter("caltask.id", "in", taskIdList);
            calTaskIdFilter.and(salaryUnPayFilter);
            calFilter = PaySalarySlipHelper.getQFilterArray(new QFilter[]{calTaskIdFilter}, permFilter);
        } else {
            QFilter calPersonIdFilter = new QFilter("id", "in", calList);
            calPersonIdFilter.and(salaryUnPayFilter);
            calFilter = new QFilter[]{calPersonIdFilter};
        }
        return calPersonHelper.query("id,calstatus,salarystatus,paystatus,caltask", calFilter);
    }

    private Long saveCalSalarySlipRecordData(Long userId, int totalNum, String salaryStatus, String operationType) {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calsalarysliprecord");
        Date nowDate = new Date();
        DynamicObject calRecord = calRecordHelper.generateEmptyDynamicObject();
        calRecord.set("totalcount", (Object)totalNum);
        calRecord.set("starttime", (Object)nowDate);
        calRecord.set("salarystatus", (Object)salaryStatus);
        calRecord.set("operationtype", (Object)operationType);
        calRecord.set("createtime", (Object)nowDate);
        calRecord.set("modifytime", (Object)nowDate);
        calRecord.set("creator", (Object)userId);
        calRecord.set("modifier", (Object)userId);
        calRecordHelper.saveOne(calRecord);
        return calRecord.getLong("id");
    }

    private Map<Long, Long> saveCalSalarySlipCalTaskRecordData(Long record, Map<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips, Long userId, String salaryStatus, String operationType) {
        SWCDataServiceHelper calTaskRecordHelper = new SWCDataServiceHelper("hsas_caltasksalarybatch");
        DynamicObjectCollection calTaskCollection = new DynamicObjectCollection();
        int size = mapCalTaskIdSalarySlips.size();
        long[] calTaskRecordIdArray = DB.genLongIds((String)"hsas_caltasksalarybatch", (int)size);
        int index = 0;
        Date nowDate = new Date();
        HashMap<Long, Long> recordIdByCalTask = new HashMap<Long, Long>(size);
        for (Map.Entry<Long, CalSalarySlipListDTO> entry : mapCalTaskIdSalarySlips.entrySet()) {
            Long calTaskId = entry.getKey();
            CalSalarySlipListDTO dto = entry.getValue();
            DynamicObject calTaskRecord = calTaskRecordHelper.generateEmptyDynamicObject();
            Long calTaskRecordId = calTaskRecordIdArray[index];
            calTaskRecord.set("id", (Object)calTaskRecordId);
            calTaskRecord.set("record", (Object)record);
            calTaskRecord.set("caltask", (Object)calTaskId);
            calTaskRecord.set("totalcount", (Object)dto.getCalPersonCount());
            calTaskRecord.set("salarystatus", (Object)salaryStatus);
            calTaskRecord.set("operationtype", (Object)operationType);
            calTaskRecord.set("createtime", (Object)nowDate);
            calTaskRecord.set("modifytime", (Object)nowDate);
            calTaskRecord.set("creator", (Object)userId);
            calTaskRecord.set("modifier", (Object)userId);
            calTaskCollection.add((Object)calTaskRecord);
            recordIdByCalTask.put(calTaskId, calTaskRecordId);
            ++index;
        }
        calTaskRecordHelper.save(calTaskCollection);
        return recordIdByCalTask;
    }

    private List<String> saveCalBatchDataRelease(Map<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips, Map<Long, Long> recordIdByCalTask, ISWCAppCache appCache, Long userId) {
        ArrayList<String> calBatchIdList = new ArrayList<String>(10);
        SWCDataServiceHelper calBatchHelper = new SWCDataServiceHelper("hsas_calsalaryslipbatch");
        DynamicObjectCollection calBatchCollection = new DynamicObjectCollection();
        for (Map.Entry<Long, CalSalarySlipListDTO> entry : mapCalTaskIdSalarySlips.entrySet()) {
            Long calTaskId = entry.getKey();
            Long recordTask = recordIdByCalTask.get(calTaskId);
            CalSalarySlipListDTO dto = entry.getValue();
            List splitCalPersonIdFirstList = SWCListUtils.split((List)dto.getCalFirst(), (int)10000);
            List splitCalPersonIdRepeatList = SWCListUtils.split((List)dto.getCalRepeat(), (int)10000);
            this.setCalBatchData(splitCalPersonIdFirstList, calBatchHelper, recordTask, userId, calBatchIdList, calBatchCollection, appCache, "1", calTaskId, "1");
            this.setCalBatchData(splitCalPersonIdRepeatList, calBatchHelper, recordTask, userId, calBatchIdList, calBatchCollection, appCache, "3", calTaskId, "1");
        }
        calBatchHelper.save(calBatchCollection);
        return calBatchIdList;
    }

    private void setCalBatchData(List<List<Long>> splitCalPersonIdList, SWCDataServiceHelper calBatchHelper, Long recordTask, Long userId, List<String> calBatchIdList, DynamicObjectCollection calBatchCollection, ISWCAppCache appCache, String type, Long calTaskId, String salaryStatus) {
        int index = 0;
        DynamicObject calBatch = null;
        long[] calBatchIdArray = DB.genLongIds((String)"hsas_calsalaryslipbatch", (int)splitCalPersonIdList.size());
        for (List<Long> tempIdList : splitCalPersonIdList) {
            calBatch = calBatchHelper.generateEmptyDynamicObject();
            calBatch.set("caltaskbatch", (Object)recordTask);
            calBatch.set("totalcount", (Object)tempIdList.size());
            calBatch.set("salarystatus", (Object)salaryStatus);
            calBatch.set("operationtype", (Object)type);
            calBatch.set("createtime", (Object)new Date());
            calBatch.set("modifytime", (Object)new Date());
            calBatch.set("creator", (Object)userId);
            calBatch.set("modifier", (Object)userId);
            String calBatchId = String.valueOf(calBatchIdArray[index]);
            calBatch.set("id", (Object)calBatchId);
            calBatchIdList.add(calBatchId);
            ++index;
            calBatchCollection.add((Object)calBatch);
            HashMap<String, Object> calBatchMap = new HashMap<String, Object>(3);
            calBatchMap.put("calTaskId", calTaskId);
            calBatchMap.put("calPersonIdList", tempIdList);
            calBatchMap.put("operationtype", type);
            appCache.put(String.format(Locale.ROOT, "calbatch_%s", calBatchId), calBatchMap);
        }
    }

    private List<String> saveCalBatchDataRecover(Map<Long, CalSalarySlipListDTO> mapCalTaskIdSalarySlips, Map<Long, Long> recordIdByCalTask, ISWCAppCache appCache, Long userId) {
        ArrayList<String> calBatchIdList = new ArrayList<String>(10);
        SWCDataServiceHelper calBatchHelper = new SWCDataServiceHelper("hsas_calsalaryslipbatch");
        DynamicObjectCollection calBatchCollection = new DynamicObjectCollection();
        for (Map.Entry<Long, CalSalarySlipListDTO> entry : mapCalTaskIdSalarySlips.entrySet()) {
            Long calTaskId = entry.getKey();
            Long recordTask = recordIdByCalTask.get(calTaskId);
            CalSalarySlipListDTO dto = entry.getValue();
            List splitCalPersonIdList = SWCListUtils.split((List)dto.getCalRecover(), (int)10000);
            this.setCalBatchData(splitCalPersonIdList, calBatchHelper, recordTask, userId, calBatchIdList, calBatchCollection, appCache, "2", calTaskId, "3");
        }
        calBatchHelper.save(calBatchCollection);
        return calBatchIdList;
    }
}

