/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;
import kd.swc.hsas.business.api.CalPersonSplit;
import kd.swc.hsas.business.cal.check.PreCalCheckService;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CalTableCalService {
    private static final Log logger = LogFactory.getLog(CalTableCalService.class);
    private static final String OPERATIONTYPE_CANCEL = "7";

    public Map<String, Object> cal(List<Long> calPersonIdList, Long calTaskId, String calType, Integer salaryItemCount, String calVersionNo, Map<String, String> calModeMap, Long taxItemSchemeVid, boolean resultCheck, CalPersonSplit split, String batchnum, String cacheUUID, boolean isSyncCal) throws Exception {
        logger.info("CalTableCalService.cal begin,calTaskId = {}", (Object)calTaskId);
        HashMap<String, Object> calMap = new HashMap<String, Object>(6);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter qFilter = new QFilter("id", "in", calPersonIdList);
        this.addQFilter(qFilter, calModeMap);
        DynamicObject[] calPersonArray = calPersonHelper.query("id,calstatus,salaryfile.id", new QFilter[]{qFilter});
        DynamicObject calTaskInfo = this.getCalTaskInfo(calTaskId);
        Long recordId = CalHelper.getCalRecordPkId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", recordId));
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", recordId));
        HashMap<String, String> oldCalStatusMap = new HashMap<String, String>(calPersonArray.length);
        HashMap<String, Long> calPersonFileRelMap = new HashMap<String, Long>(calPersonArray.length);
        ArrayList<Long> canCalPersonIdList = new ArrayList<Long>(calPersonArray.length);
        for (DynamicObject obj : calPersonArray) {
            oldCalStatusMap.put(String.valueOf(obj.getLong("id")), obj.getString("calstatus"));
            calPersonFileRelMap.put(String.valueOf(obj.getLong("id")), obj.getLong("salaryfile.id"));
            canCalPersonIdList.add(obj.getLong("id"));
        }
        boolean openTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByTask((DynamicObject)calTaskInfo);
        PreCalCheckService checkService = new PreCalCheckService(calTaskId, recordId);
        Map<String, Object> resultMap = checkService.handlePreTaxCal(calPersonArray, calModeMap, openTaxCal, split);
        DynamicObjectCollection calBatchDataList = (DynamicObjectCollection)resultMap.get("calBatchDataList");
        List calBatchIdList = (List)resultMap.get("calBatchIdList");
        DynamicObjectCollection calDetailList = (DynamicObjectCollection)resultMap.get("calDetailList");
        int failCount = calDetailList.size();
        FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "pretax_cal_progress_%s", recordId));
        if (openTaxCal) {
            FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "tax_cal_progress_%s", recordId));
        }
        FormulaCacheUtils.updateProgress((ISWCAppCache)calProgressAppCache, (int)0, (int)failCount, (int)0, (String)String.format(Locale.ROOT, "calrecord_progress_%s", recordId));
        calMap.put("calpersonidList", canCalPersonIdList);
        calMap.put("calCount", calPersonArray.length);
        calMap.put("calRecordId", recordId);
        TXHandle txHandle = TX.requiresNew();
        try {
            logger.info("begin save data");
            boolean isFinish = this.saveCalRecordData(calTaskId, recordId, calPersonArray.length, salaryItemCount, failCount, calVersionNo, batchnum);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbatch");
            if (calBatchDataList.size() > 0) {
                helper.save(calBatchDataList);
            }
            if (calDetailList.size() > 0) {
                helper.setEntityName("hsas_caldetail");
                helper.save(calDetailList);
            }
            calMap.put("isFinish", isFinish);
            if (isFinish) {
                this.cacheFinishPerson(cacheUUID, calPersonArray.length);
                HashMap<String, Object> hashMap = calMap;
                return hashMap;
            }
            calPersonHelper.update(calPersonArray);
            helper.setEntityName("hsas_calpayrolltask");
            calTaskInfo.set("calversionno", (Object)calVersionNo);
            if (taxItemSchemeVid != null) {
                calTaskInfo.set("taxitemschemev", (Object)taxItemSchemeVid);
            }
            helper.updateOne(calTaskInfo);
            this.saveCalOperationData(recordId);
            appCache.put("calversionno", (Object)calVersionNo);
            appCache.put("calPersonFileRelMap", calPersonFileRelMap);
            appCache.put("oldCalStatusMap", oldCalStatusMap);
            appCache.put("calBatchIdList", (Object)calBatchIdList);
            appCache.put("countryId", (Object)String.valueOf(calTaskInfo.getLong("country.id")));
            appCache.put(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", recordId), canCalPersonIdList);
            logger.info("end save data");
        }
        catch (Exception e) {
            logger.error("cal fail", (Throwable)e);
            txHandle.markRollback();
            this.clearCache(recordId, appCache);
            throw new Exception(e);
        }
        finally {
            txHandle.close();
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
        }
        boolean isFail = false;
        try {
            if (!isSyncCal) {
                SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSService", (String)"calculate", (Object[])new Object[]{calTaskId, recordId, calType, resultCheck});
            }
            this.cacheFinishPerson(cacheUUID, calPersonArray.length);
        }
        catch (Exception ex) {
            isFail = true;
            logger.error("invoke IHSCSService.calculate fail", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            if (isFail) {
                this.handExceptionData(appCache, canCalPersonIdList, recordId, oldCalStatusMap);
            }
        }
        logger.info("CalTableCalService.cal end,calTaskId = {}", (Object)calTaskId);
        return calMap;
    }

    private void handExceptionData(ISWCAppCache appCache, List<Long> calPersonIdList, Long recordId, Map<String, String> oldCalStatusMap) {
        DynamicObject[] calPersonArray;
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        for (DynamicObject obj : calPersonArray = calPersonHelper.query("id,calstatus,modifytime", new QFilter[]{filter})) {
            obj.set("calstatus", (Object)oldCalStatusMap.get(String.valueOf(obj.getLong("id"))));
            obj.set("modifytime", (Object)new Date());
        }
        calPersonHelper.update(calPersonArray);
        SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calrecord");
        calHelper.deleteOne((Object)recordId);
        QFilter requestFilter = new QFilter("calrecord.id", "=", (Object)recordId);
        calHelper.setEntityName("hsas_calrequest");
        calHelper.deleteByFilter(new QFilter[]{requestFilter});
        calHelper.setEntityName("hsas_calbatch");
        QFilter batchFilter = new QFilter("record.id", "=", (Object)recordId);
        calHelper.deleteByFilter(new QFilter[]{batchFilter});
        calHelper.setEntityName("hsas_caldetail");
        calHelper.deleteByFilter(new QFilter[]{batchFilter});
        this.clearCache(recordId, appCache);
    }

    private void clearCache(Long recordId, ISWCAppCache appCache) {
        appCache.remove("calBatchIdList");
        appCache.remove("calversionno");
        appCache.remove("countryId");
        appCache.remove("calPersonFileRelMap");
        appCache.remove("oldCalStatusMap");
        appCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", recordId));
    }

    private void cacheFinishPerson(String cacheUUID, int finishCount) {
        if (cacheUUID == null) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
        String cacheKey = String.format(Locale.ROOT, "finish_cal_check_%s", cacheUUID);
        Integer totalFinishCount = (Integer)appCache.get(cacheKey, Integer.class);
        if (totalFinishCount == null) {
            totalFinishCount = 0;
        }
        totalFinishCount = totalFinishCount + finishCount;
        appCache.put(cacheKey, (Object)totalFinishCount);
    }

    private DynamicObject getCalTaskInfo(Long calTaskId) {
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,number,name,startdate,enddate,country.id,paydate,payrollgroupv.currency.id,taxitemschemev,calversionno,calrulev.opentaxcal";
        return calPayrollHelper.queryOne(fields, (Object)calTaskId);
    }

    private void addQFilter(QFilter qFilter, Map<String, String> calModeMap) {
        ArrayList<String> calStatusList = new ArrayList<String>(10);
        if (!SWCStringUtils.equals((String)"0", (String)calModeMap.get("uncalstate"))) {
            calStatusList.add(CalStateEnum.UNCAL.getCode());
        }
        if (!SWCStringUtils.equals((String)"0", (String)calModeMap.get("partialcaledstate"))) {
            calStatusList.add(CalStateEnum.PARTIAL_CALED.getCode());
        }
        if (!SWCStringUtils.equals((String)"0", (String)calModeMap.get("errorstate"))) {
            calStatusList.add(CalStateEnum.PRECAL_ERROR.getCode());
            calStatusList.add(CalStateEnum.PUSHTAX_ERROR.getCode());
            calStatusList.add(CalStateEnum.TAXCAL_ERROR.getCode());
            calStatusList.add(CalStateEnum.PULLTAX_ERROR.getCode());
            calStatusList.add(CalStateEnum.AFTERCAL_ERROR.getCode());
        }
        if (!SWCStringUtils.equals((String)"0", (String)calModeMap.get("caledstate"))) {
            calStatusList.add(CalStateEnum.ALL_CALED.getCode());
        }
        qFilter.and("calstatus", "in", calStatusList);
    }

    private boolean saveCalRecordData(Long calTaskId, Long calRecordId, int totalCount, Integer salaryItemCount, int failCount, String calVersionNo, String batchnum) {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject calRecord = calRecordHelper.generateEmptyDynamicObject();
        calRecord.set("id", (Object)calRecordId);
        calRecord.set("caltask", (Object)calTaskId);
        calRecord.set("totalcount", (Object)totalCount);
        calRecord.set("failcount", (Object)failCount);
        calRecord.set("starttime", (Object)nowDate);
        boolean isFinish = false;
        if (totalCount == failCount) {
            calRecord.set("calstatus", (Object)"2");
            isFinish = true;
        } else {
            calRecord.set("calstatus", (Object)"1");
        }
        calRecord.set("salaryitemcount", (Object)salaryItemCount);
        calRecord.set("createtime", (Object)nowDate);
        calRecord.set("modifytime", (Object)nowDate);
        calRecord.set("creator", (Object)userId);
        calRecord.set("modifier", (Object)userId);
        calRecord.set("reportnum", (Object)CalHelper.getReportNum());
        calRecord.set("optype", (Object)"1");
        calRecord.set("calversionno", (Object)calVersionNo);
        calRecordHelper.saveOne(calRecord);
        CalRequestHelper.saveCalRequest((Long)calTaskId, (int)totalCount, (String)"cal", (String)(isFinish ? CalRequestStatusEnum.FINISHED.getCode() : CalRequestStatusEnum.QUEUING.getCode()), (Long)calRecordId, (String)batchnum);
        if (isFinish) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
        }
        return isFinish;
    }

    private void saveCalOperationData(Long recordId) {
        SWCDataServiceHelper calOperationHelper = new SWCDataServiceHelper("hsas_caloperation");
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject operationObj = calOperationHelper.generateEmptyDynamicObject();
        operationObj.set("record", (Object)recordId);
        operationObj.set("optype", (Object)"1");
        operationObj.set("endtime", (Object)new Date());
        operationObj.set("starttime", (Object)new Date());
        operationObj.set("createtime", (Object)new Date());
        operationObj.set("modifytime", (Object)new Date());
        operationObj.set("creator", (Object)userId);
        operationObj.set("modifier", (Object)userId);
        calOperationHelper.saveOne(operationObj);
    }

    private List<Long> getCalPersonIdListByRecord(Long calTaskId, DynamicObject calRecord) {
        List<Long> calPersonIdList = null;
        if ("2".equals(calRecord.getString("optype"))) {
            QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
            qFilter.and("calstatus", "=", (Object)CalStateEnum.CANCELCALING.getCode());
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            DynamicObjectCollection calPersonData = helper.queryOriginalCollection("id", new QFilter[]{qFilter});
            calPersonIdList = calPersonData.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        } else {
            calPersonIdList = this.getCaPersonIdListFromCalDetail(calTaskId, calRecord.getLong("id"));
        }
        return calPersonIdList;
    }

    @NotNull
    private List<Long> getCaPersonIdListFromCalDetail(Long calTaskId, Long calRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("record.id", "=", (Object)calRecordId);
        DynamicObjectCollection calDetailList = helper.queryOriginalCollection("id,calpersonid", new QFilter[]{filter});
        return calDetailList.stream().map(obj -> obj.getLong("calpersonid")).collect(Collectors.toList());
    }

    private Map<String, String> checkTaxDataStatus(List<Long> calPersonIdList, DynamicObject calTaskInfo, Long calRecordId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        String openTaxCal = calTaskInfo.getString("calrulev.opentaxcal");
        if (SWCStringUtils.isEmpty((String)openTaxCal) || SWCStringUtils.equals((String)"0", (String)openTaxCal)) {
            return resultMap;
        }
        return CalTableCalHelper.rollBackCalCheck(calPersonIdList, calTaskInfo, calRecordId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIsRepeatClick(Long calRecordId, ISWCAppCache appCache) {
        String lockKey = "_checkIsRepeatClick_" + calRecordId;
        Date nowDate = new Date();
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(60000L)) return false;
            Long cacheStopTime = (Long)appCache.get("firstOperateStopCal", Long.class);
            if (cacheStopTime == null) {
                appCache.put("firstOperateStopCal", (Object)nowDate.getTime());
                boolean bl = false;
                return bl;
            }
            long differTime = nowDate.getTime() - cacheStopTime;
            if (differTime <= 300000L && differTime >= 0L) {
                boolean bl = true;
                return bl;
            }
            appCache.put("firstOperateStopCal", (Object)nowDate.getTime());
            return false;
        }
        catch (Exception ex) {
            logger.error("batchExtractTask create dlock error", (Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> cancelCal(Long calRecordId, Long calTaskId) {
        logger.info("CalTableCalService.cancelCal start,calRecordId = {}", (Object)calRecordId);
        Date startDate = new Date();
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        DynamicObject calRecord = this.getCalRecordObj(calRecordId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        if (this.checkIsRepeatClick(calRecordId, appCache)) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u7ec8\u6b62\u5931\u8d25\uff0c\u5bf9\u4e8e\u540c\u4e00\u4e2a\u8ba1\u7b97\u8bf7\u6c425\u5206\u949f\u5185\u4ec5\u5141\u8bb8\u7ec8\u6b62\u4e00\u6b21\u3002", (String)"CalTableCalService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
            resultMap.put("level", String.valueOf(ErrorLevel.Warning.getValue()));
            return resultMap;
        }
        List<Long> calPersonIdList = (List<Long>)appCache.get(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId), List.class);
        boolean isFromCache = true;
        if (SWCListUtils.isEmpty((List)calPersonIdList)) {
            calPersonIdList = this.getCalPersonIdListByRecord(calTaskId, calRecord);
            isFromCache = false;
        }
        DynamicObject calTaskInfo = this.getCalTaskInfo(calTaskId);
        List allBatchIdList = SWCListUtils.split(calPersonIdList, (int)5000);
        for (List currentBatchIdList : allBatchIdList) {
            if (this.batchCheck(resultMap, currentBatchIdList, calTaskInfo, calRecord)) continue;
            appCache.remove("firstOperateStopCal");
            return resultMap;
        }
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
        PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey());
        SWCDataServiceHelper calOperationHelper = new SWCDataServiceHelper("hsas_caloperation");
        DynamicObject operationObj = this.assembleOperationObj(calRecordId, calOperationHelper, startDate);
        List spliteCalPersonList = SWCListUtils.split(calPersonIdList, (int)30000);
        try (TXHandle txHandle = TX.requiresNew();){
            appCache.put(String.format(Locale.ROOT, "isCancel_%s", calRecordId), (Object)Boolean.TRUE);
            for (List tempIdList : spliteCalPersonList) {
                this.batchUpdateCalDetail(tempIdList, calRecordId);
            }
            CalRequestHelper.updateCalRequest((Long)calRecordId, (String)CalRequestStatusEnum.STOPPED.getCode());
            this.updateCalRecordData(calRecordId, isFromCache, calPersonIdList);
            calOperationHelper.saveOne(operationObj);
            if (!SWCListUtils.isEmpty(calPersonIdList)) {
                logger.info("invokeSWCService  IHSCSService cancelCal");
                SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSService", (String)"cancelCal", (Object[])new Object[]{calTaskId, calRecordId, calPersonIdList, "stopcal"});
            } else {
                logger.info("calpersonidlist is empty");
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey());
            }
        }
        logger.info("CalTableCalService.cancelCal end,calRecordId = {}", (Object)calRecordId);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCalRecordData(Long calRecordId, boolean isFromCache, List<Long> calPersonIdList) {
        logger.info("updateCalRecordData start");
        String lockKey = "_updateCalRecordCount_" + calRecordId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(120000L)) {
                DynamicObject calRecord = this.getCalRecordObj(calRecordId);
                this.assembleRecordObj(calRecord, isFromCache, calPersonIdList);
                SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
                calRecordHelper.updateOne(calRecord);
            } else {
                logger.error("updateCalRecord tryLock fail,recordId={}", (Object)calRecordId);
            }
        }
        finally {
            lock.unlock();
        }
        logger.info("updateCalRecordData end");
    }

    private boolean batchCheck(Map<String, String> resultMap, List<Long> currentBatchIdList, DynamicObject calTaskInfo, DynamicObject calRecord) {
        logger.info("batchCheck start");
        long calTaskId = calTaskInfo.getLong("id");
        long calRecordId = calRecord.getLong("id");
        Set<String> calTaskNameSet = this.checkAccIndexIsMax(currentBatchIdList, calTaskId);
        if (calTaskNameSet.size() > 0) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u7ec8\u6b62\u8ba1\u7b97\u65f6\u89e6\u53d1\u7684\u8ba1\u7b97\u56de\u6eda\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6309\u8ba1\u7b97\u7684\u5012\u5e8f\u56de\u6eda\uff0c\u4e0a\u6b21\u8ba1\u7b97\u7684\u6838\u7b97\u4efb\u52a1\u4e3a{0}\u3002", (String)"CalTableCalService_4", (String)"swc-hsas-business", (Object[])new Object[]{SWCListUtils.join(calTaskNameSet, (String)",")}));
            resultMap.put("level", String.valueOf(ErrorLevel.Error.getValue()));
            return false;
        }
        if ("1".equals(calRecord.getString("optype")) && currentBatchIdList.size() > 0) {
            resultMap.putAll(this.checkTaxDataStatus(currentBatchIdList, calTaskInfo, calRecordId));
            if (resultMap.size() > 0) {
                return false;
            }
        }
        logger.info("batchCheck end");
        return true;
    }

    private void batchUpdateCalDetail(List<Long> calPersonIdList, Long calRecordId) {
        String calDetailSql = "UPDATE T_HSAS_CALDETAIL SET FCALSTATUS = '4',FFAILTYPE = ' ',FFAILMSG = ' ',FERRORELEMENT = ' ' WHERE  FRECORDID = " + calRecordId + " AND FCALPERSONID IN (" + this.buildSqlParamReplaceChar(calPersonIdList) + ")";
        Object[] params = null;
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            params = new Object[]{0L};
        } else {
            params = new Object[calPersonIdList.size()];
            calPersonIdList.toArray(params);
        }
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)calDetailSql, (Object[])params);
    }

    private String buildSqlParamReplaceChar(List<Long> calPersonIdList) {
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return "?";
        }
        StringBuilder param = new StringBuilder();
        for (Long id : calPersonIdList) {
            param.append('?').append(',');
        }
        return param.substring(0, param.length() - 1);
    }

    private Set<String> checkAccIndexIsMax(List<Long> calPersonIdList, Long calTaskId) {
        HashSet<String> calTaskNameSet = new HashSet<String>(16);
        if (calPersonIdList.size() == 0) {
            return calTaskNameSet;
        }
        DynamicObjectCollection accDetailsList = this.getAccDetailsData(calPersonIdList, calTaskId);
        if (accDetailsList.size() == 0) {
            return calTaskNameSet;
        }
        List<Long> accResultIdList = accDetailsList.stream().map(obj -> obj.getLong("accresult.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> maxIndexAccMap = this.getMaxIndexAccMap(accResultIdList, calTaskId);
        Map<Long, Map<Long, DynamicObject>> accDetailMap = this.getAccDetailMap(accDetailsList);
        DynamicObject tempAcc = null;
        block0: for (Map.Entry<Long, Map<Long, DynamicObject>> entry : accDetailMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> accEntry : entry.getValue().entrySet()) {
                tempAcc = maxIndexAccMap.get(accEntry.getKey());
                if (tempAcc == null || tempAcc.getInt("index") <= accEntry.getValue().getInt("index") || tempAcc.getLong("caltask.id") == accEntry.getValue().getLong("caltask.id")) continue;
                calTaskNameSet.add(tempAcc.getString("caltask.name"));
                continue block0;
            }
        }
        return calTaskNameSet;
    }

    private Map<Long, Map<Long, DynamicObject>> getAccDetailMap(DynamicObjectCollection accDetailsList) {
        HashMap<Long, Map<Long, DynamicObject>> accDetailMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        Map tempMap = null;
        for (DynamicObject obj : accDetailsList) {
            tempMap = accDetailMap.getOrDefault(obj.getLong("calpersonid"), new HashMap(16));
            tempMap.put(obj.getLong("accresult.id"), obj);
            accDetailMap.put(obj.getLong("calpersonid"), tempMap);
        }
        return accDetailMap;
    }

    private Map<Long, DynamicObject> getMaxIndexAccMap(List<Long> accResultIdList, Long calTaskId) {
        logger.info("getMaxIndexAccMap start");
        Integer size = ConfigurationUtil.getInteger((String)"orm.opt.in.maxsize");
        if (size == null || size == 0) {
            size = accResultIdList.size();
        }
        List batchAccResultIdList = SWCListUtils.split(accResultIdList, (int)size);
        HashMap<Long, DynamicObject> maxIndexAccMap = new HashMap<Long, DynamicObject>(accResultIdList.size());
        for (List tempIdList : batchAccResultIdList) {
            DynamicObjectCollection list = this.getMaxIndexAccDetailsData(tempIdList, calTaskId);
            for (DynamicObject obj : list) {
                if (maxIndexAccMap.containsKey(obj.getLong("accresult.id"))) continue;
                maxIndexAccMap.put(obj.getLong("accresult.id"), obj);
            }
        }
        logger.info("getMaxIndexAccMap end,maxIndexAccMap size is {}", (Object)maxIndexAccMap.size());
        return maxIndexAccMap;
    }

    private DynamicObjectCollection getMaxIndexAccDetailsData(List<Long> accResultIdList, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter qFilter = new QFilter("accresult", "in", accResultIdList);
        qFilter.and("caltask", "!=", (Object)calTaskId);
        qFilter.and("index", ">", (Object)1);
        String fields = "id,caltask.id,caltask.name,accresult.id,index";
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter}, "accresult.id asc,index desc");
    }

    private DynamicObjectCollection getAccDetailsData(List<Long> calPersonIdList, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter qFilter = new QFilter("caltask", "=", (Object)calTaskId);
        qFilter.and("calpersonid", "in", calPersonIdList);
        String fields = "id,caltask.id,caltask.name,accresult.id,calpersonid,index";
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
    }

    public Map<String, Object> cacheVersionData(Map<String, Object> versionData, Map<String, Object> formulaAndGradeMap, boolean isCache) {
        Object formulaVidAndGradeVidMap;
        Map formulabaseMap;
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        ArrayList<Long> formulaBaseIdList = new ArrayList<Long>(10);
        ArrayList dataGradeVidList = new ArrayList(10);
        if (isCache) {
            formulabaseMap = (Map)formulaAndGradeMap.get("formulabaseMap");
            for (Map.Entry entry : formulabaseMap.entrySet()) {
                formulaBaseIdList.add(Long.valueOf((String)entry.getKey()));
            }
            formulaVidAndGradeVidMap = (Map)formulaAndGradeMap.get("formulaVidAndGradeVidMap");
            for (Map.Entry entry : formulaVidAndGradeVidMap.entrySet()) {
                dataGradeVidList.addAll((Collection)entry.getValue());
            }
        } else {
            formulabaseMap = (Map)formulaAndGradeMap.get("formulabaseMap");
            for (Map.Entry entry : formulabaseMap.entrySet()) {
                formulaBaseIdList.add((Long)entry.getKey());
            }
            formulaVidAndGradeVidMap = (Map)formulaAndGradeMap.get("formulaVidAndGradeVidMap");
            for (Map.Entry entry : formulaVidAndGradeVidMap.entrySet()) {
                dataGradeVidList.addAll((Collection)entry.getValue());
            }
        }
        Map formulaDataMap = (Map)formulaAndGradeMap.get("formulaMap");
        List formulaVidList = (List)formulaDataMap.get("formulaVidList");
        data.put("formulaBaseIdList", formulaBaseIdList);
        data.put("dataGradeVidList", dataGradeVidList);
        data.put("formulaVidList", formulaVidList);
        data.put("calVersionNo", formulaAndGradeMap.get("calVersionNo"));
        versionData.put("formula_grade_verion", data);
        return versionData;
    }

    public String getTaskCalVersionNo(Long calTaskId) {
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(calTaskId);
        return task.getString("calversionno");
    }

    public Map<String, Object> getCalFormulaGradeVInfo(Long calRuleVid, String calType, String startDate, String endDate, String taxItemSchemeVid) {
        logger.info("getCalFormulaGradeVInfo_param:calRuleVid:{},calType:{},startDate:{},endDate:{},taxItemSchemeVid:{}", new Object[]{calRuleVid, calType, startDate, endDate, taxItemSchemeVid});
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        Map<Long, Integer> formulabaseMap = this.assembleFormulaBaseIdList(calRuleVid);
        List<Long> formulabaseIdList = formulabaseMap.keySet().stream().collect(Collectors.toList());
        Map<String, Object> formulaMap = this.assembleFormulaVidList(formulabaseIdList, startDate, endDate);
        List gradeUnicodeList = (List)formulaMap.get("dataGradeMap");
        List formulaDataList = (List)formulaMap.get("formulaDataList");
        Map<Object, Object> dataGradeVMap = new HashMap(16);
        HashMap formulaVidAndGradeVidMap = new HashMap(16);
        if (gradeUnicodeList.size() > 0) {
            try {
                dataGradeVMap = CalTableCalHelper.getGradeVidMap(gradeUnicodeList, SWCDateTimeUtils.parseDate((String)startDate), SWCDateTimeUtils.parseDate((String)endDate));
            }
            catch (ParseException e) {
                logger.error("assembleGradeVidList_error");
            }
            for (Map formulaMapTemp : formulaDataList) {
                String gradeunicode = formulaMapTemp.get("dependondatagrade") + "";
                ArrayList<Long> gradevidList = new ArrayList<Long>(10);
                if (!SWCStringUtils.isEmpty((String)gradeunicode)) {
                    List<String> split = Arrays.asList(gradeunicode.split(","));
                    for (String singleunicode : split) {
                        Map map = (Map)dataGradeVMap.get(singleunicode);
                        if (map == null || map.size() <= 0) continue;
                        gradevidList.add(Long.parseLong(map.get("id").toString()));
                    }
                }
                formulaVidAndGradeVidMap.put(Long.parseLong(formulaMapTemp.get("id").toString()), gradevidList);
            }
        }
        dataMap.put("formulabaseMap", formulabaseMap);
        dataMap.put("formulaMap", formulaMap);
        dataMap.put("calRuleHisVid", calRuleVid);
        dataMap.put("dataGradeVMap", dataGradeVMap);
        dataMap.put("formulaVidAndGradeVidMap", formulaVidAndGradeVidMap);
        dataMap.put("taxItemSchVMap", this.getTaxItemSchemeVersionDataMap(taxItemSchemeVid));
        logger.info("getCalFormulaGradeVInfo_result:{}", (Object)((Object)dataMap).toString());
        return dataMap;
    }

    public Map<String, String> getTaxItemSchemeVersionDataMap(String taxItemSchemeVid) {
        HashMap<String, String> taxItemSchMap = new HashMap<String, String>(16);
        if (taxItemSchemeVid == null || "0".equals(taxItemSchemeVid)) {
            return taxItemSchMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_taxprojscheme");
        DynamicObject taxItem = helper.queryOne("id,name,bsed", (Object)Long.valueOf(taxItemSchemeVid));
        taxItemSchMap.put("id", taxItemSchemeVid);
        taxItemSchMap.put("name", taxItem.getString("name"));
        taxItemSchMap.put("bsed", SWCDateTimeUtils.format((Date)taxItem.getDate("bsed"), (String)"yyyyMMdd"));
        return taxItemSchMap;
    }

    private Map<String, Object> assembleFormulaVidList(List<Long> formulaBoIdList, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        ArrayList<Long> formulaVidList = new ArrayList<Long>(10);
        ArrayList<String> dataGradeList = new ArrayList<String>(10);
        List<Object> formulaVData = new ArrayList(10);
        try {
            formulaVData = CalTableCalHelper.getFormulaGradeData(SWCDateTimeUtils.parseDate((String)startDate), SWCDateTimeUtils.parseDate((String)endDate), formulaBoIdList);
        }
        catch (ParseException e) {
            logger.error("assembleFormulaVidList_error", (Throwable)e);
        }
        ArrayList formulaVDataList = new ArrayList(formulaVData.size());
        for (DynamicObject dynamicObject : formulaVData) {
            HashMap<String, Object> single = new HashMap<String, Object>(16);
            single.put("id", dynamicObject.getLong("id"));
            single.put("originalexp", dynamicObject.getString("originalexp"));
            single.put("boid", dynamicObject.getLong("boid"));
            single.put("name", dynamicObject.getString("name"));
            single.put("number", dynamicObject.getString("number"));
            single.put("salaryitem.name", dynamicObject.getString("salaryitem.name"));
            single.put("dependondatagrade", dynamicObject.getString("dependondatagrade"));
            single.put("bsed", dynamicObject.getDate("bsed"));
            formulaVDataList.add(single);
            formulaVidList.add(dynamicObject.getLong("id"));
            String dependondatagrade = dynamicObject.getString("dependondatagrade");
            if (!SWCStringUtils.isNotEmpty((String)dependondatagrade)) continue;
            List<String> split = Arrays.asList(dependondatagrade.split(","));
            dataGradeList.addAll(split);
        }
        map.put("formulaVidList", formulaVidList);
        map.put("dataGradeMap", dataGradeList);
        map.put("formulaDataList", formulaVDataList);
        return map;
    }

    private Map<Long, Integer> assembleFormulaBaseIdList(Long calRuleHisVid) {
        HashMap<Long, Integer> formulaBaseMap = new HashMap<Long, Integer>(16);
        DynamicObjectCollection calRuleHisData = CalTableCalHelper.getCalRuleFormula(calRuleHisVid);
        for (DynamicObject entry : calRuleHisData) {
            if (entry.getLong("calruleitementry.formula.id") == 0L) continue;
            formulaBaseMap.put(entry.getLong("calruleitementry.formula.id"), entry.getInt("calruleitementry.seq"));
        }
        return formulaBaseMap;
    }

    public DynamicObjectCollection getCalVersionFormulaGradeVInfo(String calVersionNo, Long calRuleVid) {
        return CalTableCalHelper.getCalVersionData(calVersionNo, calRuleVid);
    }

    public Map<String, Object> assembleFormulaGradeByDyObj(DynamicObjectCollection dynamicObjects) {
        HashMap<String, Object> versionData = new HashMap<String, Object>(3);
        ArrayList<Long> dataGradeVidList = new ArrayList<Long>(10);
        ArrayList<Long> formulaVidList = new ArrayList<Long>(10);
        for (DynamicObject obj : dynamicObjects) {
            formulaVidList.add(obj.getLong("formulav.id"));
            long gradeVid = obj.getLong("datagradev.id");
            if (gradeVid == 0L) continue;
            dataGradeVidList.add(gradeVid);
        }
        List<Long> formulaBaseIdList = CalTableCalHelper.getFormulaBaseIdByVid(formulaVidList);
        versionData.put("formulaBaseIdList", formulaBaseIdList);
        versionData.put("dataGradeVidList", dataGradeVidList);
        versionData.put("formulaVidList", formulaVidList);
        return versionData;
    }

    public Map<String, String> checkCalVersionDiff(DynamicObjectCollection calVersionData, Map<String, Object> formulaAndGradeMap) {
        HashMap<String, String> diffData = new HashMap<String, String>(16);
        ArrayList<String> diffFormula = new ArrayList<String>(10);
        ArrayList<String> diffGrade = new ArrayList<String>(10);
        ArrayList<Long> formulaVids = new ArrayList<Long>(10);
        ArrayList<Long> gradeVids = new ArrayList<Long>(10);
        for (DynamicObject dyObj : calVersionData) {
            if (SWCStringUtils.equals((String)"1", (String)dyObj.getString("datatype"))) {
                formulaVids.add(dyObj.getLong("formulav.id"));
            }
            if (!SWCStringUtils.equals((String)"2", (String)dyObj.getString("datatype"))) continue;
            gradeVids.add(dyObj.getLong("datagradev.id"));
        }
        Map formulaMap = (Map)formulaAndGradeMap.get("formulaMap");
        List formulaDataList = (List)formulaMap.get("formulaDataList");
        Map dataGradeVMap = (Map)formulaAndGradeMap.get("dataGradeVMap");
        List gradeList = dataGradeVMap.values().stream().collect(Collectors.toList());
        for (Map formula : formulaDataList) {
            if (formulaVids.contains(Long.valueOf(formula.get("id").toString()))) continue;
            diffFormula.add(formula.get("name").toString());
        }
        for (Map grade : gradeList) {
            if (gradeVids.contains(Long.valueOf(grade.get("id").toString()))) continue;
            diffGrade.add(grade.get("name").toString());
        }
        if (CollectionUtils.isNotEmpty(diffFormula) || CollectionUtils.isNotEmpty(diffGrade)) {
            String diffFormulaNames = StringUtils.join(diffFormula, (char)',', (int)0, (int)diffFormula.size());
            String diffGradeNames = StringUtils.join(diffGrade, (char)',', (int)0, (int)diffGrade.size());
            diffData.put("diffFormula", diffFormulaNames);
            diffData.put("diffGrade", diffGradeNames);
        }
        return diffData;
    }

    @NotNull
    private void assembleRecordObj(DynamicObject calRecord, boolean isFromCache, List<Long> calPersonIdList) {
        calRecord.set("modifytime", (Object)new Date());
        calRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if ("1".equals(calRecord.getString("optype")) || isFromCache) {
            calRecord.set("sucesscount", (Object)0);
            calRecord.set("failcount", (Object)0);
        }
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            calRecord.set("calstatus", (Object)"3");
        }
    }

    private DynamicObject getCalRecordObj(long calRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        String fields = "id,optype,calstatus,totalcount,sucesscount,failcount,modifytime,modifier";
        return helper.queryOne(fields, (Object)calRecordId);
    }

    private DynamicObject assembleOperationObj(Long calRecordId, SWCDataServiceHelper calOperationHelper, Date startDate) {
        DynamicObject operationObj = calOperationHelper.generateEmptyDynamicObject();
        operationObj.set("record", (Object)calRecordId);
        operationObj.set("optype", (Object)OPERATIONTYPE_CANCEL);
        operationObj.set("endtime", (Object)new Date());
        operationObj.set("starttime", (Object)startDate);
        operationObj.set("createtime", (Object)new Date());
        operationObj.set("modifytime", (Object)new Date());
        operationObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        operationObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return operationObj;
    }
}

