/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class HSASAllotExrateService {
    public final Log logger = LogFactory.getLog(HSASAllotExrateService.class);
    private Map<String, ExchangeRateInfo> exrateMap = new HashMap<String, ExchangeRateInfo>();

    public ExchangeRateInfo getExrate(Long oriCurId, Long targetCurId, Date exrateDate, Long exrateTableId) {
        if (oriCurId.equals(targetCurId)) {
            ExchangeRateInfo exchangeRateInfo = new ExchangeRateInfo();
            exchangeRateInfo.setExchangeRate(BigDecimal.ONE);
            return exchangeRateInfo;
        }
        String exrateKey = String.format("exrate_%d_%d_%s", oriCurId, targetCurId, SWCDateTimeUtils.format((Date)exrateDate, (String)"yyyyMMdd"));
        ExchangeRateInfo exchangeRateInfo = this.exrateMap.get(exrateKey);
        if (exchangeRateInfo == null) {
            try {
                exchangeRateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)oriCurId, (Long)targetCurId, (Long)exrateTableId, (Date)exrateDate);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
            if (exchangeRateInfo == null || exchangeRateInfo.getExchangeRate() == null) {
                return null;
            }
            this.exrateMap.put(exrateKey, exchangeRateInfo);
        }
        return exchangeRateInfo;
    }
}

