/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.AllotDetailHelper;
import kd.swc.hsas.business.cal.helper.HSASCalListHelper;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.common.enums.PayDetailAbandonReasonEnum;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class HSASCalListService {
    public final Log log = LogFactory.getLog(HSASCalListService.class);
    private static final String KEY_DELETE_STATUS = "99";

    public void doAudit(DynamicObject[] checkedDyObjs, Boolean taxCalEnableStatus) {
        for (DynamicObject dynamicObject : checkedDyObjs) {
            dynamicObject.set("calstatus", (Object)CalStateEnum.AUDIT.getCode());
            if (!taxCalEnableStatus.booleanValue()) continue;
            dynamicObject.set("taxstatus", (Object)TaxStateEnum.CONFIRM.getCode());
        }
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        calTableHelper.update(checkedDyObjs);
    }

    public void doUnAudit(DynamicObject[] checkedDyObjs, String[] allotCalPersonIds, Boolean taxCalEnableStatus) {
        HashSet<Long> needUpdateApproveEntId = new HashSet<Long>(16);
        ArrayList<Long> delPayDetailIdsList = new ArrayList<Long>(checkedDyObjs.length);
        ArrayList<Long> prepayPayDetailIdsList = new ArrayList<Long>(checkedDyObjs.length);
        ArrayList<Long> calPersonIds = new ArrayList<Long>(checkedDyObjs.length);
        for (DynamicObject dynamicObject : checkedDyObjs) {
            String calState = dynamicObject.getString("calstatus");
            String onHoldStatus = dynamicObject.getString("onholdstatus");
            String payState = dynamicObject.getString("paystatus");
            if (CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calState)) {
                needUpdateApproveEntId.add(dynamicObject.getLong("id"));
                dynamicObject.set("calstatus", (Object)CalStateEnum.ALL_CALED.getCode());
            }
            if (CalStateEnum.AUDIT.getCode().equals(calState) || String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(onHoldStatus) && CalStateEnum.APPROVALED.getCode().equals(calState)) {
                dynamicObject.set("calstatus", (Object)CalStateEnum.ALL_CALED.getCode());
            }
            if (String.valueOf(PayStateEnum.UNPAY.getCode()).equals(payState)) {
                calPersonIds.add(dynamicObject.getLong("id"));
                if (String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(onHoldStatus)) {
                    delPayDetailIdsList.add(dynamicObject.getLong("id"));
                } else {
                    prepayPayDetailIdsList.add(dynamicObject.getLong("id"));
                }
            }
            if (!taxCalEnableStatus.booleanValue()) continue;
            dynamicObject.set("calstatus", (Object)CalStateEnum.ALL_CALED.getCode());
            dynamicObject.set("taxstatus", (Object)TaxStateEnum.PULLED.getCode());
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        calPersonHelper.update(checkedDyObjs);
        this.abandonPayDetail(calPersonIds, delPayDetailIdsList, prepayPayDetailIdsList, calPersonHelper);
        if (!SWCArrayUtils.isEmpty((Object[])allotCalPersonIds)) {
            QFilter filter;
            SWCDataServiceHelper allotDetailHelper;
            int count;
            DynamicObject calPerson;
            long taskId;
            ArrayList<Long> allotCalPersonIdList = new ArrayList<Long>(allotCalPersonIds.length);
            for (String allotCalPersonId : allotCalPersonIds) {
                allotCalPersonIdList.add(Long.valueOf(allotCalPersonId));
            }
            List<Long> releaseObjIds = this.queryReleaseStatusByIds(allotCalPersonIdList);
            ArrayList<Long> notReleaseObjsIds = new ArrayList<Long>(allotCalPersonIds.length);
            for (String obj : allotCalPersonIds) {
                Long allotCalPersonId = Long.valueOf(obj);
                if (releaseObjIds.contains(allotCalPersonId)) continue;
                notReleaseObjsIds.add(allotCalPersonId);
            }
            QFilter calPersonIdFilter = new QFilter("caltableid", "in", notReleaseObjsIds);
            DeleteServiceHelper.delete((String)"pcs_allotdetail", (QFilter[])new QFilter[]{calPersonIdFilter});
            boolean enableCost = CostHelper.isEnableCost();
            if (enableCost && (taskId = (calPerson = checkedDyObjs[0]).getLong("caltask.id")) != 0L && (count = (allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail")).count(new QFilter[]{filter = new QFilter("caltask.id", "=", (Object)taskId)})) < 1) {
                SWCDataServiceHelper allotTaskHelper = new SWCDataServiceHelper("pcs_allottask");
                allotTaskHelper.deleteByFilter(new QFilter[]{filter});
            }
            if (!releaseObjIds.isEmpty()) {
                AllotDetailHelper allotDetailHelper2 = new AllotDetailHelper();
                allotDetailHelper2.updateOnHoldStatus(releaseObjIds);
            }
            this.updateCalAllotStatus(allotCalPersonIdList);
        }
        this.updateApproveBillEnt(needUpdateApproveEntId);
    }

    private void abandonPayDetail(List<Long> calPersonIds, List<Long> delPayDetailIdsList, List<Long> prepayPayDetailIdsList, SWCDataServiceHelper calPersonHelper) {
        DynamicObject[] caltableDelArr;
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", prepayPayDetailIdsList);
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
        filter.and(abandonedFilter);
        DynamicObject[] payDetailArray = payDetailHelper.query("calpersonid,bankofferstatus,agencypaystate,acctmodifybill,onholdstatus,abandonedstatus,modifytime,modifier,abandonedres,approvebill", new QFilter[]{filter});
        Map<Long, String> payDetailStatusMap = this.getPayDetailUnAuditStatusMap(payDetailArray);
        ArrayList<Long> payDetailIdNeedDelete = new ArrayList<Long>(10);
        this.setPayDetailAbandon(payDetailIdNeedDelete, payDetailStatusMap, payDetailArray);
        this.dealPayDetailUnAudit(payDetailIdNeedDelete, payDetailArray);
        if (!delPayDetailIdsList.isEmpty()) {
            HSASCalListHelper hsasCalListHelper = new HSASCalListHelper();
            hsasCalListHelper.updateOnHoldStatus(delPayDetailIdsList);
        }
        QFilter caltableFilter = new QFilter("id", "in", calPersonIds);
        for (DynamicObject dynamicObject : caltableDelArr = calPersonHelper.query("paystatus", new QFilter[]{caltableFilter})) {
            dynamicObject.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
        }
        calPersonHelper.update(caltableDelArr);
    }

    private Map<Long, String> getPayDetailUnAuditStatusMap(DynamicObject[] payDetailArray) {
        HashMap<Long, String> payDetailStatusMap = new HashMap<Long, String>(16);
        HashMap<Long, DynamicObject> approveBillDyMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject payDetail : payDetailArray) {
            approveBillDyMap.put(payDetail.getLong("calpersonid"), payDetail.getDynamicObject("approvebill"));
        }
        for (DynamicObject payDetail : payDetailArray) {
            Long approveBillId;
            if (BankOfferEnum.INVALIDED.getCode().equals(payDetail.getString("bankofferstatus"))) {
                this.setPayDetailUnAuditStatus(payDetailStatusMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.OFFER_END_UNAUDIT.getCode());
                continue;
            }
            if (payDetail.getLong("acctmodifybill.id") != 0L) {
                this.setPayDetailUnAuditStatus(payDetailStatusMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.ACCOUNT_MODIFY_UNAUDIT.getCode());
                continue;
            }
            DynamicObject approveBillDy = (DynamicObject)approveBillDyMap.get(payDetail.getLong("calpersonid"));
            if (approveBillDy != null && 0L != (approveBillId = Long.valueOf(approveBillDy.getLong("id")))) {
                Long approveBillTplId = approveBillDy.getLong("approvebilltpl.id");
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
                QFilter qfilter = new QFilter("id", "=", (Object)approveBillTplId);
                String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_approvebilltpl");
                DynamicObject approveBillTplDy = helper.queryOne(selectProperties, new QFilter[]{qfilter});
                Boolean isPayDetail = ApproveBillService.isPayDetail(approveBillTplDy);
                String billStatus = approveBillDy.getString("billstatus");
                this.log.info("billStatus = {}, isPayDetail = {}", (Object)billStatus, (Object)isPayDetail);
                if ("F".equals(billStatus) && isPayDetail.booleanValue()) {
                    this.setPayDetailUnAuditStatus(payDetailStatusMap, payDetail.getLong("calpersonid"), PayDetailAbandonReasonEnum.UNAUDIT.getCode());
                    continue;
                }
            }
            this.setPayDetailUnAuditStatus(payDetailStatusMap, payDetail.getLong("calpersonid"), KEY_DELETE_STATUS);
        }
        return payDetailStatusMap;
    }

    private void setPayDetailUnAuditStatus(Map<Long, String> payDetailStatusMap, Long calPersonId, String status) {
        String unAuditStatus = payDetailStatusMap.getOrDefault(calPersonId, KEY_DELETE_STATUS);
        payDetailStatusMap.put(calPersonId, unAuditStatus.compareTo(status) < 0 ? unAuditStatus : status);
    }

    private void setPayDetailAbandon(List<Long> payDetailIdNeedDelete, Map<Long, String> payDetailStatusMap, DynamicObject[] payDetailArray) {
        for (DynamicObject payDetail : payDetailArray) {
            String status = payDetailStatusMap.get(payDetail.getLong("calpersonid"));
            if (KEY_DELETE_STATUS.equals(status)) {
                payDetailIdNeedDelete.add(payDetail.getLong("id"));
                continue;
            }
            payDetail.set("abandonedstatus", (Object)Boolean.TRUE);
            payDetail.set("modifytime", (Object)new Date());
            payDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
            payDetail.set("abandonedres", (Object)PayDetailAbandonReasonEnum.getDesc((String)status));
        }
    }

    private void dealPayDetailUnAudit(List<Long> payDetailIdNeedDelete, DynamicObject[] payDetailArray) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        helper.save(payDetailArray);
        if (payDetailIdNeedDelete == null || payDetailIdNeedDelete.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", payDetailIdNeedDelete);
        filter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
        filter.and(abandonedFilter);
        filter.and(new QFilter("bankofferstatus", "=", (Object)BankOfferEnum.UNDEXPORT.getCode()));
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        filter.and(modifyBillFilter);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public void updateApproveBillEnt(Set<Long> updateEntIds) {
        if (updateEntIds.isEmpty()) {
            return;
        }
        StringBuilder stateSql = new StringBuilder("update t_hsas_approvebillent set fauditstatus = '1' where fcaltableid in (");
        Object[] entryIds = updateEntIds.toArray();
        for (int i = 0; i < entryIds.length; ++i) {
            stateSql.append('?');
            if (i + 1 >= entryIds.length) continue;
            stateSql.append(',');
        }
        stateSql.append(')');
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)stateSql.toString(), (Object[])entryIds);
    }

    private void updateCalAllotStatus(List<Long> allotElimiIds) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("id", "in", allotElimiIds);
        DynamicObject[] calPersonDelArr = calTableHelper.query("allotstatus", new QFilter[]{calPersonFilter});
        for (int i = 0; i < calPersonDelArr.length; ++i) {
            calPersonDelArr[i].set("allotstatus", (Object)"A");
        }
        calTableHelper.update(calPersonDelArr);
    }

    public DynamicObject[] queryCalTableForShowDetail(QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,salaryfile.employee.empnumber,caltask.number,paystatus,onholdstatus,belongperiod";
        return helper.query(selectProperties, filters);
    }

    public boolean deletePayDetail(List<Long> notReleasePkList, List<Long> releasePkList, Set<Long> bankOfferInvalidedIds, Set<Long> acctModifyCalTableIds) {
        if (null != acctModifyCalTableIds && !acctModifyCalTableIds.isEmpty()) {
            this.setPayDetailAbandonedByAcctModify(acctModifyCalTableIds);
        }
        if (null != bankOfferInvalidedIds && !bankOfferInvalidedIds.isEmpty()) {
            this.setPayDetailAbandoned(bankOfferInvalidedIds);
        }
        if (null != notReleasePkList && !notReleasePkList.isEmpty()) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            QFilter filter = new QFilter("calpersonid", "in", notReleasePkList);
            filter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
            QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
            abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
            filter.and(abandonedFilter);
            filter.and(new QFilter("bankofferstatus", "=", (Object)BankOfferEnum.UNDEXPORT.getCode()));
            QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
            filter.and(modifyBillFilter);
            helper.deleteByFilter(new QFilter[]{filter});
        }
        if (null != releasePkList && !releasePkList.isEmpty()) {
            HSASCalListHelper hsasCalListHelper = new HSASCalListHelper();
            hsasCalListHelper.updateOnHoldStatus(releasePkList);
        }
        return true;
    }

    public Set<Long> acctModifyIds(List<Long> list) {
        SWCDataServiceHelper calPayDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", list);
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
        filter.and(abandonedFilter);
        QFilter releaseFilter = new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()));
        filter.and(releaseFilter);
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "!=", (Object)0L);
        filter.and(modifyBillFilter);
        DynamicObject[] dynamicObjects = calPayDetailHelper.query("calpersonid", new QFilter[]{filter});
        HashSet<Long> calPersonIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long calPersonId = dynamicObject.getLong("calpersonid");
            calPersonIds.add(calPersonId);
        }
        return calPersonIds;
    }

    public Set<Long> bankOfferInvalidedIds(List<Long> list) {
        SWCDataServiceHelper calPayDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", list);
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
        filter.and(abandonedFilter);
        QFilter releaseFilter = new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()));
        filter.and(releaseFilter);
        filter.and(new QFilter("bankofferstatus", "!=", (Object)BankOfferEnum.UNDEXPORT.getCode()));
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        filter.and(modifyBillFilter);
        DynamicObject[] dynamicObjects = calPayDetailHelper.query("calpersonid,bankofferstatus", new QFilter[]{filter});
        HashSet<Long> calPersonIds = new HashSet<Long>(16);
        HashSet<Long> calPersonIdBankOfferExports = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long calPersonId = dynamicObject.getLong("calpersonid");
            String bankOfferStatus = dynamicObject.getString("bankofferstatus");
            if (BankOfferEnum.getBankOfferExportArray().contains(bankOfferStatus)) {
                calPersonIdBankOfferExports.add(calPersonId);
                continue;
            }
            calPersonIds.add(calPersonId);
        }
        calPersonIds.removeAll(calPersonIdBankOfferExports);
        return calPersonIds;
    }

    public Set<Long> getBankOfferExportedIds(List<Long> list) {
        QFilter unableFilter = new QFilter("calpersonid", "in", list);
        unableFilter.and(new QFilter("bankofferstatus", "in", (Object)BankOfferEnum.getBankOfferExportArray()));
        unableFilter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        SWCDataServiceHelper calPayDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        DynamicObject[] query = calPayDetailHelper.query("calpersonid", new QFilter[]{unableFilter});
        HashSet<Long> calPersonIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : query) {
            long calPersonId = dynamicObject.getLong("calpersonid");
            calPersonIds.add(calPersonId);
        }
        return calPersonIds;
    }

    private void setPayDetailAbandonedByAcctModify(Set<Long> ids) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper calPayDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", ids);
        for (DynamicObject dynamicObject : dynamicObjects = calPayDetailHelper.query("id,caltableid,abandonedstatus,abandonedres,modifytime,modifier", new QFilter[]{filter})) {
            dynamicObject.set("abandonedstatus", (Object)Boolean.TRUE);
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("abandonedres", (Object)PayDetailAbandonReasonEnum.ACCOUNT_MODIFY_UNAUDIT.getDesc());
        }
        calPayDetailHelper.update(dynamicObjects);
    }

    private void setPayDetailAbandoned(Set<Long> ids) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper calPayDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("caltableid", "in", ids);
        for (DynamicObject dynamicObject : dynamicObjects = calPayDetailHelper.query("id,caltableid,abandonedstatus,abandonedres,bankofferstatus,modifytime,modifier", new QFilter[]{filter})) {
            String bankOfferStatus = dynamicObject.getString("bankofferstatus");
            dynamicObject.set("abandonedstatus", (Object)Boolean.TRUE);
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            if (BankOfferEnum.INVALIDED.getCode().equals(bankOfferStatus)) {
                dynamicObject.set("abandonedres", (Object)PayDetailAbandonReasonEnum.OFFER_END_UNAUDIT.getDesc());
                continue;
            }
            dynamicObject.set("abandonedres", (Object)PayDetailAbandonReasonEnum.UNAUDIT.getDesc());
        }
        calPayDetailHelper.update(dynamicObjects);
    }

    public List<Long> queryReleaseStatusByIds(List<Long> idList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter idsFilter = new QFilter("id", "in", idList);
        DynamicObject[] dynamicObjects = calTableHelper.query("id,onholdstatus", new QFilter[]{idsFilter});
        ArrayList<Long> releaseList = new ArrayList<Long>(idList.size());
        String releaseStatus = OnHoldStatusEnum.STATUS_RELEASE.getCode() + "";
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = dynamicObject.getLong("id");
            String onHoldStatus = dynamicObject.getString("onholdstatus");
            if (!releaseStatus.equals(onHoldStatus)) continue;
            releaseList.add(id);
        }
        return releaseList;
    }
}

