/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.cal.thread.CalResultCoverDataSaveTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class ResultCoverService {
    private static final Log logger = LogFactory.getLog(ResultCoverService.class);
    public static final ExecutorService saveLogExecutorService = ThreadPools.newExecutorService((String)"resultCoverLogSave", (int)1);
    public static final ExecutorService saveImportDataExecutorService = ThreadPools.newExecutorService((String)"resultCoverImportDataSave", (int)1);
    public static final int PAGE_SIZE = 1000;
    public static final String systemType = "swc-hsas-business";
    public static final List<String> taxOnCalStatusList = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
    public static final List<String> taxOffCalStatusList = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());

    public abstract void doSaveAndReCal(String var1, boolean var2, Long var3, String var4, String var5);

    public abstract void doOnlySave(boolean var1, String var2, Long var3, String var4);

    public abstract void removeCacheDataByIdList(String var1, Long var2, String var3, List<String> var4);

    public abstract void addNewPersonData(List<Long> var1, Long var2, String var3);

    public abstract void saveOpLogData(List<String> var1, Long var2, String var3);

    public abstract void exportExcelTemplate(IFormView var1, Boolean var2);

    public abstract boolean checkExcelTemplate(List<Map<Integer, String>> var1, Long var2);

    public abstract void doSaveImportResultCoverData(String var1, int var2, List<Long> var3, int var4, Map<String, Map<String, String>> var5, Map<Integer, String> var6, List<Map<Integer, String>> var7, Long var8, List<DynamicObject> var9, List<Map<String, String>> var10, List<DynamicObject> var11, Map<Long, List<Long>> var12, Boolean var13);

    public abstract List<Long> getNeedRecalPersonIdList(Long var1, String var2);

    public int getTaskCurrencyPrecision(Long calTaskId) {
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "payrollgroupv.currency.amtprecision";
        DynamicObject taskInfo = calPayrollHelper.queryOne(fields, (Object)calTaskId);
        int precision = taskInfo.getInt("payrollgroupv.currency.amtprecision");
        return precision;
    }

    public void saveImportData(List<DynamicObject> validCoverDataList, String coverType) {
        logger.info("saveImportData_begin");
        CalResultCoverDataSaveTask task = new CalResultCoverDataSaveTask(validCoverDataList, coverType);
        try {
            saveImportDataExecutorService.submit(task);
        }
        catch (Exception exception) {
            logger.error("\u4fdd\u5b58\u5bfc\u5165\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u6570\u636e\u5f02\u5e38", (Throwable)exception);
        }
    }

    public void writeTaskInfoRow(boolean isErr, SXSSFSheet sheet, Map<String, String> exportDescInfo, boolean isTemplate, String coverType) {
        CellStyle taskDescColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        this.addRowInfo(isErr, 0, sheet, exportDescInfo.get("taskName"), ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u540d\u79f0", (String)"ResultCoverService_24", (String)systemType, (Object[])new Object[0]), taskDescColumnStyle);
        if (isTemplate) {
            SXSSFRow headRow = sheet.createRow(1);
            SXSSFCell descCell = headRow.createCell(isErr ? 1 : 0);
            String descMsg = SWCStringUtils.equals((String)"2", (String)coverType) ? ResManager.loadKDString((String)"\u9009\u4e2d\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\u201c\u5907\u6ce8\u201d\u5217\u540e\u4e3a\u85aa\u916c\u9879\u76ee\u5217\uff08\u586b\u5199\u85aa\u916c\u9879\u76ee\u540d\u79f0\uff09\uff0c\u53ef\u76f4\u63a5\u5728Excel\u4e2d\u589e\u52a0\u548c\u5220\u9664\u3002\u8986\u76d6\u540e\u5904\u7406\u8be6\u89c1\u201c\u53ef\u8986\u76d6\u85aa\u916c\u9879\u76ee\u5217\u8868\u53ca\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565\u201d\u9875\u7b7e\u3002", (String)"ResultCoverService_23", (String)systemType, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9009\u4e2d\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff0c\u5bf9\u4e8e\u65e0\u9700\u8986\u76d6\u7684\u6570\u636e\u884c\u8bf7\u52a1\u5fc5\u5220\u9664\u3002\u8986\u76d6\u540e\u5904\u7406\u8be6\u89c1\u201c\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565\u201d\u9875\u7b7e\u3002", (String)"ResultCoverService_28", (String)systemType, (Object[])new Object[0]);
            descCell.setCellValue(descMsg);
            Font font = sheet.getWorkbook().createFont();
            CellStyle descColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
            font.setColor((short)10);
            descColumnStyle.setFont(font);
            descCell.setCellStyle(descColumnStyle);
        }
    }

    public void writeExportHeadRow(SXSSFSheet sheet, String coverType) {
        SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        SXSSFRow headRow = sheet.createRow(2);
        CellStyle headColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        CellStyle redColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        SXSSFCell salaryFileNumberCell = headRow.createCell(0);
        SXSSFCell nameCell = headRow.createCell(1);
        SXSSFCell empNumberCell = headRow.createCell(2);
        String fileNumer = "*".concat(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"ResultCoverService_25", (String)systemType, (Object[])new Object[0]));
        salaryFileNumberCell.setCellValue(fileNumer);
        salaryFileNumberCell.setCellComment(this.getComment(drawingPatriarch, salaryFileNumberCell, "text"));
        nameCell.setCellValue(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ResultCoverService_26", (String)systemType, (Object[])new Object[0]));
        nameCell.setCellComment(this.getComment(drawingPatriarch, nameCell, "text"));
        empNumberCell.setCellValue(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ResultCoverService_27", (String)systemType, (Object[])new Object[0]));
        empNumberCell.setCellComment(this.getComment(drawingPatriarch, empNumberCell, "text"));
        nameCell.setCellStyle(headColumnStyle);
        empNumberCell.setCellStyle(headColumnStyle);
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        redColumnStyle.setFont(font);
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            SXSSFCell memoCell = headRow.createCell(3);
            memoCell.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ResultCoverService_34", (String)systemType, (Object[])new Object[0]));
            memoCell.setCellComment(this.getComment(drawingPatriarch, memoCell, "text"));
            memoCell.setCellStyle(headColumnStyle);
        } else {
            this.addProrationHeadCell(headRow, headColumnStyle, drawingPatriarch, redColumnStyle);
        }
        salaryFileNumberCell.setCellStyle(redColumnStyle);
    }

    public void flushAllAndDownload(SXSSFWorkbook wb, String fileName, IFormView view) {
        String url = SWCExportDataHelper.storeFile((Workbook)wb, fileName);
        if (SWCStringUtils.isNotEmpty((String)url)) {
            view.download(url);
        }
    }

    public abstract SXSSFSheet createCalResultCoverDescSheet(SXSSFWorkbook var1, Boolean var2, Long var3);

    public void mergeCell(SXSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(region);
    }

    public void setDescSheetColumnWidth(SXSSFSheet sheet) {
        for (int i = 0; i < 5; ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
    }

    public void writeDescSheet(SXSSFSheet sheet, Boolean taxCalEnable, int index) {
        CellStyle commonColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        CellStyle boldColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        CellStyle yellowColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.CENTER, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.LIGHT_ORANGE.getIndex(), true);
        commonColumnStyle.setWrapText(true);
        Font font = sheet.getWorkbook().createFont();
        font.setBold(true);
        boldColumnStyle.setFont(font);
        yellowColumnStyle.setFont(font);
        SXSSFRow row0 = sheet.createRow(0);
        row0.setHeight((short)400);
        this.addRowCellInfo(row0, index, commonColumnStyle, ResManager.loadKDString((String)"\u5141\u8bb8\u8fdb\u884c\u7ed3\u679c\u8986\u76d6\u7684\u6838\u7b97\u72b6\u6001\uff0c\u4ee5\u53ca\u5bfc\u5165\u540e\u7cfb\u7edf\u7684\u81ea\u52a8\u5904\u7406\u5982\u4e0b\uff1a", (String)"ResultCoverService_9", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row0, index + 1, commonColumnStyle, "");
        this.addRowCellInfo(row0, index + 2, commonColumnStyle, "");
        SXSSFRow row1 = sheet.createRow(1);
        row1.setHeight((short)400);
        this.addRowCellInfo(row1, index, yellowColumnStyle, ResManager.loadKDString((String)"\u8986\u76d6\u65f6\u6570\u636e\u7684\u6838\u7b97\u72b6\u6001", (String)"ResultCoverService_10", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row1, index + 1, yellowColumnStyle, ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u8986\u76d6", (String)"ResultCoverService_11", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row1, index + 2, yellowColumnStyle, ResManager.loadKDString((String)"\u5bfc\u5165\u540e\u7cfb\u7edf\u81ea\u52a8\u5904\u7406", (String)"ResultCoverService_12", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row3 = sheet.createRow(2);
        row3.setHeight((short)400);
        this.addRowCellInfo(row3, index, commonColumnStyle, ResManager.loadKDString((String)"\u672a\u8ba1\u7b97", (String)"ResultCoverService_13", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row3, index + 1, commonColumnStyle, ResManager.loadKDString((String)"\u221a", (String)"ResultCoverService_14", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row3, index + 2, commonColumnStyle, ResManager.loadKDString((String)"\u65e0", (String)"ResultCoverService_15", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row4 = sheet.createRow(3);
        row4.setHeight((short)400);
        this.addRowCellInfo(row4, index, commonColumnStyle, ResManager.loadKDString((String)"\u7a0e\u524d\u8ba1\u7b97\u5b8c\u6210", (String)"ResultCoverService_16", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row4, index + 1, commonColumnStyle, ResManager.loadKDString((String)"\u221a", (String)"ResultCoverService_14", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row4, index + 2, commonColumnStyle, ResManager.loadKDString((String)"\u5bfc\u5165\u540e\u7cfb\u7edf\u81ea\u52a8\u8fdb\u884c\u8ba1\u7b97\u56de\u6eda", (String)"ResultCoverService_17", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row5 = sheet.createRow(4);
        row5.setHeight((short)400);
        if (taxCalEnable.booleanValue()) {
            this.addRowCellInfo(row5, index, commonColumnStyle, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\uff08\u672a\u9501\u5b9a\uff09", (String)"ResultCoverService_18", (String)systemType, (Object[])new Object[0]));
        } else {
            this.addRowCellInfo(row5, index, commonColumnStyle, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210", (String)"ResultCoverService_21", (String)systemType, (Object[])new Object[0]));
        }
        this.addRowCellInfo(row5, index + 1, commonColumnStyle, ResManager.loadKDString((String)"\u221a", (String)"ResultCoverService_14", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row5, index + 2, commonColumnStyle, ResManager.loadKDString((String)"\u5bfc\u5165\u540e\u7cfb\u7edf\u81ea\u52a8\u8fdb\u884c\u8ba1\u7b97\u56de\u6eda", (String)"ResultCoverService_17", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row6 = sheet.createRow(5);
        row6.setHeight((short)2200);
        if (taxCalEnable.booleanValue()) {
            this.addRowCellInfo(row6, index, commonColumnStyle, ResManager.loadKDString((String)"\u7a0e\u524d\u8ba1\u7b97\u5931\u8d25\r\n\u63a8\u9001\u4e2a\u7a0e\u5931\u8d25\r\n\u4e2a\u7a0e\u8ba1\u7b97\u5931\u8d25\r\n\u83b7\u53d6\u4e2a\u7a0e\u5931\u8d25\r\n\u7a0e\u540e\u8ba1\u7b97\u5931\u8d25\uff08\u672a\u9501\u5b9a\uff09\r\n\u8ba1\u7b97\u56de\u6eda\u5931\u8d25", (String)"ResultCoverService_19", (String)systemType, (Object[])new Object[0]));
        } else {
            this.addRowCellInfo(row6, index, commonColumnStyle, ResManager.loadKDString((String)"\u7a0e\u524d\u8ba1\u7b97\u5931\u8d25\r\n\u7a0e\u540e\u8ba1\u7b97\u5931\u8d25\r\n\u8ba1\u7b97\u56de\u6eda\u5931\u8d25", (String)"ResultCoverService_22", (String)systemType, (Object[])new Object[0]));
        }
        this.addRowCellInfo(row6, index + 1, commonColumnStyle, ResManager.loadKDString((String)"\u221a", (String)"ResultCoverService_14", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row6, index + 2, commonColumnStyle, ResManager.loadKDString((String)"\u65e0", (String)"ResultCoverService_15", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row7 = sheet.createRow(6);
        row7.setHeight((short)400);
        this.addRowCellInfo(row7, index, boldColumnStyle, ResManager.loadKDString((String)"\u5176\u4f59\u6838\u7b97\u72b6\u6001\u5747\u4e0d\u5141\u8bb8\u8fdb\u884c\u7ed3\u679c\u8986\u76d6", (String)"ResultCoverService_20", (String)systemType, (Object[])new Object[0]));
        this.addRowCellInfo(row7, index + 1, boldColumnStyle, "");
        this.addRowCellInfo(row7, index + 2, boldColumnStyle, "");
    }

    public void addRowCellInfo(SXSSFRow taskNameRow, int cellIndex, CellStyle taskDescColumnStyle, String value) {
        SXSSFCell cell = taskNameRow.createCell(cellIndex);
        cell.setCellValue(value);
        cell.setCellStyle(taskDescColumnStyle);
    }

    private void addProrationHeadCell(SXSSFRow headRow, CellStyle headColumnStyle, SXSSFDrawing drawingPatriarch, CellStyle redColumnStyle) {
        int index = 3;
        SXSSFCell salaryItemCell = headRow.createCell(index++);
        salaryItemCell.setCellValue("*".concat(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ResultCoverService_4", (String)systemType, (Object[])new Object[0])));
        salaryItemCell.setCellStyle(redColumnStyle);
        salaryItemCell.setCellComment(this.getComment(drawingPatriarch, salaryItemCell, SWCShowType.TEXT.getCode()));
        SXSSFCell startDateCell = headRow.createCell(index++);
        startDateCell.setCellValue("*".concat(ResManager.loadKDString((String)"\u5206\u6bb5\u5f00\u59cb\u65e5\u671f", (String)"ResultCoverService_5", (String)systemType, (Object[])new Object[0])));
        startDateCell.setCellStyle(redColumnStyle);
        startDateCell.setCellComment(this.getComment(drawingPatriarch, startDateCell, SWCShowType.DATE.getCode()));
        SXSSFCell endDateCell = headRow.createCell(index++);
        endDateCell.setCellValue("*".concat(ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u675f\u65e5\u671f", (String)"ResultCoverService_6", (String)systemType, (Object[])new Object[0])));
        endDateCell.setCellStyle(redColumnStyle);
        endDateCell.setCellComment(this.getComment(drawingPatriarch, endDateCell, SWCShowType.DATE.getCode()));
        SXSSFCell coverValueCell = headRow.createCell(index++);
        coverValueCell.setCellValue("*".concat(ResManager.loadKDString((String)"\u8986\u76d6\u503c", (String)"ResultCoverService_7", (String)systemType, (Object[])new Object[0])));
        coverValueCell.setCellStyle(redColumnStyle);
        coverValueCell.setCellComment(this.getComment(drawingPatriarch, coverValueCell, SWCShowType.AMOUNT.getCode()));
        SXSSFCell memoCell = headRow.createCell(index++);
        memoCell.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ResultCoverService_34", (String)systemType, (Object[])new Object[0]));
        memoCell.setCellStyle(headColumnStyle);
        memoCell.setCellComment(this.getComment(drawingPatriarch, memoCell, SWCShowType.TEXT.getCode()));
    }

    private Comment getComment(SXSSFDrawing drawingPatriarch, SXSSFCell cell, String datatype) {
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
        String text = this.assembleCommentText(datatype);
        comment.setString((RichTextString)new XSSFRichTextString(text));
        return comment;
    }

    private String assembleCommentText(String dataType) {
        String text = SWCShowType.AMOUNT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u5b57\u683c\u5f0f\u3002", (String)"ResultCoverService_1", (String)systemType, (Object[])new Object[0]) : (SWCShowType.DATE.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\uff0c\u683c\u5f0f\u4e3aYYYY-MM-DD\u3002", (String)"ResultCoverService_2", (String)systemType, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6587\u672c\u683c\u5f0f\u3002", (String)"ResultCoverService_3", (String)systemType, (Object[])new Object[0]));
        return text;
    }

    public void setSheetColumnWidth(SXSSFSheet sheet, int columnSize) {
        int columnWidth;
        int i;
        for (i = 0; i < 3; ++i) {
            columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
        for (i = 3; i < columnSize; ++i) {
            columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
    }

    private void addRowInfo(boolean isErr, int index, SXSSFSheet sheet, String value, String name, CellStyle taskDescColumnStyle) {
        SXSSFRow taskNameRow = sheet.createRow(index);
        SXSSFCell nameCell = taskNameRow.createCell(isErr ? 1 : 0);
        SXSSFCell valueCell = taskNameRow.createCell(isErr ? 2 : 1);
        nameCell.setCellValue(name);
        valueCell.setCellValue(value);
        nameCell.setCellStyle(taskDescColumnStyle);
        valueCell.setCellStyle(taskDescColumnStyle);
    }

    public CellStyle getColumnStyle(boolean isTmpl, int precision, int scale, String columnType, HorizontalAlignment alignment, SXSSFWorkbook wb, short colorIndex, boolean needBoard) {
        short format;
        CellStyle headColumnStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        if (!isTmpl) {
            if (SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)columnType)) {
                format = dataFormat.getFormat("yyyy-MM-dd");
            } else if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)columnType)) {
                String amountFormat = this.getAmountFormat(precision);
                format = dataFormat.getFormat(amountFormat);
            } else if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)columnType)) {
                String amountFormat = this.getAmountFormat(scale);
                format = dataFormat.getFormat(amountFormat);
            } else {
                format = dataFormat.getFormat("text");
            }
        } else {
            format = SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)columnType) ? dataFormat.getFormat("yyyy-MM-dd") : dataFormat.getFormat("text");
        }
        headColumnStyle.setDataFormat(format);
        if (needBoard) {
            headColumnStyle.setBorderBottom(BorderStyle.THIN);
            headColumnStyle.setBorderTop(BorderStyle.THIN);
            headColumnStyle.setBorderLeft(BorderStyle.THIN);
            headColumnStyle.setBorderRight(BorderStyle.THIN);
        } else {
            headColumnStyle.setBorderBottom(BorderStyle.HAIR);
            headColumnStyle.setBorderTop(BorderStyle.HAIR);
            headColumnStyle.setBorderLeft(BorderStyle.HAIR);
            headColumnStyle.setBorderRight(BorderStyle.HAIR);
        }
        headColumnStyle.setFillForegroundColor(colorIndex);
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(alignment);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    private String getAmountFormat(int precision) {
        StringBuilder format = new StringBuilder("0");
        if (precision > 0) {
            format.append('.');
            for (int i = 0; i < precision; ++i) {
                format.append('0');
            }
        }
        return format.toString();
    }

    public void doReCal(String versionNo, Map<String, List<Long>> personIdListCalblockMap, Long taskId) {
        CalTableCalService calService = new CalTableCalService();
        CalResultCoverService coverService = new CalResultCoverService();
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        personIdListCalblockMap.values().stream().forEach(personIdList::addAll);
        if (SWCListUtils.isEmpty(personIdList)) {
            return;
        }
        Map<String, Object> calParamMap = coverService.assembleCalParamMap(personIdList, taskId);
        try {
            String taxItemSchemeVid = (String)calParamMap.get("taxitemschemev");
            Long taxItemSchId = taxItemSchemeVid == null ? null : Long.valueOf(taxItemSchemeVid);
            HashMap<String, String> calModeMap = new HashMap<String, String>(4);
            calModeMap.put("uncalstate", "3");
            calModeMap.put("partialcaledstate", "3");
            calModeMap.put("errorstate", "3");
            calModeMap.put("caledstate", "3");
            Integer salaryItemCount = Integer.valueOf(calParamMap.get("salaryItemCount").toString());
            String calType = calParamMap.get("calType").toString();
            Map<String, List<Long>> personSplitCalMap = this.assemblePersonSplitCalMap(personIdListCalblockMap);
            calService.cal(personIdList, taskId, calType, salaryItemCount, versionNo, calModeMap, taxItemSchId, true, (calPersonArray, calModeMap1, calDetailList, openTaxCal, calTaskId, calRecordId) -> {
                for (DynamicObject person : calPersonArray) {
                    person.set("calstatus", (Object)CalStateEnum.CALING.getCode());
                }
                return personSplitCalMap;
            }, null, null, false);
        }
        catch (Exception ex) {
            logger.error("CalResultCoverListPlugin doReCal error", (Throwable)ex);
        }
    }

    private Map<String, List<Long>> assemblePersonSplitCalMap(Map<String, List<Long>> personIdListCalblockMap) {
        HashMap<String, List<Long>> calModeGroupIdListMap = new HashMap<String, List<Long>>(3);
        ArrayList<Long> uncalPersonList = new ArrayList<Long>(10);
        personIdListCalblockMap.values().forEach(uncalPersonList::addAll);
        ArrayList<Long> calOrReCalIdList = new ArrayList<Long>(10);
        ArrayList<Long> onlyPreCalIdList = new ArrayList<Long>(10);
        DynamicObjectCollection calPersonData = CalResultCoverHelper.getCalPersonData(uncalPersonList, "2DXPSF5JTISP");
        for (DynamicObject obj : calPersonData) {
            String calStatus = obj.getString("calstatus");
            long personId = obj.getLong("id");
            if (SWCStringUtils.equals((String)CalStateEnum.PARTIAL_CALED.getCode(), (String)calStatus)) {
                onlyPreCalIdList.add(personId);
                continue;
            }
            if (!SWCStringUtils.equals((String)CalStateEnum.ALL_CALED.getCode(), (String)calStatus)) continue;
            calOrReCalIdList.add(personId);
        }
        calModeGroupIdListMap.put("calOrReCalIdList", calOrReCalIdList);
        calModeGroupIdListMap.put("onlyPreCalIdList", onlyPreCalIdList);
        logger.info("calModeGroupIdListMap", (Object)((Object)calModeGroupIdListMap).toString());
        return calModeGroupIdListMap;
    }

    public void saveResultCoverOpLogData(List<DynamicObject> coverLogDataList) {
        long start = System.currentTimeMillis();
        SWCDataServiceHelper logServiceHelper = new SWCDataServiceHelper("hsas_resultcoveroplog");
        Object[] saveResult = logServiceHelper.save(coverLogDataList.toArray(new DynamicObject[coverLogDataList.size()]));
        logger.info("saveImportLogData_finish,count:{},cost:{} ms", (Object)saveResult.length, (Object)(System.currentTimeMillis() - start));
    }

    public boolean checkPerson(Map<Long, String> declareStatusMap, List<Long> needReCalList, int dataIndex, String fileNumber, String name, String empNumber, Map<String, Map<String, String>> taskPersonMap, List<Map<String, String>> errDataList, Boolean taxEnable) {
        if (SWCStringUtils.isEmpty((String)fileNumber)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_29", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        if (!taskPersonMap.containsKey(fileNumber)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\u6b64\u85aa\u8d44\u6863\u6848\u6216\u65e0\u8be5\u6863\u6848\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_30", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        String personName = taskPersonMap.get(fileNumber).get("name");
        String personEmpNumber = taskPersonMap.get(fileNumber).get("empnumber");
        if (SWCStringUtils.isNotEmpty((String)name) && !SWCStringUtils.equals((String)personName, (String)name)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u548c\u59d3\u540d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_31", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        if (SWCStringUtils.isNotEmpty((String)empNumber) && !SWCStringUtils.equals((String)personEmpNumber, (String)empNumber)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u5de5\u53f7\u4e0e\u6863\u6848\u7f16\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_32", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        String calStatus = taskPersonMap.get(fileNumber).get("calstatus");
        long personId = Long.parseLong(taskPersonMap.get(fileNumber).get("id"));
        String taxLockedState = declareStatusMap.get(personId);
        HashSet<String> tasOnCalStatusSet = new HashSet<String>(taxOnCalStatusList);
        HashSet<String> tasOffCalStatusSet = new HashSet<String>(taxOffCalStatusList);
        if (taxEnable.booleanValue() && !tasOnCalStatusSet.contains(calStatus)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u8bb0\u5f55\u7684\u6838\u7b97\u72b6\u6001\u4e0d\u5141\u8bb8\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_33", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        if (!taxEnable.booleanValue() && !tasOffCalStatusSet.contains(calStatus)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u8bb0\u5f55\u7684\u6838\u7b97\u72b6\u6001\u4e0d\u5141\u8bb8\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_33", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        if (SWCStringUtils.equals((String)"1", (String)taxLockedState)) {
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u8bb0\u5f55\u7684\u6838\u7b97\u72b6\u6001\u4e0d\u5141\u8bb8\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverService_33", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        needReCalList.add(personId);
        return true;
    }

    public Map<String, String> assembleErrMap(int dataIndex, boolean isAll, String fileNumber, String msg) {
        HashMap<String, String> errMap = new HashMap<String, String>(16);
        errMap.put("fileNumber", fileNumber);
        errMap.put("errMsg", msg);
        errMap.put("isAll", isAll ? "1" : "0");
        errMap.put("dataIndex", String.valueOf(dataIndex));
        return errMap;
    }

    public void removeErrorPerson(Map<String, String> personMap, List<Long> needReCalList) {
        if (personMap != null && personMap.size() > 0) {
            needReCalList.remove(Long.valueOf(personMap.get("id")));
        }
    }

    public abstract boolean checkItemDuplicate(Map<Integer, String> var1);
}

