/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.check.SalaryCalCheckService;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.impl.DefaultCalPersonSplit;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class SalaryCalService {
    private static final Log LOGGER = LogFactory.getLog(SalaryCalService.class);

    public Map<String, Object> salaryCal(Long calTaskId, List<Long> calPersonIdList, boolean isSyncCal) {
        Map formulaAndGradeMap;
        LOGGER.info("salaryCal-start,calTaskId = {}", (Object)calTaskId);
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        DynamicObject calTaskData = CalPayrollTaskHelper.queryTaskInfoById(calTaskId);
        if (calTaskData == null) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"SalaryCalService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            response.put("success", false);
            response.put("message", msg);
            response.put("calTaskId", calTaskId);
            response.put("calRecordId", null);
            response.put("data", null);
            return response;
        }
        CalPayRollTask calPayRollTask = this.buildCalPayRollTaskObj(calTaskData);
        if (!this.beforeCalCheck(calPayRollTask, response, calPersonIdList, calTaskData)) {
            return response;
        }
        this.addCertCheckErrorData(calTaskId, response);
        CalTableCalService calService = new CalTableCalService();
        HashMap<String, Object> versionDataMap = new HashMap<String, Object>(16);
        String confirmMessage = CalHelper.initCalFormulaGradeInfo(calPayRollTask, versionDataMap);
        if (SWCStringUtils.isNotEmpty((String)confirmMessage) && (formulaAndGradeMap = (Map)versionDataMap.get("formula_grade_cachekey")) != null) {
            String calVersionNo = CalTableCalHelper.createCalVersion(formulaAndGradeMap);
            formulaAndGradeMap.put("calVersionNo", calVersionNo);
            calService.cacheVersionData(versionDataMap, formulaAndGradeMap, false);
        }
        String calType = "cal";
        if (SWCStringUtils.equals((String)"1", (String)calPayRollTask.getOpenTaxCal())) {
            calType = "preTaxCal";
        }
        Map dataMap = (Map)versionDataMap.get("formula_grade_verion");
        String calVersionNo = (String)dataMap.get("calVersionNo");
        String batchNum = CalRequestHelper.getBatchNum();
        ISWCAppCache calRequestCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_request_param_%s", batchNum));
        String cacheUUID = UUID.randomUUID().toString();
        HashMap<String, String> calRequestParams = new HashMap<String, String>(16);
        calRequestParams.put("cacheUUID", cacheUUID);
        calRequestParams.put("traceId", RequestContext.get().getTraceId());
        calRequestCache.put("cal_param", calRequestParams);
        Map<String, String> calModeMap = this.getCalModeMap();
        Map<String, String> operationParam = calPayRollTask.getOperationParam();
        Long taxItemSchemeVid = operationParam.get("TAXITEMSCHEMEVID") == null ? null : Long.valueOf(operationParam.get("TAXITEMSCHEMEVID"));
        Map<String, Object> resultMap = null;
        try {
            resultMap = calService.cal(calPayRollTask.getCalPersons(), calTaskId, calType, Integer.valueOf(operationParam.get("salaryItemCount")), calVersionNo, calModeMap, taxItemSchemeVid, false, DefaultCalPersonSplit.getInstance(), batchNum, cacheUUID, isSyncCal);
            Long calRecordId = (Long)resultMap.get("calRecordId");
            Boolean isFinish = (Boolean)resultMap.get("isFinish");
            ArrayList dataList = (ArrayList)response.get("data");
            if (dataList == null) {
                dataList = new ArrayList(10);
            }
            if (isSyncCal && !isFinish.booleanValue()) {
                List calDataList = (List)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSService", (String)"syncSalaryCal", (Object[])new Object[]{calTaskId, calRecordId, calType});
                dataList.addAll(calDataList);
                response.put("data", dataList);
            }
            List successList = dataList.stream().filter(obj -> (Boolean)obj.get("success")).collect(Collectors.toList());
            int failCount = calPersonIdList.size() - successList.size();
            String message = ResManager.loadKDString((String)"\u85aa\u8d44\u8ba1\u7b97\u5b8c\u6210\uff0c\u5171{0}\u4eba\uff0c\u8ba1\u7b97\u6210\u529f{1}\u4eba\uff0c\u8ba1\u7b97\u5931\u8d25{2}\u4eba\u3002", (String)"SalaryCalService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            response.put("success", true);
            response.put("message", MessageFormat.format(message, calPersonIdList.size(), successList.size(), failCount));
            response.put("calTaskId", calTaskId);
            response.put("calRecordId", calRecordId);
        }
        catch (Exception ex) {
            LOGGER.error("SalaryCalService.salaryCal error.", (Throwable)ex);
            response.put("success", false);
            response.put("message", ex.getMessage());
            response.put("calTaskId", calTaskId);
            response.put("calRecordId", null);
            response.put("data", null);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)calPayRollTask.getCalPayRollTaskId().toString(), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            return response;
        }
        LOGGER.info("salaryCal-end,calTaskId = {}", (Object)calTaskId);
        return response;
    }

    private void addCertCheckErrorData(Long calTaskId, Map<String, Object> response) {
        ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "caltask_notaxfile_%s", calTaskId));
        List noTaxFileIdList = (List)cache.get("noTaxFileList", List.class);
        List noAuditTaxFileIdList = (List)cache.get("noAuditTaxFileList", List.class);
        ArrayList<Map<String, Object>> tempDataList = new ArrayList<Map<String, Object>>(10);
        String noTaxFileMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u672a\u5173\u8054\u4e2a\u7a0e\u6863\u6848\u3002", (String)"PreCalCheckService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noAuditTaxFileMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"PreCalCheckService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        this.buildErrorData(noTaxFileIdList, noTaxFileMsg, tempDataList);
        this.buildErrorData(noAuditTaxFileIdList, noAuditTaxFileMsg, tempDataList);
        ArrayList<Map<String, Object>> dataList = (ArrayList<Map<String, Object>>)response.get("data");
        if (dataList == null) {
            dataList = new ArrayList<Map<String, Object>>(10);
        }
        dataList.addAll(tempDataList);
        response.put("data", dataList);
    }

    private void buildErrorData(List<Long> calPersonIdList, String msg, List<Map<String, Object>> dataList) {
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        HashMap<String, Object> tempMap = null;
        for (Long id : calPersonIdList) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("success", false);
            tempMap.put("status", 400);
            tempMap.put("message", msg);
            tempMap.put("calPersonId", id);
            tempMap.put("itemList", null);
            dataList.add(tempMap);
        }
    }

    @NotNull
    private Map<String, String> getCalModeMap() {
        HashMap<String, String> calModeMap = new HashMap<String, String>(4);
        calModeMap.put("uncalstate", "4");
        calModeMap.put("partialcaledstate", "3");
        calModeMap.put("errorstate", "3");
        calModeMap.put("caledstate", "3");
        return calModeMap;
    }

    private boolean beforeCalCheck(CalPayRollTask calPayRollTask, Map<String, Object> response, List<Long> calPersonIdList, DynamicObject calTaskData) {
        String msg = CalPayrollTaskHelper.checkCalPayRollTaskIsMutex(calPayRollTask, CalPersonOperationEnum.OP_CAL);
        if (SWCStringUtils.isNotEmpty((String)msg)) {
            response.put("success", false);
            response.put("message", msg);
            response.put("calTaskId", calPayRollTask.getCalPayRollTaskId());
            response.put("calRecordId", null);
            response.put("data", null);
            return false;
        }
        SalaryCalCheckService salaryCalCheckService = new SalaryCalCheckService();
        String errorMsg = salaryCalCheckService.beforeCalCheck(calPayRollTask, calTaskData, new HashMap<String, Object>(16));
        if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
            response.put("success", false);
            response.put("message", errorMsg);
            response.put("calTaskId", calPayRollTask.getCalPayRollTaskId());
            response.put("calRecordId", null);
            response.put("data", null);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)calPayRollTask.getCalPayRollTaskId().toString(), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            return false;
        }
        DynamicObjectCollection calPersonDataList = CalHelper.getCalPersonData(calPersonIdList, calPayRollTask.getCalPayRollTaskId(), null);
        String errMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6838\u7b97\u72b6\u6001\u4e3a\u672a\u8ba1\u7b97\u3001\u7a0e\u524d\u8ba1\u7b97\u5b8c\u6210\u3001\u8ba1\u7b97\u5b8c\u6210\u3001\u8ba1\u7b97\u5931\u8d25\uff0c\u4e14\u505c\u7f13\u53d1\u72b6\u6001\u4e0d\u4e3a\u7ec8\u6b62\u53d1\u653e\u7684\u6570\u636e\uff0c\u624d\u80fd\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"SalaryCalService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (calPersonDataList == null || calPersonDataList.isEmpty()) {
            response.put("success", false);
            response.put("message", errMsg);
            response.put("calTaskId", calPayRollTask.getCalPayRollTaskId());
            response.put("calRecordId", null);
            response.put("data", null);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)calPayRollTask.getCalPayRollTaskId().toString(), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            return false;
        }
        List<Long> canCalPersonIdList = calPersonDataList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        calPayRollTask.setCalPersons(canCalPersonIdList);
        ArrayList dataList = new ArrayList(10);
        HashMap<String, Object> tempMap = null;
        for (Long id : calPersonIdList) {
            if (canCalPersonIdList.contains(id)) continue;
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("calPersonId", id);
            tempMap.put("itemList", null);
            tempMap.put("status", 400);
            tempMap.put("success", false);
            tempMap.put("message", errMsg);
            dataList.add(tempMap);
        }
        ArrayList<CalPayRollTask> validDataList = new ArrayList<CalPayRollTask>(1);
        validDataList.add(calPayRollTask);
        Map<String, Object> result = CalHelper.checkCert(canCalPersonIdList, validDataList);
        Boolean isSuccess = (Boolean)result.get("success");
        if (isSuccess == null || !isSuccess.booleanValue()) {
            response.put("success", false);
            response.put("message", result.get("msg"));
            response.put("calTaskId", calPayRollTask.getCalPayRollTaskId());
            response.put("calRecordId", null);
            response.put("data", null);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)calPayRollTask.getCalPayRollTaskId().toString(), (String)CalPersonOperationEnum.OP_CAL.getOperationKey());
            return false;
        }
        response.put("data", dataList);
        return true;
    }

    private CalPayRollTask buildCalPayRollTaskObj(DynamicObject calTaskData) {
        CalPayRollTask calPayRollTask = new CalPayRollTask();
        calPayRollTask.setCalPayRollTaskId(calTaskData.getLong("id"));
        calPayRollTask.setNumber(calTaskData.getString("number"));
        calPayRollTask.setName(calTaskData.getString("name"));
        calPayRollTask.setCountryId(calTaskData.getLong("country.id"));
        calPayRollTask.setOpenTaxCal(calTaskData.getString("calrulev.opentaxcal"));
        String calType = "cal";
        if (SWCStringUtils.equals((String)"1", (String)calPayRollTask.getOpenTaxCal())) {
            calType = "preTaxCal";
        }
        HashMap<String, String> operationParam = new HashMap<String, String>(16);
        operationParam.put("enddate", SWCDateTimeUtils.format((Date)calTaskData.getDate("enddate"), (String)"yyyy-MM-dd"));
        operationParam.put("startdate", SWCDateTimeUtils.format((Date)calTaskData.getDate("startdate"), (String)"yyyy-MM-dd"));
        operationParam.put("calType", calType);
        calPayRollTask.setOperationParam(operationParam);
        return calPayRollTask;
    }
}

