/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.thread;

import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultCoverDataSaveTask
implements Callable<String> {
    private static final Log log = LogFactory.getLog(CalResultCoverDataSaveTask.class);
    List<DynamicObject> saveDataList;
    String coverType;

    public CalResultCoverDataSaveTask(List<DynamicObject> saveDataList, String coverType) {
        this.saveDataList = saveDataList;
        this.coverType = coverType;
    }

    @Override
    public String call() {
        log.info("CalResultCoverDataSaveTask start, saveDataList.size={}", (Object)this.saveDataList.size());
        long st = System.currentTimeMillis();
        Integer result = 0;
        try {
            SWCDataServiceHelper helper = SWCStringUtils.equals((String)"2", (String)this.coverType) ? new SWCDataServiceHelper("hsas_calresultcoverdata") : new SWCDataServiceHelper("hsas_proratecoverdata");
            Object[] saveResult = helper.save(this.saveDataList.toArray(new DynamicObject[this.saveDataList.size()]));
            result = saveResult.length;
        }
        catch (Exception exception) {
            log.error("CalResultCoverDataSaveTask error=", (Throwable)exception);
        }
        log.info("CalResultCoverDataSaveTask end, save.size={},cost:{} ms", (Object)result, (Object)(System.currentTimeMillis() - st));
        return null;
    }
}

