/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.calitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalItemGroupHelper {
    public static final String EMPTY_LINE = " ";
    public static final String COMMA = ",";

    public static void openFormulahisPage(IFormView formView, Long pkId, String name) {
        boolean hasPageermission = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hsas_formula");
        if (!hasPageermission) {
            formView.showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u7b97\u516c\u5f0f\u7248\u672c\u201d\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalItemGroupHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        CalItemGroupHelper.opeanFormulaHisPage(pkId, name, formView);
    }

    public static void openDataGradeHisPage(IFormView formView, Long pkId, String name) {
        boolean hasPageermission = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hsas_datagrade");
        if (!hasPageermission) {
            formView.showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u6570\u636e\u5206\u7ea7\u7248\u672c\u201d\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalItemGroupHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        CalItemGroupHelper.opeanDataGradeHisPage(pkId, name, formView);
    }

    private static void opeanFormulaHisPage(Long pkId, String name, IFormView formView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_formula");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId((Object)pkId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7248\u672c - {0}", (String)"CalItemGroupHelper_5", (String)"swc-hsas-business", (Object[])new Object[]{name}));
        formView.showForm((FormShowParameter)showParameter);
    }

    private static void opeanDataGradeHisPage(Long pkId, String name, IFormView formView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_datagrade");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("formulabaseId", (Object)String.valueOf(pkId));
        showParameter.setCustomParam("comefromcalruleorgroup", (Object)Boolean.TRUE);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId((Object)pkId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u7248\u672c - {0}", (String)"CalItemGroupHelper_6", (String)"swc-hsas-business", (Object[])new Object[]{name}));
        formView.showForm((FormShowParameter)showParameter);
    }

    public static ListShowParameter openF7(String billFormId, String f7FormId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(f7FormId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        return showParameter;
    }

    public static void opeanSalaryItemPage(IFormView formView, DynamicObject formulaObj) {
        QFilter qFilter;
        ListShowParameter showParameter = CalItemGroupHelper.openF7("hsbs_salaryitem", "bos_listf7");
        showParameter.setMultiSelect(false);
        String title = ResManager.loadKDString((String)"\u4f9d\u8d56\u9879\u76ee", (String)"CalItemGroupHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        showParameter.setCaption(formulaObj.getString("salaryitem.name") + title);
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        String fields = "id,dependonsitem";
        DynamicObject formula = formulaHelper.queryOriginalOne(fields, (Object)formulaObj.getLong("id"));
        String salaryItems = formula.getString("dependonsitem");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        if (SWCStringUtils.isEmpty((String)salaryItems)) {
            qFilter = new QFilter("uniquecode", "=", (Object)"0");
            qFilters.add(qFilter);
        } else {
            qFilter = new QFilter("uniquecode", "in", Arrays.asList(salaryItems.split(COMMA)));
            qFilters.add(qFilter);
        }
        String orderBy = "number desc";
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, orderBy));
        formView.showForm((FormShowParameter)showParameter);
    }

    public static List<String> getFormualDependSItemCodeList(DynamicObjectCollection collection) {
        ArrayList<Long> formulaIdList = new ArrayList<Long>(10);
        ArrayList<String> salaryItemUniqueCodeList = new ArrayList<String>(10);
        DynamicObject formula = null;
        for (DynamicObject entry : collection) {
            formula = entry.getDynamicObject("formula");
            if (formula == null) continue;
            formulaIdList.add(formula.getLong("id"));
        }
        if (SWCListUtils.isEmpty(formulaIdList)) {
            return salaryItemUniqueCodeList;
        }
        String fields = "id,dependonsitem";
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        DynamicObjectCollection formulaList = formulaHelper.queryOriginalCollection(fields, new QFilter[]{new QFilter("id", "in", formulaIdList)});
        String uniqueCodeStr = null;
        for (DynamicObject temp : formulaList) {
            uniqueCodeStr = temp.getString("dependonsitem");
            if (SWCStringUtils.isEmpty((String)uniqueCodeStr)) continue;
            CalItemGroupHelper.addUniqueCodeToList(salaryItemUniqueCodeList, uniqueCodeStr);
        }
        return salaryItemUniqueCodeList;
    }

    private static void addUniqueCodeToList(List<String> list, String uniqueCodeStr) {
        String[] sItemArray;
        if (SWCStringUtils.isEmpty((String)uniqueCodeStr)) {
            return;
        }
        for (String item : sItemArray = uniqueCodeStr.split(COMMA)) {
            if (list.contains(item)) continue;
            list.add(item);
        }
    }

    public static Map<String, List<String>> checkFormulaDependOnSItemIsExist(DynamicObject dynamicObject, String entity, List<String> uniqueCodeList) {
        DynamicObjectCollection entryentityColl = null;
        entryentityColl = SWCStringUtils.equals((String)entity, (String)"hsas_calrule") ? (DynamicObjectCollection)dynamicObject.get("calruleitementry") : (DynamicObjectCollection)dynamicObject.get("entryentity");
        if (entryentityColl == null || entryentityColl.size() == 0) {
            return null;
        }
        ArrayList<String> existSalaryItemList = new ArrayList<String>(entryentityColl.size());
        DynamicObject formula = null;
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        String mapKey = null;
        String tempValue = null;
        for (DynamicObject entry : entryentityColl) {
            existSalaryItemList.add(entry.getString("salaryitem.uniquecode"));
            formula = entry.getDynamicObject("formula");
            if (formula == null) continue;
            tempValue = formula.getString("dependonsitem");
            mapKey = formula.getString("name");
            if (!SWCStringUtils.isNotEmpty((String)tempValue)) continue;
            formulaMap.put(mapKey, tempValue);
        }
        if (formulaMap.size() == 0) {
            return null;
        }
        HashMap<String, List<String>> errorDataMap = new HashMap<String, List<String>>(formulaMap.size());
        ArrayList<String> tempUniqueCodeList = null;
        for (Map.Entry entry : formulaMap.entrySet()) {
            String[] itemArray = ((String)entry.getValue()).split(COMMA);
            tempUniqueCodeList = new ArrayList<String>(itemArray.length);
            for (String item : itemArray) {
                if (existSalaryItemList.contains(item)) continue;
                tempUniqueCodeList.add(item);
                uniqueCodeList.add(item);
            }
            if (tempUniqueCodeList.size() <= 0) continue;
            errorDataMap.put((String)entry.getKey(), (List<String>)tempUniqueCodeList);
        }
        return errorDataMap;
    }

    public static void showAllFormula(List<Long> formulaBaseIdList, IFormView formView, String calRuleName) {
        if (formulaBaseIdList.size() == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u6dfb\u52a0\u4efb\u4f55\u516c\u5f0f\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"CalItemGroupHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        boolean hasPageermission = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hsas_formula");
        if (!hasPageermission) {
            formView.showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalItemGroupHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("hsas_viewformula");
        showParameter.setFormId("bos_list");
        showParameter.setLookUp(false);
        showParameter.setShowFilter(false);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter qfilter = new QFilter("id", "in", formulaBaseIdList);
        qFilters.add(qfilter);
        showParameter.setCustomParam("formulaBaseIdList", formulaBaseIdList);
        showParameter.setCustomParam("calRuleName", (Object)calRuleName);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        formView.showForm((FormShowParameter)showParameter);
    }

    public DynamicObject[] getCalRuleItemEntryInfos(Set<Long> ids) {
        SWCDataServiceHelper calRuleItemEntryHelper = new SWCDataServiceHelper("hsas_calruleitementry");
        QFilter filter = new QFilter("entryid", "in", ids);
        String selectProperties = "id,salaryitem,salaryitem.name";
        return calRuleItemEntryHelper.query(selectProperties, new QFilter[]{filter});
    }
}

